/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.handle.prop;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.ext.property.NoCodeTextProp;
import kd.bos.nocode.restapi.handle.AbstractPropertyHandle;
import org.jetbrains.annotations.Nullable;

public class TextPropHandle
extends AbstractPropertyHandle<NoCodeTextProp> {
    public TextPropHandle(NoCodeTextProp prop) {
        super(prop);
    }

    @Override
    public void copyValue(List<DynamicObject> sourceList, DynamicObject target) {
        super.copyValue(sourceList, target);
    }

    @Override
    public Object formatValue(DynamicObject source) {
        String value = source.getString(this.propName);
        return this.formatValue0(value);
    }

    @Override
    public List<Object> formatValue(List<Object> sourceValueList) {
        return sourceValueList.stream().map(e -> this.formatValue0((String)e)).collect(Collectors.toList());
    }

    @Nullable
    private Object formatValue0(String value) {
        if (Objects.equals(((NoCodeTextProp)this.prop).getTextValidType(), "pwd") && StringUtils.isNotEmpty((CharSequence)value)) {
            return "\u2022\u2022\u2022\u2022\u2022\u2022";
        }
        return value;
    }

    @Override
    public Object formatValue(Row source) {
        String value = source.getString(this.getCurrFullPropName());
        return this.formatValue0(value);
    }
}

