/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.handle.prop.qing;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Objects;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.nocode.restapi.handle.AbstractPropertyHandle;

public class DateTimePropQingHandle
extends AbstractPropertyHandle<DateTimeProp> {
    public DateTimePropQingHandle(DateTimeProp prop) {
        super(prop);
    }

    @Override
    public Object formatValue(DynamicObject source) {
        DateFormat dateFormat = ((DateTimeProp)this.prop).getDateFormat();
        Date value = source.getDate(this.propName);
        if (Objects.nonNull(value)) {
            String format = dateFormat.format(value);
            try {
                return dateFormat.parse(format).getTime();
            }
            catch (ParseException e) {
                throw new KDException(new ErrorCode("", ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u9519\u8bef", (String)"DateTimePropQingHandle_0", (String)"bos-nocode-format", (Object[])new Object[0])), new Object[0]);
            }
        }
        return value;
    }

    @Override
    public Object formatValue(Row source) {
        DateFormat dateFormat = ((DateTimeProp)this.prop).getDateFormat();
        Timestamp value = source.getTimestamp(this.getCurrFullPropName());
        if (Objects.nonNull(value)) {
            String format = dateFormat.format(value);
            try {
                return dateFormat.parse(format).getTime();
            }
            catch (ParseException e) {
                throw new KDException(new ErrorCode("", ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u9519\u8bef", (String)"DateTimePropQingHandle_0", (String)"bos-nocode-format", (Object[])new Object[0])), new Object[0]);
            }
        }
        return value;
    }
}

