/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Objects;
import kd.bos.nocode.ext.property.NoCodeDecimalProp;

public class DecimalUtil {
    public static String format(BigDecimal value, int scale, boolean useFormatStringValue, boolean useThousandsSeparator, boolean isDigit) {
        String result;
        if (Objects.nonNull(value)) {
            value = value.setScale(scale);
            DecimalFormat format = null;
            if (useFormatStringValue && useThousandsSeparator) {
                StringBuilder pattern = new StringBuilder("##,##0");
                if (scale > 0) {
                    pattern.append(".");
                    while (scale-- > 0) {
                        pattern.append("0");
                    }
                }
                format = new DecimalFormat(pattern.toString());
                result = format.format(value);
            } else {
                result = value.toPlainString();
            }
            if (!isDigit) {
                result = result + "%";
            }
        } else {
            result = null;
        }
        return result;
    }

    public static String formatByProp(NoCodeDecimalProp prop, BigDecimal value, boolean useFormatStringValue) {
        if (prop == null) {
            return null;
        }
        return DecimalUtil.format(value, prop.getScale(), useFormatStringValue, prop.getThousandsSeparator(), prop.isDigit());
    }
}

