/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.debug;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.splittingread.ThreadReadWriteContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.designer.dao.EntityDesignerData;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.tools.Column;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.nocode.debug.NoCodeDebugService;
import kd.bos.nocode.restapi.cache.RestApiServiceLocalCache;
import kd.bos.nocode.restapi.common.result.RestApiFile;
import kd.bos.nocode.restapi.service.wf.WfProcessDataService;
import kd.bos.nocode.util.NoCodeTemplateUtil;
import kd.bos.nocode.utils.DevUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.FileUtils;
import kd.bos.xdb.QueryTimeout;

public class NoCodeDebugServiceImpl
implements NoCodeDebugService {
    static final Log log = LogFactory.getLog(NoCodeDebugServiceImpl.class);
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static final String PREFIX_DIALECT = "/*dialect*/";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final int TIMEOUT = 60;
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String DOWNLOADPATH = "KINGDEEDOWNLOAD";
    private final long LIMITSIZ = 0x1400000L;
    private boolean isDebug = Boolean.parseBoolean(System.getProperty(METADATADEBUG, "false"));
    private static String METADATADEBUG = "metadata.debug";

    public NoCodeDebugServiceImpl() {
        ConfigurationUtil.observeChange((String)METADATADEBUG, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                NoCodeDebugServiceImpl.this.isDebug = Boolean.parseBoolean(System.getProperty(METADATADEBUG));
            }
        });
    }

    public String getEntityMetadata(String entiyId) {
        if (!this.hasRight()) {
            return this.getUnauthorizedMsg();
        }
        String id = MetadataDao.getIdByNumber((String)entiyId, (MetaCategory)MetaCategory.Entity);
        AbstractMetadata metadata = MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Entity);
        MetadataSerializer serializer = new MetadataSerializer(metadata.getModelType());
        return serializer.buildDiffXml((Object)metadata, null, false);
    }

    public String getFormMetadata(String formId) {
        if (!this.hasRight()) {
            return this.getUnauthorizedMsg();
        }
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        AbstractMetadata metadata = MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        MetadataSerializer serializer = new MetadataSerializer(metadata.getModelType());
        return serializer.buildDiffXml((Object)metadata, null, false);
    }

    public String getJarInfo(String jarname) {
        String ret;
        block18: {
            if (!this.hasRight()) {
                return this.getUnauthorizedMsg();
            }
            ret = null;
            try {
                String[] jarArray;
                String findJarname = null;
                String jars = System.getProperty("java.class.path");
                String spit = System.getProperty("path.separator");
                for (String jarFileName : jarArray = jars.split(spit)) {
                    if (!jarFileName.contains(jarname)) continue;
                    findJarname = jarFileName;
                    break;
                }
                if (jarname == null || findJarname == null) break block18;
                try (JarFile jarFile = new JarFile(findJarname);){
                    Enumeration<JarEntry> jarEntrys = jarFile.entries();
                    while (jarEntrys.hasMoreElements()) {
                        JarEntry jarEntry = jarEntrys.nextElement();
                        if (jarEntry.isDirectory() || !"META-INF/MANIFEST.MF".equals(jarEntry.getName())) continue;
                        InputStream in = jarFile.getInputStream(jarEntry);
                        BufferedReader br = new BufferedReader(new InputStreamReader(in));
                        String s = "";
                        StringBuilder sb = new StringBuilder();
                        while ((s = br.readLine()) != null) {
                            sb.append(s);
                        }
                        sb.append("<br>").append("p:").append(findJarname.replaceAll("\\\\", "**")).append("<br>");
                        ret = sb.toString();
                        break;
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return Instance.getAppName() + ":" + ret;
    }

    public String getAppMetadataByID(String appID) {
        if (!this.hasRight()) {
            return this.getUnauthorizedMsg();
        }
        AppMetadata appMetadataById = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appID, (boolean)true);
        String appMetadata = AppMetaServiceHelper.serializeToJSONString((AppMetadata)appMetadataById, null);
        return appMetadata;
    }

    public Object getTableInfo(String formId) {
        if (!this.hasRight()) {
            return this.getUnauthorizedMsg();
        }
        try {
            DBRoute dbRoute = DBRoute.of((String)"secd");
            DBInstance dbInstance = this.getDbInstance(dbRoute);
            if (dbInstance == null) {
                return ResManager.loadKDString((String)"\u6570\u636e\u5e93\u5b9e\u4f8b\u4e0d\u5b58\u5728", (String)"NoCodeDebugServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]);
            }
            String dbtype = dbInstance.getDbtype();
            String tableName = String.format("%s%s", "t_nc_", formId);
            String sql = this.tableDefinitionSql(tableName, dbInstance, dbtype);
            EntityMetadata metadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Entity);
            if (metadata == null) {
                return ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"NoCodeDebugServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]);
            }
            final HashMap fieldName2captionMap = new HashMap(10);
            metadata.getItems().stream().filter(item -> item instanceof Field && StringUtils.isNotBlank((CharSequence)((Field)item).getFieldName())).forEach(item -> fieldName2captionMap.put(((Field)item).getFieldName(), item.getName().toString()));
            final ArrayList columnList = new ArrayList(16);
            List rs = null;
            try (QueryTimeout q = DB.timeout((int)60);
                 ThreadReadWriteContext ctx = DB.beginThreadRead((String)"nocode_getTableInfo_query");){
                rs = (List)DB.query((DBRoute)dbRoute, (String)sql, (ResultSetHandler)new ResultSetHandler<List<List<Object>>>(){

                    public List<List<Object>> handle(ResultSet rs) throws Exception {
                        int i;
                        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
                        ResultSetMetaData meta = rs.getMetaData();
                        int columnNumber = meta.getColumnCount();
                        for (i = 1; i <= columnNumber; ++i) {
                            Column column = new Column();
                            column.setName(meta.getColumnName(i));
                            column.setcType(meta.getColumnType(i));
                            columnList.add(column);
                        }
                        i = 0;
                        while (rs.next()) {
                            ArrayList<String> row = new ArrayList<String>();
                            int index = ++i;
                            if (i > 1000) break;
                            String capton = null;
                            for (int n = 1; n <= columnNumber; ++n) {
                                String val;
                                String string = val = rs.getObject(n) == null ? "" : rs.getObject(n).toString();
                                if (n == 2 && fieldName2captionMap.containsKey(val)) {
                                    capton = (String)fieldName2captionMap.get(val);
                                }
                                if (n == 7 && capton != null) {
                                    val = capton;
                                }
                                row.add(val);
                            }
                            data.add(row);
                        }
                        return data;
                    }
                });
            }
            catch (KDException e) {
                return e.getMessage();
            }
            if (columnList.size() > 0 && rs != null && !rs.isEmpty()) {
                HashMap<String, List> result = new HashMap<String, List>(2);
                result.put("Columns", columnList);
                result.put("Data", rs);
                return SerializationUtils.toJsonString(result);
            }
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    private String tableDefinitionSql(String tableName, DBInstance dbInstance, String dbtype) throws Exception {
        String sql = "";
        if ("0".equals(dbtype)) {
            String select = "select t.TABLE_NAME,t.COLUMN_NAME, t.DATA_TYPE, t.DATA_LENGTH,t.DATA_PRECISION,t.NULLABLE,t.CHARACTER_SET_NAME,t.COLUMN_ID,c.COMMENTS ";
            String from = "from user_tab_columns t, user_col_comments c ";
            String where = "where t.table_name = c.table_name and t.column_name = c.column_name and t.table_name = '" + tableName.toUpperCase() + "' ";
            String orderBy = "order by t.COLUMN_ID";
            sql = PREFIX_DIALECT + select + from + where + orderBy;
        } else if ("1".equals(dbtype)) {
            String select = "SELECT a.attnum,a.attname AS field,t.typname AS type,a.attlen AS length,a.atttypmod AS lengthvar,a.attnotnull AS notnull,b.description AS comment ";
            String from = "FROM pg_class c,pg_attribute a LEFT OUTER JOIN pg_description b ON a.attrelid=b.objoid AND a.attnum = b.objsubid,pg_type t ";
            String where = "WHERE c.relname = '" + tableName.toLowerCase() + "' and a.attnum > 0 and a.attrelid = c.oid and a.atttypid = t.oid ";
            String orderBy = "ORDER BY a.attnum";
            sql = PREFIX_DIALECT + select + from + where + orderBy;
        } else if ("2".equals(dbtype)) {
            String dbInsatnce = dbInstance.getDBInsatnce();
            String select = "SELECT TABLE_NAME ,COLUMN_NAME ,COLUMN_TYPE ,IS_NULLABLE ,COLUMN_KEY ,COLUMN_DEFAULT ,NUMERIC_PRECISION ,NUMERIC_SCALE ,CHARACTER_SET_NAME ,COLLATION_NAME ,COLUMN_COMMENT,TABLE_SCHEMA ";
            String from = "FROM information_schema.COLUMNS ";
            String where = "WHERE TABLE_SCHEMA='" + dbInsatnce + "' AND TABLE_NAME= '" + tableName + "'";
            sql = PREFIX_DIALECT + select + from + where;
        } else if ("3".equals(dbtype)) {
            String select = "select t.TABLE_NAME,t.COLUMN_NAME, t.DATA_TYPE, t.DATA_LENGTH,t.DATA_PRECISION,t.NULLABLE,t.CHARACTER_SET_NAME,t.COLUMN_ID,c.COMMENTS ";
            String from = "from user_tab_columns t, user_col_comments c ";
            String where = "where t.table_name = c.table_name and t.column_name = c.column_name and t.table_name = '" + tableName.toUpperCase() + "' ";
            String orderBy = "order by t.COLUMN_ID";
            sql = PREFIX_DIALECT + select + from + where + orderBy;
        } else if ("6".equals(dbtype)) {
            String select = "select TABLE_NAME ,COLUMN_NAME ,TABLE_CATALOG ,TABLE_SCHEMA ,ORDINAL_POSITION ,COLUMN_DEFAULT ,IS_NULLABLE ,DATA_TYPE ,CHARACTER_MAXIMUM_LENGTH ,CHARACTER_OCTET_LENGTH ,NUMERIC_PRECISION ,NUMERIC_PRECISION_RADIX,NUMERIC_SCALE ,DATETIME_PRECISION ,CHARACTER_SET_CATALOG ,CHARACTER_SET_SCHEMA ,CHARACTER_SET_NAME ,COLLATION_CATALOG ,COLLATION_SCHEMA ,COLLATION_NAME,DOMAIN_CATALOG ,DOMAIN_SCHEMA ,DOMAIN_NAME ";
            String from = "from INFORMATION_SCHEMA.COLUMNS ";
            String where = "where table_name = '" + tableName + "'";
            sql = PREFIX_DIALECT + select + from + where;
        } else {
            throw new Exception(ResManager.loadKDString((String)"\u672a\u5904\u7406\u8be5\u6570\u636e\u5e93\u7c7b\u578b\uff1a%s", (String)"NoCodeDebugServiceImpl_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[]{dbtype}));
        }
        return sql;
    }

    private DBInstance getDbInstance(DBRoute route) {
        RequestContext requestContext = RequestContext.get();
        String accountId = requestContext.getAccountId();
        String tenantId = requestContext.getTenantId();
        Account correctAccount = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
        return this.getDBInstanceByAcountAndRoutkey(correctAccount, route.getRouteKey());
    }

    private DBInstance getDBInstanceByAcountAndRoutkey(Account account, String routeKey) {
        List dbInstanceList = account.getDBInstanceList();
        DBInstance returnInstance = null;
        if (StringUtils.isEmpty((CharSequence)routeKey) || CollectionUtils.isEmpty((Collection)dbInstanceList)) {
            return returnInstance;
        }
        for (DBInstance instance : dbInstanceList) {
            if (!routeKey.equalsIgnoreCase(instance.getRouteKey())) continue;
            returnInstance = instance;
            if (!"1".equals(instance.getReadOnly())) continue;
            break;
        }
        return returnInstance;
    }

    private boolean hasRight() {
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)Long.parseLong(RequestContext.get().getUserId()));
        return this.isDebug || isAdmin;
    }

    private String getUnauthorizedMsg() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("error:", ResManager.loadKDString((String)"\u672a\u7ecf\u6388\u6743\u7684\u8bbf\u95ee\u3002 ", (String)"NoCodeDebugServiceImpl_3", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
        return SerializationUtils.toJsonString(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportMetaByApp(String appNumber) throws IOException {
        log.debug("nocode: exportMetaByApp appNumber:" + appNumber);
        AppInfo appInfo = EntityMetadataCache.getAppInfo((String)appNumber);
        log.debug("nocode: exportMetaByApp AppInfo:" + SerializationUtils.toJsonString((Object)appInfo));
        String appID = BizAppServiceHelp.getAppIdByAppNumber((String)appNumber);
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appID, (boolean)false);
        String bizAppNumber = appMeta.getNumber();
        String appVersion = appMeta.getAppElement().getVersion();
        String appNumberPath = USER_HOME + File.separator + DOWNLOADPATH + File.separator + bizAppNumber;
        String traceIdHash = Hashing.sha256().hashString((CharSequence)RequestContext.get().getTraceId(), Charsets.UTF_8).toString();
        String traceIdPath = appNumberPath + File.separator + traceIdHash;
        String localPath = traceIdPath + File.separator + "datamodel" + File.separator + appVersion + File.separator + "main" + File.separator + bizAppNumber;
        ArrayList<File> fileList = new ArrayList<File>();
        DevUtil.expAppMetadata(appID, localPath, "EXPORT_APP");
        List<String> formIds = this.getMenuFormIds(appMeta);
        for (String formId : formIds) {
            if (!NcEntityTypeUtil.isFormExist((String)formId)) continue;
            DevUtil.expFormMetadata(formId, localPath, "EXPORT_PAGE");
        }
        InputStream in = null;
        try {
            DevUtil.zipFiles(bizAppNumber, localPath, fileList);
            String fileName = bizAppNumber + ".zip";
            String downloadFile = FileUtils.cleanString((String)(localPath + File.separator + fileName));
            Path downloadPath = Paths.get(DevUtil.checkFilePath(downloadFile), new String[0]);
            in = Files.newInputStream(downloadPath, new OpenOption[0]);
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            String path = this.getExportFilePath(fileName);
            String uploadUrl = fileService.upload(new FileItem(fileName, path, in));
            String string = UrlService.getAttachmentFullUrl((String)uploadUrl);
            return string;
        }
        finally {
            String filePath;
            File traceIdFile;
            if (in != null) {
                in.close();
            }
            if ((traceIdFile = new File(filePath = FileUtils.cleanString((String)traceIdPath.replace('.', '%').replace('/', '%')))).exists()) {
                boolean delete;
                AppUtils.deleteKd((File)traceIdFile);
                String checkFilePath = FileUtils.cleanString((String)appNumberPath.replace('.', '%').replace('/', '%'));
                File appNumberFile = new File(checkFilePath);
                if (appNumberFile.listFiles().length == 0 && !(delete = appNumberFile.delete())) {
                    log.debug("\u5220\u9664\u5931\u8d25");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportJsonMetaByApp(String appNumber) throws IOException {
        String appID = BizAppServiceHelp.getAppIdByAppNumber((String)appNumber);
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appID, (boolean)false);
        String bizAppNumber = appMeta.getNumber();
        String appVersion = appMeta.getAppElement().getVersion();
        String appNumberPath = USER_HOME + File.separator + DOWNLOADPATH + File.separator + bizAppNumber;
        String traceIdHash = Hashing.sha256().hashString((CharSequence)RequestContext.get().getTraceId(), Charsets.UTF_8).toString();
        String traceIdPath = appNumberPath + File.separator + traceIdHash;
        String localPath = traceIdPath + File.separator + "datamodel" + File.separator + appVersion + File.separator + "main" + File.separator + bizAppNumber;
        ArrayList<File> fileList = new ArrayList<File>();
        NoCodeDebugServiceImpl.saveJsonFile(AppMetaServiceHelper.serializeToJSONString((AppMetadata)appMeta, null), appNumber, localPath);
        List<String> formIds = this.getMenuFormIds(appMeta);
        EntityDesignerData entityDesignerData = new EntityDesignerData();
        for (String formId : formIds) {
            String formNumber = MetadataDao.getNumberById((String)formId);
            try {
                Map entityMetaMap = entityDesignerData.loadDesignerMetadata(formId, RequestContext.get().getLang().toString());
                if (entityMetaMap == null || entityMetaMap.isEmpty()) continue;
                NoCodeDebugServiceImpl.saveJsonFile(SerializationUtils.toJsonString((Object)entityMetaMap), formNumber, localPath);
            }
            catch (Exception e) {
                log.warn((Throwable)e);
            }
        }
        InputStream in = null;
        try {
            DevUtil.zipFiles(bizAppNumber, localPath, fileList);
            String fileName = bizAppNumber + ".zip";
            String downloadFile = FileUtils.cleanString((String)(localPath + File.separator + fileName));
            Path downloadPath = Paths.get(DevUtil.checkFilePath(downloadFile), new String[0]);
            in = Files.newInputStream(downloadPath, new OpenOption[0]);
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            String path = this.getExportFilePath(fileName);
            String uploadUrl = fileService.upload(new FileItem(fileName, path, in));
            String string = UrlService.getAttachmentFullUrl((String)uploadUrl);
            return string;
        }
        finally {
            String filePath;
            File traceIdFile;
            if (in != null) {
                in.close();
            }
            if ((traceIdFile = new File(filePath = FileUtils.cleanString((String)traceIdPath.replace('.', '%').replace('/', '%')))).exists()) {
                boolean delete;
                AppUtils.deleteKd((File)traceIdFile);
                String checkFilePath = FileUtils.cleanString((String)appNumberPath.replace('.', '%').replace('/', '%'));
                File appNumberFile = new File(checkFilePath);
                if (appNumberFile.listFiles().length == 0 && !(delete = appNumberFile.delete())) {
                    log.debug("\u5220\u9664\u5931\u8d25");
                }
            }
        }
    }

    private static void saveJsonFile(String jsonContent, String jsonFileName, String exportPath) {
        String fullPath = AppUtils.getMetaXmlPath((String)jsonFileName, (String)exportPath);
        String[] abovePath = fullPath.split(jsonFileName);
        String parentPath = abovePath[0];
        File fileAbovePath = new File(FileUtils.cleanString((String)parentPath));
        if (!fileAbovePath.exists()) {
            fileAbovePath.mkdirs();
        }
        DevUtil.createJsonFile(jsonContent, parentPath, jsonFileName);
    }

    protected String getExportFilePath(String fileName) {
        RequestContext ctx = RequestContext.getOrCreate();
        String dateStr = new SimpleDateFormat("yyyyMMdd").format(new Date());
        return String.format("/%s/%s/%s/%s/%s/%s", ctx.getTenantId(), ctx.getAccountId(), dateStr, "nocodeDebug", System.currentTimeMillis(), fileName);
    }

    private List<String> getMenuFormIds(AppMetadata appMeta) {
        ArrayList<String> result = new ArrayList<String>(10);
        for (AppMenuElement appMenu : appMeta.getAppMenus()) {
            if (StringUtils.isBlank((CharSequence)appMenu.getFormId())) continue;
            result.add(appMenu.getFormId());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String importMetaByApp(RestApiFile file) {
        if (file == null) return "null";
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getFileData());
             ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            String bizCloudId = "2HGKCE94QELW";
            HashMap<String, Object> appInfo = new HashMap<String, Object>();
            HashMap<String, Object> pageInfo = new HashMap<String, Object>();
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                Object content;
                if (zipEntry.isDirectory()) continue;
                String metaName = zipEntry.getName();
                if (metaName.endsWith("app") || metaName.endsWith("appx")) {
                    content = this.getMetadataContext(metaName, zipInputStream);
                    content = ((String)content).replaceAll("(<Isv>).+?(</Isv>)", "$1kingdee$2");
                    appInfo.put(metaName, content);
                    continue;
                }
                if (!metaName.endsWith("dym") && !metaName.endsWith("dymx")) continue;
                content = this.getMetadataContext(metaName, zipInputStream);
                content = ((String)content).replaceAll("(<Isv>).+?(</Isv>)", "$1kingdee$2");
                pageInfo.put(metaName, content);
            }
            HashSet appIs = new HashSet();
            if (appInfo.size() > 0) {
                for (Map.Entry entry : appInfo.entrySet()) {
                    String appContent = (String)entry.getValue();
                    try {
                        List appids = AppMetaServiceHelper.deployAppMetadata((String)appContent, (String)bizCloudId);
                        appIs.addAll(appids);
                    }
                    catch (Exception appException) {
                        String string = "fail:" + String.join((CharSequence)";", appException.getMessage());
                        if (zipInputStream != null) {
                            if (var5_8 != null) {
                                try {
                                    zipInputStream.close();
                                }
                                catch (Throwable throwable) {
                                    var5_8.addSuppressed(throwable);
                                }
                            } else {
                                zipInputStream.close();
                            }
                        }
                        if (inputStream == null) return string;
                        if (var3_4 == null) {
                            ((InputStream)inputStream).close();
                            return string;
                        }
                        try {
                            ((InputStream)inputStream).close();
                            return string;
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                            return string;
                        }
                    }
                }
            }
            String bizAppId = (String)appIs.iterator().next();
            if (pageInfo.size() > 0) {
                for (Map.Entry pageEntry : pageInfo.entrySet()) {
                    String pageName = (String)pageEntry.getKey();
                    String pageContent = (String)pageEntry.getValue();
                    try {
                        MetadataDao.deployMetadata((String)pageContent, null, (String)bizAppId);
                    }
                    catch (Exception pageException) {
                        log.warn((Throwable)pageException);
                    }
                }
            }
            if (appIs.isEmpty()) return "ok:" + file.getFileName();
            Iterator iterator = appIs.iterator();
            while (iterator.hasNext()) {
                String appid = (String)iterator.next();
                MetadataDao.rebuildRuntimeAppMetaById((String)appid);
                NoCodePermHelper.genAdminRole((String)appid);
            }
            return "ok:" + file.getFileName();
        }
        catch (Exception e) {
            return "fail:" + e.getMessage();
        }
    }

    private String getMetadataContext(String metaName, ZipInputStream zipIn) throws IOException {
        int readLength = 0;
        int len = 0;
        byte[] buf = new byte[0x1400000];
        while ((readLength = zipIn.read()) != -1) {
            buf[len] = (byte)readLength;
            ++len;
        }
        return new String(buf, 0, len, StandardCharsets.UTF_8);
    }

    public synchronized String fixupData(String tag) {
        StringBuilder builder = new StringBuilder();
        switch (tag) {
            case "role": {
                NoCodeDebugServiceImpl.addAdminRole(builder);
                break;
            }
            case "template": {
                this.addTemplateUser(builder);
                break;
            }
        }
        return builder.toString();
    }

    public void clearInvalidWfInfo(String entityNumber, String pkId) {
        if (!QueryServiceHelper.exists((String)entityNumber, (Object)Long.valueOf(pkId))) {
            log.debug("\u6e05\u9664\u65e0\u6548\u7684\u6d41\u7a0b\u4fe1\u606f\u6570\u636e\uff0c\u7528\u4e8e\u4fee\u590d\u6570\u636e");
            WfProcessDataService.create().deleteWfInfoByEntityNumberAndBusinessKey(entityNumber, pkId);
        }
    }

    private void addTemplateUser(StringBuilder builder) {
        DynamicObject[] templates = BusinessDataServiceHelper.load((String)"bos_nocode_templateconfig", (String)"id,creator", (QFilter[])new QFilter[0]);
        HashMap<Long, Object> map = new HashMap<Long, Object>();
        for (DynamicObject template : templates) {
            map.put(template.getLong("id"), template.getDynamicObject("creator").get("id"));
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (Map.Entry entry : map.entrySet()) {
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_tpl_user");
            dy.set("templateid", entry.getKey());
            dy.set("userid", entry.getValue());
            list.add(dy);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        builder.append(ResManager.loadKDString((String)"\u6dfb\u52a0\u5b8c\u6210", (String)"NoCodeDebugServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    private static void addAdminRole(StringBuilder builder) {
        DynamicObject[] apps;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("bizcloud", "=", (Object)RestApiServiceLocalCache.getNoCodeCloudId()));
        filters.add(new QFilter("number", "!=", (Object)"nocode_fromtemplate_app"));
        filters.add(new QFilter("id", "not in", (Object)NoCodeTemplateUtil.queryTemplateAppIds()));
        for (DynamicObject app : apps = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id,creater", (QFilter[])filters.toArray(new QFilter[0]))) {
            String appid = app.getString("id");
            List roles = NoCodePermissionServiceHelper.getRoleByAppId((String)appid);
            if (!roles.isEmpty()) continue;
            try {
                NoCodePermHelper.genAdminRole((Long)app.getDynamicObject("creater").getLong("id"), (String)appid);
            }
            catch (Exception e) {
                builder.append(app.getString("name")).append(":").append(e.getMessage()).append("</br>");
            }
            builder.append(app.getString("name")).append(ResManager.loadKDString((String)"\u91cd\u5efa\u5e94\u7528\u7ba1\u7406\u5458\u89d2\u8272\u6210\u529f", (String)"NoCodeDebugServiceImpl_5", (String)"bos-nocode-service", (Object[])new Object[0])).append("</br>");
        }
        builder.append(ResManager.loadKDString((String)"\u91cd\u5efa\u7ed3\u675f", (String)"NoCodeDebugServiceImpl_6", (String)"bos-nocode-service", (Object[])new Object[0]));
    }
}

