/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.entity.rule;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.rule.BRAction;
import kd.bos.entity.rule.BRExecuteContext;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.handle.PropertyHandle;
import kd.bos.nocode.restapi.handle.PropertyHandleFactory;

public class TakeRefBillPropertyAction
extends BRAction {
    private static final String SOURCE_FIELD = "sourceField";
    private static final Log log = LogFactory.getLog(TakeRefBillPropertyAction.class);
    private List<Map<String, Object>> expression;
    private boolean onlyEmptyRow;

    public void setParameter(Map<String, Object> param) {
        this.expression = (List)param.get("expression");
        this.onlyEmptyRow = (Boolean)param.get("onlyEmptyRow");
    }

    @SimplePropertyAttribute
    public boolean getOnlyEmptyRow() {
        return this.onlyEmptyRow;
    }

    public void setOnlyEmptyRow(boolean onlyEmptyRow) {
        this.onlyEmptyRow = onlyEmptyRow;
    }

    @SimplePropertyAttribute
    public List<Map<String, Object>> getExpression() {
        return this.expression;
    }

    public void setExpression(List<Map<String, Object>> expression) {
        this.expression = expression;
    }

    public void execute(BRExecuteContext executeContext) {
        if (executeContext.getDataEntities() == null || executeContext.getDataEntities().isEmpty()) {
            return;
        }
        Map<String, Object> firstParam = this.expression.get(0);
        String srcFullPropName = (String)firstParam.get(SOURCE_FIELD);
        String[] arr = srcFullPropName.split("\\.");
        String refBillPropName = arr[0];
        INoCodeRefBillProp refBillProp = (INoCodeRefBillProp)executeContext.getModel().getProperty(refBillPropName);
        StringBuilder sb = new StringBuilder();
        for (Map<String, Object> parameter : this.expression) {
            String srcPropName = (String)parameter.get(SOURCE_FIELD);
            String[] split = srcPropName.split("\\.");
            String propName = split[split.length - 1];
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(propName);
        }
        String refFields = sb.toString();
        for (RowDataEntity row : executeContext.getDataEntities()) {
            DynamicObjectType entityType = row.getDataEntity().getDynamicObjectType();
            RowDataModel rowDataModel = new RowDataModel(entityType.getName(), executeContext.getModel());
            rowDataModel.setRowContext(row.getDataEntity());
            String sPks = (String)rowDataModel.getValue(refBillPropName);
            if (StringUtils.isBlank((CharSequence)sPks)) break;
            DynamicObject[] refDynObjs = refBillProp.loadRefBillObjects(sPks, refFields);
            DynamicObject refDynObj = refDynObjs[0];
            for (Map<String, Object> parameter : this.expression) {
                this.takeRefPropValue(parameter, executeContext, row, rowDataModel, refDynObj, entityType);
            }
        }
    }

    private void takeRefPropValue(Map<String, Object> parameter, BRExecuteContext executeContext, RowDataEntity row, RowDataModel rowDataModel, DynamicObject refDynObj, DynamicObjectType entityType) {
        IDataModel model = executeContext.getModel();
        String srcFullPropName = (String)parameter.get(SOURCE_FIELD);
        String[] arr = srcFullPropName.split("\\.");
        IDataEntityProperty srcProp = model.getProperty(arr[0]);
        String childPropName = arr[1];
        String targetFieldKey = (String)parameter.get("targetField");
        if (!(srcProp instanceof INoCodeRefBillProp) || model.getProperty(targetFieldKey) == null) {
            return;
        }
        IDataEntityProperty targetProp = model.getProperty(targetFieldKey);
        if (!StringUtils.equals((CharSequence)targetProp.getParent().getName(), (CharSequence)entityType.getName())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u5b9e\u4f53\u670d\u52a1\u89c4\u5219\u51fa\u9519\uff1a\u201c%2$s\u201d\u4e0d\u662f\u672c\u5b9e\u4f53\u4e0a\u7684\u5b57\u6bb5\uff0c\u4e0d\u80fd\u643a\u5e26\u8868\u5355\u5c5e\u6027\u503c\u8fc7\u53bb", (String)"TakeRefBillPropertyAction_0", (String)"bos-nocode-service", (Object[])new Object[]{entityType.getDisplayName().toString(), ((DynamicProperty)targetProp).getDisplayName().toString()}));
        }
        IDataEntityProperty childProp = (IDataEntityProperty)refDynObj.getDataEntityType().getProperties().get((Object)childPropName);
        if (childProp != null && this.canTakeValue(rowDataModel, targetProp, this.getOnlyEmptyRow())) {
            Object value = this.getSrcValue(childProp, targetProp, refDynObj);
            try {
                if (value instanceof DynamicObject) {
                    model.setValue(targetFieldKey, ((DynamicObject)value).getPkValue(), row.getRowIndex(), row.getParentRowIndex());
                } else {
                    model.setValue(targetFieldKey, value, row.getRowIndex(), row.getParentRowIndex());
                }
            }
            catch (Exception e) {
                log.warn((Throwable)e);
            }
        }
    }

    private Object getSrcValue(IDataEntityProperty srcProp, IDataEntityProperty targetProp, DynamicObject refDynObj) {
        PropertyHandle propertyHandle;
        Object value = srcProp.getValue((Object)refDynObj);
        if (targetProp.getClass().isAssignableFrom(srcProp.getClass())) {
            return value;
        }
        if (targetProp instanceof TextProp && (propertyHandle = PropertyHandleFactory.getPropertyHandle((String)"$", (IDataEntityProperty)srcProp)) != null) {
            return propertyHandle.formatStringValue(refDynObj);
        }
        return value;
    }

    private boolean canTakeValue(RowDataModel rowDataModel, IDataEntityProperty targetProp, boolean onlyEmptyRow) {
        if (!onlyEmptyRow) {
            return true;
        }
        if (!(targetProp instanceof IValidatorHanlder)) {
            return true;
        }
        Object oldValue = rowDataModel.getValue(targetProp.getName());
        if (oldValue instanceof DynamicObject) {
            oldValue = ((DynamicObject)oldValue).getPkValue();
        }
        return ((IValidatorHanlder)targetProp).getValueComparator().compareValue(oldValue);
    }

    public String toString() {
        return "" + this.expression;
    }
}

