/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.metadata.dao;

import java.util.List;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.SqlObject;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IDBField;
import kd.bos.nocode.ext.metadata.entity.field.IFieldTypeChangeSupport;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeMulRefBillField;

public class AlterTableFieldHelper {
    private static final String ALTER_COLUMN_SQL = "EXEC p_AlterColumn '%s', '%s', '%s', '%s', '%s', '%s';";
    static final String NVARCHAR_DEFAULT_SQL = "%s NVARCHAR(50) NULL";
    private static final int LENGTH_CLOB_DM = 2000;

    private AlterTableFieldHelper() {
    }

    public static void addAlterTableField(List<SqlObject> sqlList, String tableName, Field<?> field, DbMetadataTable tableSchema, boolean notSupportBlobFilter) {
        String fieldName = field.getFieldName();
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            return;
        }
        String fieldDesc = AlterTableFieldHelper.genFieldDesc(field, notSupportBlobFilter);
        if (StringUtils.isEmpty((CharSequence)fieldDesc)) {
            return;
        }
        String sql = "";
        if (!IDBField.existsFieldInTableSchema((DbMetadataTable)tableSchema, (String)fieldName)) {
            sql = String.format("ALTER TABLE %s ADD %s;", tableName, fieldDesc);
            sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
            return;
        }
        if (AlterTableFieldHelper.needAlterColumn(field, tableSchema)) {
            sql = String.format(ALTER_COLUMN_SQL, tableName, fieldName, AlterTableFieldHelper.getColumnType(field, notSupportBlobFilter), AlterTableFieldHelper.getColumnIsNull(field), AlterTableFieldHelper.getColumnModifyFlag(field), AlterTableFieldHelper.getColumnDefaultValue(field));
            sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
        }
    }

    static String genFieldDesc(IDBField field, boolean notSupportBlobFilter) {
        String fieldDesc = "";
        if (field.getFieldName() == null || field.getFieldName().isEmpty()) {
            return fieldDesc;
        }
        switch (field.getFieldDBType()) {
            case 1: {
                fieldDesc = String.format("%s CHAR(1) NULL", field.getFieldName());
                break;
            }
            case -9: 
            case 12: {
                fieldDesc = String.format("%s NVARCHAR(%s) NULL", field.getFieldName(), field.getFieldLen());
                break;
            }
            case 2022: {
                fieldDesc = String.format("%s GEOGRAPHY", field.getFieldName());
                break;
            }
            case 91: {
                fieldDesc = String.format("%s DATETIME ", field.getFieldName());
                break;
            }
            case 4: {
                if (StringUtils.isNotBlank((CharSequence)field.getDBDefValue())) {
                    fieldDesc = String.format("%s INT DEFAULT('%s') %s", field.getFieldName(), field.getDBDefValue(), " NOT NULL");
                    break;
                }
                fieldDesc = String.format("%s INT DEFAULT('0')", field.getFieldName());
                break;
            }
            case 3: {
                if (StringUtils.isNotBlank((CharSequence)field.getDBDefValue())) {
                    fieldDesc = String.format("%s DECIMAL(%s,%s) DEFAULT('%s')", field.getFieldName(), field.getPrecision(), field.getScale(), field.getDBDefValue());
                    break;
                }
                fieldDesc = String.format("%s DECIMAL(%s,%s) DEFAULT('0')", field.getFieldName(), field.getPrecision(), field.getScale());
                break;
            }
            case 2004: {
                if (notSupportBlobFilter) {
                    fieldDesc = String.format("%s VARCHAR(%s) NULL", field.getFieldName(), 2000);
                    break;
                }
                fieldDesc = String.format("%s BLOB NULL", field.getFieldName());
                break;
            }
            case 2011: {
                if (notSupportBlobFilter) {
                    fieldDesc = String.format("%s NVARCHAR(%s) NULL", field.getFieldName(), 2000);
                    break;
                }
                fieldDesc = String.format("%s NCLOB NULL", field.getFieldName());
                break;
            }
            case -5: {
                if (StringUtils.isNotBlank((CharSequence)field.getDBDefValue())) {
                    fieldDesc = String.format("%s BIGINT DEFAULT('%s') %s", field.getFieldName(), field.getDBDefValue(), " NOT NULL");
                    break;
                }
                fieldDesc = String.format("%s BIGINT DEFAULT('0') NOT NULL", field.getFieldName());
                break;
            }
            case 2009: {
                fieldDesc = String.format("%s XMLTYPE NULL", field.getFieldName());
                break;
            }
            default: {
                fieldDesc = String.format(NVARCHAR_DEFAULT_SQL, field.getFieldName());
            }
        }
        return fieldDesc;
    }

    static String getCreateTableFieldDesc(IDBField field, boolean notSupportBlobFilter) {
        String fieldDesc = AlterTableFieldHelper.genFieldDesc(field, notSupportBlobFilter);
        StringBuilder sb = new StringBuilder();
        if (fieldDesc.length() > 0) {
            sb.append(fieldDesc).append(",");
        }
        return sb.toString();
    }

    private static boolean needAlterColumn(Field<?> field, DbMetadataTable tableSchema) {
        if (tableSchema == null || field == null) {
            return false;
        }
        DbMetadataColumn dbMetadataColumn = (DbMetadataColumn)tableSchema.getColumns().get(field.getFieldName());
        if (dbMetadataColumn == null) {
            return false;
        }
        if (field instanceof IFieldTypeChangeSupport) {
            boolean fieldTypeChanged = ((IFieldTypeChangeSupport)field).isFieldTypeChanged();
            if (!fieldTypeChanged && field instanceof NoCodeMulRefBillField && field.getFieldDBType() != dbMetadataColumn.getDbType()) {
                fieldTypeChanged = true;
            }
            return fieldTypeChanged;
        }
        return false;
    }

    private static String getColumnType(IDBField field, boolean notSupportBlobFilter) {
        String colType = "";
        switch (field.getFieldDBType()) {
            case 1: {
                colType = "CHAR(1)";
                break;
            }
            case -9: 
            case 12: {
                colType = String.format("NVARCHAR(%s)", field.getFieldLen());
                break;
            }
            case 2022: {
                colType = "GEOGRAPHY";
                break;
            }
            case 91: {
                colType = "DATETIME";
                break;
            }
            case 4: {
                colType = "INT";
                break;
            }
            case 3: {
                colType = String.format("DECIMAL(%s,%s)", field.getPrecision(), field.getScale());
                break;
            }
            case 2004: {
                if (notSupportBlobFilter) {
                    colType = String.format("VARCHAR(%s)", 2000);
                    break;
                }
                colType = "BLOB";
                break;
            }
            case 2011: {
                if (notSupportBlobFilter) {
                    colType = String.format("NVARCHAR(%s)", 2000);
                    break;
                }
                colType = "NCLOB";
                break;
            }
            case -5: {
                colType = "BIGINT";
                break;
            }
            case 2009: {
                colType = "XMLTYPE";
                break;
            }
            default: {
                colType = "NVARCHAR(50)";
            }
        }
        return colType;
    }

    private static String getColumnIsNull(IDBField field) {
        String flag = "NULL";
        return flag;
    }

    private static String getColumnModifyFlag(IDBField field) {
        String flag = "1111";
        if (field instanceof IFieldTypeChangeSupport) {
            flag = ((IFieldTypeChangeSupport)field).getModifyFlag();
        }
        if (StringUtils.isBlank((CharSequence)flag)) {
            flag = "1111";
        }
        return flag;
    }

    private static String getColumnDefaultValue(IDBField field) {
        String defVal = field.getDBDefValue();
        switch (field.getFieldDBType()) {
            case -9: 
            case 1: 
            case 12: 
            case 2011: {
                if (StringUtils.isNotBlank((CharSequence)defVal)) {
                    defVal = "''" + defVal + "''";
                    break;
                }
                defVal = "NULL";
                break;
            }
            case -5: 
            case 3: 
            case 4: {
                if (!StringUtils.isBlank((CharSequence)defVal)) break;
                defVal = "0";
                break;
            }
            case 91: {
                if (!StringUtils.isBlank((CharSequence)defVal)) break;
                defVal = "NULL";
                break;
            }
        }
        return defVal;
    }
}

