/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.metadata.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.rule.BR;
import kd.bos.entity.rule.EntityBR;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormConfig;
import kd.bos.formula.FormulaEngine;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.rule.TakeValueId;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.RuntimeFormMeta;
import kd.bos.nocode.metadata.DataFillMap;
import kd.bos.nocode.metadata.INoCodeRefBillField;

public class FixupBizRuleMeta {
    private static final int NUMBER_OF_MAP = 10;

    private FixupBizRuleMeta() {
    }

    protected static void fixup(FormMetadata formMetadata, List<RuntimeFormMeta> runtimeMetas) {
        if (formMetadata == null || runtimeMetas == null) {
            return;
        }
        EntityMetadata entityMetadata = formMetadata.getEntityMetadata();
        List entitys = entityMetadata.getEntitys();
        for (Entity entity : entitys) {
            List<EntityItem<?>> refBillFields = entity.getItems().stream().filter(i -> i instanceof INoCodeRefBillField && !((INoCodeRefBillField)i).getDataFill().isEmpty()).collect(Collectors.toList());
            FixupBizRuleMeta.doFixup(formMetadata, refBillFields, entity, runtimeMetas);
        }
    }

    private static void doFixup(FormMetadata formMetadata, List<EntityItem<?>> refBillFields, Entity<?, ?> entity, List<RuntimeFormMeta> runtimeMetas) {
        RuntimeFormMeta configMeta = null;
        RuntimeFormMeta ruleMeta = null;
        for (RuntimeFormMeta runtimeMeta : runtimeMetas) {
            if (RuntimeMetaType.Config.getValue() == runtimeMeta.getType()) {
                configMeta = runtimeMeta;
                continue;
            }
            if (RuntimeMetaType.Rule.getValue() != runtimeMeta.getType()) continue;
            ruleMeta = runtimeMeta;
        }
        ArrayList<EntityBR> entityBRs = new ArrayList<EntityBR>();
        ArrayList<BR> rules = new ArrayList<BR>(10);
        int idx = 0;
        for (EntityItem<?> refBillField : refBillFields) {
            INoCodeRefBillField refBillFld = (INoCodeRefBillField)refBillField;
            BR br = FixupBizRuleMeta.buildRule(refBillFld, entity, idx);
            if (br == null) continue;
            rules.add(br);
        }
        if (!rules.isEmpty()) {
            EntityBR entityBR = new EntityBR();
            entityBR.setKey(entity.getKey());
            entityBR.setRules(rules);
            entityBRs.add(entityBR);
        }
        if (entityBRs.isEmpty()) {
            return;
        }
        if (ruleMeta == null) {
            ruleMeta = formMetadata.createRuntimeFormMeta();
            ruleMeta.setKey("_formrules");
            ruleMeta.setType((int)RuntimeMetaType.Rule.getValue());
            runtimeMetas.add(ruleMeta);
        } else if (StringUtils.isNotBlank((CharSequence)ruleMeta.getData())) {
            List oldEntityBRS = (List)SerializationUtils.fromJsonString((String)ruleMeta.getData(), List.class);
            entityBRs.addAll(oldEntityBRS);
        }
        ruleMeta.setData(SerializationUtils.toJsonString(entityBRs));
        if (configMeta != null && StringUtils.isNotBlank((CharSequence)configMeta.getData())) {
            FormConfig config = (FormConfig)ControlTypes.fromJsonStringToObj((String)configMeta.getData());
            config.setRuleCount(entityBRs.stream().mapToInt(s -> s.getRules().size()).sum());
            configMeta.setData(ControlTypes.toJsonString((Object)config));
        }
    }

    private static BR buildRule(INoCodeRefBillField refBillFld, Entity<?, ?> entity, int idx) {
        BR rule = new BR();
        rule.setSource(entity.getKey());
        String preCondition = String.format("%s <> null and %s <> ''", refBillFld.getKey(), refBillFld.getKey());
        rule.setPreCondition(preCondition);
        rule.setPreDescription("when is not null");
        rule.setRET(249);
        rule.setDescription("rules generate by data fill of refbill");
        rule.setEnabled(true);
        rule.setSeq(idx);
        HashSet<String> dependencyFields = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)preCondition)) {
            String[] variables;
            for (String variable : variables = FormulaEngine.extractVariables((String)preCondition)) {
                if (!StringUtils.isNotBlank((CharSequence)variable)) continue;
                dependencyFields.add(variable.split("\\.")[0]);
            }
        }
        HashMap<String, Object> trueAction = new HashMap<String, Object>();
        trueAction.put("class", "kd.bos.nocode.entity.rule.TakeRefBillPropertyAction");
        trueAction.put("ret", 249);
        ArrayList<TakeValueId> expression = new ArrayList<TakeValueId>(refBillFld.getDataFill().size());
        for (DataFillMap dataFillMap : refBillFld.getDataFill()) {
            TakeValueId takeValueId = new TakeValueId();
            takeValueId.setId(Uuid16.create().toString());
            takeValueId.setSrcField(String.format("%s.%s", refBillFld.getKey(), dataFillMap.getRefBillFieldKey()));
            takeValueId.setTargetField(dataFillMap.getCurrBillFieldKey());
            takeValueId.setOnlyEmptyRow(false);
            expression.add(takeValueId);
        }
        trueAction.put("expression", expression);
        trueAction.put("onlyEmptyRow", false);
        for (TakeValueId item : expression) {
            if (!StringUtils.isNotBlank((CharSequence)item.getSrcField())) continue;
            dependencyFields.add(item.getSrcField().split("\\.")[0]);
        }
        trueAction.put("actionId", Uuid16.create().toString());
        trueAction.put("dependencyFields", dependencyFields);
        rule.getTrueActions().add(trueAction);
        return rule;
    }
}

