/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.metadata.dao;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.EntryOpParameter;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.entity.operation.OperationParameter;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.AdvConAp;
import kd.bos.metadata.form.container.AdvConChildPanelAp;
import kd.bos.metadata.form.container.AdvConToolbarAp;
import kd.bos.metadata.form.control.OperationColumnAp;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.entity.NoCodeBillEntity;
import kd.bos.nocode.ext.metadata.entity.NoCodeEntryEntity;
import kd.bos.nocode.ext.metadata.entity.NoCodeRefBillTable;
import kd.bos.nocode.ext.metadata.entity.field.CustomSelectContent;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeSelectItemField;
import kd.bos.nocode.ext.metadata.entity.field.SelectItem;
import kd.bos.nocode.ext.metadata.form.container.NoCodeAdvConAp;
import kd.bos.nocode.ext.metadata.form.container.NoCodeAdvConBarItemAp;
import kd.bos.nocode.ext.metadata.form.control.NoCodeEntryAp;
import kd.bos.nocode.utils.BlackFormUtil;

public class FixupEntryEntityMeta {
    private static final String ADVCONBARITEM_TYPE_GHOST = "ghost";
    private static final String NEW_ENTRY = "newentry";
    private static final String DELETE_ENTRY = "deleteentry";
    private static final String BATCH_IMPORT_DATA = "importdata";
    private static final String BATCH_EXPORT_DATA = "exportlist";
    private static final String SELECT_ENTRY = "nocodeselectentry";
    private static final String NCICON_ZENGJIA_YUAN = "zengjia-yuan";
    private static final String NCICON_DAORU = "daoru";
    private static final String NCICON_DAOCHU = "daochu";
    private static final Log log = LogFactory.getLog(FixupEntryEntityMeta.class);

    private FixupEntryEntityMeta() {
    }

    private static String getBatchImportTitle() {
        return "\u6279\u91cf\u5bfc\u5165";
    }

    private static String getBatchExportTitle() {
        return "\u6279\u91cf\u5bfc\u51fa";
    }

    protected static void fixup(FormMetadata formMeta, EntityMetadata entityMeta) {
        if (formMeta == null || entityMeta == null || !"NoCodeModel".equalsIgnoreCase(formMeta.getModelType())) {
            return;
        }
        formMeta.beginInit();
        FixupEntryEntityMeta.fixupNoCodeBillEntity(entityMeta);
        List entryAps = formMeta.getItems().stream().filter(NoCodeEntryAp.class::isInstance).collect(Collectors.toList());
        if (!entryAps.isEmpty()) {
            for (ControlAp entryAp : entryAps) {
                NoCodeEntryAp noCodeEntryAp = (NoCodeEntryAp)entryAp;
                if (noCodeEntryAp.getEntry() instanceof NoCodeRefBillTable) {
                    NoCodeRefBillTable table = (NoCodeRefBillTable)noCodeEntryAp.getEntry();
                    if (!"2".equals(table.getShowType())) continue;
                    FixupEntryEntityMeta.fixupNoCodeEntryAp(formMeta, entityMeta, noCodeEntryAp);
                    continue;
                }
                FixupEntryEntityMeta.fixupNoCodeEntryAp(formMeta, entityMeta, noCodeEntryAp);
            }
        }
        formMeta.endInit();
        formMeta.createIndex(true);
    }

    private static void fixupNoCodeBillEntity(EntityMetadata entityMeta) {
        List collect = entityMeta.getItems().stream().filter(NoCodeBillEntity.class::isInstance).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return;
        }
        NoCodeBillEntity billEntity = (NoCodeBillEntity)collect.get(0);
        if (billEntity.getItems().stream().anyMatch(i -> WfConsts.WfLockStatusEnum.LOCK_STATUS_KEY.equalsIgnoreCase(i.getKey()))) {
            return;
        }
        NoCodeSelectItemField wfLockStatus = new NoCodeSelectItemField();
        wfLockStatus.setId(Uuid16.create().toString());
        wfLockStatus.setKey(WfConsts.WfLockStatusEnum.LOCK_STATUS_KEY);
        wfLockStatus.setParentId(billEntity.getId());
        wfLockStatus.setName(new LocaleString(WfConsts.WfLockStatusEnum.LOCK_STATUS_NAME));
        String fieldName = String.format("%s%s", "f", WfConsts.WfLockStatusEnum.LOCK_STATUS_KEY);
        wfLockStatus.setFieldName(fieldName);
        wfLockStatus.getFeatures().setCopyable(false);
        wfLockStatus.getFeatures().setImportable(false);
        wfLockStatus.getFeatures().setExportable(false);
        wfLockStatus.getFeatures().setBulkEditable(false);
        wfLockStatus.getFeatures().setF7BatchFill(false);
        wfLockStatus.getFeatures().setConvertTote(false);
        wfLockStatus.setSupportQingAnalysis(false);
        CustomSelectContent customContent = new CustomSelectContent();
        customContent.setBgcSwitch(false);
        SelectItem unLock = new SelectItem();
        unLock.setValue(WfConsts.WfLockStatusEnum.UNLOCK.getCode());
        unLock.setLabel(new LocaleString(WfConsts.WfLockStatusEnum.UNLOCK.getName()));
        customContent.getOps().add(unLock);
        SelectItem locked = new SelectItem();
        locked.setValue(WfConsts.WfLockStatusEnum.LOCKED.getCode());
        locked.setLabel(new LocaleString(WfConsts.WfLockStatusEnum.LOCKED.getName()));
        customContent.getOps().add(locked);
        wfLockStatus.setCustomContent(customContent);
        billEntity.getItems().add(wfLockStatus);
        entityMeta.getItems().add(wfLockStatus);
    }

    private static void fixupNoCodeEntryAp(FormMetadata formMeta, EntityMetadata entityMeta, NoCodeEntryAp noCodeEntryAp) {
        boolean fixuped = formMeta.getItems().stream().anyMatch(i -> i.getId().equalsIgnoreCase(noCodeEntryAp.getParentId()) && i instanceof AdvConAp);
        if (fixuped) {
            return;
        }
        String advconapId = Uuid16.create().toString();
        NoCodeAdvConAp advconap = new NoCodeAdvConAp();
        advconap.setKey(advconapId);
        advconap.setName(noCodeEntryAp.getName());
        advconap.setId(advconapId);
        advconap.setIndex(2);
        advconap.setParentId(noCodeEntryAp.getParentId());
        advconap.setCollapsible(true);
        advconap.setGrow(0);
        advconap.setShrink(0);
        advconap.setColumnSpan(noCodeEntryAp.getColumnSpan());
        advconap.setIndex(noCodeEntryAp.getIndex());
        advconap.getCustomProperties().put("tableId", noCodeEntryAp.getEntry().getKey());
        if (noCodeEntryAp.getCustomProperties().containsKey("Visibility")) {
            advconap.getCustomProperties().put("Visibility", noCodeEntryAp.getCustomProperties().get("Visibility"));
        }
        FixupEntryEntityMeta.addControl(formMeta, entityMeta, (AdvConAp)advconap, noCodeEntryAp);
    }

    private static void addControl(FormMetadata formMeta, EntityMetadata entityMeta, AdvConAp advconap, NoCodeEntryAp noCodeEntryAp) {
        NoCodeEntryEntity entryEntity = (NoCodeEntryEntity)noCodeEntryAp.getEntry();
        Operation newEntryOperation = new Operation();
        String newEntryOperationId = Uuid16.create().toString().toLowerCase();
        newEntryOperation.setId(newEntryOperationId);
        newEntryOperation.setKey(newEntryOperationId);
        newEntryOperation.setName(new LocaleString("\u65b0\u589e\u5206\u5f55"));
        newEntryOperation.setOperationType(NEW_ENTRY);
        EntryOpParameter newOpParam = new EntryOpParameter();
        newOpParam.setEntryId(entryEntity.getId());
        newEntryOperation.setParameter((OperationParameter)newOpParam);
        Operation deleteEntryOperation = new Operation();
        String deleteEntryOperationId = Uuid16.create().toString().toLowerCase();
        deleteEntryOperation.setId(deleteEntryOperationId);
        deleteEntryOperation.setKey(deleteEntryOperationId);
        deleteEntryOperation.setName(new LocaleString("\u5220\u9664\u5206\u5f55"));
        deleteEntryOperation.setOperationType(DELETE_ENTRY);
        EntryOpParameter delOpParam = new EntryOpParameter();
        delOpParam.setEntryId(entryEntity.getId());
        deleteEntryOperation.setParameter((OperationParameter)delOpParam);
        Operation batchImportOperation = new Operation();
        String batchImportOperationId = Uuid16.create().toString().toLowerCase();
        batchImportOperation.setId(batchImportOperationId);
        batchImportOperation.setKey(batchImportOperationId);
        batchImportOperation.setName(new LocaleString(FixupEntryEntityMeta.getBatchImportTitle()));
        batchImportOperation.setOperationType(BATCH_IMPORT_DATA);
        EntryOpParameter batchImportOpParam = new EntryOpParameter();
        batchImportOpParam.setEntryId(entryEntity.getId());
        batchImportOperation.setParameter((OperationParameter)batchImportOpParam);
        Operation batchExportOperation = new Operation();
        String batchExportOperationId = Uuid16.create().toString().toLowerCase();
        batchExportOperation.setId(batchExportOperationId);
        batchExportOperation.setKey(batchExportOperationId);
        batchExportOperation.setName(new LocaleString(FixupEntryEntityMeta.getBatchExportTitle()));
        batchExportOperation.setOperationType(BATCH_EXPORT_DATA);
        EntryOpParameter batchExportOpParam = new EntryOpParameter();
        batchExportOpParam.setEntryId(entryEntity.getId());
        batchExportOperation.setParameter((OperationParameter)batchExportOpParam);
        Operation selectRecordOperation = new Operation();
        String selectRecordOperationId = Uuid16.create().toString().toLowerCase();
        selectRecordOperation.setId(selectRecordOperationId);
        selectRecordOperation.setKey(selectRecordOperationId);
        selectRecordOperation.setName(new LocaleString("\u9009\u62e9"));
        selectRecordOperation.setOperationType(SELECT_ENTRY);
        EntryOpParameter selectOpParam = new EntryOpParameter();
        selectOpParam.setEntryId(entryEntity.getId());
        selectRecordOperation.setParameter((OperationParameter)selectOpParam);
        List operations = entityMeta.getRootEntity().getOperations();
        operations.add(newEntryOperation);
        operations.add(deleteEntryOperation);
        operations.add(batchImportOperation);
        operations.add(batchExportOperation);
        operations.add(selectRecordOperation);
        List formItems = formMeta.getItems();
        AdvConChildPanelAp advConChildPanelAp = new AdvConChildPanelAp();
        String advConChildPanelApId = Uuid16.create().toString();
        advConChildPanelAp.setId(advConChildPanelApId);
        advConChildPanelAp.setKey(advConChildPanelApId);
        advConChildPanelAp.setName(new LocaleString("\u9ad8\u7ea7\u9762\u677f\u5b50\u5bb9\u5668"));
        advConChildPanelAp.setParentId(advconap.getId());
        advConChildPanelAp.setIndex(2);
        advConChildPanelAp.setDirection("column");
        advConChildPanelAp.setWrap(false);
        advConChildPanelAp.setAlignItems("stretch");
        AdvConToolbarAp advConToolbarAp = new AdvConToolbarAp();
        String advConToolbarApId = Uuid16.create().toString();
        advConToolbarAp.setId(advConToolbarApId);
        advConToolbarAp.setKey(advConToolbarApId);
        advConToolbarAp.setName(new LocaleString("\u9ad8\u7ea7\u9762\u677f\u5de5\u5177\u680f"));
        advConToolbarAp.setParentId(advconap.getId());
        advConToolbarAp.setIndex(1);
        NoCodeAdvConBarItemAp tbSelect = new NoCodeAdvConBarItemAp();
        String tbSelectId = Uuid16.create().toString();
        tbSelect.setId(tbSelectId);
        tbSelect.setKey(tbSelectId);
        tbSelect.setName(new LocaleString(ResManager.loadKDString((String)"\u9009\u62e9", (String)"FixupEntryEntityMeta_1", (String)"BOS_NOCODE", (Object[])new Object[0])));
        tbSelect.getName().put("zh_CN", (Object)"\u9009\u62e9");
        tbSelect.setOperationKey(selectRecordOperationId);
        tbSelect.setParentId(advConToolbarAp.getId());
        tbSelect.setBtnType(ADVCONBARITEM_TYPE_GHOST);
        tbSelect.setIcon(NCICON_ZENGJIA_YUAN);
        tbSelect.setIndex(0);
        if (noCodeEntryAp.getEntry() instanceof NoCodeRefBillTable) {
            tbSelect.setVisible(null);
        } else {
            tbSelect.setVisible("");
        }
        NoCodeAdvConBarItemAp tbNew = new NoCodeAdvConBarItemAp();
        String tbNewId = Uuid16.create().toString();
        tbNew.setId(tbNewId);
        tbNew.setKey(tbNewId);
        tbNew.setName(new LocaleString(ResManager.loadKDString((String)"\u65b0\u589e", (String)"FixupEntryEntityMeta_0", (String)"BOS_NOCODE", (Object[])new Object[0])));
        tbNew.getName().put("zh_CN", (Object)"\u65b0\u589e");
        tbNew.setOperationKey(newEntryOperationId);
        tbNew.setParentId(advConToolbarAp.getId());
        tbNew.setBtnType(ADVCONBARITEM_TYPE_GHOST);
        tbNew.setIcon(NCICON_ZENGJIA_YUAN);
        tbNew.setIndex(10);
        NoCodeAdvConBarItemAp tbBatchImport = new NoCodeAdvConBarItemAp();
        String tbBatchImportId = Uuid16.create().toString();
        tbBatchImport.setId(tbBatchImportId);
        tbBatchImport.setKey(tbBatchImportId);
        tbBatchImport.setName(new LocaleString(FixupEntryEntityMeta.getBatchImportTitle()));
        tbBatchImport.setOperationKey(batchImportOperationId);
        tbBatchImport.setParentId(advConToolbarAp.getId());
        tbBatchImport.setIcon(NCICON_DAORU);
        tbBatchImport.setIndex(20);
        if (noCodeEntryAp.isShowBatImportBtn()) {
            tbBatchImport.setVisible(null);
        } else {
            tbBatchImport.setVisible("");
        }
        NoCodeAdvConBarItemAp tbBatchExport = new NoCodeAdvConBarItemAp();
        String tbBatchExportId = Uuid16.create().toString();
        tbBatchExport.setId(tbBatchExportId);
        tbBatchExport.setKey(tbBatchExportId);
        tbBatchExport.setName(new LocaleString(FixupEntryEntityMeta.getBatchExportTitle()));
        tbBatchExport.setOperationKey(batchExportOperationId);
        tbBatchExport.setParentId(advConToolbarAp.getId());
        tbBatchExport.setIcon(NCICON_DAOCHU);
        tbBatchExport.setIndex(30);
        if (noCodeEntryAp.isShowBatExportBtn()) {
            tbBatchExport.setVisible(null);
        } else {
            tbBatchExport.setVisible("");
        }
        noCodeEntryAp.setParentId(advConChildPanelAp.getId());
        OperationColumnAp operColAp = new OperationColumnAp();
        String operColApId = Uuid16.create().toString();
        operColAp.setId(operColApId);
        operColAp.setParentId(noCodeEntryAp.getId());
        operColAp.setIndex(99);
        operColAp.setKey(operColApId);
        operColAp.setName(new LocaleString("\u64cd\u4f5c"));
        operColAp.setWidth(new LocaleString("80"));
        OperationColItem delColItem = new OperationColItem();
        String delColItemId = Uuid16.create().toString();
        delColItem.setId(delColItemId);
        delColItem.setOperationKey(deleteEntryOperationId);
        delColItem.setOperationName(new LocaleString("\u5220\u9664"));
        operColAp.getOperationColItems().add(delColItem);
        formItems.add(advconap);
        formItems.add(advConToolbarAp);
        formItems.add(advConChildPanelAp);
        if (FixupEntryEntityMeta.canAddNewBtn(noCodeEntryAp)) {
            log.debug("newEntry=====" + tbNew.getKey());
            noCodeEntryAp.getCustomProperties().put("newEntry", tbNew.getKey());
            formItems.add(tbNew);
        }
        if (FixupEntryEntityMeta.canAddSelectBtn(noCodeEntryAp)) {
            noCodeEntryAp.getCustomProperties().put("selectEntry", tbSelect.getKey());
            formItems.add(tbSelect);
        }
        formItems.add(tbBatchImport);
        formItems.add(tbBatchExport);
        formItems.add(operColAp);
    }

    private static boolean canAddNewBtn(NoCodeEntryAp noCodeEntryAp) {
        NoCodeRefBillTable table;
        return !(noCodeEntryAp.getEntry() instanceof NoCodeRefBillTable) || !BlackFormUtil.isCosmicForm((String)(table = (NoCodeRefBillTable)noCodeEntryAp.getEntry()).getBillEntityIdEx());
    }

    private static boolean canAddSelectBtn(NoCodeEntryAp noCodeEntryAp) {
        if (noCodeEntryAp.getEntry() instanceof NoCodeRefBillTable) {
            NoCodeRefBillTable table = (NoCodeRefBillTable)noCodeEntryAp.getEntry();
            return !"1".equals(table.getSourceForm());
        }
        return false;
    }
}

