/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.metadata.dao;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataColumnCollection;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.FieldInfo;
import kd.bos.db.SqlObject;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ca.CertRule;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.IAlterTableUtilDB;
import kd.bos.metadata.dao.ShardingUtil;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.LinkEntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.SplitTable;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.TreeEntryEntity;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IDBField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.mservice.svc.attach.IAttachmentField;
import kd.bos.nocode.metadata.dao.AlterTableFieldHelper;
import kd.bos.nocode.metadata.dao.NoCodeAlterTableUtilDB;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;

public class NoCodeAlterTableUtil {
    private static final Log log = LogFactory.getLog(NoCodeAlterTableUtil.class);
    private static final String SQL = "ALTER TABLE %s ADD %s %s DEFAULT(0) NOT NULL;";
    private static final String ALTER_ADD_SQL = "ALTER TABLE %s ADD %s;";
    private static final String ALTER_ADD_NCLOB_SQL = "ALTER TABLE %s ADD %s NCLOB NULL;";
    private static final String CREATE_SQL = "CREATE TABLE %s (";
    private static final String NOT_NULL = " NOT NULL,";
    private static final String CONSTRAINT = "CONSTRAINT ";
    private static final String PRIMARY_KEY = " PRIMARY KEY(%s));";
    private static final String FCLEAR_TEXT = "FClearText";
    private static final String FSIGN_TEXT = "FSignText";
    private static final String FUSER_ID = "FuserId";
    private static final String NOT_NULL_END = " NOT NULL;";
    private static final String NOTNULL = " NOT NULL";
    private static final String DEFAULT_NVARCHAR = " DEFAULT(' ');";
    private static final String DEFAULT_BIGINT = " DEFAULT(0);";
    private static final String FPK_ID = "FPKID";
    private static final String FLOCALE_ID = "FLocaleID";
    public static final String ADD_COLUMN = "ALTER TABLE %s ADD %s ";
    public static final String NVARCHAR_36 = "NVARCHAR(36)";
    public static final String BIGINT = "BIGINT";
    private static ConcurrentHashMap<String, Object> lockMap = new ConcurrentHashMap();
    private IAlterTableUtilDB dbImpl = new NoCodeAlterTableUtilDB();

    protected boolean createExtTable(EntityMetadata entityMetadata, Entity<?, ?> entity, boolean useSharding, String trackParentTableName) {
        return this.createTable(entityMetadata, entity, useSharding, trackParentTableName, true);
    }

    protected boolean createTable(EntityMetadata entityMetadata, Entity<?, ?> entity, boolean useSharding) {
        return this.createTable(entityMetadata, entity, useSharding, null, false);
    }

    protected boolean createTable(EntityMetadata entityMetadata, Entity<?, ?> entity, boolean useSharding, String trackParentTableName) {
        return this.createTable(entityMetadata, entity, useSharding, trackParentTableName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createTable(EntityMetadata entityMetadata, Entity<?, ?> entity, boolean useSharding, String trackParentTableName, boolean extSchema) {
        boolean result = false;
        try (TXHandle h = TX.notSupported();){
            List splitTables = entity.getSplitTables();
            if (StringUtils.isBlank((CharSequence)entity.getTableName()) || StringUtils.equalsIgnoreCase((CharSequence)"t_isv_xxx", (CharSequence)entity.getTableName().trim())) {
                boolean bl = false;
                return bl;
            }
            ArrayList<String> suffixList = new ArrayList<String>();
            if (splitTables != null) {
                String dbRouteKey;
                DBRoute dbRoute;
                DBType dbType;
                String suffix = null;
                for (SplitTable s : splitTables) {
                    suffix = s.getSuffix();
                    if (suffix == null || !StringUtils.isNotEmpty((CharSequence)suffix)) continue;
                    suffixList.add(suffix);
                }
                String queryFields = "fid";
                String hintFkField = "fid";
                AtomicBoolean isSingleField = new AtomicBoolean(true);
                Entity parentEntity = this.findParentEntity(entityMetadata, entity);
                if (entity.getClass().isAssignableFrom(BillEntity.class)) {
                    hintFkField = queryFields = ((BillEntity)entity).getPkFieldName();
                } else if (entity.getClass().isAssignableFrom(EntryEntity.class)) {
                    hintFkField = parentEntity != null ? ((BillEntity)parentEntity).getPkFieldName() : "fid";
                    queryFields = hintFkField + ',' + ((EntryEntity)entity).getEntryPkFieldName();
                    isSingleField.set(false);
                } else if (entity.getClass().isAssignableFrom(SubEntryEntity.class)) {
                    hintFkField = parentEntity != null ? ((EntryEntity)parentEntity).getEntryPkFieldName() : "fentryid";
                    queryFields = hintFkField + ',' + ((SubEntryEntity)entity).getEntryPkFieldName();
                    isSingleField.set(false);
                }
                ArrayList<SqlObject> sqlList = new ArrayList<SqlObject>();
                ArrayList<String> tableNameSuffix = new ArrayList<String>();
                tableNameSuffix.add("");
                tableNameSuffix.addAll(suffixList);
                DbMetadataTable entityMainTableSchema = null;
                String dbRoueKey = entityMetadata.getDBRouteKey();
                ArrayList<SqlObject> splitTableSqlList = new ArrayList<SqlObject>();
                String tableName = entity.getTableName();
                Object lo = new Object();
                Object lockObj = lockMap.putIfAbsent(tableName, lo);
                if (lockObj == null) {
                    lockObj = lo;
                }
                boolean notSupportBlobFilter = (dbType = DB.getDBType((DBRoute)(dbRoute = new DBRoute(dbRouteKey = entityMetadata.getDBRouteKey())))) == DBType.DM || dbType == DBType.OceanBase_Oracle || dbType == DBType.YasDB || dbType == DBType.HANA || dbType == DBType.Oracle || dbType == DBType.SQLServer;
                Object object = lockObj;
                synchronized (object) {
                    ArrayList inRange;
                    String sql;
                    List dataSet;
                    for (int i = 0; i < tableNameSuffix.size(); ++i) {
                        String t_suffix = (String)tableNameSuffix.get(i);
                        String newTableName = tableName;
                        if (StringUtils.isNotBlank((CharSequence)t_suffix)) {
                            newTableName = String.format("%s_%s", tableName, t_suffix);
                        }
                        DbMetadataTable tableSchema = this.dbImpl.getTableSchema(dbRoueKey, newTableName, false);
                        if (StringUtils.isBlank((CharSequence)t_suffix)) {
                            entityMainTableSchema = tableSchema;
                        }
                        if (tableSchema == null) {
                            this.genCreateTableSql(entityMetadata, entity, newTableName, sqlList, useSharding, trackParentTableName, notSupportBlobFilter);
                            if (i <= 0) continue;
                            StringBuilder insertSql = new StringBuilder();
                            if (isSingleField.get()) {
                                insertSql.append("insert into ").append(newTableName).append("(").append(queryFields).append(") values(?)");
                            } else {
                                insertSql.append("insert into ").append(newTableName).append("(").append(queryFields).append(") values(?,?)");
                            }
                            splitTableSqlList.add(new SqlObject(insertSql.toString(), null));
                            continue;
                        }
                        this.genAlterTableSql(entityMetadata, entity, tableSchema, newTableName, sqlList, useSharding, extSchema, notSupportBlobFilter);
                    }
                    if (sqlList != null && sqlList.size() > 0) {
                        for (SqlObject list : sqlList) {
                            try {
                                this.dbImpl.execute(dbRoute, list.getSql(), (Object[])list.getParams());
                            }
                            catch (Exception e) {
                                log.warn((Throwable)e);
                                if (e.getMessage().contains("cannot cast type")) {
                                    throw new KDException(ResManager.loadKDString((String)"\u56e0\u6570\u636e\u8f6c\u6362\u5931\u8d25\uff0c\u5b57\u6bb5\u7c7b\u578b\u5207\u6362\u4e0d\u6210\u529f", (String)"NoCodeAlterTableUtil_0", (String)"bos-nocode-service", (Object[])new Object[0]));
                                }
                                if (e.getMessage().contains("numeric field overflow")) {
                                    throw new KDException(ResManager.loadKDString((String)"\u5b58\u5728\u6570\u5b57\u6ea2\u51fa\uff0c\u90e8\u5206\u6570\u636e\u8f6c\u6362\u4e0d\u6210\u529f", (String)"NoCodeAlterTableUtil_1", (String)"bos-nocode-service", (Object[])new Object[0]));
                                }
                                if (e.getMessage().contains("tables can have at most 1600 columns")) {
                                    throw new KDException(ResManager.loadKDString((String)"\u5b57\u6bb5\u8fc7\u591a\uff0c\u8bf7\u5220\u9664\u4e0d\u4f7f\u7528\u7684\u5b57\u6bb5", (String)"NoCodeAlterTableUtil_2", (String)"bos-nocode-service", (Object[])new Object[0]));
                                }
                                if (e.getMessage().contains("Row size too large")) {
                                    throw new KDException(ResManager.loadKDString((String)"\u5217\u957f\u5ea6\u8d85\u8fc7\u4e86\u6700\u5927\u957f\u5ea6\u9650\u5236", (String)"NoCodeAlterTableUtil_3", (String)"bos-nocode-service", (Object[])new Object[0]));
                                }
                                if (e.getMessage().contains("\u5217\u4e0d\u5141\u8bb8\u6709 Null \u503c")) {
                                    log.error((Throwable)e);
                                    continue;
                                }
                                throw new KDException(ResManager.loadKDString((String)"\u6570\u636e\u8868\u521b\u5efa\u5931\u8d25", (String)"NoCodeAlterTableUtil_4", (String)"bos-nocode-service", (Object[])new Object[0]));
                            }
                        }
                        result = true;
                    }
                    if (!splitTableSqlList.isEmpty() && !(dataSet = (List)this.dbImpl.query(new DBRoute(dbRoueKey), sql = "select " + queryFields + " from " + entity.getTableName(), arg_0 -> NoCodeAlterTableUtil.lambda$createTable$0(isSingleField, inRange = new ArrayList(), arg_0))).isEmpty()) {
                        for (SqlObject sqlObject : splitTableSqlList) {
                            if (useSharding) {
                                String parentTableName = parentEntity == null ? entity.getTableName() : parentEntity.getTableName();
                                ShardingHintContext shc = ShardingHintContext.createAndSet((String)parentTableName, (HintCondition[])new HintCondition[]{new HintCondition(hintFkField, FilterType.in_range, inRange)});
                                Throwable throwable = null;
                                try {
                                    this.dbImpl.executeBatch(new DBRoute(dbRoueKey), sqlObject.getSql(), dataSet);
                                    continue;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (shc == null) continue;
                                    if (throwable != null) {
                                        try {
                                            shc.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    shc.close();
                                    continue;
                                }
                            }
                            this.dbImpl.executeBatch(new DBRoute(dbRoueKey), sqlObject.getSql(), dataSet);
                        }
                    }
                    lockMap.remove(tableName);
                }
            }
            boolean bl = result;
            return bl;
        }
    }

    private Entity findParentEntity(EntityMetadata entityMetadata, Entity<?, ?> entity) {
        MainEntity rootEntity = entityMetadata.getRootEntity();
        List items = rootEntity.getItems();
        return this.collectExplicitlyParentEntity(items, entity, (Entity)rootEntity);
    }

    private Entity collectExplicitlyParentEntity(List<EntityItem<?>> items, Entity<?, ?> entity, Entity parentEntity) {
        for (EntityItem<?> item : items) {
            if (!(item instanceof EntryEntity)) continue;
            if (StringUtils.equals((CharSequence)entity.getKey(), (CharSequence)item.getKey())) {
                return parentEntity;
            }
            Entity explicitlyParentEntity = this.collectExplicitlyParentEntity(((EntryEntity)item).getItems(), entity, (Entity)((EntryEntity)item));
            if (explicitlyParentEntity == null) continue;
            return explicitlyParentEntity;
        }
        return null;
    }

    private void genAlterTableSql(EntityMetadata entityMetadata, Entity<?, ?> entity, DbMetadataTable tableSchema, String tableName, List<SqlObject> sqlList, boolean useSharding, boolean isExtMeta, boolean notSupportBlobFilter) {
        EntityItem parentItem;
        if (StringUtils.isEmpty((CharSequence)entity.getTableName()) || StringUtils.isEmpty((CharSequence)tableName)) {
            return;
        }
        String sql = "";
        List entityList = entityMetadata.getEntitys();
        String pkFieldName = null;
        String pkFieldType = null;
        for (Entity billEntity : entityList) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            pkFieldType = this.getPkFieldType(((BillEntity)billEntity).getPkType() == 0 ? -9 : -5);
            break;
        }
        if ((entity instanceof SubEntryEntity || entity instanceof LinkEntryEntity) && !((parentItem = entityMetadata.getItemById(entity.getParentId())) instanceof BillEntity)) {
            if (parentItem instanceof EntryEntity) {
                pkFieldName = ((EntryEntity)parentItem).getEntryPkFieldName();
            } else if (parentItem == null) {
                return;
            }
        }
        if (!NoCodeAlterTableUtil.existsFieldInTableSchema(tableSchema, pkFieldName) && !StringUtils.isEmpty((CharSequence)pkFieldName)) {
            sql = String.format(SQL, tableName, pkFieldName, pkFieldType);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
        }
        if (entity instanceof MainEntity) {
            if (entity instanceof BillEntity && !NoCodeAlterTableUtil.existsFieldInTableSchema(tableSchema, ((BillEntity)entity).getEntityTypeId()) && StringUtils.isNotBlank((CharSequence)((BillEntity)entity).getEntityTypeId()) && tableName.equalsIgnoreCase(entity.getTableName())) {
                sql = String.format("ALTER TABLE  %s ADD  %s varchar(36) DEFAULT('') NOT NULL;", tableName, ((BillEntity)entity).getEntityTypeId());
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
        } else {
            String entryParentPkField;
            String entryPkField = ((EntryEntity)entity).getEntryPkFieldName();
            String entrySeqField = ((EntryEntity)entity).getSeqFieldName();
            if (!NoCodeAlterTableUtil.existsFieldInTableSchema(tableSchema, entryPkField) && !StringUtils.isEmpty((CharSequence)entryPkField)) {
                sql = String.format(SQL, tableName, entryPkField, pkFieldType);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (entity instanceof TreeEntryEntity && !NoCodeAlterTableUtil.existsFieldInTableSchema(tableSchema, entryParentPkField = ((TreeEntryEntity)entity).getEntryParentPkFieldName()) && !StringUtils.isEmpty((CharSequence)entryParentPkField)) {
                sql = String.format(SQL, tableName, entryParentPkField, pkFieldType);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!StringUtils.isEmpty((CharSequence)entrySeqField) && !NoCodeAlterTableUtil.existsFieldInTableSchema(tableSchema, entrySeqField) && tableName.equalsIgnoreCase(entity.getTableName())) {
                sql = String.format("ALTER TABLE %s ADD %s int DEFAULT(0) NOT NULL;", tableName, entrySeqField);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
        }
        ArrayList<MuliLangTextField> mulLangFields = new ArrayList<MuliLangTextField>();
        ArrayList<MulBasedataField> mulBDFields = new ArrayList<MulBasedataField>();
        ArrayList<IAttachmentField> attachmentFields = new ArrayList<IAttachmentField>();
        ArrayList<Field> listFields = new ArrayList<Field>();
        Field itemField = null;
        List entityItem = entity.getItems();
        for (EntityItem item : entityItem) {
            if (!(item instanceof Field)) continue;
            itemField = (Field)item;
            if ((!isExtMeta || !itemField.isExt()) && (isExtMeta || itemField.isInherit())) continue;
            listFields.add(itemField);
        }
        for (Field field : listFields) {
            if (field instanceof MuliLangTextField) {
                mulLangFields.add((MuliLangTextField)field);
                if (!((MuliLangTextField)field).isGL()) continue;
            }
            if (field instanceof IAttachmentField) {
                attachmentFields.add((IAttachmentField)field);
                continue;
            }
            if (field instanceof MulBasedataField) {
                mulBDFields.add((MulBasedataField)field);
                continue;
            }
            if (!tableName.equalsIgnoreCase(field.getTableName(entity))) continue;
            List dbFields = field.getDBFields();
            for (IDBField dbField : dbFields) {
                AlterTableFieldHelper.addAlterTableField(sqlList, tableName, (Field)dbField, tableSchema, notSupportBlobFilter);
            }
        }
        if (mulLangFields.size() > 0 && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genAlertMulLangTableSQL(entityMetadata, entity, mulLangFields, sqlList, useSharding);
        }
        if (entity instanceof BillEntity && ((BillEntity)entity).getSignField().size() > 0 && ((CertRule)((BillEntity)entity).getSignField().get(0)).getSignoperate().size() > 0) {
            this.genAlertSignTableSQL(entityMetadata, entity, sqlList);
        }
        if (mulBDFields.size() > 0 && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genAlertMulBsdTableSQL(entityMetadata, entity, mulBDFields, sqlList);
        }
        if (attachmentFields.size() > 0 && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genAlertAttachmentTableSQL(entityMetadata, entity, attachmentFields, sqlList);
        }
    }

    public static DbMetadataTable getTableSchema(String dbKey, String tableName, boolean withPkInfo) {
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)dbKey), (String)tableName)) {
            return null;
        }
        List fieldInfo = DB.getFieldInfo((DBRoute)DBRoute.of((String)dbKey), (String)tableName);
        DbMetadataTable metadataTable = new DbMetadataTable();
        DbMetadataColumnCollection col = new DbMetadataColumnCollection(metadataTable);
        for (FieldInfo info : fieldInfo) {
            DbMetadataColumn dbMetadataColumn = new DbMetadataColumn(info.getFieldName());
            dbMetadataColumn.setDbType(info.getJDBCDataType());
            dbMetadataColumn.setSize((int)info.getDataLength());
            dbMetadataColumn.setScale((byte)info.getDataScale());
            col.add(dbMetadataColumn);
        }
        if (withPkInfo) {
            List pks = DB.getPrimaryKeys((DBRoute)DBRoute.of((String)dbKey), (String)tableName);
            for (String pk : pks) {
                metadataTable.setPrimaryKey(new DbMetadataColumn(pk));
            }
        }
        metadataTable.setColumns(col);
        return metadataTable;
    }

    private void genCreateTableSql(EntityMetadata entityMetadata, Entity<?, ?> entity, String tableName, List<SqlObject> sqlList, boolean useSharding, String trackParentTableName, boolean notSupportBlobFilter) {
        String entryParentPkField;
        List entityList = entityMetadata.getEntitys();
        String pkFieldName = null;
        String pkFieldType = null;
        for (Entity billEntity : entityList) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            pkFieldType = this.getPkFieldType(((BillEntity)billEntity).getPkType() == 0 ? -9 : -5);
            break;
        }
        boolean existsEntryPKFieldName = false;
        StringBuilder sb = new StringBuilder();
        if (useSharding) {
            ShardingUtil.ensureAdd2CurrentRuntimeShardingConfig((EntityMetadata)entityMetadata, entity, (String)tableName, (String)trackParentTableName);
        } else {
            sb.append(String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s') ", tableName));
        }
        sb.append(String.format(CREATE_SQL, tableName));
        if (entity instanceof SubEntryEntity || entity instanceof LinkEntryEntity) {
            EntityItem parentItem = entityMetadata.getItemById(entity.getParentId());
            if (!(parentItem instanceof BillEntity)) {
                if (parentItem instanceof EntryEntity) {
                    pkFieldName = ((EntryEntity)parentItem).getEntryPkFieldName();
                } else if (parentItem == null) {
                    return;
                }
            }
            sb.append(pkFieldName).append(" ").append(pkFieldType).append(NOT_NULL);
        } else {
            if (entity instanceof EntryEntity && ((EntryEntity)entity).getFkFieldName() != null) {
                pkFieldName = ((EntryEntity)entity).getFkFieldName();
            }
            sb.append(pkFieldName).append(" ").append(pkFieldType).append(NOT_NULL);
        }
        if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)((EntryEntity)entity).getEntryPkFieldName())) {
            sb.append(((EntryEntity)entity).getEntryPkFieldName()).append(" ").append(pkFieldType).append(NOT_NULL);
            existsEntryPKFieldName = true;
        }
        if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)entity.getKey()) && tableName.equalsIgnoreCase(entity.getTableName())) {
            sb.append(((EntryEntity)entity).getSeqFieldName()).append(" int DEFAULT(0) NOT NULL,");
        }
        if (entity instanceof TreeEntryEntity && StringUtils.isNotBlank((CharSequence)(entryParentPkField = ((TreeEntryEntity)entity).getEntryParentPkFieldName()))) {
            sb.append(entryParentPkField).append(" ").append(pkFieldType).append(" DEFAULT(0) NOT NULL,");
        }
        if (entity instanceof BillEntity && StringUtils.isNotBlank((CharSequence)((BillEntity)entity).getEntityTypeId()) && tableName.equalsIgnoreCase(entity.getTableName())) {
            sb.append(((BillEntity)entity).getEntityTypeId()).append(" varchar(36) DEFAULT('') NOT NULL , ");
        }
        if (!StringUtils.isEmpty((CharSequence)entity.getSrcEntityDisaKey())) {
            // empty if block
        }
        ArrayList<MuliLangTextField> mulLangFields = new ArrayList<MuliLangTextField>();
        ArrayList<MulBasedataField> mulBDFields = new ArrayList<MulBasedataField>();
        ArrayList<IAttachmentField> attachmentFields = new ArrayList<IAttachmentField>();
        ArrayList<Field> listFields = new ArrayList<Field>();
        Field itemField = null;
        List entityItem = entity.getItems();
        for (EntityItem item : entityItem) {
            if (!(item instanceof Field)) continue;
            itemField = (Field)item;
            listFields.add(itemField);
        }
        for (Field field : listFields) {
            if (field instanceof IAttachmentField) {
                attachmentFields.add((IAttachmentField)field);
                continue;
            }
            if (field instanceof MulBasedataField) {
                mulBDFields.add((MulBasedataField)field);
                continue;
            }
            if (field instanceof MuliLangTextField && !StringUtils.isEmpty((CharSequence)field.getFieldName())) {
                mulLangFields.add((MuliLangTextField)field);
                if (!((MuliLangTextField)field).isGL()) continue;
            }
            if (!tableName.equalsIgnoreCase(field.getTableName(entity))) continue;
            List fields = field.getDBFields();
            for (IDBField idbField : fields) {
                String fieldDesc = AlterTableFieldHelper.getCreateTableFieldDesc(idbField, notSupportBlobFilter);
                if (fieldDesc.length() <= 0) continue;
                sb.append(fieldDesc);
            }
        }
        sb.append(CONSTRAINT);
        String pkName = "pk_" + (tableName.length() > 2 ? tableName.substring(2) : tableName);
        sb.append(pkName);
        sb.append(" PRIMARY KEY(");
        String colName = existsEntryPKFieldName ? ((EntryEntity)entity).getEntryPkFieldName() : pkFieldName;
        sb.append(colName).append("));");
        String sql = this.getShardingTableSql(tableName, pkFieldName, sb.toString());
        sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
        if (existsEntryPKFieldName) {
            String sqlFKIndex = String.format("create index idx_%s_fk on %s(%s ASC)", tableName.length() > 2 ? tableName.substring(2) : tableName, tableName, pkFieldName);
            sqlList.add(new SqlObject(sqlFKIndex, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
        }
        if (mulLangFields.size() > 0 && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genAlertMulLangTableSQL(entityMetadata, entity, mulLangFields, sqlList, useSharding);
        }
        if (entity instanceof BillEntity && ((BillEntity)entity).getSignField().size() > 0 && ((CertRule)((BillEntity)entity).getSignField().get(0)).getSignoperate().size() > 0) {
            this.genAlertSignTableSQL(entityMetadata, entity, sqlList);
        }
        if (mulBDFields.size() > 0 && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genAlertMulBsdTableSQL(entityMetadata, entity, mulBDFields, sqlList);
        }
        if (attachmentFields.size() > 0 && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genAlertAttachmentTableSQL(entityMetadata, entity, attachmentFields, sqlList);
        }
    }

    private String getShardingTableSql(String tableName, String shardingColumn, String createTableSql) {
        return createTableSql;
    }

    private void genAlertSignTableSQL(EntityMetadata entityMetadata, Entity<?, ?> entity, List<SqlObject> sqlList) {
        StringBuilder sb = new StringBuilder();
        String sql = "";
        String pkFieldName = null;
        String pkFieldType = null;
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        for (Entity billEntity : entityMetadata.getEntitys()) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            pkFieldType = this.getPkFieldType(((BillEntity)billEntity).getPkType() == 0 ? -9 : -5);
            break;
        }
        String signTableName = entity.getTableName() + "_SN";
        DbMetadataTable tableSchema = NoCodeAlterTableUtil.getTableSchema(entityMetadata.getDBRouteKey(), signTableName, false);
        if (null == tableSchema) {
            sb.append(String.format(CREATE_SQL, signTableName));
            sb.append(pkFieldName).append(" ").append(pkFieldType).append(NOT_NULL);
            sb.append(CONSTRAINT);
            String pkName = "pk_" + (signTableName.length() > 2 ? signTableName.substring(2) : signTableName);
            sb.append(pkName);
            sb.append(String.format(PRIMARY_KEY, pkFieldName));
            sql = this.getShardingTableSql(signTableName, pkFieldName, sb.toString());
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            sql = String.format("ALTER TABLE %s ADD %s NCLOB NOT NULL;", signTableName, FCLEAR_TEXT);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            sql = String.format("ALTER TABLE %s ADD %s varchar(500) NOT NULL;", signTableName, FSIGN_TEXT);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            sql = String.format("ALTER TABLE %s ADD %s varchar(20) NOT NULL;", signTableName, FUSER_ID);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            sql = String.format("CREATE INDEX %s ON %s(FID);", "idx_" + signTableName + "_SIGNID", signTableName);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
        } else {
            if (!NoCodeAlterTableUtil.existsFieldInTableSchema(tableSchema, pkFieldName)) {
                sql = String.format(ADD_COLUMN + pkFieldType + NOT_NULL_END, signTableName, pkFieldName);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!NoCodeAlterTableUtil.existsFieldInTableSchema(tableSchema, FCLEAR_TEXT)) {
                sql = String.format("ALTER TABLE %s ADD %s NCLOB NOT NULL;", signTableName, FCLEAR_TEXT);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!NoCodeAlterTableUtil.existsFieldInTableSchema(tableSchema, FSIGN_TEXT)) {
                sql = String.format("ALTER TABLE %s ADD %s varchar(500) NOT NULL;", signTableName, FSIGN_TEXT);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!NoCodeAlterTableUtil.existsFieldInTableSchema(tableSchema, FUSER_ID)) {
                sql = String.format("ALTER TABLE %s ADD %s varchar(20) NOT NULL;", signTableName, FUSER_ID);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
        }
    }

    private void genAlertMulLangTableSQL(EntityMetadata entityMetadata, Entity<?, ?> entity, List<MuliLangTextField> multiLangFields, List<SqlObject> sqlList, boolean useSharding) {
        StringBuilder sb = new StringBuilder();
        String mulLangTablePKField = FPK_ID;
        String sql = "";
        String defaultValue = "";
        String pkFieldName = null;
        String pkFieldType = null;
        String mulLangPkFieldType = null;
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        for (Entity billEntity : entityMetadata.getEntitys()) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            mulLangPkFieldType = this.getPkFieldType(-9);
            pkFieldType = this.getPkFieldType(((BillEntity)billEntity).getPkType() == 0 ? -9 : -5);
            break;
        }
        String mulLangTableName = entity.getTableName() + "_L";
        DbMetadataTable tableSchema = this.dbImpl.getTableSchema(entityMetadata.getDBRouteKey(), mulLangTableName, false);
        if (StringUtils.equals((CharSequence)NVARCHAR_36, pkFieldType)) {
            defaultValue = DEFAULT_NVARCHAR;
        } else if (StringUtils.equals((CharSequence)BIGINT, (CharSequence)pkFieldType)) {
            defaultValue = DEFAULT_BIGINT;
        }
        if (null == tableSchema) {
            if (useSharding) {
                ShardingUtil.ensureAdd2CurrentRuntimeShardingConfig((EntityMetadata)entityMetadata, entity, (String)mulLangTableName.toLowerCase(), null);
            }
            sb.append(String.format(CREATE_SQL, mulLangTableName));
            sb.append(mulLangTablePKField).append(" ").append(mulLangPkFieldType).append(NOT_NULL);
            sb.append(CONSTRAINT);
            String pkName = "pk_" + (mulLangTableName.length() > 2 ? mulLangTableName.substring(2) : mulLangTableName);
            sb.append(pkName);
            sb.append(String.format(PRIMARY_KEY, mulLangTablePKField));
            sql = this.getShardingTableSql(mulLangTableName, pkFieldName, sb.toString());
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            if (entity instanceof MainEntity) {
                sql = String.format(ADD_COLUMN + pkFieldType + NOTNULL + defaultValue, mulLangTableName, pkFieldName);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)((EntryEntity)entity).getEntryPkFieldName())) {
                sql = String.format(ADD_COLUMN + pkFieldType + NOTNULL + defaultValue, mulLangTableName, ((EntryEntity)entity).getEntryPkFieldName());
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            sql = String.format("ALTER TABLE %s ADD %s varchar(10) NOT NULL DEFAULT('');", mulLangTableName, FLOCALE_ID);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            String entryPkId = entity instanceof EntryEntity ? ((EntryEntity)entity).getEntryPkFieldName() : ((BillEntity)entity).getPkFieldName();
            sql = String.format("CREATE INDEX %s ON %s(" + entryPkId + ",FLocaleId);", "idx_" + mulLangTableName.substring(2) + "_0", mulLangTableName);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
        } else {
            if (!NoCodeAlterTableUtil.existsFieldInTableSchema(tableSchema, mulLangTablePKField)) {
                sql = String.format(ADD_COLUMN + pkFieldType + NOTNULL + defaultValue, mulLangTableName, mulLangTablePKField);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (entity instanceof MainEntity && !NoCodeAlterTableUtil.existsFieldInTableSchema(tableSchema, pkFieldName)) {
                sql = String.format(ADD_COLUMN + pkFieldType + NOTNULL + defaultValue, mulLangTableName, pkFieldName);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!(entity instanceof MainEntity) && !NoCodeAlterTableUtil.existsFieldInTableSchema(tableSchema, ((EntryEntity)entity).getEntryPkFieldName())) {
                sql = String.format(ADD_COLUMN + pkFieldType + NOTNULL + defaultValue, mulLangTableName, ((EntryEntity)entity).getEntryPkFieldName());
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!NoCodeAlterTableUtil.existsFieldInTableSchema(tableSchema, FLOCALE_ID)) {
                sql = String.format("ALTER TABLE %s ADD %s varchar(10) NOT NULL DEFAULT('');", mulLangTableName, FLOCALE_ID);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
        }
        for (MuliLangTextField field : multiLangFields) {
            if (StringUtils.isNotEmpty((CharSequence)field.getFieldName()) && !NoCodeAlterTableUtil.existsFieldInTableSchema(tableSchema, field.getFieldName())) {
                sql = String.format(ALTER_ADD_SQL, mulLangTableName, IDBField.genFieldDesc((IDBField)field));
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (field.isEncrypt() && StringUtils.isNotEmpty((CharSequence)field.getEncryptFieldName()) && !NoCodeAlterTableUtil.existsFieldInTableSchema(tableSchema, field.getEncryptFieldName())) {
                sql = String.format(ALTER_ADD_NCLOB_SQL, mulLangTableName, field.getEncryptFieldName());
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!field.isPrivacyField() || !StringUtils.isNotEmpty((CharSequence)field.getFieldName()) || NoCodeAlterTableUtil.existsFieldInTableSchema(tableSchema, field.getFieldName() + "_pr")) continue;
            sql = String.format(ALTER_ADD_NCLOB_SQL, mulLangTableName, field.getFieldName() + "_pr");
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
        }
    }

    private void genAlertMulBsdTableSQL(EntityMetadata entityMetadata, Entity<?, ?> entity, List<MulBasedataField> mulBasedataFields, List<SqlObject> sqlList) {
        String mulBsdTablePKField = FPK_ID;
        String bsdFKField = "FBasedataId";
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        MainEntity rootEntity = entityMetadata.getRootEntity();
        if (rootEntity == null || !(rootEntity instanceof BillEntity)) {
            return;
        }
        String pkFieldName = ((BillEntity)rootEntity).getPkFieldName();
        String pkFieldType = this.getPkFieldType(((BillEntity)rootEntity).getPkType() == 0 ? -9 : -5);
        String fkFieldName = pkFieldName;
        if (entity instanceof EntryEntity) {
            fkFieldName = ((EntryEntity)entity).getEntryPkFieldName();
        }
        if (StringUtils.isBlank((CharSequence)fkFieldName)) {
            return;
        }
        String sql = "";
        for (MulBasedataField mulBsdfield : mulBasedataFields) {
            String mulBsdTableName = mulBsdfield.getTableName();
            DbMetadataTable tableSchema = NoCodeAlterTableUtil.getTableSchema(entityMetadata.getDBRouteKey(), mulBsdTableName, false);
            StringBuilder sb = new StringBuilder();
            if (null != tableSchema || !StringUtils.isNotBlank((CharSequence)mulBsdTableName)) continue;
            sb.append("CREATE TABLE ").append(mulBsdTableName).append("(");
            sb.append(mulBsdTablePKField).append(" ").append(pkFieldType).append(NOT_NULL);
            sb.append(fkFieldName).append(" ").append(pkFieldType).append(NOT_NULL);
            sb.append(bsdFKField).append(" ").append(this.getPkFieldType(mulBsdfield.getFieldDBType())).append(NOT_NULL);
            sb.append(CONSTRAINT);
            String pkName = "pk_" + (mulBsdTableName.length() > 2 ? mulBsdTableName.substring(2) : mulBsdTableName);
            sb.append(pkName);
            sb.append(String.format(PRIMARY_KEY, mulBsdTablePKField));
            sql = this.getShardingTableSql(mulBsdTableName, pkFieldName, sb.toString());
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            String sqlFKIndex = String.format("create index idx_%s_fk on %s(%s ASC)", mulBsdTableName.length() > 2 ? mulBsdTableName.substring(2) : mulBsdTableName, mulBsdTableName, fkFieldName);
            sqlList.add(new SqlObject(sqlFKIndex, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
        }
    }

    private void genAlertAttachmentTableSQL(EntityMetadata entityMetadata, Entity<?, ?> entity, List<IAttachmentField> attachmentFields, List<SqlObject> sqlList) {
        String attachmentTablePKField = FPK_ID;
        String attFKField = "FBasedataId";
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        String pkFieldName = null;
        String pkFieldType = null;
        String defaultValue = "";
        for (Entity billEntity : entityMetadata.getEntitys()) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            pkFieldType = this.getPkFieldType(((BillEntity)billEntity).getPkType() == 0 ? -9 : -5);
            break;
        }
        if (StringUtils.equals((CharSequence)NVARCHAR_36, pkFieldType)) {
            defaultValue = DEFAULT_NVARCHAR;
        } else if (StringUtils.equals((CharSequence)BIGINT, pkFieldType)) {
            defaultValue = DEFAULT_BIGINT;
        }
        String sql = "";
        for (IAttachmentField attfield : attachmentFields) {
            StringBuilder sb = new StringBuilder();
            String attTableName = attfield.getTableName();
            DbMetadataTable tableSchema = NoCodeAlterTableUtil.getTableSchema(entityMetadata.getDBRouteKey(), attTableName, false);
            if (null != tableSchema || !StringUtils.isNotBlank((CharSequence)attTableName)) continue;
            sb.append(String.format(CREATE_SQL, attTableName));
            sb.append(attachmentTablePKField).append(" BIGINT NOT NULL,");
            sb.append(CONSTRAINT);
            String pkName = "pk_" + (attTableName.length() > 2 ? attTableName.substring(2) : attTableName);
            sb.append(pkName);
            sb.append(String.format(PRIMARY_KEY, attachmentTablePKField));
            sql = this.getShardingTableSql(attTableName, pkFieldName, sb.toString());
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            if (entity instanceof MainEntity) {
                sql = String.format(ADD_COLUMN + pkFieldType + NOTNULL + defaultValue, attTableName, pkFieldName);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)((EntryEntity)entity).getEntryPkFieldName())) {
                sql = String.format(ADD_COLUMN + pkFieldType + NOTNULL + defaultValue, attTableName, ((EntryEntity)entity).getEntryPkFieldName());
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            sql = String.format("ALTER TABLE %s ADD %s %s NOT NULL" + defaultValue, attTableName, attFKField, pkFieldType);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
        }
    }

    private static boolean existsFieldInTableSchema(DbMetadataTable tableSchema, String fieldName) {
        boolean exists = false;
        if (tableSchema != null && !StringUtils.isEmpty((CharSequence)fieldName)) {
            Object value = null;
            exists = tableSchema.getColumns().TryGetValue(fieldName, new RefObject(value));
        }
        return exists;
    }

    private String getPkFieldType(int pkInt) {
        String pkFieldType = null;
        switch (pkInt) {
            case 12: {
                pkFieldType = "VARCHAR(36)";
                break;
            }
            case -9: {
                pkFieldType = NVARCHAR_36;
                break;
            }
            case 4: {
                pkFieldType = "INTEGER";
                break;
            }
            case -5: {
                pkFieldType = BIGINT;
                break;
            }
            default: {
                pkFieldType = NVARCHAR_36;
            }
        }
        return pkFieldType;
    }

    protected void setAlterTableUtilDB(IAlterTableUtilDB IAlterTableUtilDB2) {
        this.dbImpl = IAlterTableUtilDB2;
    }

    private static /* synthetic */ List lambda$createTable$0(AtomicBoolean isSingleField, List inRange, ResultSet rs) throws Exception {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        while (rs.next()) {
            if (isSingleField.get()) {
                list.add(new Object[]{rs.getObject(1)});
            } else {
                list.add(new Object[]{rs.getObject(1), rs.getObject(2)});
            }
            inRange.add(rs.getObject(1));
        }
        return list;
    }
}

