/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.metadata.dao;

import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BOSRuntime;
import kd.bos.metadata.form.DesignFormMeta;

public final class NoCodeMetaVersionManager {
    private static final int INIT_CAPACITY = 10;
    private static final int IDX_0 = 0;
    private static final int IDX_1 = 1;
    private static final int IDX_2 = 2;
    private static final int IDX_3 = 3;
    private static final int IDX_4 = 4;
    private String appGroup;

    public void setAppGroup(String appGroup) {
        this.appGroup = appGroup;
    }

    String buildRuntimeVersion(String masterId) {
        IDataEntityType dt = OrmUtils.getDataEntityType(DesignFormMeta.class);
        String sql = String.format("SELECT FID, FISV, FVERSION, FTYPE from %s WHERE FID = ? OR (FMasterId = ? and FType = '2') ", this.getGrayTableName(dt.getAlias()));
        Object[] params = new Object[]{masterId, masterId};
        List list = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws Exception {
                ArrayList<Object[]> list = new ArrayList<Object[]>(10);
                while (rs.next()) {
                    String id = rs.getString(1);
                    String isv = rs.getString(2);
                    long ver = rs.getLong(3);
                    String type = rs.getString(4);
                    Object[] v = new Object[]{id, isv, ver, type};
                    list.add(v);
                }
                return list;
            }
        });
        long totalVer = 0L;
        for (Object[] v : list) {
            String id = (String)v[0];
            if (masterId.equals(id) && "2".equals(v[3])) {
                return null;
            }
            long ver = (Long)v[2];
            totalVer += ver;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        return String.format("%s.%s.%s", BOSRuntime.getVersion(), totalVer, sdf.format(new Date()));
    }

    private String getGrayTableName(String tabName) {
        if (StringUtils.isBlank((CharSequence)this.appGroup) || "defaultGroup".equals(this.appGroup)) {
            return tabName;
        }
        return String.format("%s_%s", tabName, this.appGroup);
    }
}

