/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.metadata.design;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.Category;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.nocode.constant.CommonConstants;
import kd.bos.nocode.ext.metadata.DefaultElementPropertyFactory;
import kd.bos.nocode.metadata.dao.NoCodeExMetadataDaoPlugin;
import kd.bos.nocode.mservice.NoCodeDesignMetadataService;
import kd.bos.nocode.utils.FieldTreeBuilder;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.ShowColumnInfo;
import kd.bos.service.metadata.design.DesignMetadataService;
import kd.bos.service.metadata.design.DesignMetadataServiceImpl;

public class NoCodeDesignMetadataServiceImpl
extends DesignMetadataServiceImpl
implements DesignMetadataService,
NoCodeDesignMetadataService {
    private static Log log = LogFactory.getLog(NoCodeDesignMetadataServiceImpl.class);
    private static final String DEFAULT_PROP_SETTING = "DefaultPropSetting";
    private static final String CategoryGeneralContent = "CategoryGeneralContent";
    private static final String Category_Biz_Content_ID = "CategoryBizContent";
    private static final String NoCodeMulRefBillField = "NoCodeMulRefBillField";
    private static final String BillEntityIdEx = "BillEntityIdEx";
    private static final String PropsDisplay = "PropsDisplay";
    private static final String DEFAULT = "default";
    private static final String VALUE = "value";
    private static final String LABEL = "label";
    private static final String COMPATIBLE_TYPE = "CompatibleType";

    private String getCategoryBizContentName() {
        return "\u4e1a\u52a1\u5185\u5bb9";
    }

    protected Map<String, Object> customMap(Map<String, Object> map, String modelType) {
        if ("NoCodeModel".equalsIgnoreCase(modelType) && !map.containsKey(DEFAULT_PROP_SETTING)) {
            map.put(DEFAULT_PROP_SETTING, DefaultElementPropertyFactory.getDefaultPropSetting());
        }
        return map;
    }

    public Object getCustomMetadataDaoPlugIn(String modelType) {
        if ("NoCodeModel".equalsIgnoreCase(modelType)) {
            return new NoCodeExMetadataDaoPlugin();
        }
        return null;
    }

    public String getNoCodeDomainModel(String modelType, String targetFormId) {
        if ("NoCodeModel".equalsIgnoreCase(modelType) && StringUtils.isNotBlank((CharSequence)targetFormId)) {
            String targetAppId = FormMetaUtil.getAppIdByFormId((String)targetFormId);
            String domainModel = this.getDomainModel(modelType);
            DcJsonSerializer dcJser = this.getDcJser();
            DomainModelType dm = (DomainModelType)dcJser.deserializeFromString(domainModel, null);
            try {
                this.attachBizContent(dm, targetAppId, false);
            }
            catch (Exception e) {
                log.warn((Throwable)e);
            }
            Map map = dcJser.serializeToMap((Object)dm, null);
            this.disableElementType(map);
            return SerializationUtils.toJsonString((Object)map);
        }
        return this.getDomainModel(modelType);
    }

    public String getNoCodeDomainModelSimple(String modelType, String targetFormId) {
        if ("NoCodeModel".equalsIgnoreCase(modelType) && StringUtils.isNotBlank((CharSequence)targetFormId)) {
            String targetAppId = FormMetaUtil.getAppIdByFormId((String)targetFormId);
            String domainModel = this.getDomainModel(modelType);
            DcJsonSerializer dcJser = this.getDcJser();
            DomainModelType dm = (DomainModelType)dcJser.deserializeFromString(domainModel, null);
            try {
                this.attachBizContent(dm, targetAppId, true);
            }
            catch (Exception e) {
                log.warn((Throwable)e);
            }
            Map map = dcJser.serializeToMap((Object)dm, null);
            this.disableElementType(map);
            return SerializationUtils.toJsonString((Object)map);
        }
        return this.getDomainModel(modelType);
    }

    private void disableElementType(Map<String, Object> map) {
        List categories = (List)map.get("Categories");
        for (Map category : categories) {
            List elementTypes = (List)category.get("ElementTypes");
            for (Map elementType : elementTypes) {
                String elId = (String)elementType.get("Id");
                if (!CommonConstants.isNonImplElement((String)elId)) continue;
                elementType.put("Visible", false);
            }
        }
    }

    private DcJsonSerializer getDcJser() {
        List dts = DomainModelType.getDomainModelTypeEntityTypes();
        DcJsonSerializer jser = new DcJsonSerializer((Iterable)dts);
        String locale = Lang.get().getLocale().toString();
        jser.getBinder().setLCId(locale);
        return jser;
    }

    protected void attachBizContent(DomainModelType domainModelType, String targetAppId, boolean isSimple) {
        Category genCategory;
        Optional<ElementType> mulRef;
        domainModelType.getCategories().removeIf(c -> Category_Biz_Content_ID.equalsIgnoreCase(c.getId()));
        Optional<Category> first = domainModelType.getCategories().stream().filter(c -> CategoryGeneralContent.equalsIgnoreCase(c.getId())).findFirst();
        if (first.isPresent() && (mulRef = (genCategory = first.get()).getElementTypes().stream().filter(t -> NoCodeMulRefBillField.equalsIgnoreCase(t.getId())).findFirst()).isPresent()) {
            ElementType mulRefElementType = mulRef.get();
            Category bizContentCategory = new Category();
            bizContentCategory.setId(Category_Biz_Content_ID);
            bizContentCategory.setName(new LocaleString(this.getCategoryBizContentName()));
            bizContentCategory.setSeq(1);
            this.createTheAppRefBillElementType(bizContentCategory.getElementTypes(), mulRefElementType, targetAppId, isSimple);
            domainModelType.getCategories().add(1, bizContentCategory);
        }
    }

    private void createTheAppRefBillElementType(List<ElementType> elementTypes, ElementType mulRefElementType, String targetAppId, boolean isSimple) {
        if (StringUtils.isBlank((CharSequence)targetAppId)) {
            return;
        }
        JSONObject data = NcEntityTypeUtil.buildRefBillData((String)targetAppId);
        JSONArray dataRows = (JSONArray)data.get((Object)"data");
        for (Object dataRow : dataRows) {
            JSONObject formObj = (JSONObject)dataRow;
            String name = (String)formObj.get((Object)LABEL);
            String value = (String)formObj.get((Object)VALUE);
            if ("68bde9ca00000eac".equalsIgnoreCase(value) || "bos_user".equalsIgnoreCase(value)) {
                ElementType userElementType = this.createUserElementType(mulRefElementType);
                elementTypes.add(userElementType);
                continue;
            }
            if ("PKJP6FA0=V1".equalsIgnoreCase(value) || "bos_adminorg".equalsIgnoreCase(value)) {
                ElementType orgElementType = this.createOrgElementType(mulRefElementType);
                elementTypes.add(orgElementType);
                continue;
            }
            ElementType formElementType = this.createFormElementType(value, name, mulRefElementType, isSimple);
            if (formElementType == null) continue;
            elementTypes.add(formElementType);
        }
    }

    private ElementType createUserElementType(ElementType mulRefElementType) {
        ThreeTuple<ElementType, Property, Property> tuple = this.cloneFromMulRefElementType(mulRefElementType);
        ElementType userElementType = (ElementType)tuple.item1;
        userElementType.setId("NoCodeMulRefBillField_bos_user");
        userElementType.setName(new LocaleString(NcEntityTypeUtil.getBosUserName()));
        HashMap<String, String> accept = new HashMap<String, String>(1);
        accept.put(COMPATIBLE_TYPE, "refbill");
        userElementType.setAccept(accept);
        Property billEntityIdExProperty = (Property)tuple.item2;
        Map billEntityIdExEditor = billEntityIdExProperty.getEditor();
        billEntityIdExEditor.put(DEFAULT, "bos_user");
        Property propsDisplayProperty = (Property)tuple.item3;
        Map propsDisplayEditor = propsDisplayProperty.getEditor();
        propsDisplayEditor.put(DEFAULT, "name,number,gender,phone,email");
        return userElementType;
    }

    private ElementType createOrgElementType(ElementType mulRefElementType) {
        ThreeTuple<ElementType, Property, Property> tuple = this.cloneFromMulRefElementType(mulRefElementType);
        ElementType orgElementType = (ElementType)tuple.item1;
        orgElementType.setId("NoCodeMulRefBillField_bos_adminorg");
        orgElementType.setName(new LocaleString(NcEntityTypeUtil.getBosAdminOrgNane()));
        HashMap<String, String> accept = new HashMap<String, String>(1);
        accept.put(COMPATIBLE_TYPE, "refbill");
        orgElementType.setAccept(accept);
        Property billEntityIdExProperty = (Property)tuple.item2;
        Map billEntityIdExEditor = billEntityIdExProperty.getEditor();
        billEntityIdExEditor.put(DEFAULT, "bos_adminorg");
        Property propsDisplayProperty = (Property)tuple.item3;
        Map propsDisplayEditor = propsDisplayProperty.getEditor();
        propsDisplayEditor.put(DEFAULT, "name,number");
        return orgElementType;
    }

    private ElementType createFormElementType(String formId, String title, ElementType mulRefElementType, boolean isSimple) {
        FieldTreeBuilder fieldTreeBuilder;
        List showColumns;
        if (!NcEntityTypeUtil.isFormExist((String)formId)) {
            return null;
        }
        ThreeTuple<ElementType, Property, Property> tuple = this.cloneFromMulRefElementType(mulRefElementType);
        ElementType elementType = (ElementType)tuple.item1;
        elementType.setId("NoCodeMulRefBillField_" + formId);
        elementType.setName(new LocaleString(title));
        HashMap<String, String> accept = new HashMap<String, String>(1);
        accept.put(COMPATIBLE_TYPE, "refbill");
        elementType.setAccept(accept);
        Property billEntityIdExProperty = (Property)tuple.item2;
        Map billEntityIdExEditor = billEntityIdExProperty.getEditor();
        billEntityIdExEditor.put(DEFAULT, formId);
        if (!isSimple && (showColumns = (fieldTreeBuilder = new FieldTreeBuilder(formId)).withoutFieldTypes(new FieldTreeBuilder.FieldType[]{FieldTreeBuilder.FieldType.NoCodeRichTextField, FieldTreeBuilder.FieldType.NoCodeGraphicDisplayField, FieldTreeBuilder.FieldType.NoCodeAttachmentUploadField, FieldTreeBuilder.FieldType.NoCodeImageUploadField, FieldTreeBuilder.FieldType.NoCodeBillNoField, FieldTreeBuilder.FieldType.EntryField}).withTopColumn(5).build()) != null && !showColumns.isEmpty()) {
            int cnt = 0;
            StringBuilder sb = new StringBuilder();
            for (ShowColumnInfo showColumn : showColumns) {
                if (!showColumn.isVisible()) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(showColumn.getId());
                if (++cnt < 5) continue;
                break;
            }
            if (sb.length() > 0) {
                Property propsDisplayProperty = (Property)tuple.item3;
                Map propsDisplayEditor = propsDisplayProperty.getEditor();
                propsDisplayEditor.put(DEFAULT, sb.toString());
            }
        }
        return elementType;
    }

    private ThreeTuple<ElementType, Property, Property> cloneFromMulRefElementType(ElementType mulRefElementType) {
        ElementType elementType = new ElementType();
        Property billEntityIdExProperty = null;
        Property propsDisplayProperty = null;
        elementType.setBaseType(mulRefElementType.getBaseType());
        elementType.setApType(mulRefElementType.getApType());
        elementType.setPackageName(mulRefElementType.getPackageName());
        for (Property property : mulRefElementType.getProperties()) {
            List validators;
            Map action;
            Property prop = new Property();
            prop.setName(property.getName());
            prop.setPropertyName(property.getPropertyName());
            prop.setGroupId(property.getGroupId());
            prop.setGroupSubSeq(property.getGroupSubSeq());
            prop.setGroup(property.getGroup());
            Map editor = property.getEditor();
            if (editor != null && !editor.isEmpty()) {
                prop.setEditor(new HashMap(editor));
            }
            prop.setDescription(property.getDescription());
            Map hide = property.getHide();
            if (hide != null && !hide.isEmpty()) {
                prop.setHide(new HashMap(hide));
            }
            if ((action = property.getAction()) != null && !action.isEmpty()) {
                prop.setAction(new HashMap(action));
            }
            if ((validators = property.getValidators()) != null && !validators.isEmpty()) {
                ArrayList target = new ArrayList(validators.size());
                for (Map validator : validators) {
                    if (validator.isEmpty()) continue;
                    target.add(new HashMap(validator));
                }
                prop.setValidators(target);
            }
            prop.setSeq(property.getSeq());
            prop.setReadOnly(property.isReadOnly());
            prop.setTag(property.getTag());
            if (BillEntityIdEx.equalsIgnoreCase(prop.getPropertyName())) {
                billEntityIdExProperty = prop;
            }
            if (PropsDisplay.equalsIgnoreCase(prop.getPropertyName())) {
                propsDisplayProperty = prop;
            }
            elementType.getProperties().add(prop);
        }
        return new ThreeTuple((Object)elementType, billEntityIdExProperty, propsDisplayProperty);
    }
}

