/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.rule.RaiseEventSource;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.expression.NoCodeCalcExprParser;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.ext.property.NoCodeProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;
import kd.bos.nocode.internalapi.FilterValueService;
import kd.bos.nocode.metadata.IDecimalFormatSupport;
import kd.bos.nocode.mservice.NoCodeDefValueCalculatorService;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.restapi.service.util.FormulaFilterUtils;
import kd.bos.nocode.restapi.service.util.ListFilterConfigUtils;
import kd.bos.nocode.util.DataRangeCompareUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class NoCodeDefValueCalculatorServiceImpl
implements NoCodeDefValueCalculatorService {
    protected IDataModel model;
    protected DynamicObject dataEntity;
    protected DynamicProperty fieldProp;
    private static final String FIELD_NAME = "fieldName";
    private static final String FBASEDATAID = "fbasedataid";
    private static final Log logger = LogFactory.getLog(NoCodeDefValueCalculatorServiceImpl.class);
    int rowIndex;

    public Object getValue(IDataModel model, DynamicObject dataEntity, DynamicProperty property, int rowIndex, Object defVal) {
        try (EntityTraceSpan span = EntityTracer.create((String)"NoCodeDefValueCalculatorServiceImpl", (String)"getValue");){
            this.model = model;
            this.dataEntity = dataEntity;
            this.fieldProp = property;
            this.rowIndex = rowIndex;
            if (defVal == null) {
                Object var8_8 = null;
                return var8_8;
            }
            Map valMap = null;
            try {
                valMap = (Map)SerializationUtils.fromJsonString((String)defVal.toString(), Map.class);
            }
            catch (Exception e) {
                Object object = defVal;
                if (span != null) {
                    if (var7_7 != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        span.close();
                    }
                }
                return object;
            }
            if (!valMap.containsKey("valueType")) {
                Object e = defVal;
                return e;
            }
            span.addLocaleTag("valMap", (Object)valMap);
            int valueType = (Integer)valMap.get("valueType");
            if (valueType == 0) {
                Object v = valMap.get("value");
                return v;
            }
            if (valueType == 1) {
                String expression = (String)valMap.get("value");
                if (StringUtils.isBlank((CharSequence)expression)) {
                    Object object = defVal;
                    return object;
                }
                String result = NcEntityTypeUtil.getRuntimeExpression((String)expression);
                Object object = this.dealWithFormula(result);
                return object;
            }
            if (valueType == 2) {
                Object object = this.dealWithQueryForm();
                return object;
            }
            Object object = defVal;
            return object;
        }
    }

    public String getFilterInfo(List<Map<String, Object>> filterRows, String formId) {
        return FormulaFilterUtils.buildFilter(filterRows, formId);
    }

    public String getFilterInfo(List<Map<String, Object>> filterRows) {
        return FormulaFilterUtils.buildFilter(filterRows);
    }

    public void parseExpression(List<Map<String, Object>> filterInfos, IDataModel model) {
        this.parseExpression(filterInfos, model, null);
    }

    private void parseExpression(List<Map<String, Object>> filterInfos, RaiseEventSource arg) {
        this.parseExpression(filterInfos, this.model, arg);
    }

    private void parseExpression(List<Map<String, Object>> filterInfos, IDataModel dataModel, RaiseEventSource arg) {
        try (EntityTraceSpan span = EntityTracer.create((String)"NoCodeDefValueCalculatorServiceImpl", (String)"parseExpression");){
            span.addLocaleTag("filterInfos", filterInfos);
            for (Map<String, Object> map : filterInfos) {
                Object value = map.get("value");
                String compareTypeId = (String)map.get("compareType");
                List<Map<String, Object>> valueList = ListFilterConfigUtils.getValueList(value);
                boolean isDateRangeCompare = DataRangeCompareUtil.isDateRangeCompare(map);
                map.put("value", valueList);
                for (Map<String, Object> obj : valueList) {
                    String fieldValue;
                    Object valueObj = obj.get("fieldValue");
                    if (!(valueObj instanceof String) || (fieldValue = (String)valueObj).indexOf("${model") == -1) continue;
                    fieldValue = fieldValue.replace("${model.", "");
                    fieldValue = fieldValue.replace("}", "");
                    String firstFieldName = fieldValue.split("\\.")[0];
                    IDataEntityProperty property = dataModel.getProperty(firstFieldName);
                    Object realValue = null;
                    if (arg == null) {
                        realValue = dataModel.getValue(firstFieldName);
                    } else if (!arg.getDataEntities().isEmpty() && arg.getDataEntities().get(0) instanceof ChangeData) {
                        ChangeData data = (ChangeData)arg.getDataEntities().get(0);
                        realValue = firstFieldName.equals(arg.getProperty().getName()) ? data.getNewValue() : dataModel.getValue(firstFieldName);
                    } else {
                        realValue = dataModel.getValue(firstFieldName);
                    }
                    if (FilterValueService.create().isAttachmentSubProp((DynamicObjectType)dataModel.getDataEntityType(), fieldValue)) {
                        realValue = FilterValueService.create().getAttachmentPropValue(dataModel, fieldValue, compareTypeId);
                    } else if (FilterValueService.create().isPictureProp((DynamicObjectType)dataModel.getDataEntityType(), fieldValue)) {
                        realValue = FilterValueService.create().getImagePropValue(dataModel, fieldValue, compareTypeId);
                    } else if (property instanceof IDecimalFormatSupport) {
                        realValue = ((IDecimalFormatSupport)property).getFormattedValue(realValue);
                    }
                    realValue = NcEntityTypeUtil.getOriginalValue((IDataEntityProperty)property, (Object)realValue);
                    if (isDateRangeCompare) {
                        realValue = DataRangeCompareUtil.getFieldValueWithDefault(valueList, obj, (Object)realValue);
                    }
                    obj.put("fieldValue", realValue);
                }
            }
        }
        catch (Exception e) {
            try (EntityTraceSpan span2 = EntityTracer.create((String)"NoCodeDefValueCalculatorServiceImpl", (String)"parseExpression");){
                span2.addLocaleTag("filterInfos", filterInfos);
                span2.throwException((Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> getQueryFormRecord(String expression, RaiseEventSource arg, IDataModel model) {
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>(16);
        try (EntityTraceSpan span = EntityTracer.create((String)"NoCodeDefValueCalculatorServiceImpl", (String)"getQueryFormRecord");){
            Set<String> targetFields;
            this.model = model;
            if (StringUtils.isBlank((CharSequence)expression)) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                return hashMap;
            }
            Map valMap = (Map)SerializationUtils.fromJsonString((String)expression, Map.class);
            Map configs = (Map)valMap.get("value");
            List filterInfos = (List)configs.get("filterInfos");
            this.parseExpression((List<Map<String, Object>>)filterInfos, arg);
            span.addLocaleTag("filterInfos", (Object)filterInfos);
            String formId = (String)configs.get("relationFormId");
            formId = NcEntityTypeUtil.getRealBillEntityNumber((String)formId);
            if (!NcEntityTypeUtil.isFormExist((String)formId)) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                return hashMap;
            }
            QFilter[] qFilters = this.getFilters(filterInfos, formId);
            List result = (List)configs.get("result");
            StringBuilder selectField = new StringBuilder("id,");
            LinkedHashMap fieldMapping = new LinkedHashMap(result.size());
            ArrayList<Object> refBillFieldKeys = new ArrayList<Object>(result.size());
            for (Map map : result) {
                String sourceField = (String)map.get("sourceField");
                String targetField = (String)map.get("targetField");
                if (StringUtils.isNotBlank((CharSequence)targetField) && targetField.indexOf(".") != -1) {
                    targetField = targetField.split("\\.")[1];
                }
                Tuple<Boolean, String> tuple = this.isNoCodeRefBillField(sourceField, formId);
                if (((Boolean)tuple.item1).booleanValue()) {
                    if (!refBillFieldKeys.contains(tuple.item2)) {
                        selectField.append((String)tuple.item2).append(",");
                        refBillFieldKeys.add(tuple.item2);
                    }
                } else {
                    selectField.append(sourceField).append(",");
                }
                targetFields = new HashSet<String>();
                if (fieldMapping.containsKey(sourceField)) {
                    targetFields = (Set)fieldMapping.get(sourceField);
                }
                targetFields.add(targetField);
                fieldMapping.put(sourceField, targetFields);
            }
            span.addTag("selectField", selectField.toString());
            selectField = new StringBuilder(selectField.substring(0, selectField.length() - 1));
            List sortInfos = (List)configs.get("sortInfos");
            String orderBy = "";
            for (Map map : sortInfos) {
                if (!StringUtils.isNotBlank(map.get("number")) || !StringUtils.isNotBlank(map.get("isAsc"))) continue;
                String sortType = (Boolean)map.get("isAsc") != false ? "asc" : "desc";
                orderBy = orderBy + map.get("number") + " " + sortType + ",";
            }
            orderBy = StringUtils.isBlank((CharSequence)orderBy) ? "id desc" : orderBy.substring(0, orderBy.length() - 1);
            String top = configs.getOrDefault("top", "1");
            int t = Integer.parseInt(top);
            DynamicObject[] cols = BusinessDataServiceHelper.load((String)formId, (String)selectField.toString(), (QFilter[])qFilters, (String)orderBy, (int)t);
            span.addTag("cols.size()", cols.length + "");
            if (cols.length == 0) {
                targetFields = null;
                return targetFields;
            }
            span.addLocaleTag("recordMap", (Object)cols);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formId);
            for (Map.Entry entry : fieldMapping.entrySet()) {
                DynamicObject obj;
                List objs;
                DynamicObjectCollection attObjs;
                String sourceField = (String)entry.getKey();
                Set targetFields2 = (Set)entry.getValue();
                Tuple<Boolean, String> tuple = this.isNoCodeRefBillField(sourceField, formId);
                if (((Boolean)tuple.item1).booleanValue()) {
                    String[] fields = sourceField.split("\\.");
                    INoCodeRefBillProp refBillProp = (INoCodeRefBillProp)mainEntityType.getProperty(fields[0]);
                    if (refBillProp instanceof NoCodeMulRefBillProp) {
                        Object sPks = cols[0].get(fields[0]);
                        if (!StringUtils.isNotBlank((Object)sPks)) continue;
                        DynamicObject[] refDynObjs = refBillProp.loadRefBillObjects(sPks.toString(), fields[1]);
                        DynamicObject refDynObj = refDynObjs[0];
                        for (String targetField : targetFields2) {
                            if (sourceField.indexOf(FBASEDATAID) != -1) {
                                DynamicObjectCollection attObjs2 = refDynObj.getDynamicObjectCollection(fields[1]);
                                if (attObjs2.isEmpty()) {
                                    resultMap.put(targetField, null);
                                    continue;
                                }
                                List objs2 = NoCodeProp.sortAttachment((DynamicObjectCollection)attObjs2);
                                DynamicObject obj2 = ((DynamicObject)objs2.get(0)).getDynamicObject(FBASEDATAID);
                                resultMap.put(targetField, obj2.get(fields[3]));
                                continue;
                            }
                            resultMap.put(targetField, NoCodeProp.getDisplayValue((DynamicObject)refDynObj, (String)fields[1], (IDataEntityProperty)model.getProperty(targetField)));
                        }
                        continue;
                    }
                    if (!(refBillProp instanceof RefBillProp)) continue;
                    DynamicObject refBill = cols[0].get(fields[0]) == null ? null : (DynamicObject)cols[0].get(fields[0]);
                    for (String targetField : targetFields2) {
                        if (refBill == null) continue;
                        if (sourceField.indexOf(FBASEDATAID) != -1) {
                            attObjs = refBill.getDynamicObjectCollection(fields[1]);
                            if (attObjs.isEmpty()) continue;
                            objs = NoCodeProp.sortAttachment((DynamicObjectCollection)attObjs);
                            obj = ((DynamicObject)objs.get(0)).getDynamicObject(FBASEDATAID);
                            resultMap.put(targetField, obj.get(fields[3]));
                            continue;
                        }
                        resultMap.put(targetField, NoCodeProp.getDisplayValue((DynamicObject)refBill, (String)fields[1], (IDataEntityProperty)model.getProperty(targetField)));
                    }
                    continue;
                }
                if ("currentRecord".equals(sourceField)) {
                    for (String targetField : targetFields2) {
                        List collect;
                        IDataEntityProperty p = model.getProperty(targetField);
                        if (p instanceof NoCodeMulRefBillProp) {
                            if (!((NoCodeMulRefBillProp)p).getBillEntityId().equals(formId)) continue;
                            collect = Arrays.stream(cols).map(DataEntityBase::getPkValue).map(Object::toString).collect(Collectors.toList());
                            resultMap.put(targetField, String.join((CharSequence)",", collect));
                            continue;
                        }
                        if (p instanceof NoCodeRefBillProp) {
                            if (!((NoCodeRefBillProp)p).getBillEntityId().equals(formId)) continue;
                            resultMap.put(targetField, cols[0].getPkValue());
                            continue;
                        }
                        if (!(p instanceof NoCodeRefBillTableProp)) continue;
                        collect = Arrays.stream(cols).map(DataEntityBase::getPkValue).map(Object::toString).collect(Collectors.toList());
                        resultMap.put(targetField, String.join((CharSequence)",", collect));
                    }
                    continue;
                }
                for (String targetField : targetFields2) {
                    DynamicProperty sourceProp = mainEntityType.getProperty(sourceField);
                    IDataEntityProperty targetProp = model.getProperty(targetField);
                    if (targetProp instanceof NoCodeRefBillProp && sourceProp instanceof NoCodeRefBillProp) {
                        resultMap.put(targetField, cols[0].get(sourceField + "_id"));
                        continue;
                    }
                    if (sourceField.indexOf(FBASEDATAID) != -1) {
                        DynamicObjectCollection attObjs3;
                        DynamicObject dobj;
                        String[] fields = sourceField.split("\\.");
                        if (fields.length == 3) {
                            attObjs = cols[0].getDynamicObjectCollection(fields[0]);
                            if (attObjs.isEmpty()) continue;
                            objs = NoCodeProp.sortAttachment((DynamicObjectCollection)attObjs);
                            obj = ((DynamicObject)objs.get(0)).getDynamicObject(FBASEDATAID);
                            resultMap.put(targetField, NoCodeProp.getDisplayValue((DynamicObject)obj, (String)fields[2], (IDataEntityProperty)model.getProperty(targetField)));
                            continue;
                        }
                        if (fields.length != 4 || (dobj = cols[0].getDynamicObject(fields[0])) == null || (attObjs3 = dobj.getDynamicObjectCollection(fields[1])).isEmpty()) continue;
                        List objs3 = NoCodeProp.sortAttachment((DynamicObjectCollection)attObjs3);
                        DynamicObject obj3 = ((DynamicObject)objs3.get(0)).getDynamicObject(FBASEDATAID);
                        resultMap.put(targetField, NoCodeProp.getDisplayValue((DynamicObject)obj3, (String)fields[3], (IDataEntityProperty)model.getProperty(targetField)));
                        continue;
                    }
                    resultMap.put(targetField, NoCodeProp.getDisplayValue((DynamicObject)cols[0], (String)sourceField, (IDataEntityProperty)model.getProperty(targetField)));
                }
            }
            LinkedHashMap<String, Object> linkedHashMap = resultMap;
            return linkedHashMap;
        }
        catch (Exception e) {
            try (EntityTraceSpan span2 = EntityTracer.create((String)"NoCodeDefValueCalculatorServiceImpl", (String)"getQueryFormRecord");){
                span2.addLocaleTag("expression", (Object)expression);
                span2.throwException((Throwable)e);
            }
            return resultMap;
        }
    }

    public QFilter[] getFilters(List<Map<String, Object>> filterInfos, String formId) {
        String filters = ListFilterConfigUtils.buildFilter(filterInfos, formId);
        logger.debug("filterStr: {}", (Object)filters);
        QFilter[] qFilters = FilterUtil.getQFilters(formId, filters);
        return qFilters;
    }

    private Tuple<Boolean, String> isNoCodeRefBillField(String fieldKey, String formId) {
        if (fieldKey.contains(".")) {
            String[] fields = fieldKey.split("\\.");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formId);
            IDataEntityProperty prop = NcEntityTypeUtil.findProperty((DynamicObjectType)mainEntityType, (String)fields[0]);
            if (prop instanceof NoCodeMulRefBillProp) {
                return Tuple.create((Object)true, (Object)fields[0]);
            }
        }
        return Tuple.create((Object)false, null);
    }

    private Object dealWithFormula(String expression) {
        try (EntityTraceSpan span = EntityTracer.create((String)"NoCodeDefValueCalculatorServiceImpl", (String)"dealWithFormula");){
            RowDataModel rowModel = new RowDataModel(this.model.getDataEntityType().getName(), this.model);
            ExpressionParameter parameter = new ExpressionParameter(expression, rowModel);
            parameter.setActiveRow((Object)this.dataEntity);
            parameter.setRowIndex(this.rowIndex);
            Object val = NoCodeCalcExprParser.getExpressionValue((ExpressionParameter)parameter);
            span.addTag("expression", expression);
            span.addTag("val", val == null ? null : val.toString());
            span.addLocaleTag("dataEntity", (Object)this.dataEntity);
            Object object = val;
            return object;
        }
    }

    private Object dealWithQueryForm() {
        try (EntityTraceSpan span = EntityTracer.create((String)"NoCodeDefValueCalculatorServiceImpl", (String)"dealWithQueryForm");){
            QFilter[] qfilters = new QFilter[]{new QFilter("formid", "=", (Object)this.fieldProp.getParent().getName()), QFilter.like((String)"affectfldkeys", (String)this.fieldProp.getName()), new QFilter("ruletype", "=", (Object)"1")};
            span.addLocaleTag("qfilters", (Object)qfilters);
            String expression = this.getDependencyRules(qfilters);
            span.addTag("expression", expression);
            Map<String, Object> resultMap = this.getQueryFormRecord(expression, null, this.model);
            if (resultMap == null) {
                Object var6_7 = null;
                return var6_7;
            }
            Object object = resultMap.get(this.fieldProp.getName());
            return object;
        }
    }

    private String getDependencyRules(QFilter[] filters) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_nocode_rule", (String)"expression", (QFilter[])filters);
        return collection.isEmpty() ? null : ((DynamicObject)collection.iterator().next()).getString("expression");
    }
}

