/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.mservice;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.nocode.ext.constant.QingTargetType;
import kd.bos.nocode.ext.metadata.form.NoCodeBillFormAp;
import kd.bos.nocode.mservice.NoCodeQingService;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.restapi.service.util.ListFilterConfigUtils;
import kd.bos.orm.query.QFilter;

public class NoCodeQingServiceImpl
implements NoCodeQingService {
    private static final Log log = LogFactory.getLog(NoCodeQingServiceImpl.class);

    public QFilter getQFilter(String formId, String configuredFilterRowsStr) {
        List configuredFilterRows = SerializationUtils.fromJsonStringToList((String)configuredFilterRowsStr, Map.class);
        String filterStr = ListFilterConfigUtils.buildFilter(configuredFilterRows, formId);
        QFilter[] qFilters = FilterUtil.getQFilters(formId, filterStr);
        Optional<QFilter> resultFilter = Arrays.stream(qFilters).reduce((e1, e2) -> e1.and(e2));
        return resultFilter.orElse(null);
    }

    public Set<String> getIgnoreFields(String formId) {
        HashSet<String> ignoredFieldKeys = new HashSet<String>(16);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
        FormAp rootAp = formMeta.getRootAp();
        String sysSettingStr = ((NoCodeBillFormAp)rootAp).getSysSetting();
        Map sysSettingMap = (Map)SerializationUtils.fromJsonString((String)sysSettingStr, Map.class);
        boolean isShowCreator = (Boolean)sysSettingMap.get("System_CategoryRecordInfo");
        boolean isShowBillNo = (Boolean)sysSettingMap.get("System_CategoryBillNo");
        if (!isShowCreator) {
            ignoredFieldKeys.add("nocodecreatorfield");
            ignoredFieldKeys.add("nocodecreatedatefield");
            ignoredFieldKeys.add("nocodemodifierfield");
            ignoredFieldKeys.add("nocodecreatedatefield");
        }
        if (!isShowBillNo) {
            ignoredFieldKeys.add("nocodebillnofield");
        }
        ignoredFieldKeys.add("lockstatus");
        return ignoredFieldKeys;
    }

    public String getFormattedType(IDataEntityProperty fieldProp) {
        if (fieldProp instanceof INoCodeRefBillProp || fieldProp instanceof TextProp || fieldProp instanceof ComboProp) {
            return QingTargetType.STRING.toString();
        }
        if (fieldProp instanceof DecimalProp) {
            return QingTargetType.NUMBER.toString();
        }
        if (fieldProp instanceof DateTimeProp) {
            return QingTargetType.DATETIME.toString();
        }
        return QingTargetType.STRING.toString();
    }
}

