/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.mservice;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.nocode.constant.TemplateTypeEnum;
import kd.bos.nocode.ext.metadata.NoCodeBillEntityType;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDateRangeField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeSelectItemField;
import kd.bos.nocode.ext.util.ComboItemUtils;
import kd.bos.nocode.metadata.INoCodeRefBillField;
import kd.bos.nocode.mservice.NoCodeRuleService;
import kd.bos.nocode.restapi.service.util.ListFilterConfigUtils;
import kd.bos.nocode.util.DataRangeCompareUtil;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NoCodeRuleServiceImpl
implements NoCodeRuleService {
    private static final Log logger = LogFactory.getLog(NoCodeRuleServiceImpl.class);
    private static final String NAME = "name";
    private static final String FORMID = "formId";
    private static final String PRECONDITION = "preCondition";
    private static final String TRUEACTION = "trueAction";
    private static final String EXPRESSION = "expression";
    private static final String DEPFLDKEYS = "depfldkeys";
    private static final String AFFECTFLDKEYS = "affectfldkeys";
    private static final String RULETYPE = "ruletype";
    private static final String CREATER = "creater";
    private static final String RULEID = "ruleId";
    public static final String NUMBER = "number";
    public static final String ORDER_INFO = "orderInfo";
    private static final String VALUETYPE = "valuetype";

    public DynamicObject genRule(Map<String, Object> data, int type) {
        if (type == 1) {
            return this.dealWithBizRule(data);
        }
        if (type == 2) {
            return this.dealWithFormRule(data);
        }
        return null;
    }

    public Map<String, Object> listConfig(String formId) {
        String appId = FormMetaUtil.getAppIdByFormId((String)formId);
        Map fields = ListConfigUtils.getDirectFields((String)formId, (boolean)true);
        if (fields == null) {
            return new HashMap<String, Object>();
        }
        List listItemConfig = ListConfigUtils.getListItemConfig((String)formId, (boolean)true);
        Set lastedFormNumbers = fields.keySet();
        listItemConfig.removeIf(e -> {
            String number = (String)e.get(NUMBER);
            return !lastedFormNumbers.contains(number);
        });
        listItemConfig.forEach(e -> {
            String name;
            String number = (String)e.get(NUMBER);
            IDataEntityProperty fieldProperty = (IDataEntityProperty)fields.get(number);
            String string = name = fieldProperty.getDisplayName() != null ? fieldProperty.getDisplayName().getLocaleValue() : "";
            if (number.contains(".") && fieldProperty.getParent() instanceof NoCodeBillEntityType) {
                name = fieldProperty.getParent().getDisplayName().getLocaleValue() + "." + name;
            }
            e.put(NAME, name);
        });
        List ret = listItemConfig;
        HashMap<String, EntityMetadata> formMap = new HashMap<String, EntityMetadata>();
        for (Map itemConfig : ret) {
            String number = (String)itemConfig.get(NUMBER);
            IDataEntityProperty fieldProperty = (IDataEntityProperty)fields.get(number);
            if (itemConfig.get("type") != null || !number.contains(".") || !(fieldProperty.getParent() instanceof NoCodeBillEntityType)) continue;
            String extFormId = fieldProperty.getParent().getName();
            if (!formMap.containsKey(extFormId)) {
                EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)extFormId, (MetaCategory)MetaCategory.Entity);
                formMap.put(extFormId, entityMetadata);
            }
            this.fillRefBillType(itemConfig, (EntityMetadata)formMap.get(extFormId), fieldProperty.getName());
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(5);
        resultMap.put("listStatInfo", new ArrayList(0));
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)NcEntityTypeUtil.getRealBillEntityNumber((String)formId));
        resultMap.put("filters", new ArrayList(0));
        resultMap.put("listItemConfig", ret);
        resultMap.put("configuredFilterItems", new ArrayList(0));
        String formName = dt.getDisplayName().getLocaleValue();
        resultMap.put("formName", formName);
        resultMap.put("fromId", formId);
        resultMap.put("appId", appId);
        resultMap.put(ORDER_INFO, new ArrayList(0));
        resultMap.put("orderBy", "");
        resultMap.put("configuredPageSize", 20);
        return this.genRestApiData(resultMap);
    }

    public void copyRules(String sourceFormId, String targetFormId) {
        this.copyRules(sourceFormId, targetFormId, null);
    }

    public void copyRules(@NotNull String sourceFormId, @NotNull String targetFormId, @Nullable TemplateTypeEnum templateType) {
        try (TXHandle tx = TX.requiresNew((String)"NoCodeRuleServiceImpl");){
            QFilter[] filters = new QFilter[]{new QFilter("formid", "=", (Object)sourceFormId)};
            String selectFields = "id,name,formid,expression,depfldkeys,trueaction,affectfldkeys,ruletype,valuetype,creater";
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bos_nocode_rule", (String)selectFields, (QFilter[])filters);
            long[] ids = ORM.create().genLongIds("bos_nocode_rule", objs.length);
            ArrayList<DynamicObject> newObjs = new ArrayList<DynamicObject>(objs.length);
            for (int i = 0; i < objs.length; ++i) {
                DynamicObject obj = objs[i];
                DynamicObject dynamicObject = (DynamicObject)OrmUtils.clone((Object)obj, (IDataEntityType)obj.getDataEntityType(), (boolean)true, (boolean)true);
                dynamicObject.set("formid", (Object)this.replaceFormId(obj.getString("formid"), sourceFormId, targetFormId));
                String expression = obj.getString(EXPRESSION);
                dynamicObject.set(EXPRESSION, (Object)this.replaceFormId(expression, sourceFormId, targetFormId));
                dynamicObject.set(CREATER, (Object)RequestContext.get().getCurrUserId());
                dynamicObject.set("id", (Object)ids[i]);
                if ("1".equals(obj.getString(RULETYPE)) && NoCodeRuleServiceImpl.skipRule(targetFormId, templateType, expression)) continue;
                newObjs.add(dynamicObject);
            }
            SaveServiceHelper.save((DynamicObject[])newObjs.toArray(new DynamicObject[0]));
        }
    }

    private static boolean skipRule(@NotNull String targetFormId, @Nullable TemplateTypeEnum templateType, String expression) {
        Map valueMap;
        String relationFormId;
        Map expressionMap = (Map)SerializationUtils.fromJsonString((String)expression, Map.class);
        Integer valueType = (Integer)expressionMap.get("valueType");
        if (Objects.nonNull(valueType) && valueType == 2 && StringUtils.isNotEmpty((CharSequence)(relationFormId = (String)(valueMap = (Map)expressionMap.get("value")).get("relationFormId"))) && Objects.equals(templateType, TemplateTypeEnum.FORM)) {
            boolean check = NoCodePermHelper.checkPublishEnt((String)FormMetaUtil.getAppIdByFormId((String)targetFormId), (String)relationFormId);
            return !check;
        }
        return false;
    }

    private String replaceFormId(String source, String sourceFormId, String targetFormId) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return "";
        }
        return source.replaceAll(sourceFormId, targetFormId);
    }

    private void fillRefBillType(Map<String, Object> itemConfig, EntityMetadata entityMetadata, String number) {
        List entityItems = entityMetadata.getItems();
        for (EntityItem item : entityItems) {
            NoCodeSelectItemField field;
            HashSet<String> keys = new HashSet<String>();
            if (item instanceof NoCodeDateRangeField) {
                NoCodeDateRangeField dateRangeField = (NoCodeDateRangeField)item;
                keys.add(dateRangeField.getStartDateFieldKey());
                keys.add(dateRangeField.getEndDateFieldKey());
            } else {
                keys.add(item.getKey());
            }
            if (!keys.contains(number)) continue;
            itemConfig.put("type", item.getClass().getSimpleName().toLowerCase());
            if (item instanceof NoCodeSelectItemField) {
                field = (NoCodeSelectItemField)item;
                itemConfig.put("items", ComboItemUtils.buildComboItemsVOByComboItems((List)field.getItems()));
                itemConfig.put("isMulti", field.isMulti());
                continue;
            }
            if (!(item instanceof INoCodeRefBillField)) continue;
            field = (INoCodeRefBillField)item;
            itemConfig.put("entityId", field.getBillEntityId());
            itemConfig.put("displayProp", field.getPropsDisplay());
            itemConfig.put("isMulti", field.isMultiSelect());
        }
    }

    private Map<String, Object> genRestApiData(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        rows.add(map);
        data.put("rows", rows);
        data.put("totalCount", Integer.valueOf(1));
        data.put("lastPage", Boolean.valueOf(false));
        data.put("pageSize", Integer.valueOf(10));
        data.put("pageNo", Integer.valueOf(1));
        result.put("data", data);
        return result;
    }

    private DynamicObject dealWithFormRule(Map<String, Object> data) {
        String formId = (String)data.get(FORMID);
        String name = (String)data.get(NAME);
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new KDBizException("name is null");
        }
        if (name.length() > 100) {
            throw new KDBizException("name is too long");
        }
        if (data.get(PRECONDITION) == null || data.get(TRUEACTION) == null) {
            return null;
        }
        List preCondition = (List)data.get(PRECONDITION);
        String conditionExpr = SerializationUtils.toJsonString((Object)preCondition);
        List trueAction = (List)data.get(TRUEACTION);
        String actionExpr = SerializationUtils.toJsonString((Object)trueAction);
        DynamicObject dy = data.get(RULEID) != null ? BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(data.get(RULEID).toString()), (String)"bos_nocode_rule") : BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_rule");
        dy.set(NAME, (Object)name);
        dy.set(FORMID, (Object)formId);
        dy.set(EXPRESSION, (Object)conditionExpr);
        dy.set(TRUEACTION, (Object)actionExpr);
        dy.set(RULETYPE, (Object)"0");
        dy.set(CREATER, (Object)RequestContext.get().getCurrUserId());
        if (preCondition == null) {
            return null;
        }
        String[] vars = this.parseExpression(formId, preCondition, true);
        String depFldKeys = String.join((CharSequence)",", Arrays.asList(vars));
        dy.set(DEPFLDKEYS, (Object)depFldKeys);
        StringBuilder affectFldKeys = new StringBuilder();
        for (Map action : trueAction) {
            Object fieldKey = action.get("fieldName");
            if (fieldKey instanceof String) {
                affectFldKeys.append(fieldKey).append(",");
                continue;
            }
            if (!(fieldKey instanceof ArrayList)) continue;
            ArrayList list = (ArrayList)fieldKey;
            for (Object key : list) {
                affectFldKeys.append(key).append(",");
            }
        }
        if (!StringUtils.isBlank((CharSequence)affectFldKeys.toString())) {
            affectFldKeys = new StringBuilder(affectFldKeys.substring(0, affectFldKeys.length() - 1));
            dy.set(AFFECTFLDKEYS, (Object)affectFldKeys.toString());
        }
        return dy;
    }

    private DynamicObject dealWithBizRule(Map<String, Object> data) {
        Map valMap;
        DynamicObject dy = data.get(RULEID) != null ? BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(data.get(RULEID).toString()), (String)"bos_nocode_rule") : BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_rule");
        String formId = (String)data.get(FORMID);
        String fieldKey = (String)data.get("fieldKey");
        dy.set(NAME, (Object)fieldKey);
        dy.set(FORMID, (Object)formId);
        dy.set(RULETYPE, (Object)"1");
        dy.set(CREATER, (Object)RequestContext.get().getCurrUserId());
        String ruleInfo = (String)data.get("ruleInfo");
        dy.set(EXPRESSION, (Object)ruleInfo);
        try {
            valMap = (Map)SerializationUtils.fromJsonString((String)ruleInfo, Map.class);
        }
        catch (Exception e) {
            return null;
        }
        if (!valMap.containsKey("valueType")) {
            return null;
        }
        int valueType = (Integer)valMap.get("valueType");
        if (valueType == 0) {
            return null;
        }
        if (valueType == 1) {
            this.deleteOtherBizRule(formId, fieldKey);
            String expression = (String)valMap.get("value");
            if (StringUtils.isBlank((CharSequence)expression)) {
                return null;
            }
            String result = NcEntityTypeUtil.getRuntimeExpression((String)expression);
            try {
                String[] vars = FormulaEngine.extractVariables((String)result);
                String depFldKeys = String.join((CharSequence)",", Arrays.asList(vars));
                dy.set(DEPFLDKEYS, (Object)depFldKeys);
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Object)e);
            }
            dy.set(AFFECTFLDKEYS, (Object)fieldKey);
            dy.set(VALUETYPE, (Object)"1");
        } else if (valueType == 2) {
            String ruleName = (String)valMap.get("ruleName");
            if (StringUtils.isBlank((CharSequence)ruleName)) {
                throw new KDBizException("name is null");
            }
            if (ruleName.length() > 100) {
                throw new KDBizException("name is too long");
            }
            dy.set(NAME, (Object)ruleName);
            Map configs = (Map)valMap.get("value");
            List filterInfos = (List)configs.get("filterInfos");
            if (filterInfos == null || filterInfos.isEmpty()) {
                throw new KDBizException("filterInfos is null");
            }
            String relateFormId = (String)configs.get("relationFormId");
            if (StringUtils.isBlank((CharSequence)relateFormId)) {
                throw new KDBizException("relationFormId is null");
            }
            String[] vars = this.parseExpression(formId, filterInfos, false);
            String depFldKeys = String.join((CharSequence)",", Arrays.asList(vars));
            dy.set(DEPFLDKEYS, (Object)depFldKeys);
            List result = (List)configs.get("result");
            if (result == null || result.isEmpty()) {
                throw new KDBizException("result is null");
            }
            StringBuilder affectFldKey = new StringBuilder();
            for (Map map : result) {
                String targetField = (String)map.get("targetField");
                affectFldKey.append(targetField).append(",");
            }
            if (StringUtils.isNotBlank((CharSequence)affectFldKey.toString())) {
                affectFldKey = new StringBuilder(affectFldKey.substring(0, affectFldKey.length() - 1));
                dy.set(AFFECTFLDKEYS, (Object)affectFldKey.toString());
            }
            dy.set(VALUETYPE, (Object)"0");
        } else if (valueType == 3) {
            String ruleName = (String)valMap.get("ruleName");
            if (StringUtils.isBlank((CharSequence)ruleName)) {
                throw new KDBizException("name is null");
            }
            if (ruleName.length() > 100) {
                throw new KDBizException("name is too long");
            }
            dy.set(NAME, (Object)ruleName);
            Map configs = (Map)valMap.get("value");
            String relateFormId = (String)configs.get("relationFormId");
            String[] fields = relateFormId.split("\\.");
            dy.set(DEPFLDKEYS, (Object)fields[0]);
            List result = (List)configs.get("result");
            if (result == null || result.isEmpty()) {
                throw new KDBizException("result is null");
            }
            String affectFldKey = "";
            for (Map map : result) {
                String targetField = (String)map.get("targetField");
                affectFldKey = affectFldKey + targetField + ",";
            }
            if (StringUtils.isNotBlank((CharSequence)affectFldKey)) {
                affectFldKey = affectFldKey.substring(0, affectFldKey.length() - 1);
                dy.set(AFFECTFLDKEYS, (Object)affectFldKey);
            }
            dy.set(VALUETYPE, (Object)"0");
        }
        return dy;
    }

    private void deleteOtherBizRule(String formId, String fieldKey) {
        QFilter[] qFilters = new QFilter[]{new QFilter("formid", "=", (Object)formId), QFilter.like((String)AFFECTFLDKEYS, (String)fieldKey), new QFilter(RULETYPE, "=", (Object)"1"), new QFilter(VALUETYPE, "=", (Object)"1")};
        DeleteServiceHelper.delete((String)"bos_nocode_rule", (QFilter[])qFilters);
    }

    private String[] parseExpression(String formId, List<Map<String, Object>> filterInfos, boolean formRule) {
        try (EntityTraceSpan span = EntityTracer.create((String)"NoCodeRuleServiceImpl", (String)"parseExpression");){
            span.addLocaleTag("filterInfos", filterInfos);
            ArrayList<String> list = new ArrayList<String>();
            BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)formId);
            for (Map<String, Object> map : filterInfos) {
                String sDateRangeError;
                boolean isDateRangeCompare = DataRangeCompareUtil.isDateRangeCompare(map);
                if (isDateRangeCompare && StringUtils.isNotBlank((CharSequence)(sDateRangeError = DataRangeCompareUtil.isFilterValueValid2DateRange(map, (String)ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4", (String)"NoCodeRuleServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]))))) {
                    throw new KDBizException(new ErrorCode("5001", sDateRangeError), new Object[0]);
                }
                if (formRule) {
                    DynamicProperty property;
                    String fieldName = (String)map.get("fieldName");
                    if (fieldName.contains(".") && (property = (DynamicProperty)NcEntityTypeUtil.findProperty((DynamicObjectType)dt, (String)fieldName)) != null && property.getParent() instanceof NoCodeBillEntityType) {
                        fieldName = fieldName.split("\\.")[0];
                    }
                    list.add(fieldName);
                }
                Object value = map.get("value");
                List<Map<String, Object>> valueList = ListFilterConfigUtils.getValueList(value);
                for (Map<String, Object> obj : valueList) {
                    String fieldValue;
                    if (!(obj.get("fieldValue") instanceof String) || (fieldValue = (String)obj.get("fieldValue")) == null || fieldValue.indexOf("${model") == -1) continue;
                    fieldValue = fieldValue.replace("${model.", "");
                    fieldValue = fieldValue.replace("}", "");
                    if (isDateRangeCompare) {
                        fieldValue = (String)DataRangeCompareUtil.getFieldValueWithDefault(valueList, obj, (Object)fieldValue);
                    }
                    list.add(fieldValue);
                }
            }
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
    }
}

