/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.mservice;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.ExprFuncCreator;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.function.UDFunctionVisitor;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.FormulaException;
import kd.bos.formula.excel.UDFunction;
import kd.bos.formula.excel.Visitor;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.express.NoCodeExpBillCtx;
import kd.bos.nocode.express.NoCodeExpCtx;
import kd.bos.nocode.expression.NoCodeExpressionContextAdapterEx;
import kd.bos.nocode.ext.constant.ValueMapItemVO;
import kd.bos.nocode.ext.metadata.entity.filter.FilterBuilderUtils;
import kd.bos.nocode.ext.metadata.entity.filter.pojo.FilterItem;
import kd.bos.nocode.ext.util.WfProcessUtils;
import kd.bos.nocode.func.AggregateFuncEnum;
import kd.bos.nocode.func.ContainsAllFunc;
import kd.bos.nocode.func.NotAllContainsFunc;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.common.util.CollectionUtil;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.filter.impl.RestApiFilterBuilder;
import kd.bos.nocode.restapi.filter.impl.WfJudgeFilterBuilder;
import kd.bos.nocode.restapi.handle.PropertyHandleUtil;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.utils.FuncUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.URLCodecUtils;
import kd.bos.nocode.utils.WfUtils;
import kd.bos.nocode.wf.WfExpressionBillCtx;
import kd.bos.orm.query.QFilter;
import kd.bos.service.nocode.NoCodeRuntimeServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NoCodeRuntimeServiceImplEx
extends NoCodeRuntimeServiceImpl {
    protected static final Log logger = LogFactory.getLog(NoCodeRuntimeServiceImplEx.class);
    private static final String SPAN_TYPE_FORMULA = "nocode_formula";
    private static final String SPAN_NAME_GETEXPRESSIONVALUE = "NoCodeRuntimeServiceImpl.getExpressionValue";
    private static final String SPAN_PARAM_EXPRESSION = "expression";
    private static final String SPAN_PARAM_CTX = "ctx";
    private static final String SPAN_PARAM_RESULT = "result";
    private static final String INFO_PATTERN_IN_NEST = "(%s)\\(\\s*%s\\((.+?)\\)\\s*\\)";
    private static final String INFO_PATTERN_DISP = "(disp\\(.+?\\))";

    public String checkExpression(NoCodeExpCtx ctx) {
        try {
            this.getExpressionValue(ctx);
        }
        catch (FormulaException e) {
            logger.warn((Throwable)e);
            String message = e.getMessage();
            if (message.contains("parse error") || e.getCause() instanceof ParseException) {
                return "\u516c\u5f0f\u9519\u8bef";
            }
            if (message.contains("Illegal date string")) {
                return null;
            }
            if (message.contains("\u201c+\u201d\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u6216\u5b57\u7b26\u4e32\u5bf9\u8c61")) {
                return null;
            }
            return message;
        }
        return null;
    }

    protected String mockExpression(NoCodeExpCtx ctx) {
        String expression = ctx.getExpression();
        return expression;
    }

    protected FunctionManage getFuncLib() {
        return FuncUtil.getNoCodeFuncLib();
    }

    protected Tuple<Boolean, String> prepareExpressionEx(NoCodeExpCtx ctx, WfConsts.ExpressionCtxType ctxType) {
        return this.replaceModelField(ctx, ctxType);
    }

    public Object tryGetExpressionValue(NoCodeExpCtx ctx) {
        WfConsts.ExpressionCtxType ctxType = this.getCtxType(ctx, WfConsts.ExpressionCtxType.DEFAULT);
        Tuple<Boolean, String> tuple = this.prepareExpressionEx(ctx, ctxType);
        if (((Boolean)tuple.item1).booleanValue()) {
            return tuple.item2;
        }
        String expression = (String)tuple.item2;
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        try {
            logger.info("expression: {}", (Object)expression);
            expression = StringUtil.removeNewLine((String)expression);
            Expr expr = FormulaEngine.parseFormula((String)expression);
            Object[] vars = FormulaEngine.extractVariables((String)expression);
            Arrays.sort(vars);
            HashMap<Object, Object> engineCtx = new HashMap<Object, Object>(vars.length);
            for (int i = 0; i < vars.length; ++i) {
                Object var = vars[i];
                Object varValue = ctx.getVarValue((String)var);
                varValue = this.formatVarValue(varValue, ctx);
                engineCtx.put(var, varValue);
            }
            UDFunctionVisitor funVisitor = new UDFunctionVisitor();
            expr.accept((Visitor)funVisitor);
            HashSet funcs = new HashSet();
            funcs.addAll(funVisitor.getFuncNames());
            NoCodeExpressionContextAdapterEx expContext = new NoCodeExpressionContextAdapterEx(ctx, ctxType);
            BOSUDFunction[] functions = ExprFuncCreator.createUDFunctions(funcs, (FunctionManage)this.getFuncLib(), (ExpressionContext)expContext);
            Object result = FormulaEngine.execExcelFormula((Expr)expr, engineCtx, (UDFunction[])functions);
            if (EntityTracer.isRealtime()) {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_FORMULA, (String)SPAN_NAME_GETEXPRESSIONVALUE);){
                    span.addTag(SPAN_PARAM_EXPRESSION, expression);
                    span.addLocaleTag(SPAN_PARAM_CTX, (Object)ctx);
                    span.addLocaleTag(SPAN_PARAM_RESULT, result);
                }
            }
            return result;
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            logger.info("expression:" + expression);
            return expression;
        }
    }

    public Object getExpressionValue(NoCodeExpCtx ctx) throws KDException {
        return this.innerGetExpressionValue(ctx, this.getCtxType(ctx, WfConsts.ExpressionCtxType.DEFAULT));
    }

    private Object innerGetExpressionValue(NoCodeExpCtx ctx, WfConsts.ExpressionCtxType ctxType) throws KDException {
        Tuple<Boolean, String> tuple = this.prepareExpressionEx(ctx, ctxType);
        if (((Boolean)tuple.item1).booleanValue()) {
            return tuple.item2;
        }
        String expression = (String)tuple.item2;
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        logger.info("expression: {}", (Object)expression);
        expression = StringUtil.removeNewLine((String)expression);
        Expr expr = FormulaEngine.parseFormula((String)expression);
        Object[] vars = FormulaEngine.extractVariables((String)expression);
        Arrays.sort(vars);
        HashMap<Object, Object> engineCtx = new HashMap<Object, Object>(vars.length);
        for (int i = 0; i < vars.length; ++i) {
            Object var = vars[i];
            Object varValue = ctx.getVarValue((String)var);
            varValue = this.formatVarValue(varValue, ctx);
            engineCtx.put(var, varValue);
        }
        UDFunctionVisitor funVisitor = new UDFunctionVisitor();
        expr.accept((Visitor)funVisitor);
        HashSet funcs = new HashSet();
        funcs.addAll(funVisitor.getFuncNames());
        NoCodeExpressionContextAdapterEx expContext = new NoCodeExpressionContextAdapterEx(ctx, ctxType);
        FunctionManage funcLib = this.getFuncLib();
        ContainsAllFunc containsAllFunc = new ContainsAllFunc((ExpressionContext)expContext);
        NotAllContainsFunc notAllContainsFunc = new NotAllContainsFunc((ExpressionContext)expContext);
        funcLib.addFunc(containsAllFunc.getName(), (BOSUDFunction)containsAllFunc);
        funcLib.addFunc(notAllContainsFunc.getName(), (BOSUDFunction)notAllContainsFunc);
        BOSUDFunction[] functions = ExprFuncCreator.createUDFunctions(funcs, (FunctionManage)funcLib, (ExpressionContext)expContext);
        try {
            Object result = FormulaEngine.execExcelFormula((Expr)expr, engineCtx, (UDFunction[])functions);
            if (EntityTracer.isRealtime()) {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_FORMULA, (String)SPAN_NAME_GETEXPRESSIONVALUE);){
                    span.addTag(SPAN_PARAM_EXPRESSION, expression);
                    span.addLocaleTag(SPAN_PARAM_CTX, (Object)ctx);
                    span.addLocaleTag(SPAN_PARAM_RESULT, result);
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            logger.warn((Throwable)e);
            logger.info("expression:" + expression);
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_FORMULA, (String)SPAN_NAME_GETEXPRESSIONVALUE);){
                span.addLocaleTag(SPAN_PARAM_EXPRESSION, (Object)expression);
                span.addLocaleTag(SPAN_PARAM_CTX, (Object)ctx);
                span.throwException((Throwable)e);
            }
            throw e;
        }
    }

    private Object innterGetExpressionValueWithoutReplace(NoCodeExpCtx ctx, String expression, WfConsts.ExpressionCtxType ctxType) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        try {
            logger.info("expression: {}", (Object)expression);
            expression = StringUtil.removeNewLine((String)expression);
            Expr expr = FormulaEngine.parseFormula((String)expression);
            Object[] vars = FormulaEngine.extractVariables((String)expression);
            Arrays.sort(vars);
            HashMap<Object, Object> engineCtx = new HashMap<Object, Object>(vars.length);
            for (int i = 0; i < vars.length; ++i) {
                Object var = vars[i];
                Object varValue = ctx.getVarValue((String)var);
                varValue = this.formatVarValue(varValue, ctx);
                engineCtx.put(var, varValue);
            }
            UDFunctionVisitor funVisitor = new UDFunctionVisitor();
            expr.accept((Visitor)funVisitor);
            HashSet funcs = new HashSet();
            funcs.addAll(funVisitor.getFuncNames());
            NoCodeExpressionContextAdapterEx expContext = new NoCodeExpressionContextAdapterEx(ctx, ctxType);
            BOSUDFunction[] functions = ExprFuncCreator.createUDFunctions(funcs, (FunctionManage)this.getFuncLib(), (ExpressionContext)expContext);
            Object result = FormulaEngine.execExcelFormula((Expr)expr, engineCtx, (UDFunction[])functions);
            if (EntityTracer.isRealtime()) {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_FORMULA, (String)SPAN_NAME_GETEXPRESSIONVALUE);){
                    span.addTag(SPAN_PARAM_EXPRESSION, expression);
                    span.addLocaleTag(SPAN_PARAM_CTX, (Object)ctx);
                    span.addLocaleTag(SPAN_PARAM_RESULT, result);
                }
            }
            return result;
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            logger.debug("expression:" + expression);
            return expression;
        }
    }

    private Map<String, Object> getDynamicObjectMap(NoCodeExpBillCtx ctx, boolean useFormatStringValue) {
        String entityNumber = ctx.getEntityNumber();
        Object businessKey = ctx.getPkId();
        Map map = (Map)ctx.getCustomParam().get(entityNumber);
        if (map == null || map.isEmpty()) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)businessKey, (String)entityNumber);
            String selectProperties = NcEntityTypeUtil.getSelectPropertiesIncludePkId((String)entityNumber);
            String[] splitFields = selectProperties.split(",");
            HashSet selectSet = new HashSet(splitFields.length);
            Collections.addAll(selectSet, splitFields);
            map = PropertyHandleUtil.toMap((Object)businessKey, (String)entityNumber, (String)"$", (DynamicObject)dynamicObject, selectSet, (boolean)useFormatStringValue);
            ctx.getCustomParam().put(entityNumber, map);
        }
        return map;
    }

    private Map<String, Object> getCustomJsonDynamicObjectMap(NoCodeExpBillCtx ctx) {
        String entityNumber = ctx.getEntityNumber();
        Object businessKey = ctx.getPkId();
        Map map = (Map)ctx.getCustomParam().get(entityNumber);
        if (map == null || map.isEmpty()) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)businessKey, (String)entityNumber);
            String selectProperties = Optional.ofNullable(NcEntityTypeUtil.getSelectPropertiesIncludePkId((String)entityNumber)).orElse("");
            String[] splitFields = selectProperties.split(",");
            HashSet selectSet = new HashSet(splitFields.length);
            Collections.addAll(selectSet, splitFields);
            map = PropertyHandleUtil.formatCustomJsonMap((Object)businessKey, (String)entityNumber, (String)"$", (DynamicObject)dynamicObject, selectSet);
            ctx.getCustomParam().put(entityNumber, map);
        }
        return map;
    }

    public String getNotifyExpression(NoCodeExpCtx ctx) {
        return this.replaceModelField2NotifyExp(ctx);
    }

    public boolean getConditionExpressionValue(NoCodeExpCtx ctx) throws KDException {
        Object expressionValue = this.innerGetExpressionValue(ctx, WfConsts.ExpressionCtxType.CONDITION);
        if (expressionValue instanceof Boolean) {
            return (Boolean)expressionValue;
        }
        return false;
    }

    protected Tuple<Boolean, String> replaceModelField(NoCodeExpCtx ctx, WfConsts.ExpressionCtxType ctxType) {
        boolean isCondition = ctxType == WfConsts.ExpressionCtxType.CONDITION;
        boolean isNotify = ctxType == WfConsts.ExpressionCtxType.NOTIFY;
        String expression = ctx.getExpression();
        if (StringUtils.isBlank((CharSequence)expression)) {
            return new Tuple((Object)true, null);
        }
        expression = NcEntityTypeUtil.getRuntimeExpression((String)expression);
        if (StringUtils.isBlank((CharSequence)(expression = this.sureRemoveDispFunc(expression)))) {
            return new Tuple((Object)true, null);
        }
        if (isNotify) {
            if (WfConsts.QueryResultEnum.NonData.getCode().equalsIgnoreCase(expression)) {
                return new Tuple((Object)true, (Object)WfConsts.QueryResultEnum.NonData.getName());
            }
            if (WfConsts.QueryResultEnum.HasData.getCode().equalsIgnoreCase(expression)) {
                return new Tuple((Object)true, (Object)WfConsts.QueryResultEnum.HasData.getName());
            }
            if (WfConsts.AuditResultEnum.Consent.getCode().equalsIgnoreCase(expression)) {
                return new Tuple((Object)true, (Object)WfConsts.AuditResultEnum.Consent.getName());
            }
            if (WfConsts.AuditResultEnum.Terminate.getCode().equalsIgnoreCase(expression)) {
                return new Tuple((Object)true, (Object)WfConsts.AuditResultEnum.Terminate.getName());
            }
        }
        if (expression.startsWith("[") && isCondition) {
            expression = expression.replace("%%(", "{");
            expression = this.handleConditionExpression(ctx, expression);
            return new Tuple((Object)false, (Object)(StringUtils.isBlank((CharSequence)expression) ? null : expression));
        }
        if (ctx instanceof NoCodeExpBillCtx) {
            Map<String, Object> dynamicObjectMap = this.getDynamicObjectMap((NoCodeExpBillCtx)ctx, ctxType == WfConsts.ExpressionCtxType.NOTIFY);
            Pattern pattern = WfConsts.varModelPattern;
            Matcher m = pattern.matcher(expression);
            BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)((NoCodeExpBillCtx)ctx).getEntityNumber());
            while (m.find()) {
                String modelVar = m.group();
                String fieldId = modelVar.replaceAll("\\$\\{model\\.(.+?)\\}", "$1");
                if (!dynamicObjectMap.containsKey(fieldId)) continue;
                Object fieldValue = dynamicObjectMap.get(fieldId);
                if ((fieldValue == null || StringUtil.isEmptyString((Object)fieldValue) || CollectionUtil.isEmpty((Object)fieldValue)) && isCondition && this.isCheckNullExp(expression)) {
                    expression = expression.replace("'" + modelVar + "'", "null");
                    expression = expression.replace(modelVar, "null");
                    continue;
                }
                String sFieldValue = fieldValue == null ? "" : fieldValue.toString();
                int idSuffixIndex = WfUtils.getIdSuffixIndex((String)fieldId);
                String propertyKey = idSuffixIndex == -1 ? fieldId : fieldId.substring(0, idSuffixIndex);
                IDataEntityProperty property = dt.findProperty(propertyKey);
                if (property != null && (property instanceof TextProp || property instanceof DateTimeProp || property instanceof INoCodeRefBillProp)) {
                    sFieldValue = this.sureQuotation(sFieldValue, expression, modelVar, property instanceof DateTimeProp);
                } else if (property instanceof ComboProp) {
                    String v = "";
                    if (fieldValue instanceof List) {
                        List combValue = (List)fieldValue;
                        for (ValueMapItemVO valueMapItem : combValue) {
                            if (StringUtils.isNotBlank((CharSequence)v)) {
                                v = v + ",";
                            }
                            v = v + valueMapItem.getName();
                        }
                    } else {
                        v = sFieldValue;
                    }
                    sFieldValue = this.sureQuotation(v, expression, modelVar, false);
                } else if (property instanceof DecimalProp && StringUtils.isBlank((CharSequence)sFieldValue) && !isNotify) {
                    sFieldValue = "null";
                } else if (property instanceof LongProp && StringUtils.isBlank((CharSequence)sFieldValue) && !isNotify) {
                    sFieldValue = "null";
                } else if (property instanceof INoCodeRefBillProp && StringUtils.isBlank((CharSequence)sFieldValue) && !isNotify) {
                    sFieldValue = "null";
                }
                expression = expression.replace(modelVar, sFieldValue);
                if (sFieldValue == null || !sFieldValue.equalsIgnoreCase(expression)) continue;
                return new Tuple((Object)true, (Object)expression);
            }
        }
        return new Tuple((Object)false, (Object)expression);
    }

    private String handleConditionExpression(NoCodeExpCtx ctx, @NotNull String expression) {
        expression = this.replaceConditionVariable(ctx, expression);
        expression = expression.replace("\n", "\\n");
        List mapList = SerializationUtils.fromJsonStringToList((String)expression, Map.class);
        List filterItems = FilterBuilderUtils.convert((List)mapList);
        expression = WfJudgeFilterBuilder.getInstance().buildFilter(filterItems);
        return expression;
    }

    private String replaceConditionVariable(NoCodeExpCtx ctx, @NotNull String expression) {
        if (ctx instanceof NoCodeExpBillCtx) {
            NoCodeExpBillCtx billCtx = (NoCodeExpBillCtx)ctx;
            Map<String, Object> dynamicObjectMap = this.getDynamicObjectMap(billCtx, true);
            Pattern pattern = WfConsts.varModelPattern;
            Matcher m = pattern.matcher(expression);
            BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)billCtx.getEntityNumber());
            while (dt != null && m.find()) {
                String modelVar = m.group();
                String fieldId = modelVar.replaceAll("\\$\\{model\\.(.+?)\\}", "$1");
                if (!dynamicObjectMap.containsKey(fieldId)) continue;
                Object fieldValue = dynamicObjectMap.get(fieldId);
                String sFieldValue = fieldValue == null ? "" : fieldValue.toString();
                int idSuffixIndex = WfUtils.getIdSuffixIndex((String)fieldId);
                String propertyKey = idSuffixIndex == -1 ? fieldId : fieldId.substring(0, idSuffixIndex);
                IDataEntityProperty property = dt.findProperty(propertyKey);
                if (property instanceof ComboProp) {
                    String v = "";
                    if (fieldValue instanceof List) {
                        List combValue = (List)fieldValue;
                        for (ValueMapItemVO valueMapItem : combValue) {
                            if (StringUtils.isNotBlank((CharSequence)v)) {
                                v = v + ",";
                            }
                            v = v + valueMapItem.getName();
                        }
                    } else {
                        v = sFieldValue;
                    }
                    sFieldValue = v;
                }
                expression = expression.replace(modelVar, sFieldValue);
            }
            Matcher matcherDisp = WfConsts.VAR_DISP_PATTERN.matcher(expression);
            while (matcherDisp.find()) {
                String dispVar = matcherDisp.group();
                WfExpressionBillCtx wfExpressionBillCtx = new WfExpressionBillCtx(billCtx.getEntityNumber(), billCtx.getPkId(), dispVar, null, WfConsts.ExpressionCtxType.NOTIFY);
                wfExpressionBillCtx.getCustomParam().put("condition", true);
                Object dispValue = this.tryGetExpressionValue((NoCodeExpCtx)wfExpressionBillCtx);
                String sValue = dispValue != null ? dispValue.toString().trim() : "";
                expression = expression.replace(dispVar, sValue);
            }
        }
        return expression;
    }

    private String sureQuotation(String value, String expression, String modelVar, boolean isDatetime) {
        if (value.startsWith("\"") || value.startsWith("'")) {
            return value;
        }
        boolean bHas = this.hasQuotation(expression, modelVar);
        if (bHas) {
            return value;
        }
        String result = "'" + value + "'";
        if (isDatetime && StringUtils.isNotBlank((CharSequence)result) && FuncUtil.HAS_DATE_FUNC_PATTERN.matcher(expression).matches()) {
            if ("''".equalsIgnoreCase(result)) {
                result = "'1970-01-01'";
            }
            result = String.format("DATE(%s)", result);
        }
        return result;
    }

    private boolean hasQuotation(String expression, String modelVar) {
        int idx = expression.indexOf(modelVar);
        if (idx <= 0) {
            return false;
        }
        String preChar = expression.substring(idx - 1, idx);
        return "'".equalsIgnoreCase(preChar) || "\"".equalsIgnoreCase(preChar);
    }

    private boolean isCheckNullExp(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return false;
        }
        return expression.indexOf("<> null") != -1 || expression.indexOf("= null") != -1;
    }

    protected String replaceModelField2NotifyExp(NoCodeExpCtx ctx) {
        boolean fromCustomJson = ctx.getCustomParam().containsKey("parseCustomJsonVariable");
        if (fromCustomJson) {
            return this.parseCustomJsonVariable(ctx);
        }
        WfConsts.ExpressionCtxType ctxType = this.getCtxType(ctx, WfConsts.ExpressionCtxType.NOTIFY);
        String expression = ctx.getExpression();
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        expression = NcEntityTypeUtil.getRuntimeExpression((String)expression);
        expression = this.sureRemoveDispFunc(expression);
        if (WfConsts.QueryResultEnum.NonData.getCode().equalsIgnoreCase(expression)) {
            return WfConsts.QueryResultEnum.NonData.getName();
        }
        if (WfConsts.QueryResultEnum.HasData.getCode().equalsIgnoreCase(expression)) {
            return WfConsts.QueryResultEnum.HasData.getName();
        }
        if (WfConsts.AuditResultEnum.Consent.getCode().equalsIgnoreCase(expression)) {
            return WfConsts.AuditResultEnum.Consent.getName();
        }
        if (WfConsts.AuditResultEnum.Terminate.getCode().equalsIgnoreCase(expression)) {
            return WfConsts.AuditResultEnum.Terminate.getName();
        }
        if (ctx instanceof NoCodeExpBillCtx) {
            Map<String, Object> dynamicObjectMap = this.getDynamicObjectMap((NoCodeExpBillCtx)ctx, ctxType == WfConsts.ExpressionCtxType.NOTIFY);
            expression = NoCodeRuntimeServiceImplEx.decodeComboProp(expression);
            expression = NoCodeRuntimeServiceImplEx.replaceWfModelVariable(expression, dynamicObjectMap);
            expression = NoCodeRuntimeServiceImplEx.replaceWfModelMsgVariable(expression, dynamicObjectMap);
            expression = this.replaceDispFuncVariable(ctx, expression);
        }
        expression = WfProcessUtils.replaceWfSpecialCombo((String)expression);
        return expression;
    }

    private String parseCustomJsonVariable(NoCodeExpCtx ctx) {
        String expression = ctx.getExpression();
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        if (expression.contains("@@")) {
            expression = expression.substring(0, expression.indexOf("@@"));
        }
        expression = this.sureRemoveDispFunc(expression);
        if (ctx instanceof NoCodeExpBillCtx) {
            Map<String, Object> dynamicObjectMap = this.getCustomJsonDynamicObjectMap((NoCodeExpBillCtx)ctx);
            expression = NoCodeRuntimeServiceImplEx.replaceWfModelVariable(expression, dynamicObjectMap);
            expression = NoCodeRuntimeServiceImplEx.replaceWfModelMsgVariable(expression, dynamicObjectMap);
            expression = this.replaceDispFuncVariable(ctx, expression);
        }
        expression = WfProcessUtils.replaceWfSpecialCombo((String)expression);
        return expression;
    }

    @NotNull
    private String replaceDispFuncVariable(NoCodeExpCtx ctx, String expression) {
        Pattern patternDisp = Pattern.compile(INFO_PATTERN_DISP);
        Matcher mDisp = patternDisp.matcher(expression);
        while (mDisp.find()) {
            String dispExp = mDisp.group();
            String repDispExp = dispExp.replaceAll("(disp\\(.+?,')('\\))", "$10$2");
            Object dispValue = this.innterGetExpressionValueWithoutReplace(ctx, repDispExp, WfConsts.ExpressionCtxType.NOTIFY);
            String dispStr = dispValue == null ? "" : dispValue.toString();
            expression = expression.replace(dispExp, dispStr);
        }
        return expression;
    }

    @NotNull
    private static String replaceWfModelMsgVariable(String expression, Map<String, Object> dynamicObjectMap) {
        Pattern patternMsg = Pattern.compile("(\\{model\\..+?\\})");
        Matcher mMsg = patternMsg.matcher(expression);
        while (mMsg.find()) {
            String modelVar = mMsg.group();
            String fieldId = modelVar.replaceAll("\\{model\\.(.+?)\\}", "$1");
            if (!dynamicObjectMap.containsKey(fieldId)) continue;
            Object fieldValue = dynamicObjectMap.get(fieldId);
            String sFieldValue = fieldValue == null ? "" : fieldValue.toString();
            expression = expression.replace(modelVar, sFieldValue);
        }
        return expression;
    }

    @NotNull
    private static String replaceWfModelVariable(String expression, Map<String, Object> dynamicObjectMap) {
        Pattern pattern = WfConsts.varModelPattern;
        Matcher m = pattern.matcher(expression);
        while (m.find()) {
            String modelVar = m.group();
            String fieldId = modelVar.replaceAll("\\$\\{model\\.(.+?)\\}", "$1");
            if (!dynamicObjectMap.containsKey(fieldId)) continue;
            Object fieldValue = dynamicObjectMap.get(fieldId);
            String sFieldValue = fieldValue == null ? "" : fieldValue.toString();
            expression = expression.replace(modelVar, sFieldValue);
        }
        return expression;
    }

    private static String decodeComboProp(String expression) {
        String pattern = "(%[0-9a-fA-F]{2})+";
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(expression);
        StringBuffer output = new StringBuffer();
        while (matcher.find()) {
            String encodedSubstring = matcher.group();
            String decodedSubstring = null;
            decodedSubstring = URLCodecUtils.decode((String)encodedSubstring);
            matcher.appendReplacement(output, decodedSubstring);
        }
        matcher.appendTail(output);
        return output.toString();
    }

    @Nullable
    public QFilter getQFilter(@NotNull String entityNumber, @Nullable String filterJson) {
        if (StringUtils.isBlank((CharSequence)filterJson)) {
            return null;
        }
        List filterItems = SerializationUtils.fromJsonStringToList((String)filterJson, FilterItem.class);
        String restApiFilterStr = RestApiFilterBuilder.getInstance().buildFilter(filterItems, entityNumber);
        QFilter[] filters = FilterUtil.getQFilters(entityNumber, restApiFilterStr, true);
        return Arrays.stream(filters).reduce((e1, e2) -> e1.and(e2)).orElse(null);
    }

    private WfConsts.ExpressionCtxType getCtxType(NoCodeExpCtx ctx, WfConsts.ExpressionCtxType defaultValue) {
        WfConsts.ExpressionCtxType ctxType = defaultValue;
        if (ctx.getCustomParam() != null && ctx.getCustomParam().containsKey(WfConsts.ExpressionCtxType.class.getName())) {
            ctxType = WfConsts.ExpressionCtxType.getByCode((String)((String)ctx.getCustomParam().get(WfConsts.ExpressionCtxType.class.getName())));
        }
        return ctxType;
    }

    public Set<String> getTemplateAppIds() {
        return NcEntityTypeUtil.queryTemplateAppIds();
    }

    private String sureRemoveDispFunc(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return expression;
        }
        List funcWithoutDisp = Arrays.stream(AggregateFuncEnum.values()).filter(v -> !AggregateFuncEnum.disp.getCode().equalsIgnoreCase(v.getCode())).map(AggregateFuncEnum::getCode).collect(Collectors.toList());
        String agrFunc = String.join((CharSequence)"|", funcWithoutDisp);
        String result = expression.replaceAll(String.format(INFO_PATTERN_IN_NEST, agrFunc, AggregateFuncEnum.disp.getCode()), "$1($2)");
        result = result.replaceAll("(disp\\(.+?,')('\\))", "$10$2");
        return result;
    }
}

