/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.mservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.exception.KDException;
import kd.bos.nocode.mservice.NoCodeSoftDeleteService;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NcRuntimeMetaUtil;

public class NoCodeSoftDeleteServiceImpl
implements NoCodeSoftDeleteService {
    public String softDelete(String refFormId) {
        try {
            this.disableFormDesignMeta(refFormId);
            this.disableEntitydesignMeta(refFormId);
            this.clearRefRuntimeMeta(refFormId);
            this.clearSelfRuntimeMeta(refFormId);
        }
        catch (KDException ex) {
            return ex.getMessage();
        }
        return null;
    }

    public Map<String, String> getSoftDeletedInfo(String formId) {
        HashMap<String, String> result = new HashMap<String, String>(10);
        Map data = NcRuntimeMetaUtil.getRuntimeMeta((String)formId);
        Map refBillInfos = (Map)data.get("refBillInfos");
        if (refBillInfos == null || refBillInfos.isEmpty()) {
            return Collections.emptyMap();
        }
        for (Map.Entry entrySet : refBillInfos.entrySet()) {
            if (!this.isSoftDeleted((String)entrySet.getValue())) continue;
            result.put((String)entrySet.getKey(), (String)entrySet.getValue());
        }
        return result;
    }

    public boolean isSoftDeleted(String refFormId) {
        return NcEntityTypeUtil.isSoftDeleted((String)refFormId);
    }

    private void disableFormDesignMeta(String refFormId) {
        String sqlU = "update t_meta_formdesign set fenabled = '0' where fid = ?";
        DB.execute((DBRoute)DBRoute.meta, (String)sqlU, (Object[])new SqlParameter[]{new SqlParameter("FID", 12, (Object)refFormId)});
    }

    private void disableEntitydesignMeta(String refFormId) {
        String sqlU = "update t_meta_Entitydesign set fenabled = '0' where fid = ?";
        DB.execute((DBRoute)DBRoute.meta, (String)sqlU, (Object[])new SqlParameter[]{new SqlParameter("FID", 12, (Object)refFormId)});
    }

    private void clearRefRuntimeMeta(String refFormId) {
        ArrayList sqlParams = new ArrayList();
        DBRoute dbRoute = DBRoute.meta;
        String readSql = "select fnumber, fkey, ftype from T_META_ENTITY where FTYPE = ? and FKEY = ? and FKEY <> fnumber";
        SqlParameter typeParam = new SqlParameter("FTYPE", 4, (Object)RuntimeMetaType.NOCODE.getValue());
        SqlParameter keyParam = new SqlParameter("FKEY", 12, (Object)refFormId);
        ResultSetHandler action = rs -> {
            while (rs.next()) {
                String number = rs.getString(1);
                String key = rs.getString(2);
                int type = rs.getInt(3);
                SqlParameter[] params = new SqlParameter[]{new SqlParameter("FNUMBER", 12, (Object)number), new SqlParameter("FKEY", 12, (Object)key), new SqlParameter("FTYPE", 4, (Object)type)};
                sqlParams.add(params);
            }
            return true;
        };
        DB.query((DBRoute)dbRoute, (String)readSql, (Object[])new SqlParameter[]{typeParam, keyParam}, (ResultSetHandler)action);
        if (!sqlParams.isEmpty()) {
            String deleteSql = "update T_META_ENTITY set fdata = null where fnumber = ? and fkey = ? and ftype = ?";
            DB.executeBatch((DBRoute)dbRoute, (String)deleteSql, sqlParams);
        }
    }

    private void clearSelfRuntimeMeta(String refFormId) {
        ArrayList sqlParams = new ArrayList();
        DBRoute dbRoute = DBRoute.meta;
        String readSql = "select fnumber, fkey, ftype from T_META_ENTITY where FTYPE = ? and FKEY = ? and FKEY = fnumber";
        SqlParameter typeParam = new SqlParameter("FTYPE", 4, (Object)RuntimeMetaType.NOCODE.getValue());
        SqlParameter keyParam = new SqlParameter("FKEY", 12, (Object)refFormId);
        ResultSetHandler action = rs -> {
            while (rs.next()) {
                String number = rs.getString(1);
                String key = rs.getString(2);
                int type = rs.getInt(3);
                SqlParameter[] params = new SqlParameter[]{new SqlParameter("FNUMBER", 12, (Object)number), new SqlParameter("FKEY", 12, (Object)key), new SqlParameter("FTYPE", 4, (Object)type)};
                sqlParams.add(params);
            }
            return true;
        };
        DB.query((DBRoute)dbRoute, (String)readSql, (Object[])new SqlParameter[]{typeParam, keyParam}, (ResultSetHandler)action);
        if (!sqlParams.isEmpty()) {
            String deleteSql = "update T_META_ENTITY set fdata = replace(fdata,'\"isSoftDeleted\":false','\"isSoftDeleted\":true') where fnumber = ? and fkey = ? and ftype = ?";
            DB.executeBatch((DBRoute)dbRoute, (String)deleteSql, sqlParams);
        }
    }

    private boolean isSoftDeleted(Map<String, Object> data) {
        if (data.isEmpty()) {
            return false;
        }
        Object isSoftDeletedObj = data.get("isSoftDeleted");
        if (isSoftDeletedObj == null) {
            return false;
        }
        return Boolean.parseBoolean(isSoftDeletedObj.toString());
    }
}

