/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.constant;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.bos.nocode.restapi.constant.CardTypeEnum;

public enum CardQueryTypeEnum {
    QUICK_ENTRY,
    QUICK_OP,
    FORM_LIST,
    STATISTICS,
    WF;


    public static Optional<CardQueryTypeEnum> of(String constant) {
        for (CardQueryTypeEnum value : CardQueryTypeEnum.values()) {
            if (!value.toString().equalsIgnoreCase(constant)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static List<String> getCardType(CardQueryTypeEnum queryTypeEnum) {
        ArrayList<String> cardTypeList = new ArrayList<String>(10);
        switch (queryTypeEnum) {
            case QUICK_ENTRY: {
                cardTypeList.add(CardTypeEnum.APP_ENTRY.toString());
                cardTypeList.add(CardTypeEnum.FORM_ENTRY.toString());
                cardTypeList.add(CardTypeEnum.FREQUENTLY_USED_APP.toString());
                break;
            }
            case QUICK_OP: {
                cardTypeList.add(CardTypeEnum.OPERATION_ENTRY.toString());
                break;
            }
            case FORM_LIST: {
                cardTypeList.add(CardTypeEnum.FORM_LIST.toString());
                break;
            }
            case STATISTICS: {
                cardTypeList.add(CardTypeEnum.STATISTICS.toString());
                break;
            }
            case WF: {
                cardTypeList.add(CardTypeEnum.WF_STATISTICS.toString());
                cardTypeList.add(CardTypeEnum.WF_MY_LAUNCH.toString());
                cardTypeList.add(CardTypeEnum.WF_MY_HANDLE.toString());
                break;
            }
        }
        return cardTypeList;
    }
}

