/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.filter;

import com.google.common.base.Joiner;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.entity.filter.CompareType;
import kd.bos.nocode.ext.metadata.entity.filter.NoCodeFilterMetadata;
import kd.bos.nocode.ext.metadata.entity.filter.pojo.FilterItem;
import kd.bos.nocode.ext.metadata.entity.filter.pojo.FilterValue;
import kd.bos.nocode.ext.util.WfFieldTypeUtils;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.filter.FilterBuilder;
import kd.bos.nocode.restapi.service.query.g.FilterVisitor;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.URLCodecUtils;
import kd.bos.nocode.utils.WfUtils;
import kd.bos.orm.util.CollectionUtils;

public abstract class AbstractFilterBuilder
implements FilterBuilder {
    private static final Log LOG = LogFactory.getLog(AbstractFilterBuilder.class);
    public static final String FIELD_NAME = "fieldName";
    public static final String FIELD_TYPE = "fieldType";
    public static final String COMPARE_TYPE = "compareType";
    public static final String VALUE = "value";
    public static final String FIELD_VALUE = "fieldValue";
    public static final String STRUTURE_VIEWPARENT_NAME = "structure.viewparent.name";

    @Override
    public String buildFilter(List<FilterItem> filterRows, String entityNumber) {
        try {
            if (CollectionUtils.isEmpty(filterRows)) {
                return "";
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            this.handleVirtualField(dataEntityType, filterRows);
            List<FilterField> filterFields = this.getFilterFields((IDataEntityType)dataEntityType);
            Map fieldNameMap = filterFields.stream().collect(Collectors.toMap(FilterField::getFullFieldName, Function.identity()));
            ArrayList<String> filters = new ArrayList<String>(filterRows.size());
            for (FilterItem filterItem : filterRows) {
                List filterValues;
                String className;
                CompareType compareType;
                String filter;
                String fieldName = filterItem.getFieldName();
                String fieldType = filterItem.getFieldType();
                FilterField filterField = (FilterField)fieldNameMap.get(fieldName);
                if (Objects.isNull(filterField)) {
                    IDataEntityProperty fieldProp = NcEntityTypeUtil.findProperty((DynamicObjectType)dataEntityType, (String)fieldName);
                    if (fieldProp == null) continue;
                    if (fieldProp instanceof IFieldHandle) {
                        filterField = ((IFieldHandle)fieldProp).createFilterField(dataEntityType, fieldName);
                    }
                    if (Objects.isNull(filterField)) continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)(filter = this.getFilter(fieldName, fieldType, compareType = NoCodeFilterMetadata.get().getCompareTypeById(filterItem.getCompareType()), filterField, className = compareType.getClassName(), filterValues = filterItem.getValue())))) continue;
                filters.add(filter);
            }
            String filter = String.join((CharSequence)" AND ", filters);
            this.checkFilter(entityNumber, filter);
            return filter;
        }
        catch (Exception e) {
            LOG.debug("\u6784\u5efafilter\u4e32\u5931\u8d25\uff1a{}\uff0cfilterRows={}", new Object[]{e.getMessage(), SerializationUtils.toJsonString(filterRows), e});
            return "";
        }
    }

    private void handleVirtualField(MainEntityType dataEntityType, List<FilterItem> filterRows) {
        String name = dataEntityType.getName();
        if ("bos_adminorg".equalsIgnoreCase(name)) {
            filterRows.stream().filter(e -> "parent".equalsIgnoreCase(e.getFieldName())).forEach(e -> e.setFieldName(STRUTURE_VIEWPARENT_NAME));
        }
    }

    private List<FilterField> getFilterFields(IDataEntityType dataEntityType) {
        ArrayList<FilterField> filterFieldList = new ArrayList<FilterField>(32);
        MainEntityType mainType = (MainEntityType)dataEntityType;
        Map fields = ListConfigUtils.getDirectFields((String)dataEntityType.getName());
        for (IDataEntityProperty fieldProp : fields.values()) {
            IDataEntityType parentType;
            if (!(fieldProp instanceof IFieldHandle) || (parentType = fieldProp.getParent()) instanceof EntryType) continue;
            List list = ((IFieldHandle)fieldProp).createFilterFields(mainType);
            list.removeIf(FilterField::isFieldPropAliasEmpty);
            filterFieldList.addAll(list);
        }
        this.handleOrgParentField(dataEntityType, filterFieldList);
        return filterFieldList;
    }

    private void handleOrgParentField(IDataEntityType dataEntityType, List<FilterField> filterFieldList) {
        if (dataEntityType.getName().equalsIgnoreCase("bos_adminorg")) {
            FilterField filterField = new FilterField(new LocaleString(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7", (String)"AbstractFilterBuilder_0", (String)"bos-nocode-service", (Object[])new Object[0])), STRUTURE_VIEWPARENT_NAME, "", "", 0);
            filterField.setFullFieldName(STRUTURE_VIEWPARENT_NAME);
            filterFieldList.add(filterField);
        }
    }

    private String getFilter(String fieldName, String fieldType, CompareType compareType, FilterField filterField, String className, List<FilterValue> valueList) {
        String operate = compareType.getOperate();
        if (StringUtils.isBlank((CharSequence)className)) {
            List<String> notSkipOpList = Arrays.asList("EQ", "NQ", "NC");
            if (CollectionUtils.isEmpty(valueList) && !notSkipOpList.contains(operate)) {
                return "";
            }
            String filter = this.getFilterByValue(fieldName, filterField, compareType, valueList);
            if (StringUtils.isNotEmpty((CharSequence)filter) && StringUtil.isNotEmptyBrackets((String)filter)) {
                return filter;
            }
        } else {
            String filter = this.getFilterByClass(fieldName, filterField, compareType, valueList);
            if (StringUtils.isNotEmpty((CharSequence)filter) && StringUtil.isNotEmptyBrackets((String)filter)) {
                return filter;
            }
        }
        return "";
    }

    protected abstract void checkFilter(String var1, String var2);

    public abstract String getFilterByClass(String var1, FilterField var2, CompareType var3, List<FilterValue> var4);

    public abstract String getFilterByValue(String var1, FilterField var2, CompareType var3, List<FilterValue> var4);

    @Override
    public String buildFilter(List<FilterItem> filterRows) {
        try {
            ArrayList<String> filters = new ArrayList<String>(16);
            for (FilterItem filterItem : filterRows) {
                List filterValues;
                String className;
                CompareType compareType;
                String fieldType;
                String fieldName = filterItem.getFieldName();
                String filter = this.getFilter(fieldName, fieldType = filterItem.getFieldType(), compareType = NoCodeFilterMetadata.get().getCompareTypeById(filterItem.getCompareType()), className = compareType.getClassName(), filterValues = filterItem.getValue());
                if (!StringUtils.isNotBlank((CharSequence)filter)) continue;
                filters.add(filter);
            }
            return String.join((CharSequence)" AND ", filters);
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Object)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6784\u5efafilter\u4e32\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\uff1a", (String)"AbstractFilterBuilder_1", (String)"bos-nocode-service", (Object[])new Object[0]) + e.getMessage());
        }
    }

    private String getFilter(String fieldName, String fieldType, CompareType compareType, String className, List<FilterValue> valueList) {
        String operate = compareType.getOperate();
        if (StringUtils.isBlank((CharSequence)className)) {
            List<String> notSkipOpList = Arrays.asList("EQ", "NQ", "NC");
            if (CollectionUtils.isEmpty(valueList) && !notSkipOpList.contains(operate)) {
                return "";
            }
            String filter = this.getFilterByValue(fieldName, fieldType, compareType, valueList);
            if (StringUtils.isNotEmpty((CharSequence)filter) && StringUtil.isNotEmptyBrackets((String)filter)) {
                return filter;
            }
        } else {
            String filter = this.getFilterByClass(fieldName, fieldType, compareType, valueList);
            if (StringUtils.isNotEmpty((CharSequence)filter) && StringUtil.isNotEmptyBrackets((String)filter)) {
                return filter;
            }
        }
        return "";
    }

    public String getFilterByValue(String fieldName, String fieldType, CompareType compareType, List<FilterValue> valueList) {
        boolean isNeedQuote;
        List targetList = valueList.stream().map(v -> this.getFilterValue(fieldType, (FilterValue)v)).collect(Collectors.toList());
        String valueStr = Joiner.on((String)",").join(targetList);
        boolean bl = fieldType == null ? targetList.get(0) instanceof String : (isNeedQuote = "text".equals(fieldType) || "date".equals(fieldType) || "combo".equals(fieldType) || fieldType.startsWith("combo-") || NcEntityTypeUtil.isRefBill((String)fieldType) && !WfConsts.varModelPattern.matcher(valueStr).matches());
        if (isNeedQuote) {
            valueStr = NcEntityTypeUtil.isRefBill((String)fieldType) || "combo".equals(fieldType) ? "'" + valueStr + "'" : targetList.stream().map(e -> "'" + e + "'").collect(Collectors.joining(","));
            if (WfConsts.varProcPattern.matcher(fieldName).matches()) {
                fieldName = "'" + fieldName + "'";
            }
        }
        String operate = FilterVisitor.operators.get(compareType.getOperate());
        if (StringUtils.isEmpty((CharSequence)valueStr)) {
            valueStr = "''";
        }
        if (WfFieldTypeUtils.isRefBill((String)fieldType)) {
            fieldName = WfUtils.appendId((String)fieldName);
            valueStr = WfUtils.appendId((String)valueStr);
        } else if (WfFieldTypeUtils.isPk((String)fieldType)) {
            if (WfConsts.varProcPattern.matcher(fieldName).matches()) {
                fieldName = "'" + fieldName + "'";
            }
            valueStr = WfUtils.wrapQuoteIfNotExist((String)valueStr);
            valueStr = WfUtils.appendId((String)valueStr);
        }
        if ("IN".equalsIgnoreCase(compareType.getOperate())) {
            return String.format("containsAll(%s, %s)", valueStr, fieldName);
        }
        if ("NI".equalsIgnoreCase(compareType.getOperate())) {
            return String.format("notAllContains(%s, %s)", valueStr, fieldName);
        }
        return String.format("(%s %s (%s))", fieldName, operate, valueStr);
    }

    private Object getFilterValue(String fieldType, FilterValue v) {
        String comboValue;
        Object fieldValue = v.getFieldValue();
        if ("combo".equals(fieldType) && StringUtils.isNotBlank((CharSequence)(comboValue = (String)fieldValue)) && !WfConsts.varProcPattern.matcher(comboValue).matches()) {
            fieldValue = URLCodecUtils.decode((String)comboValue);
        }
        return fieldValue;
    }

    public String getFilterByClass(String fieldName, String wfFieldType, CompareType compareType, List<FilterValue> valueList) {
        String defaultProcessor = "kd.bos.nocode.ext.metadata.entity.filter.processor";
        String targetProcessor = "kd.bos.nocode.ext.metadata.entity.filter.wf.processor";
        try {
            compareType.setWfFieldType(wfFieldType);
            String className = compareType.getClassName();
            className = className.replace("kd.bos.nocode.ext.metadata.entity.filter.processor", "kd.bos.nocode.ext.metadata.entity.filter.wf.processor");
            Class<?> cls = Class.forName(className);
            Method method = cls.getMethod("process", String.class, FilterField.class, CompareType.class, List.class);
            return (String)method.invoke(cls.newInstance(), fieldName, null, compareType, valueList);
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Object)e);
            throw new KDBizException(e.getMessage());
        }
    }
}

