/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.filter.impl;

import com.google.common.base.Splitter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.metadata.entity.filter.CompareType;
import kd.bos.nocode.ext.metadata.entity.filter.FilterBuilderUtils;
import kd.bos.nocode.ext.metadata.entity.filter.pojo.FilterValue;
import kd.bos.nocode.ext.property.NoCodeAttachmentProp;
import kd.bos.nocode.property.INoCodeComboProp;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.filter.AbstractFilterBuilder;
import kd.bos.nocode.restapi.service.query.g.FilterVisitor;
import org.apache.commons.lang3.StringUtils;

public class FormulaFilterBuilder
extends AbstractFilterBuilder {
    private static final Log LOG = LogFactory.getLog(FormulaFilterBuilder.class);
    private static final String DEFAULT_PROCESSOR = "kd.bos.nocode.ext.metadata.entity.filter.processor";
    private static final String TARGET_PROCESSOR = "kd.bos.nocode.ext.metadata.entity.filter.formula.processor";
    private static final String PROCESS = "process";
    private static final FormulaFilterBuilder INSTANCE = new FormulaFilterBuilder();

    public static FormulaFilterBuilder getInstance() {
        return INSTANCE;
    }

    private FormulaFilterBuilder() {
    }

    @Override
    protected void checkFilter(String entityNumber, String filter) {
    }

    @Override
    public String getFilterByClass(String fieldName, FilterField filterField, CompareType compareType, List<FilterValue> valueList) {
        try {
            String className = compareType.getClassName();
            className = className.replace(DEFAULT_PROCESSOR, TARGET_PROCESSOR);
            Class<?> cls = Class.forName(className);
            Method method = cls.getMethod(PROCESS, String.class, FilterField.class, CompareType.class, List.class);
            return (String)method.invoke(cls.newInstance(), fieldName, filterField, compareType, valueList);
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Object)e);
            throw new KDBizException(e.getMessage());
        }
    }

    @Override
    public String getFilterByValue(String fieldName, FilterField filterField, CompareType compareType, List<FilterValue> valueList) {
        String valueStr = FilterBuilderUtils.valueList2String((IDataEntityProperty)filterField.getFieldProp(), valueList);
        if (filterField.getSrcFieldProp() instanceof NoCodeAttachmentProp && filterField.getFieldProp().getName().contains("size")) {
            return String.format("(attachmentFieldSizeFunc(%s, \"%s\", \"%s\"))", fieldName, FilterVisitor.operators.get(compareType.getOperate()), valueStr);
        }
        if (filterField.getSrcFieldProp() instanceof NoCodeAttachmentProp && filterField.getFieldProp().getName().contains("type")) {
            return String.format("(attachmentFieldTypeFunc(%s, \"%s\", \"%s\"))", fieldName, FilterVisitor.operators.get(compareType.getOperate()), valueStr);
        }
        String originOperate = compareType.getOperate();
        if ("IN".equals(originOperate) && (filterField.getFieldProp() instanceof INoCodeComboProp || filterField.getFieldProp() instanceof INoCodeRefBillProp)) {
            return this.parseInMultiContents(fieldName, valueList, filterField.getFieldProp());
        }
        if ("NI".equals(originOperate) && (filterField.getFieldProp() instanceof INoCodeComboProp || filterField.getFieldProp() instanceof INoCodeRefBillProp)) {
            return this.parseNotInMultiContents(fieldName, valueList, filterField.getFieldProp());
        }
        boolean isNumber = filterField.getFieldProp() instanceof DecimalProp;
        String operate = FilterVisitor.operators.get(compareType.getOperate());
        if (isNumber) {
            if (StringUtils.isBlank((CharSequence)valueStr)) {
                return String.format("(%s %s null)", fieldName, operate);
            }
            return String.format("(%s %s (%s))", fieldName, operate, valueStr);
        }
        if (Arrays.asList("IN", "NI").contains(compareType.getOperate())) {
            return this.getFilterForBelong(fieldName, operate, valueStr);
        }
        if (StringUtils.isBlank((CharSequence)valueStr)) {
            if (Objects.equals("EQ", compareType.getOperate())) {
                return String.format("(%s %s null OR %s %s '' OR %s %s ' ')", fieldName, operate, fieldName, operate, fieldName, operate);
            }
            return String.format("(%s %s null AND %s %s '' AND %s %s ' ')", fieldName, operate, fieldName, operate, fieldName, operate);
        }
        return String.format("(%s %s ('%s'))", fieldName, operate, valueStr);
    }

    private String parseInMultiContents(String fieldName, List<FilterValue> valueList, IDataEntityProperty fieldProp) {
        String valueStr = FilterBuilderUtils.valueList2String((IDataEntityProperty)fieldProp, valueList);
        List values = Splitter.on((String)",").splitToList((CharSequence)valueStr);
        StringJoiner sj = new StringJoiner(",", "", "");
        for (String value : values) {
            sj.add(String.format("%s", value));
        }
        return String.format("containsAll(\"%s\", %s)", sj, fieldName);
    }

    private String parseNotInMultiContents(String fieldName, List<FilterValue> valueList, IDataEntityProperty fieldProp) {
        String valueStr = FilterBuilderUtils.valueList2String((IDataEntityProperty)fieldProp, valueList);
        List values = Splitter.on((String)",").splitToList((CharSequence)valueStr);
        StringJoiner sj = new StringJoiner(",", "", "");
        for (String value : values) {
            sj.add(String.format("%s", value));
        }
        return String.format("notAllContains(\"%s\", %s)", sj, fieldName);
    }

    private String getFilterForBelong(String fieldName, String operate, String valueStr) {
        List values = Splitter.on((String)",").splitToList((CharSequence)valueStr);
        StringJoiner sj = new StringJoiner(",", "(", ")");
        for (String value : values) {
            sj.add(String.format("'%s'", value));
        }
        return String.format("(%s %s %s)", fieldName, operate, sj);
    }
}

