/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.filter.impl;

import java.lang.reflect.Method;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterField;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.metadata.entity.filter.CompareType;
import kd.bos.nocode.ext.metadata.entity.filter.FilterBuilderUtils;
import kd.bos.nocode.ext.metadata.entity.filter.pojo.FilterValue;
import kd.bos.nocode.restapi.filter.AbstractFilterBuilder;
import kd.bos.nocode.restapi.service.util.FilterUtil;

public class RestApiFilterBuilder
extends AbstractFilterBuilder {
    private static final Log LOG = LogFactory.getLog(RestApiFilterBuilder.class);
    private static final RestApiFilterBuilder INSTANCE = new RestApiFilterBuilder();

    public static RestApiFilterBuilder getInstance() {
        return INSTANCE;
    }

    private RestApiFilterBuilder() {
    }

    @Override
    protected void checkFilter(String entityNumber, String filter) {
        FilterUtil.getQFilters(entityNumber, filter);
    }

    @Override
    public String getFilterByClass(String fieldName, FilterField filterField, CompareType compareType, List<FilterValue> valueList) {
        try {
            String className = compareType.getClassName();
            Class<?> cls = Class.forName(className);
            Method method = cls.getMethod("process", String.class, FilterField.class, CompareType.class, List.class);
            return (String)method.invoke(cls.newInstance(), fieldName, filterField, compareType, valueList);
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Object)e);
            throw new KDBizException(e.getMessage());
        }
    }

    @Override
    public String getFilterByValue(String fieldName, FilterField filterField, CompareType compareType, List<FilterValue> valueList) {
        String valueStr = FilterBuilderUtils.valueList2String((IDataEntityProperty)filterField.getFieldProp(), valueList);
        if (StringUtils.isEmpty((CharSequence)valueStr)) {
            return String.format("(%s %s )", fieldName, compareType.getOperate());
        }
        return String.format("(%s %s '%s')", fieldName, compareType.getOperate(), valueStr);
    }
}

