/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.filter.impl;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.FilterField;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.metadata.entity.filter.CompareType;
import kd.bos.nocode.ext.metadata.entity.filter.FilterBuilderUtils;
import kd.bos.nocode.ext.metadata.entity.filter.NoCodeFilterMetadata;
import kd.bos.nocode.ext.metadata.entity.filter.pojo.FilterItem;
import kd.bos.nocode.ext.metadata.entity.filter.pojo.FilterValue;
import kd.bos.nocode.ext.util.WfFieldTypeUtils;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.filter.FilterBuilder;
import kd.bos.nocode.restapi.service.query.g.FilterVisitor;
import kd.bos.nocode.utils.DateTimeUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WfJudgeFilterBuilder
implements FilterBuilder {
    private static final Log logger = LogFactory.getLog(WfJudgeFilterBuilder.class);
    private static final WfJudgeFilterBuilder INSTANCE = new WfJudgeFilterBuilder();
    private static final int DECIMAL_MAX_VALID_COUNT = 38;
    private static final String SINGLE_FILTER_DELIMITER = " AND ";

    public static WfJudgeFilterBuilder getInstance() {
        return INSTANCE;
    }

    @Override
    public String buildFilter(List<FilterItem> filterRows, String entityNumber) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String buildFilter(List<FilterItem> filterRows) {
        try {
            return filterRows.stream().map(this::buildSingleFilter).filter(StringUtils::isNotBlank).collect(Collectors.joining(SINGLE_FILTER_DELIMITER));
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6784\u5efafilter\u4e32\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\uff1a", (String)"WfJudgeFilterBuilder_0", (String)"bos-nocode-service", (Object[])new Object[0]) + e.getMessage());
        }
    }

    private String buildSingleFilter(FilterItem filterItem) {
        String fieldName = filterItem.getFieldName();
        String fieldType = filterItem.getFieldType();
        CompareType compareType = NoCodeFilterMetadata.get().getCompareTypeById(filterItem.getCompareType());
        String className = compareType.getClassName();
        List filterValues = filterItem.getValue();
        return this.getFilter(fieldName, fieldType, compareType, className, filterValues);
    }

    private String getFilter(String fieldName, String fieldType, CompareType compareType, String className, List<FilterValue> valueList) {
        if (StringUtils.isBlank((CharSequence)className)) {
            String filter = this.getFilterByValue(fieldName, fieldType, compareType, valueList);
            if (StringUtils.isNotEmpty((CharSequence)filter) && StringUtil.isNotEmptyBrackets((String)filter)) {
                return filter;
            }
        } else {
            String filter = this.getFilterByClass(fieldName, fieldType, compareType, valueList);
            if (StringUtils.isNotEmpty((CharSequence)filter) && StringUtil.isNotEmptyBrackets((String)filter)) {
                return filter;
            }
        }
        return "";
    }

    public String getFilterByValue(String fieldName, String fieldType, CompareType compareType, List<FilterValue> valueList) {
        String operate = FilterVisitor.operators.get(compareType.getOperate());
        String wfFieldType = WfFieldTypeUtils.getWfFieldType((String)fieldType, (CompareType)compareType);
        String valueStr = FilterBuilderUtils.valueList2String((String)wfFieldType, valueList);
        if ("IN".equalsIgnoreCase(compareType.getOperate())) {
            return String.format("containsAll('%s', '%s')", valueStr, fieldName);
        }
        if ("NI".equalsIgnoreCase(compareType.getOperate())) {
            return String.format("notAllContains('%s', '%s')", valueStr, fieldName);
        }
        if ("number".equals(fieldType)) {
            return this.handleNumberCompareExpression(fieldName, operate, valueStr);
        }
        if ("date".equals(fieldType)) {
            return WfJudgeFilterBuilder.handleDateCompareExpression(fieldName, operate, valueStr);
        }
        return String.format("('%s' %s '%s')", fieldName, operate, valueStr);
    }

    private static String handleDateCompareExpression(String fieldName, String operate, String valueStr) {
        Date leftDate = DateTimeUtils.loopParseSilent((String)fieldName);
        Date rightDate = DateTimeUtils.loopParseSilent((String)valueStr);
        String leftDateTime = "";
        String rightDateTime = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        if (leftDate != null) {
            leftDateTime = sdf.format(leftDate);
        }
        if (rightDate != null) {
            rightDateTime = sdf.format(rightDate);
        }
        return String.format("('%s' %s '%s')", leftDateTime, operate, rightDateTime);
    }

    private String handleNumberCompareExpression(String fieldName, String operate, @NotNull String valueStr) {
        fieldName = this.getValidNumber(fieldName);
        valueStr = this.getValidNumber(valueStr);
        return String.format("(%s %s %s)", fieldName, operate, valueStr);
    }

    @Nullable
    private String getValidNumber(@Nullable String number) {
        if (StringUtils.isBlank((CharSequence)number)) {
            return null;
        }
        if (this.countValidDigital(number = number.replace(",", "")) > 38) {
            return null;
        }
        if (!number.contains(".")) {
            number = number + ".0";
        }
        try {
            return new BigDecimal(number).toPlainString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private int countValidDigital(String valueStr) {
        return valueStr.replace(".", "").length();
    }

    public String getFilterByClass(String fieldName, String wfFieldType, CompareType compareType, List<FilterValue> valueList) {
        String defaultProcessor = "kd.bos.nocode.ext.metadata.entity.filter.processor";
        String targetProcessor = "kd.bos.nocode.ext.metadata.entity.filter.wf.processor.v2";
        try {
            compareType.setWfFieldType(wfFieldType);
            String className = compareType.getClassName();
            className = className.replace("kd.bos.nocode.ext.metadata.entity.filter.processor", "kd.bos.nocode.ext.metadata.entity.filter.wf.processor.v2");
            Class<?> cls = Class.forName(className);
            Method method = cls.getMethod("process", String.class, FilterField.class, CompareType.class, List.class);
            return (String)method.invoke(cls.newInstance(), fieldName, null, compareType, valueList);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Object)e);
            throw new KDBizException(e.getMessage());
        }
    }
}

