/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.batch.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.api.BatchRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiBatchParam;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestBaseFilterItemData;
import kd.bos.nocode.restapi.api.result.RestBaseFilterResult;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.batch.impl.BizButtonBatchProcessor;
import kd.bos.nocode.restapi.service.batch.impl.FieldValueUpdateBatchProcessor;
import kd.bos.nocode.restapi.service.batch.pojo.BatchProcessResult;
import kd.bos.nocode.restapi.service.batch.pojo.ErrorInfo;
import kd.bos.nocode.restapi.service.batch.pojo.PendingField;
import kd.bos.nocode.restapi.service.sys.service.ListSchemaService;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.restapi.service.util.ListSchemaUtils;
import kd.bos.nocode.servicehelper.AssociationServiceHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.nocode.model.PermItemEnum;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BatchRestApiServiceImpl
implements BatchRestApiService {
    private static final int DEFAULT_MAX_COUNT = 500;

    public RestApiServiceData<RestBaseFilterResult> execute(RestApiBatchParam param) {
        BatchProcessResult batchProcessResult;
        long startTime = System.currentTimeMillis();
        String appNumber = param.getAppNumber();
        String formId = param.getFormId();
        List<Object> idList = BatchRestApiServiceImpl.getPendingIdList(param, formId);
        if (idList.size() > 500) {
            throw new RestApiException(ResManager.loadKDString((String)"\u5355\u6b21\u5904\u7406\u6700\u591a\u652f\u6301%s\u6761", (String)"BatchRestApiServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[]{500}));
        }
        if ("edit".equalsIgnoreCase(param.getOperation())) {
            boolean ignoreAssociation = true;
            List<PendingField> pendingFields = this.buildPendingFields(param);
            if (!pendingFields.isEmpty()) {
                Tuple tuple = AssociationServiceHelper.existAssociation((String)formId, (String)pendingFields.get(0).getField());
                if (((Boolean)tuple.item1).booleanValue()) {
                    String targetField;
                    INoCodeRefBillProp prop = (INoCodeRefBillProp)pendingFields.get(0).getProperty();
                    String billEntityId = prop.getBillEntityId();
                    MainEntityType type = EntityMetadataCache.getDataEntityType((String)billEntityId);
                    INoCodeRefBillProp targetProp = (INoCodeRefBillProp)type.getProperty(targetField = (String)tuple.item2);
                    if (!targetProp.isMultiSelect() && idList.size() > 1 && !pendingFields.get(0).getValue().isEmpty()) {
                        MainEntityType sourceType = EntityMetadataCache.getDataEntityType((String)formId);
                        throw new RestApiException(ResManager.loadKDString((String)"\u4e00\u4e2a%1$s\u65e0\u6cd5\u540c\u65f6\u5173\u8054\u591a\u4e2a%2$s", (String)"BatchRestApiServiceImpl_3", (String)"bos-nocode-service", (Object[])new Object[]{type.getDisplayName(), sourceType.getDisplayName()}));
                    }
                    ignoreAssociation = false;
                }
            }
            FieldValueUpdateBatchProcessor batchProcessor = new FieldValueUpdateBatchProcessor(pendingFields, ignoreAssociation);
            batchProcessResult = batchProcessor.process(appNumber, formId, idList);
        } else {
            batchProcessResult = new BizButtonBatchProcessor(param.getOperation()).process(appNumber, formId, idList);
        }
        Map<Object, Integer> id2NumberMap = this.getId2NumberMap(param, formId);
        return this.parseBatchProcessResult(batchProcessResult, idList, id2NumberMap, startTime);
    }

    private Map<Object, Integer> getId2NumberMap(RestApiBatchParam param, String formId) {
        if (StringUtils.isEmpty((CharSequence)param.getOrderBy())) {
            param.setOrderBy("id desc");
        }
        String queryFilter = param.getQueryFilter();
        String search = param.getSearch();
        QFilter[] tempFilters = FilterUtil.getQFilters(param.getFormId(), queryFilter, search);
        return ListSchemaUtils.getId2NumberMap(param.getAppNumber(), formId, param.getSchemaId(), param.getOrderBy(), tempFilters);
    }

    @NotNull
    private static List<Object> getPendingIdList(RestApiBatchParam param, String formId) {
        Object[] filters = FilterUtil.getQFilters(formId, param.getFilter(), param.getSearch());
        String schemaId = param.getSchemaId();
        filters = (QFilter[])ArrayUtils.addAll((Object[])filters, (Object[])ListSchemaService.create().getSchemaFilters(Long.parseLong(schemaId)));
        long uid = RequestContext.get().getCurrUserId();
        if (!"edit".equalsIgnoreCase(param.getOperation())) {
            QFilter filter = NoCodePermissionServiceHelper.getDataRuleFilter((long)uid, (String)formId, (PermItemEnum)PermItemEnum.VIEW);
            filters = (QFilter[])ArrayUtils.addAll((Object[])filters, (Object[])new QFilter[]{filter});
        }
        if (StringUtils.isEmpty((CharSequence)param.getOrderBy())) {
            param.setOrderBy("id desc");
        }
        return QueryServiceHelper.queryPrimaryKeys((String)formId, (QFilter[])filters, (String)param.getOrderBy(), (int)501);
    }

    private RestApiServiceData<RestBaseFilterResult> parseBatchProcessResult(BatchProcessResult batchProcessResult, List<Object> idList, Map<Object, Integer> id2NumberMap, long startTime) {
        RestBaseFilterResult batchResult = new RestBaseFilterResult();
        if (batchProcessResult.isSuccess()) {
            batchResult.setSuccessCount((long)idList.size());
        } else {
            Map<Object, List<ErrorInfo>> id2ErrorInfos = batchProcessResult.getErrorInfoList().stream().collect(Collectors.groupingBy(ErrorInfo::getId));
            ArrayList batchItemDataList = new ArrayList(id2ErrorInfos.size());
            idList.stream().filter(id2ErrorInfos::containsKey).filter(id2NumberMap::containsKey).forEach(id -> {
                List v = (List)id2ErrorInfos.get(id);
                RestBaseFilterItemData restApiBatchItemData = new RestBaseFilterItemData();
                restApiBatchItemData.setId(id.toString());
                restApiBatchItemData.setBillIndex(((Integer)id2NumberMap.get(id)).intValue());
                restApiBatchItemData.setBillStatus(Boolean.FALSE.booleanValue());
                restApiBatchItemData.setErrors((List)Lists.newArrayList(this.getErrorMessages(v).iterator()));
                batchItemDataList.add(restApiBatchItemData);
            });
            batchResult.setSuccessCount((long)(idList.size() - batchItemDataList.size()));
            batchResult.setFailCount((long)batchItemDataList.size());
            batchResult.setResult(batchItemDataList);
            if (CollectionUtils.isEmpty(batchItemDataList)) {
                batchProcessResult.setSuccess(true);
            }
        }
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)batchResult);
        return RestApiServiceData.of((boolean)batchProcessResult.isSuccess(), (RestApiResponse)response, (long)(System.currentTimeMillis() - startTime));
    }

    private Set<String> getErrorMessages(List<ErrorInfo> v) {
        return v.stream().map(ErrorInfo::getMessage).collect(Collectors.toSet());
    }

    private List<PendingField> buildPendingFields(RestApiBatchParam param) {
        List fields = param.getFields();
        List pendingFields = SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString((Object)fields), PendingField.class);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)param.getFormId());
        pendingFields.forEach(pendingField -> {
            DynamicProperty property = dataEntityType.getProperty(pendingField.getField());
            if (Objects.isNull(property)) {
                throw new RestApiException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5[%s]\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u5c5e\u6027\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5", (String)"BatchRestApiServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[]{pendingField.getField()}), new Object[0]));
            }
            pendingField.setProperty((IDataEntityProperty)property);
        });
        return pendingFields;
    }
}

