/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.batch.impl;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.batch.FieldUpdater;
import kd.bos.nocode.restapi.service.batch.helper.FieldValueHelper;
import kd.bos.nocode.restapi.service.batch.pojo.FieldUpdateModeEnum;
import kd.bos.nocode.restapi.service.batch.pojo.PendingField;

public abstract class AbstractFieldUpdater
implements FieldUpdater {
    @Override
    public void execute(DynamicObject dynObj, PendingField pendingField) {
        FieldUpdateModeEnum mode = pendingField.getUpdateMode();
        switch (mode) {
            case add: {
                this.doAdd(dynObj, pendingField);
                break;
            }
            case update: {
                this.doUpdate(dynObj, pendingField);
                break;
            }
            case replace: {
                this.doReplace(dynObj, pendingField);
                break;
            }
            default: {
                throw new RestApiException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u66f4\u65b0\u6a21\u5f0f", (String)"AbstractFieldUpdater_0", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
        }
    }

    protected abstract void doAdd(DynamicObject var1, PendingField var2);

    protected abstract void doUpdate(DynamicObject var1, PendingField var2);

    protected abstract void doReplace(DynamicObject var1, PendingField var2);

    protected List<Object> getConvertedFieldValues(PendingField pendingField) {
        return FieldValueHelper.getConvertedFieldValues(pendingField);
    }
}

