/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.batch.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.nocode.restapi.service.batch.ListDataBatchProcessor;
import kd.bos.nocode.restapi.service.batch.helper.BatchProcessResultHelper;
import kd.bos.nocode.restapi.service.batch.pojo.BatchProcessResult;
import kd.bos.nocode.restapi.service.batch.pojo.ErrorInfo;
import kd.bos.util.CollectionUtils;
import org.apache.commons.compress.utils.Lists;

public abstract class AbstractListDataBatchProcessor
implements ListDataBatchProcessor {
    @Override
    public BatchProcessResult process(String appId, String entityNumber, List<Object> idList) {
        List<ErrorInfo> processErrors;
        ArrayList toHandleIdList = Lists.newArrayList(idList.iterator());
        this.init(appId, entityNumber, toHandleIdList);
        ArrayList<ErrorInfo> errorInfos = new ArrayList<ErrorInfo>(64);
        List<ErrorInfo> validateErrors = this.validate(appId, entityNumber, toHandleIdList);
        if (CollectionUtils.isNotEmpty(validateErrors)) {
            List errorIds = validateErrors.stream().map(ErrorInfo::getId).collect(Collectors.toList());
            toHandleIdList.removeIf(errorIds::contains);
            errorInfos.addAll(validateErrors);
        }
        if (CollectionUtils.isNotEmpty((Collection)toHandleIdList) && CollectionUtils.isNotEmpty(processErrors = this.doProcess(appId, entityNumber, toHandleIdList))) {
            errorInfos.addAll(processErrors);
        }
        if (CollectionUtils.isNotEmpty(errorInfos)) {
            return BatchProcessResultHelper.fail(errorInfos);
        }
        return BatchProcessResultHelper.success();
    }

    protected abstract void init(String var1, String var2, List<Object> var3);

    protected abstract List<ErrorInfo> validate(String var1, String var2, List<Object> var3);

    protected abstract List<ErrorInfo> doProcess(String var1, String var2, List<Object> var3);
}

