/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.batch.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.nocode.ext.metadata.form.control.NoCodeBizButtonAp;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.batch.impl.AbstractListDataBatchProcessor;
import kd.bos.nocode.restapi.service.batch.pojo.ErrorInfo;
import kd.bos.nocode.restapi.service.util.NoCodeBizButtonUtils;
import kd.bos.nocode.util.BizButtonUtil;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.api.model.ProcessModel;

public class BizButtonBatchProcessor
extends AbstractListDataBatchProcessor {
    private static final Log log = LogFactory.getLog(BizButtonBatchProcessor.class);
    private static final ExecutorService es = ThreadPools.newCachedExecutorService((String)"BizButtonBatchProcessor", (int)0, (int)10);
    private final String operation;
    private NoCodeBizButtonAp bizButton;

    public BizButtonBatchProcessor(String operation) {
        this.operation = operation;
    }

    @Override
    protected void init(String appId, String entityNumber, List<Object> idList) {
        this.bizButton = BizButtonUtil.getBizButtonDesignMeta((String)entityNumber, (String)this.operation);
        if (Objects.isNull(this.bizButton)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u64cd\u4f5c\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664", (String)"BizButtonBatchProcessor_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
    }

    @Override
    protected List<ErrorInfo> validate(String appId, String entityNumber, List<Object> idList) {
        ArrayList<ErrorInfo> errorInfos = new ArrayList<ErrorInfo>();
        if (StringUtils.isEmpty((String)this.bizButton.getTriggerProcess())) {
            throw new RestApiException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u89e6\u53d1\u6d41\u7a0b", (String)"BizButtonBatchProcessor_1", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        if (!this.bizButton.getOperationType().equalsIgnoreCase("1")) {
            throw new RestApiException(ResManager.loadKDString((String)"\u6682\u65f6\u53ea\u652f\u6301\u64cd\u4f5c\u7c7b\u578b\u4e3a[\u89e6\u53d1\u6d41\u7a0b]\u7684\u4e1a\u52a1\u64cd\u4f5c", (String)"BizButtonBatchProcessor_2", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        for (Object id : idList) {
            if (NoCodeBizButtonUtils.isVisibleByEnableFilterSetting(this.bizButton, entityNumber, id.toString())) continue;
            errorInfos.add(new ErrorInfo(id, ResManager.loadKDString((String)"\u4e0d\u652f\u6301", (String)"BizButtonBatchProcessor_3", (String)"bos-nocode-service", (Object[])new Object[0]) + this.bizButton.getName()));
        }
        return errorInfos;
    }

    @Override
    protected List<ErrorInfo> doProcess(String appId, String entityNumber, List<Object> idList) {
        ArrayList<ErrorInfo> errorInfos = new ArrayList<ErrorInfo>();
        long modelId = Long.parseLong(this.bizButton.getTriggerProcess());
        boolean isProcessExist = true;
        boolean isTimeProc = false;
        try {
            ProcessModel process = NoCodeWorkflowServiceHelper.getProcess((Long)modelId);
            isTimeProc = process.getData().indexOf("\"triggerMode\":\"time\"") != -1;
            isProcessExist = process != null;
        }
        catch (Exception ex) {
            log.warn((Throwable)ex);
            isProcessExist = false;
        }
        if (!isProcessExist) {
            errorInfos.add(new ErrorInfo(0, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6d41\u7a0b\u5df2\u5931\u6548", (String)"BizButtonBatchProcessor_4", (String)"bos-nocode-service", (Object[])new Object[0])));
            return errorInfos;
        }
        if (isTimeProc) {
            NoCodeWorkflowServiceHelper.tryTriggerProcess((Long)modelId, null, (String)"timer");
        } else {
            for (Object id : idList) {
                try {
                    es.execute(() -> NoCodeWorkflowServiceHelper.tryTriggerProcess((Long)modelId, (String)id.toString(), (String)"bizOperate"));
                }
                catch (Exception e) {
                    errorInfos.add(new ErrorInfo(id, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a", (String)"BizButtonBatchProcessor_5", (String)"bos-nocode-service", (Object[])new Object[0]) + e.getMessage()));
                    log.debug(e.getMessage(), (Object)e);
                }
            }
        }
        return errorInfos;
    }
}

