/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.batch.impl;

import com.google.common.base.Splitter;
import com.tongtech.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.nocode.restapi.service.batch.impl.AbstractFieldUpdater;
import kd.bos.nocode.restapi.service.batch.pojo.PendingField;
import kd.bos.nocode.restapi.service.batch.pojo.PendingFieldValue;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CommonFieldUpdater
extends AbstractFieldUpdater {
    @Override
    protected void doAdd(DynamicObject dynObj, PendingField pendingField) {
        String fieldName = pendingField.getField();
        Object oldValue = dynObj.get(fieldName);
        List<Object> fieldValues = this.getConvertedFieldValues(pendingField);
        if (Objects.isNull(oldValue)) {
            this.updateValue(dynObj, fieldName, fieldValues);
        } else {
            ArrayList<String> oldValueList = new ArrayList(Splitter.on((String)",").splitToList((CharSequence)oldValue.toString()));
            oldValueList = oldValueList.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            List<Object> unionFieldValues = this.getUnionFieldValues(oldValueList, fieldValues);
            Collections.sort(unionFieldValues);
            this.updateValue(dynObj, fieldName, unionFieldValues);
        }
    }

    @Override
    protected void doUpdate(DynamicObject dynObj, PendingField pendingField) {
        List<Object> fieldValues = this.getConvertedFieldValues(pendingField);
        this.updateValue(dynObj, pendingField.getField(), fieldValues);
    }

    @Override
    protected void doReplace(DynamicObject dynObj, PendingField pendingField) {
        String fieldName = pendingField.getField();
        List<PendingFieldValue> values = pendingField.getValue();
        if (CollectionUtils.isEmpty(values)) {
            return;
        }
        PendingFieldValue value = values.get(0);
        String fieldValue = (String)value.getFieldValue();
        String search = value.getSearch();
        String oldValue = dynObj.getString(fieldName);
        String newValue = oldValue.replace(search, fieldValue);
        dynObj.set(fieldName, (Object)newValue);
    }

    private List<Object> getUnionFieldValues(List<String> oldValueList, List<Object> fieldValues) {
        ArrayList<Object> unionFieldValues = new ArrayList<Object>(oldValueList);
        fieldValues.forEach(fieldValue -> {
            if (!unionFieldValues.contains(fieldValue)) {
                unionFieldValues.add(fieldValue);
            }
        });
        return unionFieldValues;
    }

    private void updateValue(DynamicObject dynObj, String fieldName, List<Object> newValues) {
        if (CollectionUtils.isEmpty(newValues)) {
            dynObj.set(fieldName, null);
        } else if (newValues.size() == 1) {
            Object fieldValue = newValues.get(0);
            dynObj.set(fieldName, fieldValue);
        } else {
            String strValue = newValues.stream().map(Object::toString).collect(Collectors.joining(","));
            dynObj.set(fieldName, (Object)strValue);
        }
    }
}

