/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.batch.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.property.NoCodeMulComboProp;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.batch.FieldUpdater;
import kd.bos.nocode.restapi.service.batch.helper.FieldValueHelper;
import kd.bos.nocode.restapi.service.batch.impl.AbstractListDataBatchProcessor;
import kd.bos.nocode.restapi.service.batch.impl.FieldUpdaterFactory;
import kd.bos.nocode.restapi.service.batch.pojo.ErrorInfo;
import kd.bos.nocode.restapi.service.batch.pojo.FieldUpdateModeEnum;
import kd.bos.nocode.restapi.service.batch.pojo.PendingField;
import kd.bos.nocode.restapi.service.batch.pojo.PendingFieldValue;
import kd.bos.nocode.restapi.service.util.NoCodeOperationServiceHelper;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class FieldValueUpdateBatchProcessor
extends AbstractListDataBatchProcessor {
    private static final String ID = "id";
    private final List<PendingField> fields;
    private Map<Object, DynamicObject> id2DynObj;
    private boolean ignoreAssociation = false;

    public FieldValueUpdateBatchProcessor(List<PendingField> fields) {
        this.fields = fields;
    }

    public FieldValueUpdateBatchProcessor(List<PendingField> fields, boolean ignoreAssociation) {
        this.fields = fields;
        this.ignoreAssociation = ignoreAssociation;
    }

    @Override
    protected void init(String appId, String entityNumber, List<Object> idList) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String selectProperties = this.getSelectProperties(dataEntityType, this.fields);
        QFilter idListFilter = new QFilter(dataEntityType.getPrimaryKey().getName(), "in", idList);
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)entityNumber, (String)selectProperties, (QFilter[])idListFilter.toArray());
        this.id2DynObj = Arrays.stream(dynObjs).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
    }

    @Override
    protected List<ErrorInfo> validate(String appId, String entityNumber, List<Object> idList) {
        List<ErrorInfo> lockStatusErrorInfos;
        List<ErrorInfo> fieldRequiredErrorInfos;
        List<ErrorInfo> notEditPermErrorInfos;
        ArrayList validateIds = Lists.newArrayList(idList.iterator());
        ArrayList<ErrorInfo> errorInfos = new ArrayList<ErrorInfo>(validateIds.size());
        this.checkFields();
        List<ErrorInfo> idErrorInfos = this.checkIdList(validateIds);
        if (CollectionUtils.isNotEmpty(idErrorInfos)) {
            List errorIds = idErrorInfos.stream().map(ErrorInfo::getId).collect(Collectors.toList());
            validateIds.removeIf(errorIds::contains);
            errorInfos.addAll(idErrorInfos);
        }
        if (CollectionUtils.isNotEmpty(notEditPermErrorInfos = this.checkEditPerm(entityNumber, validateIds))) {
            List errorIds = notEditPermErrorInfos.stream().map(ErrorInfo::getId).collect(Collectors.toList());
            validateIds.removeIf(errorIds::contains);
            errorInfos.addAll(notEditPermErrorInfos);
        }
        if (CollectionUtils.isNotEmpty(fieldRequiredErrorInfos = this.checkFieldRequired(validateIds))) {
            List errorIds = fieldRequiredErrorInfos.stream().map(ErrorInfo::getId).collect(Collectors.toList());
            validateIds.removeIf(errorIds::contains);
            errorInfos.addAll(fieldRequiredErrorInfos);
        }
        if (CollectionUtils.isNotEmpty(lockStatusErrorInfos = this.checkLockStatus(validateIds))) {
            List errorIds = lockStatusErrorInfos.stream().map(ErrorInfo::getId).collect(Collectors.toList());
            validateIds.removeIf(errorIds::contains);
            errorInfos.addAll(lockStatusErrorInfos);
        }
        errorInfos.addAll(lockStatusErrorInfos);
        return errorInfos;
    }

    private List<ErrorInfo> checkEditPerm(String entityNumber, List<Object> validateIds) {
        ArrayList errorInfos = Lists.newArrayList();
        for (Object validateId : validateIds) {
            if (NoCodePermHelper.checkDataEditPermInNoCode((String)entityNumber, (Object)validateId)) continue;
            errorInfos.add(new ErrorInfo(validateId, ResManager.loadKDString((String)"\u6ca1\u6709\u7f16\u8f91\u6743\u9650\uff0c\u4e0d\u53ef\u7f16\u8f91", (String)"FieldValueUpdateBatchProcessor_0", (String)"bos-nocode-service", (Object[])new Object[0])));
        }
        return errorInfos;
    }

    @Override
    protected List<ErrorInfo> doProcess(String appId, String entityNumber, List<Object> idList) {
        DynamicObject[] dynObjs;
        for (DynamicObject dynObj : dynObjs = this.getToProcessDynObjs(idList)) {
            for (PendingField field : this.fields) {
                IDataEntityProperty property = field.getProperty();
                FieldUpdater fieldUpdater = FieldUpdaterFactory.getFieldUpdater(property);
                fieldUpdater.execute(dynObj, field);
            }
        }
        OperationResult operationResult = FieldValueUpdateBatchProcessor.doUpdateDynObjs(appId, entityNumber, dynObjs, this.ignoreAssociation);
        return this.buildErrorInfo(operationResult);
    }

    private DynamicObject[] getToProcessDynObjs(List<Object> idList) {
        Collection<DynamicObject> values = this.id2DynObj.values();
        return (DynamicObject[])values.stream().filter(e -> idList.contains(e.getPkValue())).toArray(DynamicObject[]::new);
    }

    private void checkFields() {
        for (PendingField field : this.fields) {
            IDataEntityProperty property = field.getProperty();
            if (Objects.isNull(property)) {
                throw new RestApiException(ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38\uff0c\u5b57\u6bb5[%s]\u5c5e\u6027\u4e3a\u7a7a", (String)"FieldValueUpdateBatchProcessor_1", (String)"bos-nocode-service", (Object[])new Object[]{field.getField()}));
            }
            if (this.notSupportBatchEdit(property)) {
                throw new RestApiException(ResManager.loadKDString((String)"\u5b57\u6bb5[%s]\u4e0d\u652f\u6301\u6279\u91cf\u7f16\u8f91", (String)"FieldValueUpdateBatchProcessor_2", (String)"bos-nocode-service", (Object[])new Object[]{property.getDisplayName()}));
            }
            if (!this.notSupportUseAddMode(property, field.getUpdateMode())) continue;
            throw new RestApiException(ResManager.loadKDString((String)"\u5b57\u6bb5[%s]\u4e0d\u652f\u6301\u8be5\u66f4\u65b0\u6a21\u5f0f", (String)"FieldValueUpdateBatchProcessor_3", (String)"bos-nocode-service", (Object[])new Object[]{property.getDisplayName()}));
        }
    }

    private List<ErrorInfo> checkFieldRequired(List<Object> validateIds) {
        ArrayList allFieldErrorInfos = Lists.newArrayList();
        for (PendingField field : this.fields) {
            if (field.getUpdateMode() == FieldUpdateModeEnum.update && this.isRequiredField(field) && this.isEmptyValue(field)) {
                allFieldErrorInfos.addAll(this.buildErrorInfo(field.getProperty().getDisplayName().toString(), validateIds));
                continue;
            }
            if (field.getUpdateMode() != FieldUpdateModeEnum.replace || !this.isRequiredField(field)) continue;
            allFieldErrorInfos.addAll(this.buildReplaceErrorInfo(field.getProperty().getDisplayName().toString(), validateIds, field));
        }
        return allFieldErrorInfos;
    }

    private List<? extends ErrorInfo> buildReplaceErrorInfo(String fieldName, List<Object> validateIds, PendingField field) {
        List<PendingFieldValue> value = field.getValue();
        if (CollectionUtils.isEmpty(value)) {
            return new ArrayList(0);
        }
        PendingFieldValue pendingFieldValue = value.get(0);
        String search = pendingFieldValue.getSearch();
        String fieldValue = (String)pendingFieldValue.getFieldValue();
        if (StringUtils.isEmpty((String)search)) {
            return new ArrayList(0);
        }
        return validateIds.stream().filter(id -> search.equals(this.id2DynObj.get(id).getString(field.getField())) && StringUtils.isEmpty((String)fieldValue)).map(id -> new ErrorInfo(id, ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a", (String)"FieldValueUpdateBatchProcessor_4", (String)"bos-nocode-service", (Object[])new Object[]{fieldName}))).collect(Collectors.toList());
    }

    private List<ErrorInfo> buildErrorInfo(String fieldName, List<Object> validateIds) {
        return validateIds.stream().map(id -> new ErrorInfo(id, ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a", (String)"FieldValueUpdateBatchProcessor_4", (String)"bos-nocode-service", (Object[])new Object[]{fieldName}))).collect(Collectors.toList());
    }

    private boolean isEmptyValue(PendingField field) {
        List<Object> fieldValues = FieldValueHelper.getConvertedFieldValues(field);
        String valueStr = fieldValues.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(","));
        return StringUtils.isEmpty((String)valueStr);
    }

    private boolean isRequiredField(PendingField field) {
        IDataEntityProperty property = field.getProperty();
        boolean flag = false;
        if (property instanceof DynamicProperty) {
            String fieldRequired = (String)((DynamicProperty)property).getCustomProperty("FieldRequired");
            boolean bl = flag = Objects.equals("2", fieldRequired) || Objects.equals("3", fieldRequired);
            if (!flag && property instanceof INoCodeRefBillProp && StringUtils.isNotEmpty((String)((INoCodeRefBillProp)property).getRefTableKey())) {
                DynamicProperty p = (DynamicProperty)((MainEntityType)property.getParent()).findProperty(((INoCodeRefBillProp)property).getRefTableKey());
                fieldRequired = (String)p.getCustomProperty("FieldRequired");
                flag = Objects.equals("2", fieldRequired) || Objects.equals("3", fieldRequired);
            }
        }
        return flag;
    }

    private boolean notSupportUseAddMode(IDataEntityProperty property, FieldUpdateModeEnum updateMode) {
        return !this.supportAddMode(property) && updateMode == FieldUpdateModeEnum.add;
    }

    private boolean supportAddMode(IDataEntityProperty property) {
        return property instanceof NoCodeMulComboProp || property instanceof NoCodeMulRefBillProp;
    }

    private boolean notSupportBatchEdit(IDataEntityProperty property) {
        return !this.supportBatchEdit(property);
    }

    private boolean supportBatchEdit(IDataEntityProperty property) {
        return property instanceof TextProp || property instanceof DecimalProp || property instanceof ComboProp || property instanceof DateTimeProp || property instanceof INoCodeRefBillProp;
    }

    private List<ErrorInfo> checkIdList(List<Object> idList) {
        if (this.id2DynObj.size() == idList.size()) {
            return new ArrayList<ErrorInfo>();
        }
        Set<Object> existIdList = this.id2DynObj.keySet();
        HashSet notExistIdList = Sets.newHashSet(idList);
        notExistIdList.removeAll(existIdList);
        return notExistIdList.stream().map(id -> new ErrorInfo(id, ResManager.loadKDString((String)"\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"FieldValueUpdateBatchProcessor_5", (String)"bos-nocode-service", (Object[])new Object[0]))).collect(Collectors.toList());
    }

    private List<ErrorInfo> checkLockStatus(List<Object> idList) {
        return idList.stream().filter(id -> {
            DynamicObject dynObj = this.id2DynObj.get(id);
            return Objects.nonNull(dynObj) && dynObj.containsProperty(WfConsts.WfLockStatusEnum.LOCK_STATUS_KEY) && Objects.equals(dynObj.getString(WfConsts.WfLockStatusEnum.LOCK_STATUS_KEY), WfConsts.WfLockStatusEnum.LOCKED.getCode());
        }).map(id -> new ErrorInfo(id, ResManager.loadKDString((String)"\u6d41\u7a0b\u9501\u5b9a\u4e2d\uff0c\u4e0d\u53ef\u7f16\u8f91", (String)"FieldValueUpdateBatchProcessor_6", (String)"bos-nocode-service", (Object[])new Object[0]))).collect(Collectors.toList());
    }

    private static OperationResult doUpdateDynObjs(String appId, String entityNumber, DynamicObject[] dynObjs, boolean ignoreAssociation) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("autogeneratebillno", String.valueOf(false));
        option.setVariableValue("currbizappid", appId);
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("batchImport", String.valueOf(false));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("strictvalidation", Boolean.TRUE.toString());
        option.setVariableValue("ignoreAssociation", String.valueOf(ignoreAssociation));
        return NoCodeOperationServiceHelper.executeOperate("save", entityNumber, dynObjs, option);
    }

    private String getSelectProperties(MainEntityType dataEntityType, List<PendingField> fields) {
        Set fieldSet = fields.stream().map(PendingField::getField).collect(Collectors.toSet());
        fieldSet.add(ID);
        fieldSet.add(WfConsts.WfLockStatusEnum.LOCK_STATUS_KEY);
        if (Objects.nonNull(dataEntityType.getProperty("nocodebillnofield"))) {
            fieldSet.add("nocodebillnofield");
        }
        return String.join((CharSequence)",", fieldSet);
    }

    private List<ErrorInfo> buildErrorInfo(OperationResult operationResult) {
        ArrayList resultList = Lists.newArrayList();
        if (operationResult.isSuccess() && operationResult.getValidateResult().isSuccess()) {
            return resultList;
        }
        List validateErrors = operationResult.getValidateResult().getValidateErrors();
        if (CollectionUtils.isEmpty((Collection)validateErrors)) {
            return resultList;
        }
        List<OperateErrorInfo> errorMessages = validateErrors.stream().flatMap(e -> e.getAllErrorInfo().stream()).collect(Collectors.toList());
        ArrayList list = Lists.newArrayListWithCapacity((int)errorMessages.size());
        errorMessages.forEach(e -> {
            ErrorInfo errorInfo = new ErrorInfo(e.getPkValue(), e.getMessage());
            list.add(errorInfo);
        });
        return list;
    }
}

