/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.card;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.constant.CardTypeEnum;
import kd.bos.nocode.restapi.service.card.CardDataQuery;
import kd.bos.nocode.restapi.service.card.impl.AppEntryQuery;
import kd.bos.nocode.restapi.service.card.impl.DefaultQuery;
import kd.bos.nocode.restapi.service.card.impl.FormEntryQuery;
import kd.bos.nocode.restapi.service.card.impl.FormListQuery;
import kd.bos.nocode.restapi.service.card.impl.FrequentlyUsedAppQuery;
import kd.bos.nocode.restapi.service.card.impl.OperationEntryQuery;
import kd.bos.nocode.restapi.service.card.impl.StatisticsQuery;
import kd.bos.nocode.restapi.service.card.impl.WfStatQuery;

public class CardDataManager {
    static final Map<CardTypeEnum, CardDataQuery> MAPPER = new HashMap<CardTypeEnum, CardDataQuery>();
    static final CardDataQuery DEFAULT_QUERY = new DefaultQuery();

    private CardDataManager() {
    }

    public static CardDataQuery getQuery(CardTypeEnum cardTypeEnum) {
        CardDataQuery query = MAPPER.getOrDefault((Object)cardTypeEnum, DEFAULT_QUERY);
        if (Objects.isNull(query)) {
            throw new RestApiException("invalid card type.");
        }
        return query;
    }

    static {
        MAPPER.put(CardTypeEnum.FREQUENTLY_USED_APP, new FrequentlyUsedAppQuery());
        MAPPER.put(CardTypeEnum.APP_ENTRY, new AppEntryQuery());
        MAPPER.put(CardTypeEnum.FORM_ENTRY, new FormEntryQuery());
        MAPPER.put(CardTypeEnum.OPERATION_ENTRY, new OperationEntryQuery());
        MAPPER.put(CardTypeEnum.FORM_LIST, new FormListQuery());
        MAPPER.put(CardTypeEnum.STATISTICS, new StatisticsQuery());
        MAPPER.put(CardTypeEnum.WF_STATISTICS, new WfStatQuery());
    }
}

