/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.card.impl;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.nocode.restapi.service.card.CardAuthOrgRepository;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CardAuthOrgRepositoryImpl
implements CardAuthOrgRepository {
    private static final String CARD_AUTH_ORG_ENTITY_NAME = "bos_nocode_card_orgauth";
    private static final String CARD_ID = "cardId";
    private static final String ORG_ID = "orgId";

    @Override
    public void save(Long cardId, Set<Long> orgIds) {
        DynamicObject[] dynamicObjects = (DynamicObject[])orgIds.stream().map(orgId -> this.castToDynamicObject(cardId, (Long)orgId)).toArray(DynamicObject[]::new);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    private DynamicObject castToDynamicObject(Long cardId, Long orgId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)CARD_AUTH_ORG_ENTITY_NAME);
        dynamicObject.set(CARD_ID, (Object)cardId);
        dynamicObject.set(ORG_ID, (Object)orgId);
        return dynamicObject;
    }

    @Override
    public Set<Long> getCardIds(long orgId) {
        QFilter filter = new QFilter(ORG_ID, "=", (Object)orgId);
        DynamicObject[] cardObjs = BusinessDataServiceHelper.load((String)CARD_AUTH_ORG_ENTITY_NAME, (String)CARD_ID, (QFilter[])filter.toArray());
        return Arrays.stream(cardObjs).map(e -> e.getLong(CARD_ID)).collect(Collectors.toSet());
    }

    @Override
    public Set<Long> getOrgIds(long cardId) {
        QFilter filter = new QFilter(CARD_ID, "=", (Object)cardId);
        DynamicObject[] cardObjs = BusinessDataServiceHelper.load((String)CARD_AUTH_ORG_ENTITY_NAME, (String)ORG_ID, (QFilter[])filter.toArray());
        return Arrays.stream(cardObjs).map(e -> e.getLong(ORG_ID)).collect(Collectors.toSet());
    }

    @Override
    public void deleteByCardId(long cardId) {
        QFilter filter = new QFilter(CARD_ID, "=", (Object)cardId);
        DeleteServiceHelper.delete((String)CARD_AUTH_ORG_ENTITY_NAME, (QFilter[])filter.toArray());
    }
}

