/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.card.impl;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.nocode.restapi.service.card.CardAuthUserRepository;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CardAuthUserRepositoryImpl
implements CardAuthUserRepository {
    private static final String CARD_AUTH_USER_ENTITY_NAME = "bos_nocode_card_userauth";
    private static final String CARD_ID = "cardId";
    private static final String USER_ID = "userId";

    @Override
    public void save(Long cardId, Set<Long> userIds) {
        DynamicObject[] dynamicObjects = (DynamicObject[])userIds.stream().map(userId -> this.castToDynamicObject(cardId, (Long)userId)).toArray(DynamicObject[]::new);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    private DynamicObject castToDynamicObject(Long cardId, Long userId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)CARD_AUTH_USER_ENTITY_NAME);
        dynamicObject.set(CARD_ID, (Object)cardId);
        dynamicObject.set(USER_ID, (Object)userId);
        return dynamicObject;
    }

    @Override
    public Set<Long> getCardIds(long userId) {
        QFilter filter = new QFilter(USER_ID, "=", (Object)userId);
        DynamicObject[] cardObjs = BusinessDataServiceHelper.load((String)CARD_AUTH_USER_ENTITY_NAME, (String)CARD_ID, (QFilter[])filter.toArray());
        return Arrays.stream(cardObjs).map(e -> e.getLong(CARD_ID)).collect(Collectors.toSet());
    }

    @Override
    public void deleteByCardId(long cardId) {
        QFilter filter = new QFilter(CARD_ID, "=", (Object)cardId);
        DeleteServiceHelper.delete((String)CARD_AUTH_USER_ENTITY_NAME, (QFilter[])filter.toArray());
    }

    @Override
    public Set<Long> getUserIds(long cardId) {
        QFilter filter = new QFilter(CARD_ID, "=", (Object)cardId);
        DynamicObject[] cardObjs = BusinessDataServiceHelper.load((String)CARD_AUTH_USER_ENTITY_NAME, (String)USER_ID, (QFilter[])filter.toArray());
        return Arrays.stream(cardObjs).map(e -> e.getLong(USER_ID)).collect(Collectors.toSet());
    }
}

