/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.cardschema.impl;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.nocode.restapi.service.cardschema.CardSchemaAuthOrgRepository;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CardSchemaAuthOrgRepositoryImpl
implements CardSchemaAuthOrgRepository {
    private static final String CARD_SCHEMA_AUTH_ORG_ENTITY_NAME = "bos_nc_cardschema_orgauth";
    private static final String SCHEMA_ID = "schemaId";
    private static final String ORG_ID = "orgId";

    @Override
    public void save(Long schemaId, Set<Long> orgIds) {
        DynamicObject[] dynamicObjects = (DynamicObject[])orgIds.stream().map(orgId -> this.castToDynamicObject(schemaId, (Long)orgId)).toArray(DynamicObject[]::new);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    private DynamicObject castToDynamicObject(Long schemaId, Long orgId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)CARD_SCHEMA_AUTH_ORG_ENTITY_NAME);
        dynamicObject.set(SCHEMA_ID, (Object)schemaId);
        dynamicObject.set(ORG_ID, (Object)orgId);
        return dynamicObject;
    }

    @Override
    public Set<Long> getSchemaIds(long orgId) {
        QFilter filter = new QFilter(ORG_ID, "=", (Object)orgId);
        DynamicObject[] cardObjs = BusinessDataServiceHelper.load((String)CARD_SCHEMA_AUTH_ORG_ENTITY_NAME, (String)SCHEMA_ID, (QFilter[])filter.toArray());
        return Arrays.stream(cardObjs).map(e -> e.getLong(SCHEMA_ID)).collect(Collectors.toSet());
    }

    @Override
    public Set<Long> getOrgIds(long schemaId) {
        QFilter filter = new QFilter(SCHEMA_ID, "=", (Object)schemaId);
        DynamicObject[] cardObjs = BusinessDataServiceHelper.load((String)CARD_SCHEMA_AUTH_ORG_ENTITY_NAME, (String)ORG_ID, (QFilter[])filter.toArray());
        return Arrays.stream(cardObjs).map(e -> e.getLong(ORG_ID)).collect(Collectors.toSet());
    }

    @Override
    public void deleteBySchemaId(long schemaId) {
        QFilter filter = new QFilter(SCHEMA_ID, "=", (Object)schemaId);
        DeleteServiceHelper.delete((String)CARD_SCHEMA_AUTH_ORG_ENTITY_NAME, (QFilter[])filter.toArray());
    }
}

