/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.cardschema.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.nocode.restapi.constant.CardTypeEnum;
import kd.bos.nocode.restapi.service.cardschema.CardSchemaAuthOrgRepository;
import kd.bos.nocode.restapi.service.cardschema.CardSchemaAuthService;
import kd.bos.nocode.restapi.service.cardschema.CardSchemaAuthUserRepository;
import kd.bos.nocode.restapi.service.sys.repository.CardRepository;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CardSchemaAuthServiceImpl
implements CardSchemaAuthService {
    private final CardSchemaAuthUserRepository cardSchemaAuthUserRepository = CardSchemaAuthUserRepository.create();
    private final CardSchemaAuthOrgRepository cardSchemaAuthOrgRepository = CardSchemaAuthOrgRepository.create();
    private final CardRepository cardRepository = CardRepository.create();
    private static final String USER_ID = "id";
    private static final String USER_NAME = "name";
    private static final String USER_NUMBER = "number";
    private static final String ORG_ID = "id";
    private static final String ORG_NAME = "name";
    private static final String ORG_NUMBER = "number";
    private static final String NAME = "name";
    private static final String ID = "name";
    private static final String NUMBER = "number";
    private static final int USER_INFO_MAP_SIZE = 2;
    private static final int ORG_INFO_MAP_SIZE = 2;

    @Override
    public void assignUsers(long schemaId, Set<Long> userIds) {
        this.cardSchemaAuthUserRepository.deleteBySchemaId(schemaId);
        if (CollectionUtils.isNotEmpty(userIds)) {
            this.cardSchemaAuthUserRepository.save(schemaId, userIds);
        }
    }

    @Override
    public void assignOrgs(long schemaId, Set<Long> orgIds) {
        this.cardSchemaAuthOrgRepository.deleteBySchemaId(schemaId);
        if (CollectionUtils.isNotEmpty(orgIds)) {
            this.cardSchemaAuthOrgRepository.save(schemaId, orgIds);
        }
    }

    @Override
    public Set<Long> getCurrentUserPermittedSchemaIds() {
        long currUserId = RequestContext.get().getCurrUserId();
        long orgId = RequestContext.get().getOrgId();
        Set<Long> cardIdsForUser = this.cardSchemaAuthUserRepository.getSchemaIds(currUserId);
        Set<Long> cardIdsForOrg = this.cardSchemaAuthOrgRepository.getSchemaIds(orgId);
        cardIdsForUser.addAll(cardIdsForOrg);
        return cardIdsForUser;
    }

    @Override
    public DynamicObject[] getPermittedStatCards() {
        Set<Long> currentUserPermittedCardIds = this.getCurrentUserPermittedSchemaIds();
        QFilter filter = new QFilter("id", "in", currentUserPermittedCardIds).and("type", "=", (Object)CardTypeEnum.STATISTICS.toString());
        return this.cardRepository.getCards(filter);
    }

    @Override
    public List<Map<String, Object>> getAssignUsers(long schemaId) {
        Set<Long> userIds = this.cardSchemaAuthUserRepository.getUserIds(schemaId);
        return userIds.stream().map(this::getUserInfo).collect(Collectors.toList());
    }

    @NotNull
    private Map<String, Object> getUserInfo(Long e) {
        Map userInfo = UserServiceHelper.getUserInfoByID((long)e);
        HashMap<String, Object> userInfoVO = new HashMap<String, Object>(2);
        userInfoVO.put("id", e);
        userInfoVO.put("name", userInfo.get("name"));
        userInfoVO.put("number", userInfo.get("number"));
        return userInfoVO;
    }

    @Override
    public List<Map<String, Object>> getAssignOrgs(long schemaId) {
        Set<Long> orgIds = this.cardSchemaAuthOrgRepository.getOrgIds(schemaId);
        return orgIds.stream().map(this::getOrgInfo).collect(Collectors.toList());
    }

    @NotNull
    private Map<String, Object> getOrgInfo(Long e) {
        HashMap<String, Object> orgMap = new HashMap<String, Object>(2);
        Map orgProperties = OrgUnitServiceHelper.getOrgProperty((long)e, Arrays.asList("name", "name", "number"));
        orgMap.put("id", e);
        orgMap.put("name", "");
        orgMap.put("number", "");
        OrmLocaleValue name = (OrmLocaleValue)orgProperties.get("name");
        String number = (String)orgProperties.get("number");
        if (Objects.nonNull(name)) {
            orgMap.put("name", name.getLocaleValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)number)) {
            orgMap.put("number", number);
        }
        return orgMap;
    }
}

