/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.cardschema.impl;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.nocode.restapi.service.cardschema.CardSchemaAuthUserRepository;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CardSchemaAuthUserRepositoryImpl
implements CardSchemaAuthUserRepository {
    private static final String CARD_SCHEMA_AUTH_USER_ENTITY_NAME = "bos_nc_cardsch_userauth";
    private static final String SCHEMA_ID = "schemaId";
    private static final String USER_ID = "userId";

    @Override
    public void save(Long schemaId, Set<Long> userIds) {
        DynamicObject[] dynamicObjects = (DynamicObject[])userIds.stream().map(userId -> this.castToDynamicObject(schemaId, (Long)userId)).toArray(DynamicObject[]::new);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    private DynamicObject castToDynamicObject(Long schemaId, Long userId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)CARD_SCHEMA_AUTH_USER_ENTITY_NAME);
        dynamicObject.set(SCHEMA_ID, (Object)schemaId);
        dynamicObject.set(USER_ID, (Object)userId);
        return dynamicObject;
    }

    @Override
    public Set<Long> getSchemaIds(long userId) {
        QFilter filter = new QFilter(USER_ID, "=", (Object)userId);
        DynamicObject[] cardObjs = BusinessDataServiceHelper.load((String)CARD_SCHEMA_AUTH_USER_ENTITY_NAME, (String)SCHEMA_ID, (QFilter[])filter.toArray());
        return Arrays.stream(cardObjs).map(e -> e.getLong(SCHEMA_ID)).collect(Collectors.toSet());
    }

    @Override
    public Set<Long> getUserIds(long schemaId) {
        QFilter filter = new QFilter(SCHEMA_ID, "=", (Object)schemaId);
        DynamicObject[] cardObjs = BusinessDataServiceHelper.load((String)CARD_SCHEMA_AUTH_USER_ENTITY_NAME, (String)USER_ID, (QFilter[])filter.toArray());
        return Arrays.stream(cardObjs).map(e -> e.getLong(USER_ID)).collect(Collectors.toSet());
    }

    @Override
    public void deleteBySchemaId(long schemaId) {
        QFilter filter = new QFilter(SCHEMA_ID, "=", (Object)schemaId);
        DeleteServiceHelper.delete((String)CARD_SCHEMA_AUTH_USER_ENTITY_NAME, (QFilter[])filter.toArray());
    }
}

