/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.cardschema.impl;

import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.cardschema.CardSchemaRepository;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CardSchemaRepositoryImpl
implements CardSchemaRepository {
    public static final String ID = "id";
    private static final String CARD_SCHEMA = "bos_nocode_cardschema";
    private static final String USER_CARD_SCHEMA = "bos_nocode_wuserschema";
    private static final String CARD_CONTAINER = "bos_nocode_cardcontainer";
    public static final String USER_ID = "userId";
    public static final String NAME = "name";
    public static final String SCHEMA_ID = "schemaId";
    public static final String ACTIVE = "active";
    public static final String OWN = "own";
    public static final String CREATER = "creater";

    @Override
    public DynamicObject add(long userId, String name) {
        DynamicObject cardSchema = BusinessDataServiceHelper.newDynamicObject((String)CARD_SCHEMA);
        cardSchema.set(NAME, (Object)name);
        cardSchema.set(CREATER, (Object)userId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cardSchema});
        return cardSchema;
    }

    @Override
    public void addUserCardSchema(long userId, long schemaId, boolean isActive) {
        DynamicObject userCardSchema = BusinessDataServiceHelper.newDynamicObject((String)USER_CARD_SCHEMA);
        userCardSchema.set(USER_ID, (Object)userId);
        userCardSchema.set(SCHEMA_ID, (Object)schemaId);
        userCardSchema.set(ACTIVE, (Object)isActive);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userCardSchema});
    }

    @Override
    public DynamicObject update(long schemaId, String name) {
        QFilter schemaFilter = new QFilter(ID, "=", (Object)schemaId);
        QFilter[] filters = new QFilter[]{schemaFilter};
        DynamicObject updateObj = BusinessDataServiceHelper.loadSingle((String)CARD_SCHEMA, (QFilter[])filters);
        if (Objects.isNull(updateObj)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u65e0\u6743\u8bbf\u95ee", (String)"CardSchemaRepositoryImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        updateObj.set(NAME, (Object)name);
        SaveServiceHelper.update((DynamicObject)updateObj);
        return updateObj;
    }

    @Override
    public void delete(long schemaId) {
        QFilter schemaFilter = new QFilter(ID, "=", (Object)schemaId);
        QFilter[] filters = new QFilter[]{schemaFilter};
        DeleteServiceHelper.delete((String)CARD_SCHEMA, (QFilter[])filters);
        DeleteServiceHelper.delete((String)CARD_CONTAINER, (QFilter[])filters);
    }

    @Override
    public void deleteUserCardSchema(long schemaId) {
        QFilter schemaFilter = new QFilter(SCHEMA_ID, "=", (Object)schemaId);
        QFilter[] filters = new QFilter[]{schemaFilter};
        DeleteServiceHelper.delete((String)USER_CARD_SCHEMA, (QFilter[])filters);
    }

    @Override
    public DynamicObject get(long schemaId) {
        QFilter schemaFilter = new QFilter(ID, "=", (Object)schemaId);
        QFilter[] filters = new QFilter[]{schemaFilter};
        return BusinessDataServiceHelper.loadSingle((String)CARD_SCHEMA, (QFilter[])filters);
    }

    @Override
    public DynamicObject[] getCardSchemas(Set<Long> schemaIds) {
        QFilter schemaFilter = new QFilter(ID, "in", schemaIds);
        QFilter[] filters = new QFilter[]{schemaFilter};
        return BusinessDataServiceHelper.load((String)CARD_SCHEMA, (String)"name,creater", (QFilter[])filters, (String)"createdate");
    }

    @Override
    public DynamicObject[] getUserCardSchemas(long userId) {
        QFilter userFilter = new QFilter(USER_ID, "=", (Object)userId);
        QFilter[] filters = new QFilter[]{userFilter};
        return BusinessDataServiceHelper.load((String)USER_CARD_SCHEMA, (String)"userId, schemaId, active", (QFilter[])filters);
    }
}

