/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.cardschema.impl;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.handle.PropertyHandleUtil;
import kd.bos.nocode.restapi.service.cardschema.CardSchemaRepository;
import kd.bos.nocode.restapi.service.cardschema.CardSchemaService;
import kd.bos.nocode.restapi.service.sys.repository.CardRepository;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.ArrayUtils;

public class CardSchemaServiceImpl
implements CardSchemaService {
    private static final String CARD_SCHEMA = "bos_nocode_cardschema";
    private static final String USER_CARD_SCHEMA = "bos_nocode_wuserschema";
    public static final String USER_ID = "userId";
    public static final int DLOCK_TIMEOUT_MILLIS = 30000;
    public static final String OWNER = "owner";
    public static final String CREATER = "creater";
    public static final String NAME = "name";
    public static final String COPY_SCHEMA_ID = "copySchemaId";
    private final CardSchemaRepository cardSchemaRepository;
    private final CardRepository cardRepository;
    public static final String ID = "id";
    public static final String SCHEMA_ID = "schemaId";
    public static final String ACTIVE = "active";
    public static final String CARD_ID = "cardid";
    public static final String PAGE_ID = "pageid";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String W = "w";
    public static final String H = "h";

    private String getDefaultSchemaName() {
        return "\u9ed8\u8ba4\u89c6\u56fe";
    }

    public CardSchemaServiceImpl() {
        this.cardSchemaRepository = CardSchemaRepository.create();
        this.cardRepository = CardRepository.create();
    }

    public CardSchemaServiceImpl(CardSchemaRepository cardSchemaRepository, CardRepository cardRepository) {
        this.cardSchemaRepository = cardSchemaRepository;
        this.cardRepository = cardRepository;
    }

    @Override
    public List<Map<String, Object>> getCardSchemas(long userId) {
        this.createDefaultCardSchemaIfNotExist(userId);
        DynamicObject[] userCardSchemas = this.cardSchemaRepository.getUserCardSchemas(userId);
        Set<Long> schemaIds = Arrays.stream(userCardSchemas).map(e -> (Long)e.get(SCHEMA_ID)).collect(Collectors.toSet());
        DynamicObject[] cardSchemas = this.cardSchemaRepository.getCardSchemas(schemaIds);
        List rows = PropertyHandleUtil.toMapListRoot((String)CARD_SCHEMA, (String)"$", (DynamicObject[])cardSchemas, this.getSchemaSelectSet());
        this.addExtraFields(userId, rows, userCardSchemas);
        this.handleActiveStatus(rows);
        return rows;
    }

    private void handleActiveStatus(List<Map<String, Object>> rows) {
        boolean hasActive = rows.stream().anyMatch(e -> (Boolean)e.get(ACTIVE));
        if (!hasActive) {
            rows.stream().findFirst().ifPresent(e -> e.put(ACTIVE, Boolean.TRUE));
        } else {
            Long activeSchemaId = rows.stream().filter(e -> (Boolean)e.get(ACTIVE)).findFirst().map(e -> (Long)e.get(ID)).orElse(0L);
            if (activeSchemaId != 0L) {
                rows.stream().filter(e -> !((Long)e.get(ID)).equals(activeSchemaId)).forEach(e -> e.put(ACTIVE, Boolean.FALSE));
            }
        }
    }

    private void createDefaultCardSchemaIfNotExist(Long userId) {
        if (!this.existCardSchema(userId)) {
            this.doAddCardSchema(userId, this.getDefaultSchemaName(), Boolean.TRUE);
        }
    }

    private Set<String> getSchemaSelectSet() {
        return Sets.newHashSet((Object[])new String[]{ID, NAME, CREATER});
    }

    private void addExtraFields(long userId, List<Map<String, Object>> rows, DynamicObject[] userCardSchemas) {
        Map id2UserCardSchema = Arrays.stream(userCardSchemas).collect(Collectors.toMap(e -> e.getLong(SCHEMA_ID), Function.identity()));
        for (Map<String, Object> row : rows) {
            long schemaId = (Long)row.get(ID);
            Map creater = (Map)row.get(CREATER);
            DynamicObject userCardSchema = (DynamicObject)id2UserCardSchema.get(schemaId);
            if (!Objects.nonNull(userCardSchema)) continue;
            row.put(ACTIVE, userCardSchema.getBoolean(ACTIVE));
            row.put(OWNER, (Long)creater.get(ID) == userId);
        }
    }

    @Override
    public boolean existCardSchema(long userId) {
        QFilter userFilter = new QFilter(USER_ID, "=", (Object)userId);
        QFilter[] filters = new QFilter[]{userFilter};
        return ORM.create().exists(USER_CARD_SCHEMA, filters);
    }

    @Override
    public boolean existCardSchema(long userId, long schemaId) {
        QFilter userFilter = new QFilter(USER_ID, "=", (Object)userId);
        QFilter schemaFilter = new QFilter(SCHEMA_ID, "=", (Object)schemaId);
        QFilter[] filters = new QFilter[]{userFilter, schemaFilter};
        return ORM.create().exists(USER_CARD_SCHEMA, filters);
    }

    @Override
    public boolean canEdit(long userId, long schemaId) {
        DynamicObject cardSchema = this.cardSchemaRepository.get(schemaId);
        return cardSchema.getDynamicObject(CREATER).getLong(ID) == userId;
    }

    @Override
    public void activate(long userId, long schemaId) {
        DynamicObject[] userCardSchemas;
        boolean existSchema = this.existCardSchema(userId, schemaId);
        if (!existSchema) {
            throw new RestApiException("\u5f53\u524d\u7528\u6237\u65e0\u6cd5\u8bbf\u95ee\u6b64\u89c6\u56fe\uff0cschemaId=%s", new Object[]{schemaId});
        }
        QFilter userFilter = new QFilter(USER_ID, "=", (Object)userId);
        DynamicObject[] dynamicObjectArray = userCardSchemas = BusinessDataServiceHelper.load((String)USER_CARD_SCHEMA, (String)"userId, schemaId, active", (QFilter[])userFilter.toArray());
        int n = dynamicObjectArray.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject userCardSchema;
            long itemSchemaId = (userCardSchema = dynamicObjectArray[i]).getLong(SCHEMA_ID);
            userCardSchema.set(ACTIVE, (Object)(itemSchemaId == schemaId ? 1 : 0));
        }
        SaveServiceHelper.update((DynamicObject[])userCardSchemas);
    }

    private void inactivate(long userId, long schemaId) {
        boolean existSchema = this.existCardSchema(userId, schemaId);
        if (!existSchema) {
            throw new RestApiException("\u5f53\u524d\u7528\u6237\u65e0\u6cd5\u8bbf\u95ee\u6b64\u89c6\u56fe\uff0cschemaId=%s", new Object[]{schemaId});
        }
        QFilter userFilter = new QFilter(USER_ID, "=", (Object)userId);
        QFilter schemaIdFilter = new QFilter(SCHEMA_ID, "=", (Object)schemaId);
        QFilter[] filters = new QFilter[]{userFilter, schemaIdFilter};
        DynamicObject userCardSchema = BusinessDataServiceHelper.loadSingle((String)USER_CARD_SCHEMA, (String)"userId, schemaId, active", (QFilter[])filters);
        userCardSchema.set(ACTIVE, (Object)Boolean.FALSE);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{userCardSchema});
    }

    @Override
    public long getActiveSchemaId(long userId) {
        DynamicObject activeSchema = this.getActiveSchema(userId);
        if (Objects.isNull(activeSchema)) {
            throw new RestApiException("\u5f53\u524d\u6ca1\u6709\u6fc0\u6d3b\u7684\u89c6\u56fe");
        }
        return activeSchema.getLong(SCHEMA_ID);
    }

    private DynamicObject getActiveSchema(long userId) {
        QFilter userFilter = new QFilter(USER_ID, "=", (Object)userId);
        QFilter activeFilter = new QFilter(ACTIVE, "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{userFilter, activeFilter};
        return BusinessDataServiceHelper.loadSingle((String)USER_CARD_SCHEMA, (QFilter[])filters);
    }

    @Override
    public DynamicObject addCardSchema(Map<String, Object> dataItem) {
        long userId = RequestContext.get().getCurrUserId();
        String name = (String)dataItem.get(NAME);
        return this.doAddCardSchema(userId, name, Boolean.FALSE);
    }

    private DynamicObject doAddCardSchema(long userId, String name, boolean isActive) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            DynamicObject cardSchema = this.cardSchemaRepository.add(userId, name);
            long schemaId = cardSchema.getLong(ID);
            this.cardSchemaRepository.addUserCardSchema(userId, schemaId, isActive);
            DynamicObject dynamicObject = cardSchema;
            return dynamicObject;
        }
        catch (Exception e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public DynamicObject updateCardSchema(Map<String, Object> dataItem) {
        String schemaIdStr;
        long schemaId;
        long userId = RequestContext.get().getCurrUserId();
        if (!this.canEdit(userId, schemaId = Long.parseLong(schemaIdStr = (String)dataItem.get(ID)))) {
            throw new RestApiException("\u6ca1\u6709\u6743\u9650\u7f16\u8f91\u6b64\u89c6\u56fe");
        }
        if (dataItem.containsKey(ACTIVE)) {
            boolean active = (Boolean)dataItem.get(ACTIVE);
            if (active) {
                this.activate(userId, schemaId);
            } else {
                this.inactivate(userId, schemaId);
            }
        }
        if (dataItem.containsKey(NAME)) {
            String name = (String)dataItem.get(NAME);
            this.cardSchemaRepository.update(schemaId, name);
        }
        return this.cardSchemaRepository.get(schemaId);
    }

    @Override
    public DynamicObject copyCardSchema(Map<String, Object> dataItem) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            String copySchemaIdStr = (String)dataItem.get(COPY_SCHEMA_ID);
            Long copySchemaId = Long.parseLong(copySchemaIdStr);
            long userId = RequestContext.get().getCurrUserId();
            if (!this.existCardSchema(userId, copySchemaId)) {
                throw new RestApiException("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u590d\u5236\u6b64\u89c6\u56fe\uff0cschemaId=%s", new Object[]{copySchemaId});
            }
            String name = (String)dataItem.get(NAME);
            DynamicObject cardSchema = this.doAddCardSchema(userId, name, Boolean.FALSE);
            long targetSchemaId = cardSchema.getLong(ID);
            this.copyCardInfo(copySchemaId, targetSchemaId);
            DynamicObject dynamicObject = cardSchema;
            return dynamicObject;
        }
        catch (Exception e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private void copyCardInfo(Long sourceSchemaId, Long targetSchemaId) {
        HashSet selectSet = Sets.newHashSet((Object[])new String[]{CARD_ID, X, Y, W, H, SCHEMA_ID});
        String selectProperties = String.join((CharSequence)",", selectSet);
        QFilter sourceSchemaFilter = new QFilter(SCHEMA_ID, "=", (Object)sourceSchemaId);
        QFilter[] filters = new QFilter[]{sourceSchemaFilter};
        Object[] sources = BusinessDataServiceHelper.load((String)"bos_nocode_cardcontainer", (String)selectProperties, (QFilter[])filters);
        if (ArrayUtils.isEmpty((Object[])sources)) {
            return;
        }
        DynamicObject[] targets = (DynamicObject[])Arrays.stream(sources).map(e -> {
            DynamicObject saveObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_cardcontainer");
            saveObj.set(CARD_ID, e.get(CARD_ID));
            saveObj.set(SCHEMA_ID, (Object)targetSchemaId);
            saveObj.set(X, e.get(X));
            saveObj.set(Y, e.get(Y));
            saveObj.set(W, e.get(W));
            saveObj.set(H, e.get(H));
            return saveObj;
        }).toArray(DynamicObject[]::new);
        SaveServiceHelper.save((DynamicObject[])targets);
    }

    @Override
    public void deleteCardSchema(long schemaId) {
        try (TXHandle h = TX.requiresNew();){
            try {
                this.cardSchemaRepository.delete(schemaId);
                this.cardSchemaRepository.deleteUserCardSchema(schemaId);
                this.cardRepository.deleteBySchemaId(schemaId);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }
}

