/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.customimport;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeCreateDateField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeCreatorField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeImageUploadField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeModifierField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeModifyDateField;
import kd.bos.nocode.ext.metadata.form.control.NoCodeImageUploadFieldAp;
import kd.bos.nocode.ext.property.NoCodeCreatorProp;
import kd.bos.nocode.ext.property.NoCodeDateTimeProp;
import kd.bos.nocode.ext.property.NoCodeDecimalProp;
import kd.bos.nocode.ext.property.NoCodeGraphicDisplayProp;
import kd.bos.nocode.ext.property.NoCodeModifierProp;
import kd.bos.nocode.ext.property.NoCodeMulComboProp;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRichTextProp;
import kd.bos.nocode.metadata.IDateFormatSupport;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.api.result.customimportresult.RestApiPropertyConfigResult;
import kd.bos.nocode.restapi.common.util.CollectionUtil;
import kd.bos.nocode.restapi.service.customimport.csv.dto.CsvCellInfo;
import kd.bos.nocode.restapi.service.customimport.csv.dto.CsvDataInfo;
import kd.bos.nocode.restapi.service.customimport.csv.dto.CsvRowInfo;
import kd.bos.nocode.restapi.service.customimport.mapping.CellMappingInformation;
import kd.bos.nocode.restapi.service.customimport.mapping.ExcelRowMappingInformation;
import kd.bos.nocode.restapi.service.customimport.mapping.PictureInformation;
import kd.bos.nocode.restapi.service.util.NoCodeOperationServiceHelper;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.utils.DateTimeUtils;
import kd.bos.nocode.utils.FieldTreeBuilder;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.ShowColumnInfo;
import kd.bos.nocode.utils.URLCodecUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.web.actions.export.ExportSheetStyle;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CustomImportHelper {
    private static final Log log = LogFactory.getLog(CustomImportHelper.class);
    private static final String EXCEL_HEAD = "importHead";
    private static final String EXCEL_ROW = "importRows";
    private static final String ROW_TAG = "rowTag";
    private static final String FIELDTYPE = "fieldType";
    public static final String FORM_CONFIG = "nocode_customimport_form_config_by_";
    private static final String TEMP_LOCAL_DIR = "CUSTOM_IMPORT_TEMPFILE_PATH:";
    public static final String PREVIEW_DATA = "_nocode_preview_data_";
    private static final int MAX_FILE_NAME_LENGTH = 50;
    public static final int FILE_FACTOR = 0x100000;
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("NOCODE_CUSTOM_IMPORT", new DistributeCacheHAPolicy(true, true));
    private static HashMap<String, String> imageTypeMapping = new HashMap();

    public static DistributeSessionlessCache getCache() {
        return cache;
    }

    private CustomImportHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isRefBill(String fieldType) {
        return "refbill".equalsIgnoreCase(fieldType) || "user".equalsIgnoreCase(fieldType) || "org".equalsIgnoreCase(fieldType);
    }

    public static Map<String, List<ExcelRowMappingInformation>> buildImportPreviewData(String formId, String url, Map<String, List<ExcelRowMappingInformation>> previewData, boolean isUpdate, List<String> updateConds, Map<String, Map<String, Object>> config) {
        CustomImportHelper.completeConfig(formId, url, config, previewData);
        CustomImportHelper.checkConfig(config);
        int size = 0;
        if (isUpdate && CollectionUtil.isNotEmpty(updateConds)) {
            QFilter qFilter = CustomImportHelper.createQFilter(updateConds, config, previewData, formId);
            DynamicObject[] alreadyExistBillData = BusinessDataServiceHelper.load((String)formId, (String)("id," + String.join((CharSequence)",", updateConds)), (QFilter[])new QFilter[]{qFilter});
            Map<String, String> rowUpdateBasisMap = CustomImportHelper.getRowUpdateBasis(formId, updateConds, config, alreadyExistBillData);
            for (ExcelRowMappingInformation rowMappingInformation : previewData.get(EXCEL_ROW)) {
                Map<String, CellMappingInformation> cellInfos = rowMappingInformation.getCellInfos();
                StringBuilder curValue = new StringBuilder();
                for (String updateCond : updateConds) {
                    curValue.append(cellInfos.get(config.get(updateCond).get("seq").toString()).getCellValue());
                }
                size = CustomImportHelper.getTagValue(cellInfos);
                if (rowUpdateBasisMap.containsKey(curValue.toString())) {
                    cellInfos.put(ROW_TAG, new CellMappingInformation(String.valueOf(size), ResManager.loadKDString((String)"\u66ff\u6362", (String)"CustomImportHelper_0", (String)"bos-nocode-service", (Object[])new Object[0])));
                    rowMappingInformation.setBillId(rowUpdateBasisMap.get(curValue.toString()));
                    continue;
                }
                cellInfos.put(ROW_TAG, new CellMappingInformation(String.valueOf(size), ResManager.loadKDString((String)"\u65b0\u589e", (String)"CustomImportHelper_1", (String)"bos-nocode-service", (Object[])new Object[0])));
            }
        } else {
            for (ExcelRowMappingInformation rowMappingInformation : previewData.get(EXCEL_ROW)) {
                Map<String, CellMappingInformation> cellInfors = rowMappingInformation.getCellInfos();
                size = CustomImportHelper.getTagValue(cellInfors);
                cellInfors.put(ROW_TAG, new CellMappingInformation(String.valueOf(size), ResManager.loadKDString((String)"\u65b0\u589e", (String)"CustomImportHelper_1", (String)"bos-nocode-service", (Object[])new Object[0])));
            }
        }
        Map<String, CellMappingInformation> headCellInfors = previewData.get(EXCEL_HEAD).get(0).getCellInfos();
        headCellInfors.put(ROW_TAG, new CellMappingInformation(String.valueOf(size), ResManager.loadKDString((String)"\u6807\u7b7e", (String)"CustomImportHelper_2", (String)"bos-nocode-service", (Object[])new Object[0])));
        CustomImportHelper.checkPreviewData(config, previewData.get(EXCEL_ROW), formId);
        return previewData;
    }

    private static int getTagValue(Map<String, CellMappingInformation> cellInfors) {
        int value = 1;
        int count = 0;
        for (CellMappingInformation info : cellInfors.values()) {
            int current = Integer.parseInt(info.getSeq());
            if (current == value) {
                ++count;
            }
            value = Math.max(value, current);
        }
        if (count == 0) {
            ++count;
        }
        return value + count;
    }

    private static void completeConfig(String formId, String url, Map<String, Map<String, Object>> config, Map<String, List<ExcelRowMappingInformation>> previewData) {
        String cacheFormConfigStr = (String)cache.get(url + FORM_CONFIG + formId);
        List<RestApiPropertyConfigResult> perPropConfig = cacheFormConfigStr != null ? SerializationUtils.fromJsonStringToList((String)cacheFormConfigStr, RestApiPropertyConfigResult.class) : CustomImportHelper.buildRestApiPropertyConfigResults(formId, url);
        ExcelRowMappingInformation excelHead = previewData.get(EXCEL_HEAD).get(0);
        CustomImportHelper.resetConfig(config, perPropConfig);
        try {
            Map<String, CellMappingInformation> cellInfors = excelHead.getCellInfos();
            HashMap<String, CellMappingInformation> cellInfoCopy = new HashMap<String, CellMappingInformation>();
            for (Map.Entry<String, CellMappingInformation> map : cellInfors.entrySet()) {
                CellMappingInformation cellInfo = map.getValue();
                String seq = cellInfo.getSeq();
                for (String billFieldId : config.keySet()) {
                    Map<String, Object> fieldMatchConfig = config.get(billFieldId);
                    if (!seq.equals(fieldMatchConfig.get("seq"))) continue;
                    boolean dataAutoOptions = CustomImportHelper.isDataAutoOptions(fieldMatchConfig);
                    cellInfo.setDataAutoOptions(dataAutoOptions);
                    if (null != cellInfo.getBillFieldId()) {
                        CellMappingInformation information = new CellMappingInformation();
                        BeanUtils.copyProperties((Object)information, (Object)cellInfo);
                        information.setCellValue(fieldMatchConfig.get("fieldName").toString());
                        information.setBillFieldId(billFieldId);
                        cellInfoCopy.put(map.getKey() + billFieldId, information);
                        continue;
                    }
                    cellInfo.setCellValue(fieldMatchConfig.get("fieldName").toString());
                    cellInfo.setBillFieldId(billFieldId);
                    cellInfoCopy.put(map.getKey(), cellInfo);
                }
            }
            excelHead.setCellInfos(cellInfoCopy);
        }
        catch (Exception e) {
            log.debug("completeConfig error:", (Object)e);
        }
    }

    public static void resetConfig(Map<String, Map<String, Object>> config, List<RestApiPropertyConfigResult> perPropConfig) {
        for (RestApiPropertyConfigResult restApiPropertyConfigResult : perPropConfig) {
            String fieldId = restApiPropertyConfigResult.getId();
            if (!config.containsKey(fieldId)) continue;
            config.get(fieldId).put("fieldName", restApiPropertyConfigResult.getName());
            config.get(fieldId).put(FIELDTYPE, restApiPropertyConfigResult.getFieldType());
            config.get(fieldId).put("formatType", restApiPropertyConfigResult.getConfig().get("formatType"));
        }
    }

    public static List<RestApiPropertyConfigResult> buildRestApiPropertyConfigResults(String formId, String url) {
        Map directFields = ListConfigUtils.getDirectFields((String)formId);
        LinkedList<RestApiPropertyConfigResult> perpropConfig = new LinkedList<RestApiPropertyConfigResult>();
        for (IDataEntityProperty prop : directFields.values()) {
            if (prop instanceof EntryProp) continue;
            LocaleString name = prop.getDisplayName();
            String id = prop.getName();
            String dataType = CustomImportHelper.getDataType(prop);
            RestApiPropertyConfigResult restApiPropertyConfigResult = new RestApiPropertyConfigResult();
            restApiPropertyConfigResult.setId(id);
            restApiPropertyConfigResult.setName(name.toString());
            restApiPropertyConfigResult.setFieldType(dataType);
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("isMulti", false);
            if (prop instanceof NoCodeRefBillProp || prop instanceof NoCodeMulRefBillProp) {
                List<Map<String, String>> fieldItems = CustomImportHelper.getFieldItems(prop);
                config.put("fieldItems", fieldItems.toArray());
                Object showType = ((DynamicProperty)prop).getCustomProperty("showType");
                config.put("showType", showType);
            }
            if (prop instanceof NoCodeMulComboProp || prop instanceof NoCodeMulRefBillProp && ((NoCodeMulRefBillProp)prop).isMultiSelect()) {
                config.put("isMulti", true);
            }
            if (prop instanceof IDateFormatSupport) {
                config.put("formatType", ((IDateFormatSupport)prop).getFormatType());
            }
            restApiPropertyConfigResult.setConfig(config);
            perpropConfig.add(restApiPropertyConfigResult);
        }
        cache.put(url + FORM_CONFIG + formId, (Object)SerializationUtils.toJsonString(perpropConfig), 1, TimeUnit.HOURS);
        return perpropConfig;
    }

    public static String getDataType(IDataEntityProperty prop) {
        String dataType = NcEntityTypeUtil.getDataType((IDataEntityProperty)prop);
        if (prop instanceof ComboProp) {
            dataType = dataType.split("-")[0];
        }
        if (prop instanceof NoCodeRichTextProp) {
            dataType = "richText";
        }
        if (prop instanceof NoCodeGraphicDisplayProp) {
            dataType = "graphicDisplay";
        }
        return dataType;
    }

    private static List<Map<String, String>> getFieldItems(IDataEntityProperty prop) {
        LinkedList<Map<String, String>> fieldItems = new LinkedList<Map<String, String>>();
        FieldTreeBuilder fieldTreeBuilder = new FieldTreeBuilder(((INoCodeRefBillProp)prop).getBillEntityNumber());
        List showColumns = fieldTreeBuilder.build();
        for (ShowColumnInfo showColumn : showColumns) {
            LinkedHashMap<String, String> fieldItem = new LinkedHashMap<String, String>();
            String id = showColumn.getId();
            String name = showColumn.getCaption();
            fieldItem.put("id", id);
            fieldItem.put("name", name);
            fieldItems.add(fieldItem);
        }
        return fieldItems;
    }

    public static void checkConfig(Map<String, Map<String, Object>> config) {
        for (Map<String, Object> fieldMatchConfig : config.values()) {
            String fieldType = fieldMatchConfig.get(FIELDTYPE).toString();
            if (!CustomImportHelper.isRefBill(fieldType) || !StringUtils.isBlank((Object)fieldMatchConfig.get("billMatchCond"))) continue;
            throw new KDBizException(fieldMatchConfig.get("fieldName") + ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5339\u914d\u5185\u5bb9\u3002", (String)"CustomImportHelper_3", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
    }

    private static QFilter createQFilter(List<String> updateConds, Map<String, Map<String, Object>> config, Map<String, List<ExcelRowMappingInformation>> previewData, String formId) {
        QFilter qFilter = null;
        for (String updateCond : updateConds) {
            if (!config.containsKey(updateCond)) continue;
            Map<String, Object> fieldMatchConfig = config.get(updateCond);
            String seq = fieldMatchConfig.get("seq").toString();
            List<ExcelRowMappingInformation> rowLists = previewData.get(EXCEL_ROW);
            HashSet<String> fieldValues = new HashSet<String>(rowLists.size());
            for (ExcelRowMappingInformation rowMappingInformation : rowLists) {
                Map<String, CellMappingInformation> cellInfors = rowMappingInformation.getCellInfos();
                fieldValues.add(cellInfors.get(seq).getCellValue());
            }
            qFilter = CustomImportHelper.getFilter(qFilter, fieldMatchConfig, formId, updateCond, fieldValues);
        }
        return qFilter;
    }

    public static QFilter createQFilterForCsv(List<String> updateConds, Map<String, Map<String, Object>> config, CsvDataInfo previewData, String formId) {
        QFilter qFilter = null;
        for (String updateCond : updateConds) {
            if (!config.containsKey(updateCond)) continue;
            Map<String, Object> fieldMatchConfig = config.get(updateCond);
            String seq = fieldMatchConfig.get("seq").toString();
            List<CsvRowInfo> csvRowsList = previewData.getImportRows();
            HashSet<String> fieldValues = new HashSet<String>(csvRowsList.size());
            for (CsvRowInfo csvRowInfo : csvRowsList) {
                List<CsvCellInfo> curRowInfo = csvRowInfo.getCellInfos();
                fieldValues.add(curRowInfo.get(Integer.parseInt(seq)).getCellValue());
            }
            qFilter = CustomImportHelper.getFilter(qFilter, fieldMatchConfig, formId, updateCond, fieldValues);
        }
        return qFilter;
    }

    private static QFilter getFilter(QFilter qFilter, Map<String, Object> fieldMatchConfig, String formId, String updateCond, Set<String> fieldValues) {
        QFilter refBillFilter = null;
        String fieldType = fieldMatchConfig.get(FIELDTYPE).toString();
        if (CustomImportHelper.isRefBill(fieldType)) {
            refBillFilter = CustomImportHelper.buildRefBillPropNcFilter((IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)formId).getProperty(updateCond), updateCond, fieldMatchConfig.get("billMatchCond").toString(), fieldValues);
        } else if ("combo".equalsIgnoreCase(fieldType)) {
            refBillFilter = CustomImportHelper.buildComboPropNcFilter(formId, updateCond, fieldMatchConfig.get("split").toString(), fieldValues);
        } else if ("date".equalsIgnoreCase(fieldType)) {
            refBillFilter = CustomImportHelper.buildDateFilter(updateCond, fieldValues);
        } else if ("number".equalsIgnoreCase(fieldType)) {
            refBillFilter = CustomImportHelper.buildNumberFilter(updateCond, fieldValues);
        }
        if (qFilter != null && refBillFilter == null) {
            qFilter.and(updateCond, "in", fieldValues);
        } else if (qFilter != null) {
            qFilter.and(refBillFilter);
        } else {
            qFilter = refBillFilter != null ? refBillFilter : new QFilter(updateCond, "in", fieldValues);
        }
        return qFilter;
    }

    private static QFilter buildRefBillPropNcFilter(IDataEntityProperty property, String field, String billMatchCond, Set<String> values) {
        LinkedHashSet<Object> ids;
        block3: {
            Map refObjs;
            INoCodeRefBillProp fieldProp;
            block2: {
                fieldProp = (INoCodeRefBillProp)property;
                MainEntityType refBillType = EntityMetadataCache.getDataEntityType((String)fieldProp.getBillEntityNumber());
                refObjs = BusinessDataServiceHelper.loadFromCache((String)refBillType.getName(), (String)"id", (QFilter[])new QFilter[]{new QFilter(billMatchCond, "in", values)});
                ids = new LinkedHashSet<Object>(refObjs.size());
                if (!(fieldProp instanceof NoCodeMulRefBillProp)) break block2;
                for (DynamicObject refObj : refObjs.values()) {
                    ids.add(refObj.getString("id"));
                }
                break block3;
            }
            if (!(fieldProp instanceof NoCodeRefBillProp)) break block3;
            for (DynamicObject refObj : refObjs.values()) {
                ids.add(refObj.getLong("id"));
            }
        }
        return new QFilter(field, "in", ids);
    }

    private static QFilter buildComboPropNcFilter(String formId, String billFieldId, String split, Set<String> fieldValues) {
        Map<String, String> selectValues = CustomImportHelper.getSelectValues(formId, billFieldId);
        HashSet<String> needFilterComboValues = new HashSet<String>(fieldValues.size());
        for (String fieldValue : fieldValues) {
            String[] comboValues = null;
            comboValues = StringUtils.isBlank((CharSequence)split) ? new String[]{fieldValue} : fieldValue.split(CustomImportHelper.quoteReplacement(split));
            LinkedHashSet<String> oneComboFieldValue = new LinkedHashSet<String>();
            for (String comboValue : comboValues) {
                if (!selectValues.containsKey(comboValue)) continue;
                oneComboFieldValue.add(selectValues.get(comboValue));
            }
            needFilterComboValues.add(String.join((CharSequence)",", oneComboFieldValue));
        }
        return new QFilter(billFieldId, "in", needFilterComboValues);
    }

    private static QFilter buildNumberFilter(String updateCond, Set<String> fieldValues) {
        LinkedHashSet<BigDecimal> filterSet = new LinkedHashSet<BigDecimal>(fieldValues.size());
        for (String fieldValue : fieldValues) {
            filterSet.add(new BigDecimal(fieldValue));
        }
        return new QFilter(updateCond, "in", filterSet);
    }

    private static QFilter buildDateFilter(String updateCond, Set<String> fieldValues) {
        try {
            LinkedHashSet<Date> filterSet = new LinkedHashSet<Date>(fieldValues.size());
            for (String fieldValue : fieldValues) {
                filterSet.add(DateTimeUtils.loopParse((String)fieldValue));
            }
            return new QFilter(updateCond, "in", filterSet);
        }
        catch (Exception e) {
            log.debug("buildDateFilter failed", (Object)e);
            return null;
        }
    }

    public static Map<String, String> getSelectValues(String formId, String billFieldId) {
        List selectItems = NcEntityTypeUtil.getSelectItems((String)formId, (String)billFieldId);
        HashMap<String, String> selectValues = new HashMap<String, String>(selectItems.size());
        for (ValueMapItem selectItem : selectItems) {
            selectValues.put(selectItem.getName().getLocaleValue(), selectItem.getValue());
        }
        return selectValues;
    }

    public static Map<String, String> getRowUpdateBasis(String formId, List<String> updateConds, Map<String, Map<String, Object>> config, DynamicObject[] alreadyExistBillData) {
        HashMap<String, String> rowUpdateBasisMap = new HashMap<String, String>((int)Arrays.stream(alreadyExistBillData).count());
        for (DynamicObject alreadyExistBillDatum : alreadyExistBillData) {
            StringBuilder curValue = new StringBuilder();
            for (String updateCond : updateConds) {
                Object obj = alreadyExistBillDatum.get(updateCond);
                String idStr = obj instanceof DynamicObject ? ((DynamicObject)obj).getString("id") : (obj instanceof BigDecimal ? CustomImportHelper.dealBigDecimal((BigDecimal)obj) : alreadyExistBillDatum.getString(updateCond));
                if (StringUtils.isBlank((CharSequence)idStr)) continue;
                StringBuilder fieldValue = new StringBuilder(idStr);
                Map<String, Object> fieldMatchConfig = config.get(updateCond);
                String fieldType = fieldMatchConfig.get(FIELDTYPE).toString();
                if (CustomImportHelper.isRefBill(fieldType)) {
                    INoCodeRefBillProp refBillProp = (INoCodeRefBillProp)alreadyExistBillDatum.getDynamicObjectType().getProperty(updateCond);
                    String refBillEntityNumber = refBillProp.getBillEntityNumber();
                    String billMatchCond = fieldMatchConfig.get("billMatchCond").toString();
                    Map refBillDyns = BusinessDataServiceHelper.loadFromCache((String)refBillEntityNumber, (String)billMatchCond, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)fieldValue.toString())});
                    fieldValue = new StringBuilder();
                    for (DynamicObject refBillDyn : refBillDyns.values()) {
                        fieldValue.append(refBillDyn.getString(billMatchCond));
                    }
                } else if ("combo".equalsIgnoreCase(fieldType)) {
                    String split = fieldMatchConfig.get("split").toString();
                    Map<String, String> selectValues = CustomImportHelper.getSelectValues(formId, updateCond);
                    String[] comboValues = fieldValue.toString().split(",");
                    LinkedHashSet<String> showComboValues = new LinkedHashSet<String>(comboValues.length);
                    for (String comboValue : comboValues) {
                        for (String showComboValue : selectValues.keySet()) {
                            if (!selectValues.get(showComboValue).equals(comboValue)) continue;
                            showComboValues.add(showComboValue);
                        }
                    }
                    fieldValue = new StringBuilder(String.join((CharSequence)split, showComboValues));
                }
                curValue.append((CharSequence)fieldValue);
            }
            String id = alreadyExistBillDatum.getString("id");
            rowUpdateBasisMap.put(curValue.toString(), id);
        }
        return rowUpdateBasisMap;
    }

    public static String dealBigDecimal(BigDecimal number) {
        BigDecimal noZeros = number.stripTrailingZeros();
        return noZeros.toPlainString();
    }

    private static void checkPreviewData(Map<String, Map<String, Object>> config, List<ExcelRowMappingInformation> previewRowDatas, String formId) {
        for (ExcelRowMappingInformation previewRowData : previewRowDatas) {
            Map<String, CellMappingInformation> cellInfors = previewRowData.getCellInfos();
            boolean isRowError = false;
            for (String billFieldId : config.keySet()) {
                String fieldType;
                Map<String, Object> fieldMatchConfig = config.get(billFieldId);
                String colSeq = fieldMatchConfig.get("seq").toString();
                CellMappingInformation cellMappingInformation = cellInfors.get(colSeq);
                String cellValue = cellMappingInformation.getCellValue();
                boolean isDataAutoCollect = CustomImportHelper.isDataAutoOptions(fieldMatchConfig);
                cellMappingInformation.setDataAutoOptions(isDataAutoCollect);
                if (!"image".equals(fieldMatchConfig.get(FIELDTYPE)) && (isRowError = CustomImportHelper.checkNotButExistImage(cellInfors, cellMappingInformation, cellValue))) {
                    previewRowData.setError(true);
                    continue;
                }
                if ("image".equals(fieldMatchConfig.get(FIELDTYPE))) {
                    isRowError = CustomImportHelper.checkImage(formId, billFieldId, cellInfors, cellMappingInformation, cellValue);
                    if (!isRowError) continue;
                    previewRowData.setError(true);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)cellValue) || "text".equalsIgnoreCase(fieldType = fieldMatchConfig.get(FIELDTYPE).toString()) || "unknown".equalsIgnoreCase(fieldType)) continue;
                if ("date".equalsIgnoreCase(fieldType)) {
                    isRowError = CustomImportHelper.checkDateFormat(cellInfors, fieldMatchConfig, cellMappingInformation, cellValue) || isRowError;
                    if (!isRowError) continue;
                    previewRowData.setError(true);
                    continue;
                }
                if ("number".equalsIgnoreCase(fieldType)) {
                    isRowError = CustomImportHelper.checkNumberFormat(formId, billFieldId, cellInfors, cellMappingInformation, cellValue) || isRowError;
                    if (!isRowError) continue;
                    previewRowData.setError(true);
                    continue;
                }
                if (CustomImportHelper.isRefBill(fieldType)) {
                    isRowError = CustomImportHelper.checkRefBill(formId, cellInfors, billFieldId, fieldMatchConfig, cellMappingInformation, cellValue) || isRowError;
                    if (!isRowError) continue;
                    previewRowData.setError(true);
                    continue;
                }
                if (!"combo".equalsIgnoreCase(fieldType) || !(isRowError = CustomImportHelper.checkCombo(formId, cellInfors, billFieldId, fieldMatchConfig, cellMappingInformation, cellValue, isDataAutoCollect) || isRowError)) continue;
                previewRowData.setError(true);
            }
        }
    }

    public static boolean isDataAutoOptions(Map<String, Object> fieldMatchConfig) {
        Object dataAutoOptions = fieldMatchConfig.get("dataAutoOptions");
        return Objects.nonNull(dataAutoOptions) && (Boolean)dataAutoOptions != false;
    }

    private static boolean checkCombo(String formId, Map<String, CellMappingInformation> cellInfors, String billFieldId, Map<String, Object> fieldMatchConfig, CellMappingInformation cellMappingInformation, String cellValue, boolean isDataAutoCollect) {
        boolean isCellError = false;
        String split = "";
        if (fieldMatchConfig.get("split") != null) {
            split = fieldMatchConfig.get("split").toString();
        }
        Map<String, String> selectValues = CustomImportHelper.getSelectValues(formId, billFieldId);
        String[] comboValues = null;
        comboValues = split == null || split.equalsIgnoreCase("") ? new String[]{cellValue} : cellValue.split(CustomImportHelper.quoteReplacement(split));
        HashSet<String> existSelectVals = new HashSet<String>();
        for (String comboValue : comboValues) {
            if (!selectValues.containsKey(comboValue)) {
                if (!isDataAutoCollect) {
                    String cellErrMsg = ResManager.loadKDString((String)"\u9009\u9879\u4e0d\u5b58\u5728", (String)"CustomImportHelper_4", (String)"bos-nocode-service", (Object[])new Object[0]);
                    CustomImportHelper.buildCellErrMsg(cellInfors, cellMappingInformation, cellErrMsg);
                    isCellError = true;
                    continue;
                }
                try {
                    existSelectVals.add(URLCodecUtils.encode((String)comboValue));
                }
                catch (Exception e) {
                    existSelectVals.add(comboValue);
                }
                continue;
            }
            existSelectVals.add(selectValues.get(comboValue));
        }
        cellMappingInformation.setSelectValue(String.join((CharSequence)",", existSelectVals));
        cellMappingInformation.setDataAutoOptions(isDataAutoCollect);
        return isCellError;
    }

    public static String quoteReplacement(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '$' || c == '.' || c == '|' || c == ' ' || c == '?') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean checkRefBill(String formId, Map<String, CellMappingInformation> cellInfors, String billFieldId, Map<String, Object> fieldMatchConfig, CellMappingInformation cellMappingInformation, String cellValue) {
        boolean isCellError = false;
        String billMatchCond = fieldMatchConfig.get("billMatchCond").toString();
        String split = "";
        if (fieldMatchConfig.get("split") != null) {
            split = fieldMatchConfig.get("split").toString();
        }
        String[] values = null;
        values = StringUtils.isBlank((CharSequence)split) ? new String[]{cellValue} : cellValue.split(CustomImportHelper.quoteReplacement(split));
        INoCodeRefBillProp property = (INoCodeRefBillProp)EntityMetadataCache.getDataEntityType((String)formId).getProperty(billFieldId);
        String billEntityNumber = property.getBillEntityNumber();
        Object[] condition = CustomImportHelper.transQueryCondition(fieldMatchConfig, billMatchCond, values);
        Map refBillMap = condition.length == 0 ? new HashMap() : BusinessDataServiceHelper.loadFromCache((String)billEntityNumber, (String)("id," + billMatchCond), (QFilter[])new QFilter[]{new QFilter(billMatchCond, "in", (Object)condition)});
        HashMap<String, String> refBillValues = new HashMap<String, String>(refBillMap.size());
        for (Map.Entry refBill : refBillMap.entrySet()) {
            Object dataBaseValue = ((DynamicObject)refBill.getValue()).get(billMatchCond);
            if (dataBaseValue instanceof BigDecimal) {
                refBillValues.put(CustomImportHelper.dealBigDecimal((BigDecimal)dataBaseValue), refBill.getKey().toString());
                continue;
            }
            refBillValues.put(((DynamicObject)refBill.getValue()).getString(billMatchCond), refBill.getKey().toString());
        }
        LinkedHashSet refBillIds = new LinkedHashSet();
        for (String refBillValue : values) {
            if (!refBillValues.containsKey(refBillValue)) {
                String cellErrMsg = ResManager.loadKDString((String)"\u5173\u8054\u8868\u5355\u4e0d\u5b58\u5728", (String)"CustomImportHelper_5", (String)"bos-nocode-service", (Object[])new Object[0]);
                CustomImportHelper.buildCellErrMsg(cellInfors, cellMappingInformation, cellErrMsg);
                isCellError = true;
                break;
            }
            refBillIds.add(refBillValues.get(refBillValue));
        }
        if (refBillIds.size() <= values.length) {
            cellMappingInformation.setRefBillId(String.join((CharSequence)",", refBillIds));
        }
        return isCellError;
    }

    public static Object[] transQueryCondition(Map<String, Object> fieldMatchConfig, String billMatchCond, String[] values) {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (NoCodeCreateDateField.class.getSimpleName().equalsIgnoreCase(billMatchCond) || NoCodeModifyDateField.class.getSimpleName().equalsIgnoreCase(billMatchCond)) {
            for (String value : values) {
                try {
                    Date date = DateTimeUtils.loopParse((String)value);
                    objects.add(date);
                }
                catch (Exception e) {
                    log.debug("matched value not date");
                }
            }
            return objects.toArray();
        }
        if (NoCodeCreatorField.class.getSimpleName().equalsIgnoreCase(billMatchCond) || NoCodeModifierField.class.getSimpleName().equalsIgnoreCase(billMatchCond)) {
            for (String value : values) {
                try {
                    Long id = Long.parseLong(value);
                    objects.add(id);
                }
                catch (Exception e) {
                    log.debug("matched value not long value");
                }
            }
            return objects.toArray();
        }
        if (null != fieldMatchConfig.get("billEntityIdEx")) {
            String refBillFormId = fieldMatchConfig.get("billEntityIdEx").toString();
            IDataEntityProperty iDataEntityProperty = NcEntityTypeUtil.findProperty((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)refBillFormId), (String)billMatchCond);
            if (iDataEntityProperty instanceof NoCodeDecimalProp) {
                for (String value : values) {
                    try {
                        BigDecimal decimal = new BigDecimal(value);
                        objects.add(decimal);
                    }
                    catch (Exception e) {
                        log.debug("ref field value not BigDecimal");
                    }
                }
            } else if (iDataEntityProperty instanceof NoCodeDateTimeProp) {
                for (String value : values) {
                    try {
                        Date date = DateTimeUtils.loopParse((String)value);
                        objects.add(date);
                    }
                    catch (Exception e) {
                        log.debug("ref field value not Date");
                    }
                }
            } else {
                for (String value : values) {
                    objects.add(value);
                }
            }
            return objects.toArray();
        }
        return values;
    }

    private static boolean checkNumberFormat(String formId, String billFieldId, Map<String, CellMappingInformation> cellInfors, CellMappingInformation cellMappingInformation, String cellValue) {
        boolean isCellError = false;
        String cellErrMsg = "";
        try {
            new BigDecimal(cellValue);
        }
        catch (NumberFormatException e) {
            cellErrMsg = ResManager.loadKDString((String)"\u6570\u503c\u683c\u5f0f\u9519\u8bef", (String)"CustomImportHelper_6", (String)"bos-nocode-service", (Object[])new Object[0]);
            CustomImportHelper.buildCellErrMsg(cellInfors, cellMappingInformation, cellErrMsg);
            isCellError = true;
        }
        if (StringUtils.isBlank((CharSequence)cellErrMsg)) {
            DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)formId).getProperties();
            IDataEntityProperty prop = (IDataEntityProperty)properties.get((Object)billFieldId);
            BigDecimal decimal = new BigDecimal(cellValue);
            int integerCheck = decimal.precision() - decimal.scale();
            int precision = ((NoCodeDecimalProp)prop).getPrecision();
            int decimalCheck = decimal.scale();
            int scale = ((NoCodeDecimalProp)prop).getScale();
            if (integerCheck > precision || decimalCheck > scale) {
                cellErrMsg = ResManager.loadKDString((String)"\u7cbe\u5ea6\u8d85\u51fa\u9650\u5236", (String)"CustomImportHelper_7", (String)"bos-nocode-service", (Object[])new Object[0]);
                CustomImportHelper.buildCellErrMsg(cellInfors, cellMappingInformation, cellErrMsg);
                isCellError = true;
            }
        }
        return isCellError;
    }

    private static boolean checkImage(String formId, String billFieldId, Map<String, CellMappingInformation> cellInfos, CellMappingInformation cellMappingInformation, String cellValue) {
        boolean isCellError = false;
        Set<PictureInformation> pictureInfomations = cellMappingInformation.getPictureInformations();
        if (StringUtils.isNotBlank((CharSequence)cellValue) && CollectionUtil.isEmpty(pictureInfomations)) {
            String cellErrMsg = ResManager.loadKDString((String)"\u56fe\u7247\u683c\u5f0f\u9519\u8bef", (String)"CustomImportHelper_8", (String)"bos-nocode-service", (Object[])new Object[0]);
            CustomImportHelper.buildCellErrMsg(cellInfos, cellMappingInformation, cellErrMsg);
            isCellError = true;
        } else if (CollectionUtil.isNotEmpty(pictureInfomations)) {
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Entity);
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
            List entityItems = entityMetadata.getItems();
            for (EntityItem item : entityItems) {
                if (!(item instanceof NoCodeImageUploadField) || !billFieldId.equals(item.getKey())) continue;
                String allowFileType = ((NoCodeImageUploadField)item).getImageFileType();
                for (PictureInformation pictureInformation : pictureInfomations) {
                    String fileName = pictureInformation.getName();
                    String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
                    String fileEnum = imageTypeMapping.get(fileType.toLowerCase(Locale.ENGLISH));
                    if (fileEnum == null || !allowFileType.contains(fileEnum)) {
                        String cellErrMsg = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4e0a\u4f20\u8be5\u56fe\u7247\u7c7b\u578b\uff1a", (String)"CustomImportHelper_9", (String)"bos-nocode-service", (Object[])new Object[0]) + fileType;
                        CustomImportHelper.buildCellErrMsg(cellInfos, cellMappingInformation, cellErrMsg);
                        return true;
                    }
                    int maxSize = ((NoCodeImageUploadField)item).getMaxImgSize();
                    ControlAp apItem = formMetadata.getItem(item.getId());
                    if (apItem instanceof NoCodeImageUploadFieldAp) {
                        NoCodeImageUploadFieldAp noCodeImageUploadFieldAp = (NoCodeImageUploadFieldAp)apItem;
                        maxSize = Integer.parseInt(noCodeImageUploadFieldAp.getFileMaxSize());
                    }
                    if (maxSize == 0) continue;
                    long maxFileSize = (long)maxSize * 0x100000L;
                    if ((long)pictureInformation.getSize() <= maxFileSize) continue;
                    String cellErrMsg = ResManager.loadKDString((String)"\u56fe\u7247\u5927\u5c0f\u8d85\u8fc7\u9650\u5236", (String)"CustomImportHelper_10", (String)"bos-nocode-service", (Object[])new Object[0]);
                    CustomImportHelper.buildCellErrMsg(cellInfos, cellMappingInformation, cellErrMsg);
                    return true;
                }
            }
        }
        return isCellError;
    }

    private static boolean checkNotButExistImage(Map<String, CellMappingInformation> cellInfos, CellMappingInformation cellMappingInformation, String cellValue) {
        boolean isCellError = false;
        Set<PictureInformation> pictureInfomations = cellMappingInformation.getPictureInformations();
        if (StringUtils.isBlank((CharSequence)cellValue) && CollectionUtil.isNotEmpty(pictureInfomations)) {
            String cellErrMsg = ResManager.loadKDString((String)"\u975e\u56fe\u7247\u5b57\u6bb5\uff0c\u4e0d\u80fd\u5bfc\u5165\u56fe\u7247", (String)"CustomImportHelper_11", (String)"bos-nocode-service", (Object[])new Object[0]);
            CustomImportHelper.buildCellErrMsg(cellInfos, cellMappingInformation, cellErrMsg);
            isCellError = true;
        }
        return isCellError;
    }

    private static boolean checkDateFormat(Map<String, CellMappingInformation> cellInfors, Map<String, Object> fieldMatchConfig, CellMappingInformation cellMappingInformation, String cellValue) {
        boolean isCellError = false;
        try {
            Date date = DateTimeUtils.loopParse((String)cellValue);
            String formatString = DateTimeUtils.getFormatString((String)((String)fieldMatchConfig.get("formatType")));
            String dateStr = new SimpleDateFormat(formatString).format(date);
            cellMappingInformation.setCellValue(dateStr);
        }
        catch (Exception e) {
            String cellErrMsg = ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef", (String)"CustomImportHelper_12", (String)"bos-nocode-service", (Object[])new Object[0]);
            CustomImportHelper.buildCellErrMsg(cellInfors, cellMappingInformation, cellErrMsg);
            isCellError = true;
        }
        return isCellError;
    }

    private static void buildCellErrMsg(Map<String, CellMappingInformation> cellInfors, CellMappingInformation cellMappingInformation, String cellErrMsg) {
        cellMappingInformation.setError(true);
        cellMappingInformation.setErrMessage(cellErrMsg);
        cellInfors.get(ROW_TAG).setCellValue(ResManager.loadKDString((String)"\u9519\u8bef", (String)"CustomImportHelper_13", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    public static OperationResult saveData(List<DynamicObject> billObjs, String formId, String appId) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("importtype", "new");
        option.setVariableValue("autogeneratebillno", String.valueOf(true));
        option.setVariableValue("currbizappid", appId);
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("batchImport", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("importtag_of_datasource", String.valueOf(true));
        return NoCodeOperationServiceHelper.executeOperate("save", formId, billObjs.toArray(new DynamicObject[0]), option);
    }

    public static List<DynamicObject> convertDataToDynamicObject(Map<String, List<ExcelRowMappingInformation>> importData, String formId) {
        LinkedList<DynamicObject> billObjs = new LinkedList<DynamicObject>();
        Map<String, CellMappingInformation> fieldMapping = importData.get(EXCEL_HEAD).get(0).getCellInfos();
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)formId).getProperties();
        for (ExcelRowMappingInformation rowData : importData.get(EXCEL_ROW)) {
            String billId = rowData.getBillId();
            DynamicObject dyObj = StringUtils.isNotBlank((CharSequence)billId) ? BusinessDataServiceHelper.loadSingle((Object)billId, (String)formId) : BusinessDataServiceHelper.newDynamicObject((String)formId);
            for (CellMappingInformation fieldData : rowData.getCellInfos().values()) {
                ArrayList<String> sameCellMappingId = new ArrayList<String>();
                for (CellMappingInformation cellMappingInformation : fieldMapping.values()) {
                    if (!StringUtils.equals((CharSequence)cellMappingInformation.getSeq(), (CharSequence)fieldData.getSeq())) continue;
                    sameCellMappingId.add(cellMappingInformation.getBillFieldId());
                }
                if (CollectionUtil.isEmpty(sameCellMappingId)) continue;
                for (String billFieldId : sameCellMappingId) {
                    if (StringUtils.isBlank((CharSequence)billFieldId)) continue;
                    IDataEntityProperty prop = (IDataEntityProperty)properties.get((Object)billFieldId);
                    String fieldType = CustomImportHelper.getDataType(prop);
                    String fieldValue = fieldData.getCellValue();
                    if (CustomImportHelper.isRefBill(fieldType)) {
                        String refBillId = fieldData.getRefBillId();
                        dyObj.set(billFieldId, (Object)refBillId);
                        continue;
                    }
                    if ("date".equalsIgnoreCase(fieldType)) {
                        try {
                            Date date = DateTimeUtils.loopParse((String)fieldValue);
                            dyObj.set(billFieldId, (Object)date);
                        }
                        catch (Exception e) {
                            log.warn((Throwable)e);
                        }
                        continue;
                    }
                    if ("combo".equalsIgnoreCase(fieldType)) {
                        String selectValue = fieldData.getSelectValue();
                        dyObj.set(billFieldId, (Object)selectValue);
                        continue;
                    }
                    if ("image".equalsIgnoreCase(fieldType)) {
                        Set<PictureInformation> pictureInformations = fieldData.getPictureInformations();
                        Date nowDate = new Date();
                        for (PictureInformation pictureInformation : pictureInformations) {
                            pictureInformation.setCurCol(null);
                            pictureInformation.setCurRow(null);
                            pictureInformation.setUploadTime(String.valueOf(nowDate.getTime()));
                        }
                        String str = SerializationUtils.toJsonString(pictureInformations);
                        dyObj.set(billFieldId, (Object)str);
                        continue;
                    }
                    if (prop instanceof NoCodeDecimalProp && StringUtils.isBlank((CharSequence)fieldValue)) {
                        dyObj.set(billFieldId, null);
                        continue;
                    }
                    dyObj.set(billFieldId, (Object)fieldValue);
                }
            }
            for (IDataEntityProperty property : properties) {
                if (!(property instanceof NoCodeCreatorProp) && !(property instanceof NoCodeModifierProp) || null != dyObj.get(property.getName())) continue;
                dyObj.set(property.getName(), (Object)RequestContext.get().getCurrUserId());
            }
            billObjs.add(dyObj);
        }
        return billObjs;
    }

    public static void clearCache(String formId, String url, String sheetName, int row, int col) {
        try {
            File tempFile;
            String tempFilePath = (String)cache.get(TEMP_LOCAL_DIR + url);
            if (StringUtils.isNotBlank((CharSequence)tempFilePath) && (tempFile = FileUtils.getFile((String[])new String[]{tempFilePath})) != null && tempFile.exists()) {
                Files.delete(tempFile.toPath());
            }
        }
        catch (IOException e) {
            log.warn((Throwable)e);
        }
        cache.remove(TEMP_LOCAL_DIR + url);
        cache.remove(url + PREVIEW_DATA + sheetName + "_row_" + (row - 1) + "_col_" + (col - 1));
        cache.remove(FORM_CONFIG + formId);
    }

    public static String buildErrorReport(Map<String, List<ExcelRowMappingInformation>> importData, OperationResult operationResult, String sheetName, String formId) {
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        List<ExcelRowMappingInformation> rowMappingInformations = importData.get(EXCEL_ROW);
        LinkedList<ExcelRowMappingInformation> errorRowMappingInformations = new LinkedList<ExcelRowMappingInformation>();
        for (IOperateInfo errorInfo : allErrorOrValidateInfo) {
            int dataEntityIndex = ((OperateErrorInfo)errorInfo).getDataEntityIndex();
            String errMessage = errorInfo.getMessage();
            int index = rowMappingInformations.size() - 1 - dataEntityIndex;
            if (index < 0 || index >= rowMappingInformations.size()) continue;
            ExcelRowMappingInformation curErrorRow = rowMappingInformations.get(index);
            if (StringUtils.isNotBlank((CharSequence)curErrorRow.getRowErrMsg())) {
                errMessage = curErrorRow.getRowErrMsg() + System.lineSeparator() + errMessage;
            } else {
                errorRowMappingInformations.add(curErrorRow);
            }
            curErrorRow.setRowErrMsg(errMessage);
        }
        return CustomImportHelper.buildExcel(importData.get(EXCEL_HEAD).get(0), errorRowMappingInformations, sheetName, formId);
    }

    private static String buildExcel(ExcelRowMappingInformation headFieldInformations, List<ExcelRowMappingInformation> errorRowMappingInformations, String sheetName, String formId) {
        SXSSFWorkbook wb = new SXSSFWorkbook(5000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet(sheetName);
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        ArrayList<String> keyList = new ArrayList<String>(headFieldInformations.getCellInfos().size());
        for (Map.Entry<String, CellMappingInformation> entry : headFieldInformations.getCellInfos().entrySet()) {
            keyList.add(entry.getKey());
        }
        CustomImportHelper.writeHead(wb, sheet, styles, headFieldInformations);
        CustomImportHelper.writeRowData(wb, sheet, styles, errorRowMappingInformations, keyList);
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
        String formName = formConfig.getCaption().getLocaleValue();
        String dateStr = new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
        String fileName = ResManager.loadKDString((String)"\u3010%1$s\u3011\u5bfc\u5165\u9519\u8bef\u62a5\u544av%2$s", (String)"CustomImportHelper_16", (String)"bos-nocode-service", (Object[])new Object[]{formName, dateStr});
        return CustomImportHelper.flush(wb, fileName);
    }

    private static void writeHead(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, ExcelRowMappingInformation headFieldInformations) {
        Map<String, CellMappingInformation> cellInfos = headFieldInformations.getCellInfos();
        SXSSFRow headRow = sheet.createRow(0);
        SXSSFCell errCell = headRow.createCell(0);
        errCell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u63cf\u8ff0", (String)"CustomImportHelper_15", (String)"bos-nocode-service", (Object[])new Object[0]));
        CellStyle errCellStyle = styles.getTitleStyle();
        errCellStyle.setWrapText(true);
        errCell.setCellStyle(errCellStyle);
        sheet.setColumnWidth(0, CustomImportHelper.calcColumnWidth("", 300));
        int columnIndex = 0;
        for (Map.Entry<String, CellMappingInformation> entry : cellInfos.entrySet()) {
            if (!CustomImportHelper.isNumeric(entry.getKey()) && !entry.getKey().equals(ROW_TAG)) continue;
            String cellValue = entry.getValue().getCellValue();
            SXSSFCell curRowCell = headRow.createCell(++columnIndex);
            curRowCell.setCellValue(cellValue);
            CellStyle cellStyle = styles.getTitleStyle();
            cellStyle.setWrapText(true);
            curRowCell.setCellStyle(cellStyle);
            sheet.setColumnWidth(columnIndex, CustomImportHelper.calcColumnWidth(cellValue, 0));
        }
    }

    private static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static void writeRowData(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, List<ExcelRowMappingInformation> errorRowMappingInformations, List<String> keyList) {
        for (int i = 0; i < errorRowMappingInformations.size(); ++i) {
            int rowIndex = i + 1;
            SXSSFRow curRow = sheet.createRow(rowIndex);
            ExcelRowMappingInformation errorRowInformation = errorRowMappingInformations.get(i);
            SXSSFCell errCell = curRow.createCell(0);
            String rowErrMsg = errorRowInformation.getRowErrMsg();
            errCell.setCellValue(rowErrMsg);
            CellStyle errCellStyle = wb.createCellStyle();
            errCellStyle.setWrapText(true);
            Font redFont = wb.createFont();
            redFont.setColor(IndexedColors.RED.getIndex());
            errCellStyle.setFont(redFont);
            errCell.setCellStyle(errCellStyle);
            sheet.setColumnWidth(0, CustomImportHelper.calcColumnWidth(rowErrMsg, 300));
            Map<String, CellMappingInformation> cellInfos = errorRowInformation.getCellInfos();
            int index = 1;
            for (Map.Entry<String, CellMappingInformation> entry : cellInfos.entrySet()) {
                for (String key : keyList) {
                    if (!key.equals(entry.getKey())) continue;
                    String cellValue = entry.getValue().getCellValue();
                    SXSSFCell curRowCell = curRow.createCell(index);
                    curRowCell.setCellValue(cellValue);
                    CellStyle cellStyle = styles.getTextStyle();
                    cellStyle.setWrapText(true);
                    cellStyle.setFont(null);
                    curRowCell.setCellStyle(cellStyle);
                    sheet.setColumnWidth(index, CustomImportHelper.calcColumnWidth(cellValue, 0));
                    ++index;
                }
            }
        }
    }

    private static int calcColumnWidth(String caption, int designatedColWidth) {
        if (designatedColWidth > 0) {
            return designatedColWidth * 32;
        }
        int colWidth = 0;
        try {
            colWidth = 256 * (caption.getBytes("GBK").length + 8);
        }
        catch (UnsupportedEncodingException e) {
            colWidth = 256 * (caption.getBytes(StandardCharsets.UTF_8).length + 8);
        }
        return Math.min(colWidth, 51200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String flush(SXSSFWorkbook wb, String fileName) {
        String string;
        File temp;
        FileInputStream fis;
        block8: {
            FileOutputStream fos = null;
            fis = null;
            temp = null;
            try {
                temp = File.createTempFile(UUID.randomUUID().toString(), ".xlsx");
                fos = new FileOutputStream(temp);
                wb.write((OutputStream)fos);
                wb.dispose();
                fis = new FileInputStream(temp);
                string = CustomImportHelper.upload(fileName + ".xlsx", fis);
                if (fos == null) break block8;
            }
            catch (IOException e) {
                block9: {
                    try {
                        log.warn((Throwable)e);
                        if (fos == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (fos != null) {
                            FileSecurityUtil.safeClose(fos);
                        }
                        if (fis != null) {
                            FileSecurityUtil.safeClose(fis);
                        }
                        if (temp == null) throw throwable;
                        FileSecurityUtil.safeDeleteFile((File)temp);
                        throw throwable;
                    }
                    FileSecurityUtil.safeClose((Closeable)fos);
                }
                if (fis != null) {
                    FileSecurityUtil.safeClose(fis);
                }
                if (temp == null) return "";
                FileSecurityUtil.safeDeleteFile((File)temp);
                return "";
            }
            FileSecurityUtil.safeClose((Closeable)fos);
        }
        if (fis != null) {
            FileSecurityUtil.safeClose((Closeable)fis);
        }
        if (temp == null) return string;
        FileSecurityUtil.safeDeleteFile((File)temp);
        return string;
    }

    public static String upload(String fileName, InputStream in) {
        int timeout = 7200;
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        if (fileName.length() > 50) {
            int trimLength = fileName.length() - 50;
            int suffixIndex = fileName.lastIndexOf(46);
            String suffix = fileName.substring(suffixIndex);
            fileName = fileName.substring(0, fileName.length() - trimLength - suffix.length()) + suffix;
        }
        return tempFileCache.saveAsFullUrl(fileName, in, timeout);
    }

    static {
        imageTypeMapping.put("jpg", "0");
        imageTypeMapping.put("jpeg", "1");
        imageTypeMapping.put("png", "2");
        imageTypeMapping.put("gif", "3");
    }
}

