/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.customimport;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.nocode.design.NoCodeDesignerData;
import kd.bos.nocode.ext.metadata.entity.field.CustomSelectContent;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeSelectItemField;
import kd.bos.nocode.ext.metadata.entity.field.SelectItem;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.customimportresult.RestApiCustomImportResult;
import kd.bos.nocode.restapi.api.result.customimportresult.RestApiImportPreviewResult;
import kd.bos.nocode.restapi.api.result.customimportresult.RestApiPropertyConfigResult;
import kd.bos.nocode.restapi.api.result.customimportresult.RestApiSheetResult;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.customimport.CustomImportContext;
import kd.bos.nocode.restapi.service.customimport.CustomImportHelper;
import kd.bos.nocode.restapi.service.customimport.CustomSheetHandler;
import kd.bos.nocode.restapi.service.customimport.NoCodeExcelReader;
import kd.bos.nocode.restapi.service.customimport.csv.CsvImportHelper;
import kd.bos.nocode.restapi.service.customimport.csv.NoCodeCsvReader;
import kd.bos.nocode.restapi.service.customimport.csv.dto.CsvCellInfo;
import kd.bos.nocode.restapi.service.customimport.csv.dto.CsvDataInfo;
import kd.bos.nocode.restapi.service.customimport.csv.dto.CsvRowInfo;
import kd.bos.nocode.restapi.service.customimport.mapping.CellMappingInformation;
import kd.bos.nocode.restapi.service.customimport.mapping.ExcelRowMappingInformation;
import kd.bos.nocode.utils.ColorUtils;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.URLCodecUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;

public class CustomImportServiceImpl
implements SaveRestApiService {
    private static final Log log = LogFactory.getLog(CustomImportServiceImpl.class);
    private static final String REGEX = "/customimport/?";
    private static final Pattern PATTERN = Pattern.compile("/customimport/?");
    private static final String FORMID = "formId";
    public static final String FILEURL = "fileUrl";
    public static final String SHEETNAME = "sheetName";
    private static final String FIELDTYPE = "fieldType";
    private static final String TEMP_LOCAL_DIR = "CUSTOM_IMPORT_TEMPFILE_PATH:";
    private static final String PREVIEW_DATA = "_nocode_preview_data_";
    private static final String FORM_CONFIG = "nocode_customimport_form_config_by_";
    private static final String EXCEL_HEAD = "importHead";
    private static final String EXCEL_ROW = "importRows";
    private static final String ROW_TAG = "rowTag";
    private static boolean isImportDataError = false;
    private CustomImportContext ctx;
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("NOCODE_CUSTOM_IMPORT", new DistributeCacheHAPolicy(true, true));
    protected static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"CustomImportServiceThreadPool", (int)2, (int)6);
    private static final DistributeSessionlessCache csvInfoCacheInRedis = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("NOCODE_CSV_IMPORT", new DistributeCacheHAPolicy(true, true));

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    private String getAction(RestApiSaveParam param) {
        String url = param.getRequest().getUrl();
        String[] split = url.split(REGEX);
        String action = "";
        if (split.length > 1) {
            action = split[1];
        }
        return action;
    }

    public RestApiServiceData execute(RestApiSaveParam param) {
        String action;
        switch (action = this.getAction(param)) {
            case "getsheet": {
                return this.getSheet(param);
            }
            case "datapreview": {
                return this.dataPreview(param);
            }
            case "getpropertyconfig": {
                return this.getPropertyConfig(param);
            }
            case "impreview": {
                return this.importPreview(param);
            }
            case "dataimport": {
                return this.importData(param);
            }
            case "clear": {
                return this.clear(param);
            }
        }
        throw new RestApiException("unknown request");
    }

    private RestApiServiceData<RestApiSheetResult> getSheet(RestApiSaveParam param) {
        long start = System.currentTimeMillis();
        Map importParam = (Map)param.getDataList().get(0);
        String url = importParam.get(FILEURL).toString();
        boolean isCsv = "csv".equals(importParam.get("fileType"));
        RestApiResponse response = new RestApiResponse();
        RestApiSheetResult restApiSheetResult = new RestApiSheetResult();
        if (isCsv) {
            CsvDataInfo previewData = NoCodeCsvReader.getPreviewDataByCsv(url, 0, 0, 10, 1);
            restApiSheetResult.setPreviewData((Object)previewData);
            restApiSheetResult.setTotalCount(previewData.getTotalRow());
        } else {
            List<String> sheetNames = NoCodeExcelReader.getSheetName(url);
            Map<String, List<ExcelRowMappingInformation>> previewData = this.createPreviewData(url, sheetNames.get(0), 1, 1, 10, 1);
            restApiSheetResult.setSheetNames(sheetNames);
            restApiSheetResult.setPreviewData(previewData);
            restApiSheetResult.setTotalCount(this.ctx.getTotalCount());
        }
        response.setData((Object)restApiSheetResult);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)System.currentTimeMillis());
    }

    private RestApiServiceData<RestApiSheetResult> dataPreview(RestApiSaveParam param) {
        long start = System.currentTimeMillis();
        Map importParam = (Map)param.getDataList().get(0);
        String url = importParam.get(FILEURL).toString();
        int startRow = Integer.parseInt(importParam.get("row") + "");
        int startCol = Integer.parseInt(importParam.get("col") + "");
        int pageSize = Integer.parseInt(importParam.get("pageSize") + "");
        int pageNo = Integer.parseInt(importParam.get("pageNo") + "");
        boolean isCsv = "csv".equals(importParam.get("fileType"));
        RestApiSheetResult restApiSheetResult = new RestApiSheetResult();
        RestApiResponse response = new RestApiResponse();
        if (isCsv) {
            CsvDataInfo previewData = NoCodeCsvReader.getPreviewDataByCsv(url, startRow - 1, startCol - 1, pageSize, pageNo);
            restApiSheetResult.setPreviewData((Object)previewData);
            restApiSheetResult.setTotalCount(previewData.getTotalRow());
        } else {
            String sheetName = importParam.get(SHEETNAME).toString();
            Map<String, List<ExcelRowMappingInformation>> previewData = this.createPreviewData(url, sheetName, startRow, startCol, pageSize, pageNo);
            restApiSheetResult.setPreviewData(previewData);
            restApiSheetResult.setTotalCount(this.ctx.getTotalCount());
        }
        response.setData((Object)restApiSheetResult);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)System.currentTimeMillis());
    }

    private Map<String, List<ExcelRowMappingInformation>> createPreviewData(String url, String sheetName, int startRow, int startCol, int pageSize, int pageNo) {
        if (startRow > 0) {
            --startRow;
        }
        if (startCol > 0) {
            --startCol;
        }
        this.ctx = new CustomImportContext(url, sheetName, startRow, startCol, pageSize, pageNo);
        CustomSheetHandler customSheetHandler = new CustomSheetHandler(this.ctx, startRow, startCol);
        NoCodeExcelReader.getPreviewData(url, sheetName, customSheetHandler, this.ctx);
        return this.ctx.getPreviewData();
    }

    private RestApiServiceData<List<RestApiPropertyConfigResult>> getPropertyConfig(RestApiSaveParam param) {
        long start = System.currentTimeMillis();
        Map importParam = (Map)param.getDataList().get(0);
        String formId = importParam.get(FORMID).toString();
        String url = importParam.get(FILEURL).toString();
        boolean isBack = (Boolean)importParam.get("isBack");
        boolean isCsv = "csv".equals(importParam.get("fileType"));
        int row = Integer.parseInt(importParam.get("row") + "");
        int col = Integer.parseInt(importParam.get("col") + "");
        if (isBack) {
            if (isCsv) {
                csvInfoCacheInRedis.remove(url + "_row_" + (row - 1) + "_col_" + (col - 1));
            } else {
                String sheetName = importParam.get(SHEETNAME).toString();
                cache.remove(url + PREVIEW_DATA + sheetName + "_row_" + (row - 1) + "_col_" + (col - 1));
            }
        }
        RestApiResponse response = new RestApiResponse();
        String cacheFormConfigStr = (String)cache.get(url + FORM_CONFIG + formId);
        if (cacheFormConfigStr != null) {
            List cachePerpropConfig = SerializationUtils.fromJsonStringToList((String)cacheFormConfigStr, RestApiPropertyConfigResult.class);
            response.setData((Object)cachePerpropConfig);
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)System.currentTimeMillis());
        }
        List<RestApiPropertyConfigResult> perpropConfig = CustomImportHelper.buildRestApiPropertyConfigResults(formId, url);
        response.setData(perpropConfig);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)System.currentTimeMillis());
    }

    private RestApiServiceData<RestApiImportPreviewResult> importPreview(RestApiSaveParam param) {
        Map<String, List<ExcelRowMappingInformation>> importpreviewData;
        CsvDataInfo csvDataInfo;
        long start = System.currentTimeMillis();
        Map importParam = (Map)param.getDataList().get(0);
        String url = importParam.get(FILEURL).toString();
        String formId = importParam.get(FORMID).toString();
        int row = Integer.parseInt(importParam.get("row") + "");
        int col = Integer.parseInt(importParam.get("col") + "");
        int amount = Integer.parseInt(importParam.get("pageSize") + "");
        int page = Integer.parseInt(importParam.get("pageNo") + "");
        boolean isNeedMsg = (Boolean)importParam.get("isNeedMsg");
        String sheetName = "";
        boolean isCsv = "csv".equals(importParam.get("fileType"));
        RestApiResponse response = new RestApiResponse();
        RestApiImportPreviewResult restApiImportPreviewResult = new RestApiImportPreviewResult();
        boolean isUpdate = (Boolean)importParam.get("isUpdate");
        List updateConditions = (List)SerializationUtils.fromJsonString((String)importParam.get("updateCond").toString(), List.class);
        Map config = (Map)SerializationUtils.fromJsonString((String)importParam.get("config").toString(), Map.class);
        if (isNeedMsg) {
            String promptMessage;
            if (isCsv) {
                CsvDataInfo csvPreviewData = NoCodeCsvReader.getPreviewDataByCsv(url, row - 1, col - 1, 1000, 1);
                try {
                    csvDataInfo = CsvImportHelper.buildImportPreviewData(formId, url, csvPreviewData, isUpdate, updateConditions, config);
                }
                catch (KDBizException e) {
                    return RestApiServiceData.ofFalse((String)"-1", (String)e.getMessage(), (RestApiResponse)response, (long)(System.currentTimeMillis() - start));
                }
                cache.put(url + "_row_" + (row - 1) + "_col_" + (col - 1), (Object)SerializationUtils.toJsonString((Object)csvDataInfo), 1, TimeUnit.HOURS);
                promptMessage = this.buildCsvPromptMessage(csvDataInfo, row);
            } else {
                sheetName = importParam.get(SHEETNAME).toString();
                Map<String, List<ExcelRowMappingInformation>> previewData = this.createPreviewData(url, sheetName, row, col, 1000, 1);
                try {
                    importpreviewData = CustomImportHelper.buildImportPreviewData(formId, url, previewData, isUpdate, updateConditions, config);
                }
                catch (KDBizException e) {
                    return RestApiServiceData.ofFalse((String)"-1", (String)e.getMessage(), (RestApiResponse)response, (long)(System.currentTimeMillis() - start));
                }
                cache.put(url + PREVIEW_DATA + sheetName + "_row_" + (row - 1) + "_col_" + (col - 1), (Object)SerializationUtils.toJsonString(importpreviewData), 1, TimeUnit.HOURS);
                promptMessage = this.buildPromptMessage(importpreviewData, row);
            }
            restApiImportPreviewResult.setPromptMessage(promptMessage);
            restApiImportPreviewResult.setImportDataError(isImportDataError);
        }
        if (isCsv) {
            csvDataInfo = NoCodeCsvReader.getPreviewDataByCsv(url, row - 1, col - 1, amount, page);
            restApiImportPreviewResult.setImportpreviewData((Object)csvDataInfo);
            restApiImportPreviewResult.setTotalCount(csvDataInfo.getTotalRow());
        } else {
            sheetName = importParam.get(SHEETNAME).toString();
            importpreviewData = this.createPreviewData(url, sheetName, row, col, amount, page);
            restApiImportPreviewResult.setImportpreviewData(importpreviewData);
            restApiImportPreviewResult.setTotalCount(this.ctx.getTotalCount());
        }
        response.setData((Object)restApiImportPreviewResult);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)System.currentTimeMillis());
    }

    private String buildPromptMessage(Map<String, List<ExcelRowMappingInformation>> importpreviewData, int row) {
        String promptMessage;
        int addCount = 0;
        int updateCount = 0;
        int errorCount = 0;
        List<Object> showErrorRowIndex = new ArrayList();
        ArrayList<Integer> errorRowIndex = new ArrayList<Integer>();
        for (ExcelRowMappingInformation rowMappingInformation : importpreviewData.get(EXCEL_ROW)) {
            if (rowMappingInformation.isError()) {
                ++errorCount;
                errorRowIndex.add(Integer.parseInt(rowMappingInformation.getRowSeq()) - row + 1);
                showErrorRowIndex = CustomImportServiceImpl.transParam(errorRowIndex);
                continue;
            }
            if (ResManager.loadKDString((String)"\u66ff\u6362", (String)"CustomImportServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]).equals(rowMappingInformation.getCellInfos().get(ROW_TAG).getCellValue())) {
                ++updateCount;
                continue;
            }
            ++addCount;
        }
        if (errorCount > 0) {
            promptMessage = ResManager.loadKDString((String)"\u65b0\u589e%1$s\u6761\u6570\u636e\uff0c\u66ff\u6362%2$s\u6761\u6570\u636e\uff1b\n\u5b58\u5728%3$s\u6761\u9519\u8bef\u6570\u636e\uff0c\u9519\u8bef\u884c\u53f7\u5206\u522b\u662f\uff1a%4$s", (String)"CustomImportServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[]{addCount, updateCount, errorCount, String.join((CharSequence)"\uff0c", showErrorRowIndex)});
            isImportDataError = true;
        } else {
            promptMessage = ResManager.loadKDString((String)"\u65b0\u589e%1$s\u6761\u6570\u636e\uff0c\u66ff\u6362%2$s\u6761\u6570\u636e\uff1b", (String)"CustomImportServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[]{addCount, updateCount});
            isImportDataError = false;
        }
        return promptMessage;
    }

    private String buildCsvPromptMessage(CsvDataInfo csvDataInfo, int row) {
        String promptMessage;
        int addCount = 0;
        int updateCount = 0;
        int errorCount = 0;
        List<Object> showErrorRowIndex = new ArrayList();
        ArrayList<Integer> errorRowIndex = new ArrayList<Integer>();
        for (CsvRowInfo csvRowInfo : csvDataInfo.getImportRows()) {
            if (csvRowInfo.isError()) {
                ++errorCount;
                errorRowIndex.add(Integer.parseInt(csvRowInfo.getRowSeq()) - row + 1);
                showErrorRowIndex = CustomImportServiceImpl.transParam(errorRowIndex);
                continue;
            }
            if (ResManager.loadKDString((String)"\u66ff\u6362", (String)"CustomImportServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]).equals(csvRowInfo.getCellInfos().get(csvRowInfo.getCellInfos().size() - 1).getCellValue())) {
                ++updateCount;
                continue;
            }
            ++addCount;
        }
        if (errorCount > 0) {
            promptMessage = ResManager.loadKDString((String)"\u65b0\u589e%1$s\u6761\u6570\u636e\uff0c\u66ff\u6362%2$s\u6761\u6570\u636e\uff1b\n\u5b58\u5728%3$s\u6761\u9519\u8bef\u6570\u636e\uff0c\u9519\u8bef\u884c\u53f7\u5206\u522b\u662f\uff1a%4$s", (String)"CustomImportServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[]{addCount, updateCount, errorCount, String.join((CharSequence)"\uff0c", showErrorRowIndex)});
            isImportDataError = true;
        } else {
            promptMessage = ResManager.loadKDString((String)"\u65b0\u589e%1$s\u6761\u6570\u636e\uff0c\u66ff\u6362%2$s\u6761\u6570\u636e\uff1b", (String)"CustomImportServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[]{addCount, updateCount});
            isImportDataError = false;
        }
        return promptMessage;
    }

    private static List<String> transParam(List<Integer> params) {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        Integer lastValue = -1;
        Integer startValue = 0;
        for (Integer param : params) {
            if (lastValue >= 0) {
                if (param - lastValue == 1) {
                    map.put(startValue, startValue + "~" + param);
                } else {
                    map.put(param, param + "");
                    startValue = param;
                }
            } else {
                map.put(param, param + "");
                startValue = param;
            }
            lastValue = param;
        }
        Collection collections = map.values();
        return new ArrayList<String>(collections);
    }

    public static List<List<Integer>> getSerialNumList(List<Integer> list) {
        ArrayList<List<Integer>> resultList = new ArrayList<List<Integer>>();
        ArrayList<Integer> arrList = new ArrayList<Integer>();
        resultList.add(arrList);
        if (list.size() == 1) {
            ((List)resultList.get(resultList.size() - 1)).add(list.get(0));
            return resultList;
        }
        for (int i = 0; i < list.size(); ++i) {
            Integer nextNum = list.get(i + 1);
            Integer nowNum = list.get(i);
            if (nextNum - nowNum != 1) {
                ((List)resultList.get(resultList.size() - 1)).add(nowNum);
                arrList = new ArrayList();
                resultList.add(arrList);
            } else {
                arrList.add(nowNum);
            }
            if (i + 1 != list.size() - 1) continue;
            arrList.add(nextNum);
            break;
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestApiServiceData<RestApiCustomImportResult> importData(RestApiSaveParam param) {
        int total;
        long start = System.currentTimeMillis();
        Map importParam = (Map)param.getDataList().get(0);
        String formId = importParam.get(FORMID).toString();
        String appId = importParam.get("appId").toString();
        String url = importParam.get(FILEURL).toString();
        String sheetName = "";
        boolean isCsv = "csv".equals(importParam.get("fileType"));
        boolean insertDefaultSelectItem = Boolean.parseBoolean((String)importParam.get("insertDefaultSelectItem"));
        int row = Integer.parseInt(importParam.get("row") + "");
        int col = Integer.parseInt(importParam.get("col") + "");
        RestApiResponse response = new RestApiResponse();
        RestApiCustomImportResult restApiImportPreviewResult = new RestApiCustomImportResult();
        Map<Object, Object> importData = new HashMap();
        CsvDataInfo csvDataInfo = null;
        if (isCsv) {
            csvDataInfo = NoCodeCsvReader.getPreviewDataByCsv(url, row - 1, col - 1, 1000, 1);
            total = csvDataInfo.getImportRows().size();
        } else {
            sheetName = importParam.get(SHEETNAME).toString();
            importData = this.createPreviewData(url, sheetName, row, col, 1000, 1);
            total = ((List)importData.get(EXCEL_ROW)).size();
        }
        try {
            String msg;
            String sErrorOverRecordMax = NcEntityTypeUtil.checkRecordCount((String)formId, (int)total);
            if (StringUtils.isNotBlank((CharSequence)sErrorOverRecordMax)) {
                RestApiServiceData restApiServiceData = RestApiServiceData.ofFalse((String)RestApiErrorCode.ERROR.getStatusCode(), (String)sErrorOverRecordMax, (RestApiResponse)response, (long)(System.currentTimeMillis() - start));
                return restApiServiceData;
            }
            new NoCodeDesignerData().enableForm(appId, formId);
            List<Object> dynamicObjects = new ArrayList();
            dynamicObjects = isCsv ? CsvImportHelper.convertDataToDynamicObject(csvDataInfo, formId) : CustomImportHelper.convertDataToDynamicObject(importData, formId);
            Collections.reverse(dynamicObjects);
            OperationResult operationResult = CustomImportHelper.saveData(dynamicObjects, formId, appId);
            List successPkIds = operationResult.getSuccessPkIds();
            int succeed = successPkIds.size();
            if (isCsv) {
                this.rebuildSelectItemFieldConfig(formId, successPkIds, insertDefaultSelectItem, null, csvDataInfo.getImportHead());
            } else {
                this.rebuildSelectItemFieldConfig(formId, successPkIds, insertDefaultSelectItem, (ExcelRowMappingInformation)((List)importData.get(EXCEL_HEAD)).get(0), null);
            }
            if (succeed == total) {
                msg = ResManager.loadKDString((String)"\u6210\u529f\u5bfc\u5165%s\u6761\u8bb0\u5f55", (String)"CustomImportServiceImpl_3", (String)"bos-nocode-service", (Object[])new Object[]{succeed});
                restApiImportPreviewResult.setSuccess(true);
            } else {
                msg = ResManager.loadKDString((String)"\u6210\u529f\u5bfc\u5165%1$s\u6761\u8bb0\u5f55\uff0c\n\u5b58\u5728%2$s\u6761\u9519\u8bef\u8bb0\u5f55\u5bfc\u5165\u5931\u8d25", (String)"CustomImportServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[]{succeed, total - succeed});
                String errReportUrl = isCsv ? CsvImportHelper.buildErrorReport(csvDataInfo, operationResult, formId) : CustomImportHelper.buildErrorReport(importData, operationResult, sheetName, formId);
                restApiImportPreviewResult.setErrorReportUrl(errReportUrl);
                restApiImportPreviewResult.setSuccess(false);
            }
            restApiImportPreviewResult.setMessage(msg);
            response.setData((Object)restApiImportPreviewResult);
        }
        finally {
            CustomImportHelper.clearCache(formId, url, sheetName, row, col);
        }
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)System.currentTimeMillis());
    }

    private void rebuildSelectItemFieldConfig(String formId, List<Object> successPkIds, boolean insertDefaultSelectItem, ExcelRowMappingInformation headRow, CsvRowInfo csvHeadRow) {
        Set needAutoAddOptionFields = null == headRow ? csvHeadRow.getCellInfos().stream().filter(CsvCellInfo::isDataAutoOptions).map(CsvCellInfo::getBillFieldId).collect(Collectors.toSet()) : headRow.getCellInfos().values().stream().filter(CellMappingInformation::isDataAutoOptions).map(CellMappingInformation::getBillFieldId).collect(Collectors.toSet());
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Entity);
        List selectItemFields = entityMetadata.getItems().stream().filter(e -> e instanceof NoCodeSelectItemField).map(AbstractElement::getKey).filter(needAutoAddOptionFields::contains).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(selectItemFields)) {
            return;
        }
        String selectProperties = String.join((CharSequence)",", selectItemFields);
        HashMap<String, Set> field2DbValues = new HashMap<String, Set>(selectItemFields.size());
        if (CollectionUtils.isNotEmpty(successPkIds)) {
            QFilter idsFilter = new QFilter("id", "in", successPkIds);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"rebuildSelectItemFieldConfig", (String)formId, (String)selectProperties, (QFilter[])idsFilter.toArray(), null);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    for (String selectItemField : selectItemFields) {
                        String value = row.getString(selectItemField);
                        if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                        Set values = field2DbValues.getOrDefault(selectItemField, new HashSet(32));
                        String[] splitValues = value.split(",");
                        values.addAll(Arrays.asList(splitValues));
                        field2DbValues.put(selectItemField, values);
                    }
                }
            }
        }
        entityMetadata.getItems().stream().filter(e -> e instanceof NoCodeSelectItemField).map(NoCodeSelectItemField.class::cast).forEach(e -> {
            List existValues = e.getCustomContent().getOps().stream().map(SelectItem::getValue).collect(Collectors.toList());
            String fieldKey = e.getKey();
            Set dbValues = field2DbValues.getOrDefault(fieldKey, new HashSet(2));
            dbValues.removeIf(existValues::contains);
            if (CollectionUtils.isNotEmpty((Collection)dbValues)) {
                e.getCustomContent().getOps().addAll(this.getCustomSelectContentByValues(dbValues, e.getCustomContent().isBgcSwitch()));
            } else if (CollectionUtils.isEmpty(existValues) && insertDefaultSelectItem) {
                e.setCustomContent(this.getDefaultCustomSelectContent());
            }
        });
        MetadataWriter writer = new MetadataWriter("NoCodeModel");
        writer.save(Boolean.valueOf(false), new AbstractMetadata[]{formMetadata, entityMetadata});
    }

    private List<SelectItem> getCustomSelectContentByValues(Set<String> values, boolean bgcSwitch) {
        ArrayList valueList = Lists.newArrayList(values);
        ArrayList<SelectItem> ops = new ArrayList<SelectItem>(valueList.size());
        for (int i = 0; i < valueList.size(); ++i) {
            String value = (String)valueList.get(i);
            SelectItem selectItem = new SelectItem();
            selectItem.setLabel(new LocaleString(URLCodecUtils.decode((String)value)));
            selectItem.setValue(value);
            if (bgcSwitch) {
                List randomDarkColorList = ColorUtils.getRandomDarkColorList();
                int darkColorListLength = ColorUtils.getDarkColorListLength();
                int colorIndex = i % darkColorListLength;
                String color = (String)randomDarkColorList.get(colorIndex);
                selectItem.setBgc(color);
            }
            ops.add(selectItem);
        }
        return ops;
    }

    public CustomSelectContent getDefaultCustomSelectContent() {
        List randomDarkColorList = ColorUtils.getRandomDarkColorList();
        SelectItem selectItem1 = new SelectItem();
        selectItem1.setLabel(new LocaleString(ResManager.loadKDString((String)"\u9009\u9879\u4e00", (String)"CustomImportServiceImpl_5", (String)"bos-nocode-service", (Object[])new Object[0])));
        selectItem1.setValue("%E9%80%89%E9%A1%B9%E4%B8%80");
        selectItem1.setBgc((String)randomDarkColorList.get(0));
        SelectItem selectItem2 = new SelectItem();
        selectItem2.setLabel(new LocaleString(ResManager.loadKDString((String)"\u9009\u9879\u4e8c", (String)"CustomImportServiceImpl_6", (String)"bos-nocode-service", (Object[])new Object[0])));
        selectItem2.setValue("%E9%80%89%E9%A1%B9%E4%BA%8C");
        selectItem2.setBgc((String)randomDarkColorList.get(1));
        SelectItem selectItem3 = new SelectItem();
        selectItem3.setLabel(new LocaleString(ResManager.loadKDString((String)"\u9009\u9879\u4e09", (String)"CustomImportServiceImpl_7", (String)"bos-nocode-service", (Object[])new Object[0])));
        selectItem3.setValue("%E9%80%89%E9%A1%B9%E4%B8%89");
        selectItem3.setBgc((String)randomDarkColorList.get(2));
        CustomSelectContent customSelectContent = new CustomSelectContent();
        customSelectContent.setBgcSwitch(Boolean.TRUE.booleanValue());
        customSelectContent.setOps((List)Lists.newArrayList((Object[])new SelectItem[]{selectItem1, selectItem2, selectItem3}));
        return customSelectContent;
    }

    private RestApiServiceData clear(RestApiSaveParam param) {
        boolean delete;
        File tempFile;
        Map importParam = (Map)param.getDataList().get(0);
        String url = importParam.get(FILEURL).toString();
        String sheetName = importParam.get(SHEETNAME).toString();
        String formId = importParam.get(FORMID).toString();
        String tempFilePath = (String)cache.get(TEMP_LOCAL_DIR + url);
        if (StringUtils.isNotBlank((CharSequence)tempFilePath) && (tempFile = FileUtils.getFile((String[])new String[]{tempFilePath})) != null && tempFile.exists() && !(delete = tempFile.delete())) {
            log.debug("\u5220\u9664\u5931\u8d25");
        }
        cache.remove(TEMP_LOCAL_DIR + url);
        cache.remove(url + PREVIEW_DATA + sheetName + "_row_" + 0 + "_col_" + 0);
        cache.remove(url + PREVIEW_DATA + sheetName + "_row_" + 3 + "_col_" + 0);
        cache.remove(url + FORM_CONFIG + formId);
        return null;
    }
}

