/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.customimport;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.impt.SheetHandler;
import kd.bos.nocode.restapi.service.customimport.CustomImportContext;
import kd.bos.nocode.restapi.service.customimport.mapping.CellMappingInformation;
import kd.bos.nocode.restapi.service.customimport.mapping.ExcelRowMappingInformation;
import kd.bos.nocode.restapi.service.customimport.mapping.PictureInformation;
import kd.bos.nocode.restapi.service.impt.AbstractNoCodeSheetHandler;
import org.apache.poi.ss.util.CellRangeAddress;
import org.xml.sax.SAXException;

public class CustomSheetHandler
extends AbstractNoCodeSheetHandler {
    private int startRow = 0;
    private int startCol = 0;
    private int endCol = 0;
    private int headMergedCellIndex = 16384;
    private int rowMergedCellIndex = 0;
    private int nullLineIndex = 0;
    private CustomImportContext ctx;
    private Map<String, List<ExcelRowMappingInformation>> previewDataMap;
    private static final String PREVIEW_DATA = "_nocode_preview_data_";
    private static final String EXCEL_HEAD = "importHead";
    private static final String EXCEL_ROW = "importRows";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("NOCODE_CUSTOM_IMPORT", new DistributeCacheHAPolicy(true, true));

    public CustomSheetHandler() {
    }

    public CustomSheetHandler(CustomImportContext ctx, int startRow, int startCol) {
        this.ctx = ctx;
        this.startRow = startRow;
        this.startCol = startCol;
        this.rowMergedCellIndex = startRow + 1000 + 1;
        this.nullLineIndex = startRow + 1000 + 1;
    }

    @Override
    public void handleRow(SheetHandler.ParsedRow row) {
        int curRowIndex = row.getRowNum();
        if (curRowIndex < this.startRow || curRowIndex > 1001 + this.startRow || curRowIndex >= this.nullLineIndex) {
            return;
        }
        Map rowData = row.getData();
        this.fillPictrues(curRowIndex, rowData);
        if (curRowIndex != this.startRow && this.isRowDataEmpty(rowData)) {
            this.nullLineIndex = curRowIndex;
            return;
        }
        rowData.keySet().removeIf(index -> index < this.startCol || index >= this.startCol + 150);
        if (curRowIndex > this.startRow && curRowIndex >= this.rowMergedCellIndex) {
            return;
        }
        this.buildPreviewData(curRowIndex, rowData);
    }

    private void fillPictrues(int curRowIndex, Map<Integer, String> rowData) {
        Set<PictureInformation> pictureInfos = this.ctx.getPictureInfo();
        for (Map.Entry<Integer, String> entry : rowData.entrySet()) {
            Integer curCol = entry.getKey();
            for (PictureInformation pictureInfo : pictureInfos) {
                if (curRowIndex != pictureInfo.getCurRow()) continue;
                rowData.put(pictureInfo.getCurCol(), pictureInfo.getName());
            }
        }
    }

    private boolean isRowDataEmpty(Map<Integer, String> rowData) {
        Set<Integer> cols = rowData.keySet();
        for (int curCol = this.startCol; curCol <= this.endCol; ++curCol) {
            if (!cols.contains(curCol)) continue;
            return false;
        }
        return true;
    }

    private void buildPreviewData(int currRowNum, Map<Integer, String> rowData) {
        if (this.previewDataMap == null) {
            this.previewDataMap = new LinkedHashMap<String, List<ExcelRowMappingInformation>>();
            LinkedList excelRowInformations = new LinkedList();
            LinkedList excelHeadInformations = new LinkedList();
            this.previewDataMap.put(EXCEL_HEAD, excelHeadInformations);
            this.previewDataMap.put(EXCEL_ROW, excelRowInformations);
        }
        LinkedHashMap<String, CellMappingInformation> cellInfors = new LinkedHashMap<String, CellMappingInformation>();
        if (currRowNum == this.startRow) {
            rowData = this.collateTableHead(rowData);
            ExcelRowMappingInformation excelHeadInformation = this.buildRowPreviewData(currRowNum, rowData, cellInfors);
            excelHeadInformation.setRowSeq(String.valueOf(currRowNum));
            this.previewDataMap.get(EXCEL_HEAD).add(excelHeadInformation);
        } else {
            rowData = this.setDefault(rowData);
            ExcelRowMappingInformation excelRowInformation = this.buildRowPreviewData(currRowNum, rowData, cellInfors);
            excelRowInformation.setRowSeq(String.valueOf(currRowNum));
            this.previewDataMap.get(EXCEL_ROW).add(excelRowInformation);
        }
    }

    private ExcelRowMappingInformation buildRowPreviewData(int curRowIndex, Map<Integer, String> rowData, Map<String, CellMappingInformation> cellInfos) {
        for (Map.Entry<Integer, String> entry : rowData.entrySet()) {
            Integer curCol = entry.getKey();
            CellMappingInformation cellMappingInformation = new CellMappingInformation(String.valueOf(curCol), rowData.get(curCol));
            cellInfos.put(String.valueOf(curCol), cellMappingInformation);
            Set<PictureInformation> pictureInformations = this.ctx.getPictureInfo();
            LinkedHashSet<PictureInformation> cellpics = new LinkedHashSet<PictureInformation>();
            for (PictureInformation pictureInformation : pictureInformations) {
                if (curRowIndex != pictureInformation.getCurRow() || !curCol.equals(pictureInformation.getCurCol())) continue;
                cellpics.add(pictureInformation);
            }
            cellMappingInformation.setPictureInformations(cellpics);
        }
        return new ExcelRowMappingInformation(cellInfos);
    }

    private void setHeadMergedCellIndex() {
        List<CellRangeAddress> mergedRegions = this.ctx.getMergedRegions();
        for (CellRangeAddress mergedRegion : mergedRegions) {
            int firstRow = mergedRegion.getFirstRow();
            int firstColumn = mergedRegion.getFirstColumn();
            if (firstRow != this.startRow || firstColumn < this.startCol) continue;
            this.headMergedCellIndex = Math.min(this.headMergedCellIndex, firstColumn);
        }
    }

    private void setRowMergedCellIndex() {
        List<CellRangeAddress> mergedRegions = this.ctx.getMergedRegions();
        for (CellRangeAddress mergedRegion : mergedRegions) {
            int firstRow = mergedRegion.getFirstRow();
            int firstColumn = mergedRegion.getFirstColumn();
            if (firstRow < this.startRow || firstColumn < this.startCol || firstColumn > this.endCol) continue;
            this.rowMergedCellIndex = Math.min(this.rowMergedCellIndex, firstRow);
        }
    }

    private Map<Integer, String> collateTableHead(Map<Integer, String> rowData) {
        LinkedHashMap<Integer, String> realHead = new LinkedHashMap<Integer, String>(rowData.size());
        Integer[] integers = rowData.keySet().toArray(new Integer[0]);
        Integer maxCol = integers[integers.length - 1];
        this.endCol = maxCol;
        this.setHeadMergedCellIndex();
        for (int i = this.startCol; i <= maxCol; ++i) {
            String colVal = rowData.get(i);
            if (StringUtils.isBlank((CharSequence)colVal) || i == this.headMergedCellIndex) {
                this.endCol = i - 1;
                break;
            }
            realHead.put(i, colVal);
        }
        this.setRowMergedCellIndex();
        return realHead;
    }

    private Map<Integer, String> setDefault(Map<Integer, String> rowData) {
        LinkedHashMap<Integer, String> realRowData = new LinkedHashMap<Integer, String>(rowData.size());
        for (int i = this.startCol; i <= this.endCol; ++i) {
            rowData.putIfAbsent(i, "");
            realRowData.put(i, rowData.get(i));
        }
        return realRowData;
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        cache.put(this.ctx.getUrl() + PREVIEW_DATA + this.ctx.getSheetName() + "_row_" + this.ctx.getRow() + "_col_" + this.ctx.getCol(), (Object)SerializationUtils.toJsonString(this.previewDataMap), 1, TimeUnit.HOURS);
        this.createPreviewData();
    }

    public void createPreviewData(Map<String, List<ExcelRowMappingInformation>> cacheData) {
        this.previewDataMap = cacheData;
        List headInformations = SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(cacheData.get(EXCEL_HEAD)), ExcelRowMappingInformation.class);
        List rowInformations = SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(cacheData.get(EXCEL_ROW)), ExcelRowMappingInformation.class);
        this.previewDataMap.replace(EXCEL_HEAD, headInformations);
        this.previewDataMap.replace(EXCEL_ROW, rowInformations);
        this.createPreviewData();
    }

    private void createPreviewData() {
        int pageSize = this.ctx.getPageSize();
        int pageNo = this.ctx.getPageNo();
        int excelDataTotal = this.previewDataMap.get(EXCEL_ROW).size();
        this.ctx.setTotalCount(excelDataTotal);
        int pageTotal = excelDataTotal / pageSize;
        if (excelDataTotal % pageSize != 0) {
            ++pageTotal;
        }
        int startRow = pageSize * (pageNo - 1);
        int endRow = Math.min(pageSize * pageNo, excelDataTotal);
        LinkedHashMap<String, List<ExcelRowMappingInformation>> previewData = new LinkedHashMap<String, List<ExcelRowMappingInformation>>();
        previewData.put(EXCEL_HEAD, this.previewDataMap.get(EXCEL_HEAD));
        LinkedList<ExcelRowMappingInformation> rowList = new LinkedList<ExcelRowMappingInformation>();
        for (int i = startRow; i < endRow; ++i) {
            rowList.add(this.previewDataMap.get(EXCEL_ROW).get(i));
        }
        previewData.put(EXCEL_ROW, rowList);
        this.ctx.setPreviewData(previewData);
    }
}

