/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.customimport;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.db.DB;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.service.customimport.CustomImportContext;
import kd.bos.nocode.restapi.service.customimport.CustomSheetHandler;
import kd.bos.nocode.restapi.service.customimport.mapping.PictureInformation;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFPictureData;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class NoCodeExcelReader {
    private static Log log = LogFactory.getLog(NoCodeExcelReader.class);
    private static final String TEMP_LOCAL_DIR = "CUSTOM_IMPORT_TEMPFILE_PATH:";
    private static final String PREVIEW_DATA = "_nocode_preview_data_";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("NOCODE_CUSTOM_IMPORT", new DistributeCacheHAPolicy(true, true));

    public static List<String> getSheetName(String url) {
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream in = tempFileCache.getInputStream(url);
        try {
            IOUtils.setByteArrayMaxOverride((int)Integer.MAX_VALUE);
            OPCPackage pkg = OPCPackage.open((InputStream)in);
            XSSFReader r = new XSSFReader(pkg);
            XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)r.getSheetsData();
            LinkedList<String> sheetNames = new LinkedList<String>();
            while (sheets.hasNext()) {
                sheets.next();
                if (!StringUtils.isNotBlank((CharSequence)sheets.getSheetName())) continue;
                sheetNames.add(sheets.getSheetName());
            }
            return sheetNames;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getPreviewData(String url, String sheetName, CustomSheetHandler customSheetHandler, CustomImportContext ctx) {
        String cacheDataStr = (String)cache.get(url + PREVIEW_DATA + sheetName + "_row_" + ctx.getRow() + "_col_" + ctx.getCol());
        if (cacheDataStr != null) {
            Map cacheData = (Map)SerializationUtils.fromJsonString((String)cacheDataStr, Map.class);
            customSheetHandler.createPreviewData(cacheData);
            return;
        }
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream in = tempFileCache.getInputStream(url);
        File tempFile = null;
        try {
            log.debug("get file available is:" + in.available());
            tempFile = File.createTempFile(UUID.randomUUID().toString(), ".xlsx");
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            FileUtils.copyInputStreamToFile((InputStream)in, (File)tempFile);
            XSSFWorkbook wb = new XSSFWorkbook(tempFile);
            Sheet wbSheet = wb.getSheet(sheetName);
            List mergedRegions = wbSheet.getMergedRegions();
            ctx.setMergedRegions(mergedRegions);
            Map<PictureInformation, PictureData> pictures = NoCodeExcelReader.getPictures((XSSFSheet)wbSheet);
            Set<PictureInformation> pictureInformations = NoCodeExcelReader.uploadImg(pictures);
            ctx.setPictureInfo(pictureInformations);
            OPCPackage pkg = OPCPackage.open((File)tempFile);
            XSSFReader r = new XSSFReader(pkg);
            r.setUseReadOnlySharedStringsTable(false);
            XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)r.getSheetsData();
            customSheetHandler.setSharedStringsTable((SharedStringsTable)r.getSharedStringsTable());
            customSheetHandler.setStylesTable(r.getStylesTable());
            customSheetHandler.setSheetName(sheetName);
            XMLReader parser = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
            parser.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            parser.setFeature("http://xml.org/sax/features/external-general-entities", false);
            parser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            parser.setContentHandler((ContentHandler)((Object)customSheetHandler));
            CommonReaderWay readerWay = new CommonReaderWay(customSheetHandler, parser, sheets);
            while (sheets.hasNext()) {
                InputStream sheet = sheets.next();
                if (!sheetName.equals(sheets.getSheetName())) continue;
                readerWay.handle(sheet, sheetName);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        finally {
            boolean delete;
            if (tempFile != null && tempFile.exists() && !(delete = tempFile.delete())) {
                log.debug("\u5220\u9664\u5931\u8d25");
            }
        }
    }

    public static Map<PictureInformation, PictureData> getPictures(XSSFSheet sheet) {
        HashMap<PictureInformation, PictureData> map = new HashMap<PictureInformation, PictureData>();
        for (POIXMLDocumentPart dr : sheet.getRelations()) {
            if (!(dr instanceof XSSFDrawing)) continue;
            XSSFDrawing drawing = (XSSFDrawing)dr;
            List shapes = drawing.getShapes();
            for (XSSFShape shape : shapes) {
                XSSFPicture pic;
                XSSFPictureData pictureData;
                if (!(shape instanceof XSSFPicture) || null == (pictureData = NoCodeExcelReader.getPictureData(pic = (XSSFPicture)shape))) continue;
                XSSFClientAnchor anchor = (XSSFClientAnchor)shape.getAnchor();
                CTMarker ctMarker = anchor.getFrom();
                PictureInformation pictureInformation = new PictureInformation();
                pictureInformation.setCurRow(ctMarker.getRow());
                pictureInformation.setCurCol(ctMarker.getCol());
                map.put(pictureInformation, (PictureData)pictureData);
            }
        }
        return map;
    }

    private static XSSFPictureData getPictureData(XSSFPicture pic) {
        XSSFPictureData pictureData = null;
        try {
            pictureData = pic.getPictureData();
        }
        catch (Exception e) {
            log.debug("get error picture", (Object)e);
        }
        return pictureData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<PictureInformation> uploadImg(Map<PictureInformation, PictureData> mapList) throws IOException {
        Set<PictureInformation> pictureInformations = mapList.keySet();
        for (PictureInformation pictureInformation : pictureInformations) {
            PictureData pic = mapList.get(pictureInformation);
            String ext = pic.suggestFileExtension();
            byte[] data = pic.getData();
            try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
                FileService service = FileServiceFactory.getImageFileService();
                RequestContext ctx = RequestContext.getOrCreate();
                String imgName = Uuid8.generateShortUuid() + "." + ext;
                String path = NoCodeExcelReader.getUploadImgPath(ctx.getTenantId(), ctx.getAccountId(), imgName);
                String url = service.upload(new FileItem(imgName, path, (InputStream)in));
                String uid = String.format("kd-upload-%s-1", DB.genGlobalLongId());
                pictureInformation.setUid(uid);
                pictureInformation.setName(imgName);
                pictureInformation.setSize(data.length);
                pictureInformation.setUrl(url);
                pictureInformation.setStatus("success");
            }
        }
        return pictureInformations;
    }

    private static String getUploadImgPath(String tenantId, String accountId, String filename) {
        String dateStr = new SimpleDateFormat("yyyyMM").format(new Date());
        return String.format("/%s/%s/%s/nocode/%s", tenantId, accountId, dateStr, filename);
    }

    static class CommonReaderWay
    implements ReaderWay {
        protected CustomSheetHandler customSheetHandler;
        protected XMLReader parser;
        protected XSSFReader.SheetIterator sheets;

        public CommonReaderWay(CustomSheetHandler customSheetHandler, XMLReader parser, XSSFReader.SheetIterator sheets) {
            this.customSheetHandler = customSheetHandler;
            this.parser = parser;
            this.sheets = sheets;
        }

        @Override
        public void handle(InputStream sheet, String sheetName) throws Exception {
            InputSource sheetSource = new InputSource(sheet);
            if (StringUtils.isNotBlank((CharSequence)this.sheets.getSheetName())) {
                this.customSheetHandler.setSheetName(this.sheets.getSheetName());
                Comments comments = this.sheets.getSheetComments();
                if (comments != null) {
                    this.customSheetHandler.addSheetComments(this.sheets.getSheetName(), (CommentsTable)comments);
                }
                this.parser.parse(sheetSource);
                sheet.close();
            }
        }

        @Override
        public boolean interrupt(InputStream sheet, String sheetName) {
            if (StringUtils.isNotBlank((CharSequence)this.sheets.getSheetName())) {
                return this.customSheetHandler.isInterrupt();
            }
            return true;
        }
    }

    static interface ReaderWay {
        public void handle(InputStream var1, String var2) throws Exception;

        public boolean interrupt(InputStream var1, String var2);
    }
}

