/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.customimport.csv;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.property.NoCodeCreatorProp;
import kd.bos.nocode.ext.property.NoCodeDecimalProp;
import kd.bos.nocode.ext.property.NoCodeModifierProp;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.api.result.customimportresult.RestApiPropertyConfigResult;
import kd.bos.nocode.restapi.common.util.CollectionUtil;
import kd.bos.nocode.restapi.service.customimport.CustomImportHelper;
import kd.bos.nocode.restapi.service.customimport.csv.NoCodeCsvReader;
import kd.bos.nocode.restapi.service.customimport.csv.dto.CsvCellInfo;
import kd.bos.nocode.restapi.service.customimport.csv.dto.CsvDataInfo;
import kd.bos.nocode.restapi.service.customimport.csv.dto.CsvRowInfo;
import kd.bos.nocode.utils.DateTimeUtils;
import kd.bos.nocode.utils.URLCodecUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CsvImportHelper {
    private static final Log log = LogFactory.getLog(NoCodeCsvReader.class);
    private static final DistributeSessionlessCache csvInfoCacheInRedis = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("NOCODE_CSV_IMPORT", new DistributeCacheHAPolicy(true, true));
    private static final String FIELDTYPE = "fieldType";

    public static CsvDataInfo buildImportPreviewData(String formId, String url, CsvDataInfo previewData, boolean isUpdate, List<String> updateConds, Map<String, Map<String, Object>> config) {
        CsvImportHelper.completeConfig(formId, url, config, previewData);
        CustomImportHelper.checkConfig(config);
        boolean size = false;
        if (isUpdate && CollectionUtil.isNotEmpty(updateConds)) {
            QFilter qFilter = CustomImportHelper.createQFilterForCsv(updateConds, config, previewData, formId);
            DynamicObject[] alreadyExistBillData = BusinessDataServiceHelper.load((String)formId, (String)("id," + String.join((CharSequence)",", updateConds)), (QFilter[])new QFilter[]{qFilter});
            Map<String, String> rowUpdateBasisMap = CustomImportHelper.getRowUpdateBasis(formId, updateConds, config, alreadyExistBillData);
            List<CsvRowInfo> csvRowInfoList = previewData.getImportRows();
            for (CsvRowInfo csvRowInfo : csvRowInfoList) {
                List<CsvCellInfo> csvCellInfos = csvRowInfo.getCellInfos();
                StringBuilder curValue = new StringBuilder();
                for (String updateCond : updateConds) {
                    curValue.append(csvCellInfos.get(Integer.parseInt(config.get(updateCond).get("seq").toString())).getCellValue());
                }
                if (rowUpdateBasisMap.containsKey(curValue.toString())) {
                    csvCellInfos.add(new CsvCellInfo(String.valueOf(csvCellInfos.size()), ResManager.loadKDString((String)"\u66ff\u6362", (String)"CsvImportHelper_0", (String)"bos-nocode-service", (Object[])new Object[0]), true));
                    csvRowInfo.setBillId(rowUpdateBasisMap.get(curValue.toString()));
                    continue;
                }
                csvCellInfos.add(new CsvCellInfo(String.valueOf(csvCellInfos.size()), ResManager.loadKDString((String)"\u65b0\u589e", (String)"CsvImportHelper_1", (String)"bos-nocode-service", (Object[])new Object[0]), true));
            }
        } else {
            for (CsvRowInfo csvRowInfo : previewData.getImportRows()) {
                List<CsvCellInfo> csvCellInfos = csvRowInfo.getCellInfos();
                csvCellInfos.add(new CsvCellInfo(String.valueOf(csvCellInfos.size()), ResManager.loadKDString((String)"\u65b0\u589e", (String)"CsvImportHelper_1", (String)"bos-nocode-service", (Object[])new Object[0]), true));
            }
        }
        CsvRowInfo csvHead = previewData.getImportHead();
        List<CsvCellInfo> csvCellInfos = csvHead.getCellInfos();
        csvCellInfos.add(new CsvCellInfo(String.valueOf(csvCellInfos.size()), ResManager.loadKDString((String)"\u6807\u7b7e", (String)"CsvImportHelper_2", (String)"bos-nocode-service", (Object[])new Object[0]), true));
        CsvImportHelper.checkPreviewData(config, previewData.getImportRows(), formId);
        return previewData;
    }

    private static void completeConfig(String formId, String url, Map<String, Map<String, Object>> config, CsvDataInfo previewData) {
        String cacheFormConfigStr = (String)csvInfoCacheInRedis.get(url + "nocode_customimport_form_config_by_" + formId);
        List<RestApiPropertyConfigResult> perpropConfig = cacheFormConfigStr != null ? SerializationUtils.fromJsonStringToList((String)cacheFormConfigStr, RestApiPropertyConfigResult.class) : CustomImportHelper.buildRestApiPropertyConfigResults(formId, url);
        CustomImportHelper.resetConfig(config, perpropConfig);
        CsvImportHelper.reMappingHead(previewData.getImportHead(), config);
        CsvImportHelper.reMappingRows(previewData.getImportRows(), config);
    }

    private static void reMappingHead(CsvRowInfo csvHead, Map<String, Map<String, Object>> config) {
        try {
            List<CsvCellInfo> csvHeadCells = csvHead.getCellInfos();
            ArrayList<CsvCellInfo> newCsvHeadRows = new ArrayList<CsvCellInfo>();
            int newSeq = 0;
            for (CsvCellInfo cellInfo : csvHeadCells) {
                String seq = cellInfo.getSeq();
                for (String billFieldId : config.keySet()) {
                    Map<String, Object> fieldMatchConfig = config.get(billFieldId);
                    if (!seq.equals(fieldMatchConfig.get("seq"))) continue;
                    boolean dataAutoOptions = CustomImportHelper.isDataAutoOptions(fieldMatchConfig);
                    cellInfo.setDataAutoOptions(dataAutoOptions);
                    CsvCellInfo information = new CsvCellInfo();
                    BeanUtils.copyProperties((Object)information, (Object)cellInfo);
                    information.setCellValue(fieldMatchConfig.get("fieldName").toString());
                    information.setBillFieldId(billFieldId);
                    information.setSeq(String.valueOf(newSeq));
                    ++newSeq;
                    newCsvHeadRows.add(information);
                }
            }
            csvHead.getCellInfos().clear();
            csvHead.setCellInfos(newCsvHeadRows);
        }
        catch (Exception e) {
            log.debug("reMappingHead error:", (Object)e);
        }
    }

    private static void reMappingRows(List<CsvRowInfo> csvRowInfoList, Map<String, Map<String, Object>> config) {
        try {
            HashMap<String, String> seqMapping = new HashMap<String, String>();
            for (CsvRowInfo csvRowInfo : csvRowInfoList) {
                List<CsvCellInfo> csvPerRowCells = csvRowInfo.getCellInfos();
                ArrayList<CsvCellInfo> newCsvRows = new ArrayList<CsvCellInfo>();
                int newSeq = 0;
                for (CsvCellInfo cellInfo : csvPerRowCells) {
                    String seq = cellInfo.getSeq();
                    for (String billFieldId : config.keySet()) {
                        Map<String, Object> fieldMatchConfig = config.get(billFieldId);
                        if (!seq.equals(fieldMatchConfig.get("seq"))) continue;
                        boolean dataAutoOptions = CustomImportHelper.isDataAutoOptions(fieldMatchConfig);
                        CsvCellInfo copyCell = new CsvCellInfo();
                        BeanUtils.copyProperties((Object)copyCell, (Object)cellInfo);
                        copyCell.setDataAutoOptions(dataAutoOptions);
                        copyCell.setSeq(String.valueOf(newSeq));
                        seqMapping.put(billFieldId, String.valueOf(newSeq));
                        ++newSeq;
                        newCsvRows.add(copyCell);
                    }
                }
                csvRowInfo.getCellInfos().clear();
                csvRowInfo.setCellInfos(newCsvRows);
            }
            for (String billFieldId : config.keySet()) {
                String newSeq = (String)seqMapping.get(billFieldId);
                if (null == newSeq) continue;
                Map<String, Object> fieldMatchConfig = config.get(billFieldId);
                fieldMatchConfig.put("seq", newSeq);
            }
        }
        catch (Exception e) {
            log.debug("reMappingRows error:", (Object)e);
        }
    }

    private static void checkPreviewData(Map<String, Map<String, Object>> config, List<CsvRowInfo> csvRowInfoList, String formId) {
        for (CsvRowInfo csvRowInfo : csvRowInfoList) {
            List<CsvCellInfo> csvCellInfos = csvRowInfo.getCellInfos();
            boolean isRowError = false;
            for (String billFieldId : config.keySet()) {
                String fieldType;
                Map<String, Object> fieldMatchConfig = config.get(billFieldId);
                String colSeq = fieldMatchConfig.get("seq").toString();
                CsvCellInfo cellInfo = csvCellInfos.get(Integer.parseInt(colSeq));
                String cellValue = cellInfo.getCellValue();
                boolean isDataAutoCollect = CustomImportHelper.isDataAutoOptions(fieldMatchConfig);
                cellInfo.setDataAutoOptions(isDataAutoCollect);
                if ("image".equals(fieldMatchConfig.get(FIELDTYPE)) && (isRowError = CsvImportHelper.checkImage(csvCellInfos, cellInfo, cellValue))) {
                    csvRowInfo.setError(true);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)cellValue) || "text".equalsIgnoreCase(fieldType = fieldMatchConfig.get(FIELDTYPE).toString()) || "unknown".equalsIgnoreCase(fieldType)) continue;
                if ("date".equalsIgnoreCase(fieldType)) {
                    boolean bl = isRowError = CsvImportHelper.checkDateFormat(csvCellInfos, fieldMatchConfig, cellInfo, cellValue) || isRowError;
                    if (isRowError) {
                        csvRowInfo.setError(true);
                        continue;
                    }
                }
                if ("number".equalsIgnoreCase(fieldType)) {
                    boolean bl = isRowError = CsvImportHelper.checkNumberFormat(formId, billFieldId, csvCellInfos, cellInfo, cellValue) || isRowError;
                    if (isRowError) {
                        csvRowInfo.setError(true);
                        continue;
                    }
                }
                if (CustomImportHelper.isRefBill(fieldType)) {
                    boolean bl = isRowError = CsvImportHelper.checkRefBill(formId, csvCellInfos, billFieldId, fieldMatchConfig, cellInfo, cellValue) || isRowError;
                    if (isRowError) {
                        csvRowInfo.setError(true);
                        continue;
                    }
                }
                if (!"combo".equalsIgnoreCase(fieldType) || !(isRowError = CsvImportHelper.checkCombo(formId, csvCellInfos, billFieldId, fieldMatchConfig, cellInfo, cellValue, isDataAutoCollect) || isRowError)) continue;
                csvRowInfo.setError(true);
            }
        }
    }

    private static boolean checkImage(List<CsvCellInfo> csvCellInfos, CsvCellInfo csvCellInfo, String cellValue) {
        boolean isCellError = false;
        if (StringUtils.isNotBlank((CharSequence)cellValue)) {
            String cellErrMsg = ResManager.loadKDString((String)"\u56fe\u7247\u683c\u5f0f\u9519\u8bef", (String)"CsvImportHelper_3", (String)"bos-nocode-service", (Object[])new Object[0]);
            CsvImportHelper.buildCellErrMsg(csvCellInfos, csvCellInfo, cellErrMsg);
            isCellError = true;
        }
        return isCellError;
    }

    private static boolean checkDateFormat(List<CsvCellInfo> csvCellInfos, Map<String, Object> fieldMatchConfig, CsvCellInfo csvCellInfo, String cellValue) {
        boolean isCellError = false;
        try {
            Date date = DateTimeUtils.loopParse((String)cellValue);
            String formatString = DateTimeUtils.getFormatString((String)((String)fieldMatchConfig.get("formatType")));
            String dateStr = new SimpleDateFormat(formatString).format(date);
            csvCellInfo.setCellValue(dateStr);
        }
        catch (Exception e) {
            String cellErrMsg = ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef", (String)"CsvImportHelper_4", (String)"bos-nocode-service", (Object[])new Object[0]);
            CsvImportHelper.buildCellErrMsg(csvCellInfos, csvCellInfo, cellErrMsg);
            isCellError = true;
        }
        return isCellError;
    }

    private static boolean checkNumberFormat(String formId, String billFieldId, List<CsvCellInfo> csvCellInfos, CsvCellInfo csvCellInfo, String cellValue) {
        boolean isCellError = false;
        String cellErrMsg = "";
        try {
            new BigDecimal(cellValue);
        }
        catch (NumberFormatException e) {
            cellErrMsg = ResManager.loadKDString((String)"\u6570\u503c\u683c\u5f0f\u9519\u8bef", (String)"CsvImportHelper_5", (String)"bos-nocode-service", (Object[])new Object[0]);
            CsvImportHelper.buildCellErrMsg(csvCellInfos, csvCellInfo, cellErrMsg);
            isCellError = true;
        }
        if (StringUtils.isBlank((CharSequence)cellErrMsg)) {
            DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)formId).getProperties();
            IDataEntityProperty prop = (IDataEntityProperty)properties.get((Object)billFieldId);
            BigDecimal decimal = new BigDecimal(cellValue);
            int integerCheck = decimal.precision() - decimal.scale();
            int precision = ((NoCodeDecimalProp)prop).getPrecision();
            int decimalCheck = decimal.scale();
            int scale = ((NoCodeDecimalProp)prop).getScale();
            if (integerCheck > precision || decimalCheck > scale) {
                cellErrMsg = ResManager.loadKDString((String)"\u7cbe\u5ea6\u8d85\u51fa\u9650\u5236", (String)"CsvImportHelper_6", (String)"bos-nocode-service", (Object[])new Object[0]);
                CsvImportHelper.buildCellErrMsg(csvCellInfos, csvCellInfo, cellErrMsg);
                isCellError = true;
            }
        }
        return isCellError;
    }

    private static boolean checkRefBill(String formId, List<CsvCellInfo> csvCellInfos, String billFieldId, Map<String, Object> fieldMatchConfig, CsvCellInfo csvCellInfo, String cellValue) {
        boolean isCellError = false;
        String billMatchCond = fieldMatchConfig.get("billMatchCond").toString();
        String split = "";
        if (fieldMatchConfig.get("split") != null) {
            split = fieldMatchConfig.get("split").toString();
        }
        String[] values = null;
        values = StringUtils.isBlank((CharSequence)split) ? new String[]{cellValue} : cellValue.split(CustomImportHelper.quoteReplacement(split));
        INoCodeRefBillProp property = (INoCodeRefBillProp)EntityMetadataCache.getDataEntityType((String)formId).getProperty(billFieldId);
        String billEntityNumber = property.getBillEntityNumber();
        Object[] condition = CustomImportHelper.transQueryCondition(fieldMatchConfig, billMatchCond, values);
        Map refBillMap = BusinessDataServiceHelper.loadFromCache((String)billEntityNumber, (String)("id," + billMatchCond), (QFilter[])new QFilter[]{new QFilter(billMatchCond, "in", (Object)condition)});
        HashMap<String, String> refBillValues = new HashMap<String, String>(refBillMap.size());
        for (Map.Entry refBill : refBillMap.entrySet()) {
            Object dataBaseValue = ((DynamicObject)refBill.getValue()).get(billMatchCond);
            if (dataBaseValue instanceof BigDecimal) {
                refBillValues.put(CustomImportHelper.dealBigDecimal((BigDecimal)dataBaseValue), refBill.getKey().toString());
                continue;
            }
            refBillValues.put(((DynamicObject)refBill.getValue()).getString(billMatchCond), refBill.getKey().toString());
        }
        LinkedHashSet refBillIds = new LinkedHashSet();
        for (String refBillValue : values) {
            if (!refBillValues.containsKey(refBillValue)) {
                String cellErrMsg = ResManager.loadKDString((String)"\u5173\u8054\u8868\u5355\u4e0d\u5b58\u5728", (String)"CsvImportHelper_7", (String)"bos-nocode-service", (Object[])new Object[0]);
                CsvImportHelper.buildCellErrMsg(csvCellInfos, csvCellInfo, cellErrMsg);
                isCellError = true;
                break;
            }
            refBillIds.add(refBillValues.get(refBillValue));
        }
        if (refBillIds.size() <= values.length) {
            csvCellInfo.setRefBillId(String.join((CharSequence)",", refBillIds));
        }
        return isCellError;
    }

    private static boolean checkCombo(String formId, List<CsvCellInfo> csvCellInfos, String billFieldId, Map<String, Object> fieldMatchConfig, CsvCellInfo csvCellInfo, String cellValue, boolean isDataAutoCollect) {
        boolean isCellError = false;
        String split = "";
        if (fieldMatchConfig.get("split") != null) {
            split = fieldMatchConfig.get("split").toString();
        }
        Map<String, String> selectValues = CustomImportHelper.getSelectValues(formId, billFieldId);
        String[] comboValues = StringUtils.isBlank((CharSequence)split) ? new String[]{cellValue} : cellValue.split(CustomImportHelper.quoteReplacement(split));
        HashSet<String> existSelectVals = new HashSet<String>();
        for (String comboValue : comboValues) {
            if (!selectValues.containsKey(comboValue)) {
                if (!isDataAutoCollect) {
                    String cellErrMsg = ResManager.loadKDString((String)"\u9009\u9879\u4e0d\u5b58\u5728", (String)"CsvImportHelper_8", (String)"bos-nocode-service", (Object[])new Object[0]);
                    CsvImportHelper.buildCellErrMsg(csvCellInfos, csvCellInfo, cellErrMsg);
                    isCellError = true;
                    continue;
                }
                try {
                    existSelectVals.add(URLCodecUtils.encode((String)comboValue));
                }
                catch (Exception e) {
                    existSelectVals.add(comboValue);
                }
                continue;
            }
            existSelectVals.add(selectValues.get(comboValue));
        }
        csvCellInfo.setSelectValue(String.join((CharSequence)",", existSelectVals));
        csvCellInfo.setDataAutoOptions(isDataAutoCollect);
        return isCellError;
    }

    private static void buildCellErrMsg(List<CsvCellInfo> csvCellInfos, CsvCellInfo csvCellInfo, String cellErrMsg) {
        csvCellInfo.setError(true);
        csvCellInfo.setErrMessage(cellErrMsg);
        csvCellInfos.get(csvCellInfos.size() - 1).setCellValue(ResManager.loadKDString((String)"\u9519\u8bef", (String)"CsvImportHelper_9", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    public static List<DynamicObject> convertDataToDynamicObject(CsvDataInfo csvDataInfo, String formId) {
        LinkedList<DynamicObject> billObjs = new LinkedList<DynamicObject>();
        List<CsvCellInfo> headCellInfoList = csvDataInfo.getImportHead().getCellInfos();
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)formId).getProperties();
        for (CsvRowInfo csvRowInfo : csvDataInfo.getImportRows()) {
            String billId = csvRowInfo.getBillId();
            DynamicObject dyObj = StringUtils.isNotBlank((CharSequence)billId) ? BusinessDataServiceHelper.loadSingle((Object)billId, (String)formId) : BusinessDataServiceHelper.newDynamicObject((String)formId);
            for (CsvCellInfo cellInfo : csvRowInfo.getCellInfos()) {
                ArrayList<String> sameCellMappingId = new ArrayList<String>();
                for (CsvCellInfo csvHeadCellInfo : headCellInfoList) {
                    if (!StringUtils.equals((CharSequence)csvHeadCellInfo.getSeq(), (CharSequence)cellInfo.getSeq())) continue;
                    sameCellMappingId.add(csvHeadCellInfo.getBillFieldId());
                }
                if (CollectionUtil.isEmpty(sameCellMappingId)) continue;
                for (String billFieldId : sameCellMappingId) {
                    if (StringUtils.isBlank((CharSequence)billFieldId)) continue;
                    IDataEntityProperty prop = (IDataEntityProperty)properties.get((Object)billFieldId);
                    String fieldType = CustomImportHelper.getDataType(prop);
                    String fieldValue = cellInfo.getCellValue();
                    if (CustomImportHelper.isRefBill(fieldType)) {
                        String refBillId = cellInfo.getRefBillId();
                        dyObj.set(billFieldId, (Object)refBillId);
                        continue;
                    }
                    if ("date".equalsIgnoreCase(fieldType)) {
                        try {
                            Date date = DateTimeUtils.loopParse((String)fieldValue);
                            dyObj.set(billFieldId, (Object)date);
                        }
                        catch (Exception e) {
                            log.warn((Throwable)e);
                        }
                        continue;
                    }
                    if ("combo".equalsIgnoreCase(fieldType)) {
                        String selectValue = cellInfo.getSelectValue();
                        dyObj.set(billFieldId, (Object)selectValue);
                        continue;
                    }
                    if (prop instanceof NoCodeDecimalProp && StringUtils.isBlank((CharSequence)fieldValue)) {
                        dyObj.set(billFieldId, null);
                        continue;
                    }
                    dyObj.set(billFieldId, (Object)fieldValue);
                }
            }
            for (IDataEntityProperty property : properties) {
                if (!(property instanceof NoCodeCreatorProp) && !(property instanceof NoCodeModifierProp) || null != dyObj.get(property.getName())) continue;
                dyObj.set(property.getName(), (Object)RequestContext.get().getCurrUserId());
            }
            billObjs.add(dyObj);
        }
        return billObjs;
    }

    public static String buildErrorReport(CsvDataInfo importData, OperationResult operationResult, String formId) {
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        List<CsvRowInfo> importRows = importData.getImportRows();
        LinkedList<CsvRowInfo> errorImportRows = new LinkedList<CsvRowInfo>();
        for (IOperateInfo errorInfo : allErrorOrValidateInfo) {
            int dataEntityIndex = ((OperateErrorInfo)errorInfo).getDataEntityIndex();
            String errMessage = errorInfo.getMessage();
            int index = importRows.size() - 1 - dataEntityIndex;
            if (index < 0 || index >= importRows.size()) continue;
            CsvRowInfo curErrorRow = importRows.get(index);
            if (StringUtils.isNotBlank((CharSequence)curErrorRow.getRowErrMsg())) {
                errMessage = curErrorRow.getRowErrMsg() + errMessage;
            } else {
                errorImportRows.add(curErrorRow);
            }
            curErrorRow.setRowErrMsg(errMessage);
        }
        return CsvImportHelper.buildCsv(importData.getImportHead(), errorImportRows, formId);
    }

    private static String buildCsv(CsvRowInfo csvHead, List<CsvRowInfo> errorImportRows, String formId) {
        String string;
        File csvFile = null;
        FileInputStream fis = null;
        PrintWriter printWriter = null;
        CSVPrinter csvPrinter = null;
        try {
            String fileName = CsvImportHelper.generateErrorReportName(formId) + ".csv";
            csvFile = File.createTempFile(fileName, "csv", null);
            printWriter = new PrintWriter(csvFile, "gbk");
            List<String> headNameList = csvHead.getCellInfos().stream().map(CsvCellInfo::getCellValue).collect(Collectors.toList());
            headNameList.add(0, ResManager.loadKDString((String)"\u9519\u8bef\u63cf\u8ff0", (String)"CsvImportHelper_10", (String)"bos-nocode-service", (Object[])new Object[0]));
            String[] headNames = headNameList.toArray(new String[0]);
            csvPrinter = CSVFormat.EXCEL.withHeader(headNames).print((Appendable)printWriter);
            for (CsvRowInfo csvRowInfo : errorImportRows) {
                List perRow = csvRowInfo.getCellInfos().stream().map(CsvCellInfo::getCellValue).collect(Collectors.toList());
                perRow.add(0, csvRowInfo.getRowErrMsg());
                csvPrinter.printRecord(perRow);
            }
            csvPrinter.flush();
            fis = new FileInputStream(csvFile);
            string = CustomImportHelper.upload(fileName, fis);
        }
        catch (Exception e) {
            try {
                log.debug("buildErrorReport failed", (Object)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u5bfc\u5165\u9519\u8bef\u6587\u4ef6\u5931\u8d25", (String)"CsvImportHelper_11", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            catch (Throwable throwable) {
                FileSecurityUtil.safeClose(fis);
                FileSecurityUtil.safeDeleteFile(csvFile);
                FileSecurityUtil.safeClose(printWriter);
                FileSecurityUtil.safeClose(csvPrinter);
                throw throwable;
            }
        }
        FileSecurityUtil.safeClose((Closeable)fis);
        FileSecurityUtil.safeDeleteFile((File)csvFile);
        FileSecurityUtil.safeClose((Closeable)printWriter);
        FileSecurityUtil.safeClose((Closeable)csvPrinter);
        return string;
    }

    private static String generateErrorReportName(String formId) {
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
        String formName = formConfig.getCaption().getLocaleValue();
        String dateStr = new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
        return ResManager.loadKDString((String)"\u3010%1$s\u3011\u5bfc\u5165\u9519\u8bef\u62a5\u544av%2$s", (String)"CsvImportHelper_13", (String)"bos-nocode-service", (Object[])new Object[]{formName, dateStr});
    }
}

