/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.customimport.csv;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.service.customimport.csv.dto.CsvCellInfo;
import kd.bos.nocode.restapi.service.customimport.csv.dto.CsvDataInfo;
import kd.bos.nocode.restapi.service.customimport.csv.dto.CsvRowInfo;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.StringUtils;

public class NoCodeCsvReader {
    private static final Log log = LogFactory.getLog(NoCodeCsvReader.class);
    private static final DistributeSessionlessCache csvInfoCacheInRedis = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("NOCODE_CSV_IMPORT", new DistributeCacheHAPolicy(true, true));

    public static CsvDataInfo getPreviewDataByCsv(String url, int startRow, int startCol, int pageSize, int pageNo) {
        CsvDataInfo csvDataInfo = new CsvDataInfo();
        String cacheDataStr = (String)csvInfoCacheInRedis.get(url + "_row_" + startRow + "_col_" + startCol);
        if (cacheDataStr != null) {
            csvDataInfo = (CsvDataInfo)SerializationUtils.fromJsonString((String)cacheDataStr, CsvDataInfo.class);
            return NoCodeCsvReader.pagingPreviewData(pageSize, pageNo, csvDataInfo);
        }
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream in = tempFileCache.getInputStream(url);
        try {
            CSVParser parser = CSVParser.parse((InputStream)in, (Charset)Charset.forName("GBK"), (CSVFormat)CSVFormat.DEFAULT);
            log.debug("get file available is:" + in.available());
            ArrayList<CsvRowInfo> csvRowInfoList = new ArrayList<CsvRowInfo>();
            List csvRecords = parser.getRecords();
            int maxImportRows = 0;
            int breakColumns = 150 + startCol;
            for (int i = startRow; i < csvRecords.size(); ++i) {
                CsvRowInfo csvRowInfo = new CsvRowInfo();
                CSVRecord csvRecord = (CSVRecord)csvRecords.get(i);
                ArrayList<CsvCellInfo> csvCellInfoList = new ArrayList<CsvCellInfo>();
                int maxImportColumns = 0;
                for (int j = startCol; j < csvRecord.size(); ++j) {
                    if (i == startRow && StringUtils.isEmpty((String)csvRecord.get(j))) {
                        breakColumns = j;
                    }
                    if (breakColumns <= j) break;
                    ++maxImportColumns;
                    CsvCellInfo csvCellInfo = new CsvCellInfo();
                    csvCellInfo.setSeq(String.valueOf(j - startCol));
                    csvCellInfo.setCellValue(csvRecord.get(j));
                    csvCellInfoList.add(csvCellInfo);
                    if (maxImportColumns == 150) break;
                }
                csvRowInfo.setCellInfos(csvCellInfoList);
                csvRowInfo.setRowSeq(String.valueOf(i - startRow));
                if (i == startRow) {
                    csvDataInfo.setImportHead(csvRowInfo);
                    continue;
                }
                boolean isNotEmptyRow = csvRowInfo.getCellInfos().stream().anyMatch(item -> StringUtils.isNotEmpty((String)item.getCellValue()));
                if (!isNotEmptyRow) break;
                csvRowInfoList.add(csvRowInfo);
                if (++maxImportRows == 1000) break;
            }
            csvDataInfo.setImportRows(csvRowInfoList);
            csvDataInfo.setTotalRow(csvRowInfoList.size());
            csvInfoCacheInRedis.put(url + "_row_" + startRow + "_col_" + startCol, (Object)SerializationUtils.toJsonString((Object)csvDataInfo), 1, TimeUnit.HOURS);
            CsvDataInfo csvDataInfo2 = NoCodeCsvReader.pagingPreviewData(pageSize, pageNo, csvDataInfo);
            return csvDataInfo2;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u89e3\u6790\u5931\u8d25", (String)"NoCodeCsvReader_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        finally {
            FileSecurityUtil.safeClose((Closeable)in);
        }
    }

    private static CsvDataInfo pagingPreviewData(int pageSize, int pageNo, CsvDataInfo csvDataInfo) {
        CsvDataInfo pagingData = new CsvDataInfo();
        List<CsvRowInfo> csvRows = csvDataInfo.getImportRows().stream().skip((long)(pageNo - 1) * (long)pageSize).limit(pageSize).collect(Collectors.toList());
        pagingData.setImportHead(csvDataInfo.getImportHead());
        pagingData.setImportRows(csvRows);
        pagingData.setTotalRow(csvDataInfo.getTotalRow());
        return pagingData;
    }
}

