/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.delete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.login.utils.StringUtils;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.restapi.api.DeleteRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiDeleteParam;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.result.RestApiDeleteResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestBaseFilterItemData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.CollectionUtil;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.service.sys.SysServiceHelpHandle;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.restapi.service.util.ListSchemaUtils;
import kd.bos.nocode.restapi.service.util.NoCodeOperationServiceHelper;
import kd.bos.nocode.restapi.service.wf.WfProcessDataService;
import kd.bos.nocode.util.NoCodeTemplateUtil;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.nocode.model.PermItemEnum;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class DeleteRestApiServiceImpl
implements DeleteRestApiService {
    private static final String QUERY_FILTER = "queryFilter";
    private static final String SEARCH = "search";
    private static final String ORDER_BY = "order_by";

    public RestApiServiceData<RestApiDeleteResult> execute(RestApiDeleteParam param) {
        Pair sysHandle = SysServiceHelpHandle.sysCustomHandle(param);
        if (((Boolean)sysHandle.getKey()).booleanValue()) {
            return (RestApiServiceData)sysHandle.getValue();
        }
        long start = System.currentTimeMillis();
        NoCodeTemplateUtil.templateCheck((RestApiParam)param);
        String formId = param.getFormId();
        NoCodePermHelper.verifyFuncPerm((FuncPermItemEnum)FuncPermItemEnum.delete, (String)formId);
        Pair<Boolean, QFilter[]> qFilterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
        Object[] filters = (QFilter[])qFilterPair.getValue();
        if (CollectionUtil.isEmpty((Object[])filters)) {
            throw new RestApiException(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u5220\u9664\u64cd\u4f5c\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeleteRestApiServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]), (String)"DeleteApiServiceImpl_0"));
        }
        String orderBy = (String)param.getRequest().getHttpQueryString().get(ORDER_BY);
        if (StringUtils.isEmpty((String)orderBy)) {
            orderBy = "id desc";
        }
        String schemaId = (String)param.getRequest().getHttpQueryString().get("schemaId");
        filters = ListSchemaUtils.getListDataFilter(param.getAppNumber(), formId, schemaId, (QFilter[])filters, false);
        List allSelectedPkIds = QueryServiceHelper.queryPrimaryKeys((String)formId, (QFilter[])filters, (String)orderBy, (int)Integer.MAX_VALUE);
        int handleTotal = allSelectedPkIds.size();
        if (handleTotal == 0) {
            throw new RestApiException(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u8981\u5220\u9664\u7684\u6570\u636e", (String)"DeleteRestApiServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]), (String)"DeleteApiServiceImpl_1"));
        }
        long uid = RequestContext.get().getCurrUserId();
        QFilter filter = NoCodePermissionServiceHelper.getDataRuleFilter((long)uid, (String)formId, (PermItemEnum)PermItemEnum.DELETE);
        List canDeleteIds = QueryServiceHelper.queryPrimaryKeys((String)formId, (QFilter[])(filters = (QFilter[])ArrayUtils.addAll((Object[])filters, (Object[])new QFilter[]{filter})), (String)orderBy, (int)Integer.MAX_VALUE);
        if (canDeleteIds.size() == Integer.MAX_VALUE) {
            throw new RestApiException(ResManager.loadKDString((String)"\u8981\u5220\u9664\u7684\u6570\u636e\u8d85\u8fc7\u6700\u5927\u503c %s, \u8bf7\u4fee\u6539\u5220\u9664\u6761\u4ef6", (String)"DeleteRestApiServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[]{Integer.MAX_VALUE}));
        }
        List notDeletePermPkIds = allSelectedPkIds.stream().filter(e -> !canDeleteIds.contains(e)).collect(Collectors.toList());
        List<Object> lockObjs = this.getLockObjects(formId, canDeleteIds);
        canDeleteIds.removeIf(lockObjs::contains);
        OperateOption option = OperateOption.create();
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)formId);
        OperationResult operationResult = NoCodeOperationServiceHelper.executeOperate("delete", formId, canDeleteIds.toArray(), option);
        RestApiDeleteResult result = new RestApiDeleteResult();
        result.setSuccessCount((long)operationResult.getSuccessPkIds().size());
        result.setFailCount((long)(handleTotal - operationResult.getSuccessPkIds().size()));
        result.setFilter(Arrays.toString(filters));
        result.setTotalCount((long)handleTotal);
        ArrayList<RestBaseFilterItemData> resultsData = new ArrayList<RestBaseFilterItemData>(canDeleteIds.size());
        result.setResult(resultsData);
        String queryFilter = (String)((Map)param.getRequest().getData()).get(QUERY_FILTER);
        QFilter[] tempFilter = FilterUtil.getQFilters(formId, queryFilter, (String)param.getRequest().getHttpQueryString().get(SEARCH));
        Map<Object, Integer> id2NumberMap = ListSchemaUtils.getId2NumberMap(param.getAppNumber(), formId, schemaId, orderBy, tempFilter);
        for (Object pkId : allSelectedPkIds) {
            RestBaseFilterItemData data;
            if (canDeleteIds.contains(pkId)) {
                this.handleRow(dt, operationResult, resultsData, pkId, id2NumberMap);
                continue;
            }
            if (lockObjs.contains(pkId)) {
                data = new RestBaseFilterItemData();
                data.setId(pkId.toString());
                data.setBillStatus(false);
                data.setBillIndex(id2NumberMap.get(pkId).intValue());
                data.getErrors().add(ResManager.loadKDString((String)"\u6d41\u7a0b\u9501\u5b9a\u4e2d\uff0c\u4e0d\u53ef\u5220\u9664", (String)"DeleteRestApiServiceImpl_3", (String)"bos-nocode-service", (Object[])new Object[0]));
                resultsData.add(data);
                continue;
            }
            if (!notDeletePermPkIds.contains(pkId)) continue;
            data = new RestBaseFilterItemData();
            data.setId(pkId.toString());
            data.setBillStatus(false);
            data.setBillIndex(id2NumberMap.get(pkId).intValue());
            data.getErrors().add(ResManager.loadKDString((String)"\u6ca1\u6709\u5220\u9664\u6743\u9650\uff0c\u4e0d\u53ef\u5220\u9664", (String)"DeleteRestApiServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[0]));
            resultsData.add(data);
        }
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)result);
        long end = System.currentTimeMillis();
        return RestApiServiceData.of((boolean)operationResult.isSuccess(), (RestApiResponse)response, (long)(end - start));
    }

    private List<Object> getLockObjects(String formId, List<Object> pkIds) {
        String selectFields = "id";
        if (CollectionUtils.isEmpty(pkIds)) {
            return new ArrayList<Object>(0);
        }
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)formId);
        boolean existLockStatusKey = NcEntityTypeUtil.existProperty((DynamicObjectType)dt, (String)WfConsts.WfLockStatusEnum.LOCK_STATUS_KEY);
        if (!existLockStatusKey) {
            return new ArrayList<Object>(0);
        }
        selectFields = selectFields.concat(",").concat(WfConsts.WfLockStatusEnum.LOCK_STATUS_KEY);
        DynamicObjectCollection returnFields = QueryServiceHelper.query((String)formId, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
        ArrayList<Object> lockObjs = new ArrayList<Object>(pkIds.size());
        for (DynamicObject returnField : returnFields) {
            if (!Objects.equals(returnField.getString(WfConsts.WfLockStatusEnum.LOCK_STATUS_KEY), WfConsts.WfLockStatusEnum.LOCKED.getCode())) continue;
            lockObjs.add(returnField.get("id"));
        }
        return lockObjs;
    }

    private void handleRow(BillEntityType dt, OperationResult operationResult, List<RestBaseFilterItemData> resultsData, Object pkId, Map<Object, Integer> id2NumberMap) {
        RestBaseFilterItemData data = new RestBaseFilterItemData();
        data.setId(pkId.toString());
        data.setNumber(pkId.toString());
        Optional<Object> first = operationResult.getSuccessPkIds().stream().filter(i -> i.equals(pkId)).findFirst();
        if (first == Optional.empty()) {
            for (IOperateInfo iOperateInfo : operationResult.getAllErrorOrValidateInfo().stream().filter(ev -> ev.getPkValue().equals(pkId)).collect(Collectors.toList())) {
                data.getErrors().add(iOperateInfo.getMessage());
                data.setBillIndex(id2NumberMap.get(pkId).intValue());
            }
        }
        boolean billStatus = first != Optional.empty();
        data.setBillStatus(billStatus);
        if (billStatus) {
            WfProcessDataService.create().deleteWfInfoByEntityNumberAndBusinessKey(dt.getName(), pkId.toString());
        }
        resultsData.add(data);
    }
}

