/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.impt;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.DecimalProp;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@SdkPublic
public abstract class AbstractNoCodeSheetHandler
extends SheetHandler {
    private static final int DATE_FORMAT_INDEX28 = 28;
    private static final int DATE_FORMAT_INDEX31 = 31;
    private static Log log = LogFactory.getLog(AbstractNoCodeSheetHandler.class);
    private static Pattern UpperCacePattern = Pattern.compile("[A-Z]");
    private static Pattern QuotationPattern = Pattern.compile("\"");
    private static Pattern SpecCharPattern = Pattern.compile("[\n`~!@#$^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5\u2026\u2026&*\uff08\uff09+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]");
    private static Pattern NotPrintCharPattern = Pattern.compile("[\\p{C}&&[^\\s]&&[^\n]&&[^\r][^\t]]");
    private Boolean readOriginalNum = Boolean.FALSE;
    private SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat msdatetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private boolean interrupt = true;
    private boolean numberFormat = false;
    private SharedStringsTable sst;
    private StylesTable stylesTable;
    private final DataFormatter formatter = new DataFormatter();
    private String lastContents;
    private SheetHandler.XSSFDataType nextDataType = SheetHandler.XSSFDataType.NUMBER;
    private Integer index;
    private SheetHandler.ParsedRow rowHolder;
    private SheetHandler.ParsedCol colHolder;
    private short formatIndex;
    private String formatString;
    private Set<SheetHandler.CellValidation> dataValidations = new HashSet<SheetHandler.CellValidation>();
    private SheetHandler.CellValidation currentValidation;
    private int rowCount;
    private Set<String> sheetNames = new HashSet<String>();
    private String sheetName;
    private Map<String, CommentsTable> sheetComments = new HashMap<String, CommentsTable>();

    public void setReadOriginalNum(Boolean readOriginalNum) {
        this.readOriginalNum = readOriginalNum;
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("dimension".equals(name)) {
            String refdata = attributes.getValue("ref");
            String rowCountStr = refdata.substring(refdata.indexOf(":") + 1, refdata.length()).toUpperCase();
            rowCountStr = UpperCacePattern.matcher(rowCountStr).replaceAll("");
            this.setRowCount(Integer.parseInt(rowCountStr));
        }
        if (name.equals("row")) {
            boolean hideRow = "1".equals(attributes.getValue("hidden"));
            this.getRowHolder().setHideRow(hideRow);
            this.getRowHolder().setRowNum(Integer.parseInt(attributes.getValue("r")) - 1);
        } else if ("col".equalsIgnoreCase(name)) {
            String width = attributes.getValue("width");
            String colNumMinStr = attributes.getValue("min");
            String colNumMaxStr = attributes.getValue("max");
            if (NumberUtils.isParsable((String)width) && NumberUtils.isParsable((String)colNumMinStr) && NumberUtils.isParsable((String)colNumMaxStr)) {
                int colNumMin = Integer.parseInt(colNumMinStr);
                int colNumMax = Integer.parseInt(colNumMaxStr);
                for (int i = colNumMin; i <= colNumMax; ++i) {
                    HashMap<String, String> colProperty = new HashMap<String, String>();
                    colProperty.put("colWidth", width);
                    this.getColHolder().getColProperty().put(i, colProperty);
                }
            }
        } else if (name.equals("c")) {
            String coordinate = attributes.getValue("r");
            CellReference cellReference = new CellReference(coordinate);
            this.index = cellReference.getCol();
            this.nextDataType = SheetHandler.XSSFDataType.NUMBER;
            this.formatIndex = (short)-1;
            this.formatString = null;
            String cellType = attributes.getValue("t");
            String cellStyleStr = attributes.getValue("s");
            if ("b".equals(cellType)) {
                this.nextDataType = SheetHandler.XSSFDataType.BOOL;
            } else if ("e".equals(cellType)) {
                this.nextDataType = SheetHandler.XSSFDataType.ERROR;
            } else if ("inlineStr".equals(cellType)) {
                this.nextDataType = SheetHandler.XSSFDataType.INLINESTR;
            } else if ("s".equals(cellType)) {
                this.nextDataType = SheetHandler.XSSFDataType.SSTINDEX;
            } else if ("str".equals(cellType)) {
                this.nextDataType = SheetHandler.XSSFDataType.FORMULA;
            } else if (cellStyleStr != null) {
                int styleIndex = Integer.parseInt(cellStyleStr);
                XSSFCellStyle style = this.stylesTable.getStyleAt(styleIndex);
                this.formatIndex = style.getDataFormat();
                this.formatString = style.getDataFormatString();
                if (this.formatString == null) {
                    this.formatString = BuiltinFormats.getBuiltinFormat((int)this.formatIndex);
                }
            }
        } else if ("dataValidation".equalsIgnoreCase(name)) {
            if ("list".equals(attributes.getValue("type"))) {
                this.currentValidation = new SheetHandler.CellValidation(this.sheetName);
                this.currentValidation.setRange(attributes.getValue("sqref"));
            }
        } else if ("x14:dataValidation".equalsIgnoreCase(name) && "list".equals(attributes.getValue("type"))) {
            this.currentValidation = new SheetHandler.CellValidation(this.sheetName);
        }
        this.lastContents = "";
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        boolean isDate = false;
        if ("formula1".equals(name)) {
            if (this.currentValidation != null) {
                String validationStr = QuotationPattern.matcher(this.lastContents).replaceAll("").trim();
                if (!validationStr.isEmpty()) {
                    this.currentValidation.setValidation(validationStr);
                    this.dataValidations.add(this.currentValidation);
                }
                this.currentValidation = null;
            }
        } else if ("xm:f".equalsIgnoreCase(name)) {
            if (this.currentValidation != null) {
                this.currentValidation.setValidation(this.lastContents);
            }
        } else if ("x14:dataValidation".equalsIgnoreCase(name)) {
            if (this.currentValidation != null) {
                this.currentValidation.setRange(this.lastContents);
                this.dataValidations.add(this.currentValidation);
                this.currentValidation = null;
            }
        } else if (name.equals("c")) {
            switch (this.nextDataType) {
                case BOOL: {
                    char first = this.lastContents.charAt(0);
                    this.lastContents = first == '0' ? "FALSE" : "TRUE";
                    break;
                }
                case ERROR: {
                    this.lastContents = "\"ERROR:" + this.lastContents + '\"';
                    break;
                }
                case FORMULA: {
                    break;
                }
                case INLINESTR: {
                    XSSFRichTextString rtsi = new XSSFRichTextString(this.lastContents);
                    this.lastContents = rtsi.toString();
                    break;
                }
                case SSTINDEX: {
                    String sstIndex = this.lastContents;
                    try {
                        int idx = Integer.parseInt(sstIndex);
                        RichTextString richTextString = this.sst.getItemAt(idx);
                        String string = richTextString.getString();
                        this.lastContents = string == null ? "" : string;
                    }
                    catch (NumberFormatException ex) {
                        log.debug("Failed to parse SST index '" + sstIndex + "': " + ex.toString());
                    }
                    break;
                }
                case NUMBER: {
                    if (!StringUtils.isNotBlank((CharSequence)this.lastContents)) break;
                    double n = Double.parseDouble(this.lastContents);
                    boolean isADateFormat = false;
                    try {
                        isADateFormat = DateUtil.isADateFormat((int)this.formatIndex, (String)this.formatString);
                    }
                    catch (Exception e) {
                        log.debug("this.formatIndex" + this.formatIndex + "-this.formatString:" + this.formatString);
                        log.warn((Throwable)e);
                        throw e;
                    }
                    if (isADateFormat || 31 == this.formatIndex || 28 == this.formatIndex || 58 == this.formatIndex) {
                        Date date = DateUtil.getJavaDate((double)n, (boolean)false, null, (boolean)true);
                        if (date == null) {
                            this.lastContents = String.valueOf(n);
                            break;
                        }
                        isDate = true;
                        String timestamp = String.valueOf(date.getTime());
                        this.lastContents = timestamp.endsWith("000") ? this.datetimeFormat.format(date) : this.msdatetimeFormat.format(date);
                        if (!StringUtils.equals((CharSequence)"yyyy\\-mm\\-dd", (CharSequence)this.formatString)) break;
                        this.lastContents = new SimpleDateFormat("yyyy-MM-dd").format(date);
                        break;
                    }
                    if (!this.readOriginalNum.booleanValue() && this.formatIndex >= 0 && StringUtils.isNotBlank((CharSequence)this.formatString)) {
                        this.lastContents = SpecCharPattern.matcher(this.formatter.formatRawCellContents(n, (int)this.formatIndex, this.formatString)).replaceAll("");
                        if (this.lastContents != null && this.lastContents.endsWith("%")) {
                            this.lastContents = DecimalProp.percentToDoubleString((String)this.lastContents);
                        }
                        boolean isNegative = n < 0.0;
                        try {
                            n = Double.parseDouble(this.lastContents);
                        }
                        catch (NumberFormatException e) {
                            log.debug("excel\u89e3\u6790\u6570\u5b57\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
                        }
                        if (isNegative && n >= 0.0) {
                            n = -n;
                        }
                    }
                    this.lastContents = new BigDecimal(Double.toString(n)).stripTrailingZeros().toPlainString();
                    break;
                }
                default: {
                    this.lastContents = "(TODO: Unexpected type: " + this.nextDataType + ")";
                }
            }
            this.lastContents = NotPrintCharPattern.matcher(this.lastContents).replaceAll("").trim();
            if (this.lastContents.isEmpty()) {
                return;
            }
            this.getRowHolder().getData().put(this.index, this.isAllowSetNULL() && "NULL".equals(this.lastContents) ? null : this.lastContents);
            this.getRowHolder().getTypes().put(this.index, this.nextDataType);
            JSONObject style = new JSONObject();
            style.put("isDate", (Object)isDate);
            if (StringUtils.isNotBlank((CharSequence)this.formatString)) {
                style.put("fmt", (Object)this.formatString);
            }
            this.getRowHolder().getStyles().put(this.index, style);
        } else if (name.equals("row")) {
            this.handleRow(this.getRowHolder());
            this.setRowHolder(new SheetHandler.ParsedRow(this.sheetName));
        }
    }

    @SdkInternal
    protected Map<String, Object> getOption() {
        return new HashMap<String, Object>();
    }

    private boolean isAllowSetNULL() {
        Map<String, Object> option = this.getOption();
        return option != null && Boolean.TRUE.equals(option.get("SetNULL"));
    }

    public abstract void handleRow(SheetHandler.ParsedRow var1);

    public void handleDataValidation(Set<SheetHandler.CellValidation> dataValidations) {
    }

    public void handleSheetComments(Map<String, CommentsTable> sheetComments) {
    }

    public void endDocument() throws SAXException {
        this.handleDataValidation(this.dataValidations);
        this.dataValidations.clear();
        this.handleSheetComments(this.sheetComments);
    }

    public void addSheetComments(String sheetName, CommentsTable comments) {
        this.sheetComments.put(sheetName, comments);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastContents = this.lastContents + new String(ch, start, length);
    }

    public boolean isInterrupt() {
        return this.interrupt;
    }

    public void setInterrupt(boolean interrupt) {
        this.interrupt = interrupt;
    }

    public void setSharedStringsTable(SharedStringsTable sst) {
        this.sst = sst;
    }

    @SdkInternal
    public StylesTable getStylesTable() {
        return this.stylesTable;
    }

    @SdkInternal
    public void setStylesTable(StylesTable stylesTable) {
        this.stylesTable = stylesTable;
    }

    @SdkInternal
    public SharedStringsTable getSharedStringsTable() {
        return this.sst;
    }

    @SdkInternal
    public SheetHandler.ParsedRow getRowHolder() {
        return this.rowHolder;
    }

    @SdkInternal
    public void setRowHolder(SheetHandler.ParsedRow holder) {
        this.rowHolder = holder;
    }

    @SdkInternal
    public SheetHandler.ParsedCol getColHolder() {
        return this.colHolder;
    }

    @SdkInternal
    public void setColHolder(SheetHandler.ParsedCol colHolder) {
        this.colHolder = colHolder;
    }

    @SdkInternal
    public boolean isNumberFormat() {
        return this.numberFormat;
    }

    @SdkInternal
    public void setNumberFormat(boolean numberFormat) {
        this.numberFormat = numberFormat;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public Set<String> getSheetNames() {
        return this.sheetNames;
    }

    public void setSheetNames(Set<String> sheetNames) {
        this.sheetNames = sheetNames;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
        this.rowHolder = new SheetHandler.ParsedRow(sheetName);
        this.colHolder = new SheetHandler.ParsedCol();
    }
}

