/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.impt;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.nocode.design.NoCodeDesignerData;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDateField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDecimalField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeImageUploadField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeImportFieldEnum;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeMulRefBillField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeSelectItemField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeTextAreaField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeTextField;
import kd.bos.nocode.ext.metadata.form.control.NoCodeDateFieldAp;
import kd.bos.nocode.ext.metadata.form.control.NoCodeFieldAp;
import kd.bos.nocode.ext.metadata.form.control.NoCodeImageUploadFieldAp;
import kd.bos.nocode.ext.metadata.form.control.NoCodeSelectItemFieldAp;
import kd.bos.nocode.ext.metadata.form.control.NoCodeTextAreaAp;
import kd.bos.nocode.ext.metadata.form.control.NoCodeTextFieldAp;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.constant.RestApiConstant;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.customimport.CustomImportHelper;
import kd.bos.nocode.restapi.service.sys.SysFormMetaServiceImpl;

public class ExcelCreateFormSaveApiServiceImpl
implements SaveRestApiService {
    private static final Log logger = LogFactory.getLog(ExcelCreateFormSaveApiServiceImpl.class);
    private static final int FIELD_COUNT_NORMAL_LEVEL = 16;
    private static final int TEXT_LENGTH = 100;
    private static final int TEXTAREA_LENGTH = 400;
    private static final String REGEX = "/excel/create/save?";
    private static final Pattern PATTERN = Pattern.compile("/excel/create/save?");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
        long startTime = System.currentTimeMillis();
        ArrayList<RestApiSaveItemData> saveItemDataList = new ArrayList<RestApiSaveItemData>(10);
        for (Map item : param.getDataList()) {
            RestApiSaveItemData saveItemData = new RestApiSaveItemData();
            String appId = (String)item.get("appId");
            String formId = item.getOrDefault("formId", "");
            List fields = (List)item.get("fields");
            String url = item.get("fileUrl").toString();
            String sheetName = item.get("sheetName").toString();
            int row = Integer.parseInt(String.valueOf(item.get("row")));
            int col = Integer.parseInt(String.valueOf(item.get("col")));
            String formName = (String)item.get("name");
            item.put("enabled", Boolean.FALSE);
            param.setAppNumber(appId);
            String formNumber = formId;
            boolean isUpdate = false;
            if (StringUtils.isEmpty((CharSequence)formId)) {
                RestApiServiceData<RestApiSaveResult> formCreateResult = new SysFormMetaServiceImpl.FormMetaServiceSaveImpl().execute(param);
                if (!formCreateResult.isStatus()) return formCreateResult;
                formNumber = ((RestApiSaveItemData)((RestApiSaveResult)formCreateResult.getResponse().getData()).getResult().get(0)).getNumber();
                this.addFieldItem(formNumber, fields);
            } else {
                this.updateFieldItem(formNumber, fields, url, row, col, sheetName, formName);
                isUpdate = true;
            }
            saveItemData.setId(formNumber);
            saveItemData.setNumber(formNumber);
            saveItemData.setBillStatus(true);
            saveItemData.setType(isUpdate ? "Update" : "Add");
            saveItemDataList.add(saveItemData);
        }
        return this.getSaveResultData(saveItemDataList, startTime);
    }

    private void addFieldItem(String formId, List<Map<String, Object>> fields) {
        LinkedHashMap field2FieldAp = new LinkedHashMap(fields.size());
        for (Map<String, Object> field : fields) {
            this.addField(field2FieldAp, field, fields.size());
        }
        String errMsg = new NoCodeDesignerData().addFields2RootPrepend(formId, field2FieldAp);
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            throw new RestApiException(errMsg);
        }
    }

    private void updateFieldItem(String formNumber, List<Map<String, Object>> fields, String url, int row, int col, String sheetName, String formName) {
        LinkedHashMap field2FieldAp = new LinkedHashMap(fields.size());
        for (Map<String, Object> field : fields) {
            this.addField(field2FieldAp, field, fields.size());
        }
        String errMsg = new NoCodeDesignerData().updateFieldItem(formNumber, field2FieldAp, formName);
        CustomImportHelper.getCache().remove(url + "nocode_customimport_form_config_by_" + formNumber);
        CustomImportHelper.getCache().remove(url + "_nocode_preview_data_" + sheetName + "_row_" + (row - 1) + "_col_" + (col - 1));
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            throw new RestApiException(errMsg);
        }
    }

    private RestApiServiceData<RestApiSaveResult> getSaveResultData(List<RestApiSaveItemData> saveItemDataList, long startTime) {
        RestApiSaveResult result = new RestApiSaveResult(saveItemDataList);
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)result);
        long endTime = System.currentTimeMillis();
        boolean allMatch = saveItemDataList.stream().allMatch(RestApiSaveItemData::isBillStatus);
        if (allMatch) {
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)(endTime - startTime));
        }
        return RestApiServiceData.ofFalse((String)RestApiErrorCode.ERROR.getStatusCode(), (String)RestApiConstant.getOperationfalsemessage(), (RestApiResponse)response, (long)(endTime - startTime));
    }

    private void addField(Map<Field<?>, FieldAp> field2FieldAp, Map<String, Object> field, int fieldCount) {
        NoCodeTextFieldAp fieldAp;
        NoCodeTextField fieldItem;
        boolean tooMuchFieldFlag;
        String number = (String)field.get("number");
        String name = (String)field.get("name");
        String type = (String)field.get("type");
        String id = (String)field.get("id");
        boolean bl = tooMuchFieldFlag = fieldCount > 16;
        if (type.equalsIgnoreCase(NoCodeImportFieldEnum.NoCodeTextField.getType())) {
            fieldItem = new NoCodeTextField();
            if (tooMuchFieldFlag) {
                fieldItem.setMaxLength(100);
            }
            fieldAp = new NoCodeTextFieldAp();
        } else if (type.equalsIgnoreCase(NoCodeImportFieldEnum.NoCodeTextAreaField.getType())) {
            fieldItem = new NoCodeTextAreaField();
            if (tooMuchFieldFlag) {
                ((NoCodeTextAreaField)fieldItem).setMaxLength(400);
            }
            fieldAp = new NoCodeTextAreaAp();
        } else if (type.equalsIgnoreCase(NoCodeImportFieldEnum.NoCodeSelectItemField.getType())) {
            int selectItemType = (Integer)field.getOrDefault("selectItemType", 0);
            String split = (String)field.getOrDefault("split", "");
            NoCodeSelectItemField selectItemField = new NoCodeSelectItemField();
            selectItemField.setSelectItemType(selectItemType);
            selectItemField.setDelimiter(split);
            fieldItem = selectItemField;
            fieldAp = new NoCodeSelectItemFieldAp();
        } else if (type.equalsIgnoreCase(NoCodeImportFieldEnum.NoCodeImageUploadField.getType())) {
            fieldItem = new NoCodeImageUploadField();
            fieldAp = new NoCodeImageUploadFieldAp();
        } else if (type.equalsIgnoreCase(NoCodeImportFieldEnum.NoCodeMulRefBillField.getType())) {
            int multi = (Integer)field.getOrDefault("multi", 0);
            String split = (String)field.getOrDefault("split", "");
            String billEntityIdEx = (String)field.getOrDefault("billEntityIdEx", "");
            String propsDisplay = (String)field.getOrDefault("propsDisplay", "");
            NoCodeMulRefBillField noCodeMulRefBillField = new NoCodeMulRefBillField();
            noCodeMulRefBillField.setBillEntityIdEx(billEntityIdEx);
            noCodeMulRefBillField.setPropsDisplay(propsDisplay);
            noCodeMulRefBillField.setDelimiter(split);
            noCodeMulRefBillField.setMulti(multi);
            fieldItem = noCodeMulRefBillField;
            fieldAp = new NoCodeFieldAp();
        } else if (type.equalsIgnoreCase(NoCodeImportFieldEnum.NoCodeDecimalField.getType())) {
            fieldItem = new NoCodeDecimalField();
            fieldAp = new NoCodeFieldAp();
        } else if (type.equalsIgnoreCase(NoCodeImportFieldEnum.NoCodeDateField.getType())) {
            String formatType = (String)field.getOrDefault("formatType", "1");
            NoCodeDateField noCodeDateField = new NoCodeDateField();
            noCodeDateField.setFormatType(formatType);
            fieldItem = noCodeDateField;
            fieldAp = new NoCodeDateFieldAp();
        } else {
            throw new RestApiException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u5b57\u6bb5\u7c7b\u578b\uff1a%s", (String)"ExcelCreateFormSaveApiServiceImpl_0", (String)"BOS_NOCODE", (Object[])new Object[]{type}));
        }
        fieldItem.setId(id);
        fieldItem.setKey(number);
        fieldItem.setName(new LocaleString(name));
        fieldAp.setId(id);
        fieldAp.setFieldId(id);
        fieldAp.setField((Field)fieldItem);
        fieldAp.setKey(number);
        fieldAp.setName(new LocaleString(name));
        field2FieldAp.put((Field<?>)fieldItem, (FieldAp)fieldAp);
    }

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }
}

