/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.impt;

import com.alibaba.fastjson.JSONObject;
import com.cronutils.utils.StringUtils;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDateField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDecimalField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeImportFieldEnum;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.impt.AbstractNoCodeSheetHandler;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ExcelCreatePreviewApiServiceImpl
implements QueryRestApiService {
    private static final Log logger = LogFactory.getLog(ExcelCreatePreviewApiServiceImpl.class);
    public static final String PARENT_ID = "parentId";
    private static final String REGEX = "/excel/create/preview?";
    private static final Pattern PATTERN = Pattern.compile("/excel/create/preview?");

    public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
        final LinkedHashMap sheets = new LinkedHashMap(3);
        long startTime = System.currentTimeMillis();
        String fileUrl = (String)((Map)param.getRequest().getData()).get("fileUrl");
        String appId = (String)((Map)param.getRequest().getData()).get("appId");
        final int startRow = Integer.parseInt(((Map)param.getRequest().getData()).getOrDefault("row", "1")) - 1;
        final int startCol = Integer.parseInt(((Map)param.getRequest().getData()).getOrDefault("col", "1")) - 1;
        final String sheetName = (String)((Map)param.getRequest().getData()).get("sheetName");
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (InputStream in = tempFileCache.getInputStream(fileUrl);){
            AbstractNoCodeSheetHandler sheetHandler = new AbstractNoCodeSheetHandler(){

                @Override
                public void handleRow(SheetHandler.ParsedRow row) {
                    ExcelCreatePreviewApiServiceImpl.this.handleDataRow(row, sheets, startRow, startCol, sheetName);
                }

                @Override
                public boolean isInterrupt() {
                    return false;
                }
            };
            new ExcelReader().read(in, (SheetHandler)sheetHandler, false);
        }
        catch (Exception e) {
            String IMPORT_ERROR = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25", (String)"ExcelCreatePreviewApiServiceImpl_0", (String)"BOS_NOCODE", (Object[])new Object[0]);
            logger.debug(IMPORT_ERROR, (Object)e);
            throw new RestApiException(IMPORT_ERROR);
        }
        ArrayList rows = new ArrayList(sheets.size());
        rows.addAll(sheets.values());
        List<Map<String, String>> importFieldTypes = this.getImportFieldTypes();
        HashMap<String, List<Map<String, Object>>> resultMap = new HashMap<String, List<Map<String, Object>>>(2);
        resultMap.put("importFieldTypes", importFieldTypes);
        resultMap.put("sheetData", rows);
        resultMap.put("groups", this.getGroups(appId));
        long endTime = System.currentTimeMillis();
        return RestApiServiceData.ofTrue(this.getQueryResponse(Lists.newArrayList((Object[])new Map[]{resultMap})), (long)startTime, (long)endTime);
    }

    private List<Map<String, Object>> getGroups(String appId) {
        ArrayList<Map<String, Object>> menus = new ArrayList<Map<String, Object>>(10);
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)appId);
        List appMenus = appMetadata.getAppMenus();
        for (AppMenuElement appMenu : appMenus) {
            HashMap<String, String> itemMap = new HashMap<String, String>(2);
            String name = appMenu.getName().getLocaleValue();
            String id = appMenu.getId();
            String parentId = appMenu.getParentId();
            String formId = appMenu.getFormId();
            if (!StringUtils.isEmpty((CharSequence)formId)) continue;
            itemMap.put("key", id);
            itemMap.put("title", name);
            itemMap.put(PARENT_ID, parentId);
            menus.add(itemMap);
        }
        return this.buildTreeMenu(appId, menus);
    }

    private List<Map<String, Object>> buildTreeMenu(String appId, List<Map<String, Object>> menus) {
        return menus.stream().filter(menu -> menu.get(PARENT_ID).equals(appId)).peek(menu -> menu.put("children", this.getChildren((String)menu.get("key"), menus))).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getChildren(String key, List<Map<String, Object>> menus) {
        return menus.stream().filter(menu -> menu.get(PARENT_ID).equals(key)).peek(menu -> menu.put("children", this.getChildren((String)menu.get("key"), menus))).collect(Collectors.toList());
    }

    private List<Map<String, String>> getImportFieldTypes() {
        ArrayList<Map<String, String>> importFieldTypes = new ArrayList<Map<String, String>>(5);
        Arrays.stream(NoCodeImportFieldEnum.values()).forEach(e -> {
            HashMap<String, String> item = new HashMap<String, String>(2);
            item.put("type", e.getType());
            item.put("name", e.getName());
            importFieldTypes.add(item);
        });
        return importFieldTypes;
    }

    private void handleDataRow(SheetHandler.ParsedRow row, Map<String, Map<String, Object>> sheets, int startRow, int startCol, String targetSheetName) {
        String sheetName = row.getSheetName();
        if (!sheetName.equalsIgnoreCase(targetSheetName)) {
            return;
        }
        Map rowData = row.getData();
        rowData.keySet().removeIf(key -> key < startCol || key >= startCol + 150);
        if (row.getRowNum() == startRow) {
            Map<String, Object> sheetData = this.getSheetData(sheetName, rowData);
            sheets.put(sheetName, sheetData);
        } else if (row.getRowNum() == startRow + 1) {
            this.parseFieldType(row, sheetName, sheets);
        }
    }

    private void parseFieldType(SheetHandler.ParsedRow row, String sheetName, Map<String, Map<String, Object>> sheets) {
        Map<String, Object> sheetData = sheets.get(sheetName);
        Map types = row.getTypes();
        Map styles = row.getStyles();
        if (MapUtils.isEmpty(sheetData)) {
            return;
        }
        List headRows = (List)sheetData.get("headRows");
        if (CollectionUtils.isEmpty((Collection)headRows)) {
            return;
        }
        headRows.forEach(e -> {
            int index = (Integer)e.get("index");
            String type = (String)e.get("type");
            SheetHandler.XSSFDataType xssfDataType = (SheetHandler.XSSFDataType)types.get(index);
            if (xssfDataType == SheetHandler.XSSFDataType.NUMBER) {
                type = NoCodeDecimalField.class.getSimpleName().toLowerCase();
                Object isDate = ((JSONObject)styles.get(index)).get((Object)"isDate");
                if (Objects.nonNull(isDate) && ((Boolean)isDate).booleanValue()) {
                    type = NoCodeDateField.class.getSimpleName().toLowerCase();
                }
            }
            e.put("type", type);
        });
    }

    private Map<String, Object> getSheetData(String sheetName, Map<Integer, String> rowData) {
        HashMap<String, Object> sheetData = new HashMap<String, Object>(1);
        sheetData.put("sheetName", sheetName);
        sheetData.put("headRows", this.getHeadRows(rowData));
        return sheetData;
    }

    private RestApiResponse<RestApiQueryResult> getQueryResponse(List<Map<String, Object>> rows) {
        RestApiResponse response = new RestApiResponse();
        RestApiQueryResult result = new RestApiQueryResult();
        response.setData((Object)result);
        result.setRows(rows);
        result.setTotalCount(rows.size());
        return response;
    }

    private List<Map<String, Object>> getHeadRows(Map<Integer, String> rowData) {
        ArrayList<Map<String, Object>> headRows = new ArrayList<Map<String, Object>>(rowData.size());
        rowData.forEach((index, name) -> {
            String type = "nocodetextfield";
            String number = "nc_" + Uuid8.generateShortUuid().toLowerCase();
            HashMap<String, Object> headRow = new HashMap<String, Object>(4);
            headRow.put("index", index);
            headRow.put("name", name);
            headRow.put("number", number);
            headRow.put("type", type);
            headRow.put("id", Uuid16.create().toString());
            headRows.add(headRow);
        });
        return headRows;
    }

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }
}

