/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.impt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiImportCancelResult;
import kd.bos.nocode.restapi.api.result.RestApiImportProgress;
import kd.bos.nocode.restapi.api.result.RestApiImportResult;
import kd.bos.nocode.restapi.api.result.RestApiLoadTemplateResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.impt.ImportTemplateHelper;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.service.TimeService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class ImportDataServiceImpl
implements SaveRestApiService {
    private static final Log log = LogFactory.getLog(ImportDataServiceImpl.class);
    private static final String REGEX = "/import/?";
    private static final Pattern PATTERN = Pattern.compile("/import/?");
    private final String IMPORTERRORMEG_0 = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002 \u8bf7\u68c0\u67e5\u6570\u636e\u6a21\u677f\u6765\u6e90\u662f\u5426\u4e3a\u65e0\u4ee3\u7801\u5e73\u53f0\u4e2d\u4e0b\u8f7d\u7684\u6a21\u677f", (String)"ImportDataServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]);
    private final String IMPORTERRORMEG_1 = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u67e5\u8be2\u5b9e\u4f53\u5bfc\u5165", (String)"ImportDataServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]);
    private final String IMPORTERRORMEG_2 = ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230\u6709\u6548\u6570\u636e\uff0c\u8bf7\u5f55\u5165\u6570\u636e\u540e\u518d\u8bd5", (String)"ImportDataServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]);
    private static final String IMPORTCACHEKEY = "Cached_Import_Logger_ByTaskId:";
    private static final String CANCEL_IMPORT = "Cancel_Import_ByTaskId:";
    public static final String CACHEKEY_JOBFORMINFO = "Import_Jobforminfo_ByTaskId:";
    public static final String NOCODE_IMPORT_TASKID = "Import_TaskParam_ByTaskId:";
    private Map<Integer, String> allFieldNumber = new HashMap<Integer, String>(16);
    private Map<Integer, String> allFieldName = new HashMap<Integer, String>(16);
    private String billFormId = "";
    private String billFormName = "";
    private static final String PROGRESS = "progress";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("NOCODE_IMPORT", new DistributeCacheHAPolicy(true, true));

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    private String getAction(RestApiSaveParam param) {
        String url = param.getRequest().getUrl();
        String[] split = url.split(REGEX);
        String action = "";
        if (split.length > 1) {
            action = split[1];
        }
        return action;
    }

    public RestApiServiceData execute(RestApiSaveParam param) {
        String action;
        switch (action = this.getAction(param)) {
            case "importdata": {
                return this.importData(param);
            }
            case "poll": {
                return this.queryProgress(param);
            }
            case "cancel": {
                return this.cancel(param);
            }
            case "downloadTemplate": {
                return this.downloadTemplate(param);
            }
        }
        throw new RestApiException("unknown request");
    }

    private RestApiServiceData<RestApiImportResult> importData(RestApiSaveParam param) {
        long start = System.currentTimeMillis();
        Map importParam = (Map)param.getDataList().get(0);
        String url = importParam.get("fileUrl").toString();
        String appId = importParam.get("appId").toString();
        this.billFormId = importParam.get("formId").toString();
        NoCodePermHelper.verifyFuncPerm((FuncPermItemEnum)FuncPermItemEnum._import, (String)this.billFormId);
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)this.billFormId);
        this.billFormName = formConfig.getCaption().getLocaleValue();
        RestApiResponse response = new RestApiResponse();
        RestApiImportResult restApiImportResult = new RestApiImportResult();
        RestApiServiceData<RestApiImportResult> resolveResults = this.resolve(start, url, this.billFormId);
        if (resolveResults != null) {
            return resolveResults;
        }
        String taskId = this.startImport();
        HashMap<String, String> taskParam = new HashMap<String, String>();
        taskParam.put("url", url);
        taskParam.put("appId", appId);
        taskParam.put("billFormId", this.billFormId);
        taskParam.put("billFormName", this.billFormName);
        cache.put(NOCODE_IMPORT_TASKID + taskId, (Object)SerializationUtils.toJsonString(taskParam));
        restApiImportResult.setTaskId(taskId);
        response.setData((Object)restApiImportResult);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)System.currentTimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RestApiServiceData<RestApiImportResult> resolve(long start, String url, final String billFormId) {
        RestApiResponse response = new RestApiResponse();
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (InputStream in = tempFileCache.getInputStream(url);){
            final boolean[] condition = new boolean[]{false, true, false, false};
            final HashMap entityRow = new HashMap();
            final boolean[] reallyVerified = new boolean[]{false, false, false, false};
            new ExcelReader().read(in, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow row) {
                    ImportDataServiceImpl.this.handleDataRow(row, reallyVerified, billFormId, condition, entityRow);
                }
            }, true);
            if (!condition[3]) {
                log.debug(this.IMPORTERRORMEG_0);
                throw new KDBizException(this.IMPORTERRORMEG_0);
            }
            if (condition[2]) return null;
            RestApiServiceData restApiServiceData = RestApiServiceData.ofFalse((String)"-1", (String)this.IMPORTERRORMEG_2, (RestApiResponse)response, (long)(System.currentTimeMillis() - start));
            return restApiServiceData;
        }
        catch (KDBizException e) {
            ErrorCode code = e.getErrorCode();
            if (code == null) return RestApiServiceData.ofFalse((String)"-1", (String)e.getMessage(), (RestApiResponse)response, (long)(System.currentTimeMillis() - start));
            if ("ValidFile".equalsIgnoreCase(code.getCode())) return null;
            return RestApiServiceData.ofFalse((String)"-1", (String)e.getMessage(), (RestApiResponse)response, (long)(System.currentTimeMillis() - start));
        }
        catch (Throwable e) {
            log.debug(this.IMPORTERRORMEG_0, (Object)e);
            return RestApiServiceData.ofFalse((String)"-1", (String)this.IMPORTERRORMEG_0, (RestApiResponse)response, (long)(System.currentTimeMillis() - start));
        }
    }

    private void handleDataRow(SheetHandler.ParsedRow row, boolean[] reallyVerified, String billFormId, boolean[] condition, Map<Integer, String> entityRow) {
        if (row.getRowNum() == 0) {
            reallyVerified[0] = true;
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)NcEntityTypeUtil.getRealBillEntityNumber((String)billFormId));
            if (entityType instanceof QueryEntityType) {
                throw new KDBizException(this.IMPORTERRORMEG_1);
            }
            String entityName = row.get(Integer.valueOf(0));
            if (StringUtils.isEmpty((CharSequence)entityName)) {
                entityName = row.get(Integer.valueOf(1));
                condition[0] = true;
            }
            if (entityName == null) {
                log.debug(this.IMPORTERRORMEG_0);
                throw new KDBizException(this.IMPORTERRORMEG_0);
            }
            if (!(entityName.contains("unitTest") || entityName.split(" # ").length >= 2 && entityName.split(" # ")[1].equalsIgnoreCase(billFormId))) {
                log.debug(this.IMPORTERRORMEG_0);
                throw new KDBizException(this.IMPORTERRORMEG_0);
            }
            entityRow.putAll(row.getData());
            condition[3] = true;
        } else if (row.getRowNum() == 1) {
            reallyVerified[1] = true;
        } else if (row.getRowNum() == 2) {
            reallyVerified[2] = true;
            if (row.isEmpty()) {
                log.debug(this.IMPORTERRORMEG_0);
                throw new KDBizException(this.IMPORTERRORMEG_0);
            }
            Map nameRow = row.getData();
            condition[1] = !((String)nameRow.get(condition[0] ? 1 : 0)).contains(" # ");
        } else if (row.getRowNum() > (condition[1] ? 3 : 2)) {
            reallyVerified[3] = true;
            if (!row.isEmpty()) {
                condition[2] = true;
                if (!(reallyVerified[0] && reallyVerified[1] && reallyVerified[2] && reallyVerified[3])) {
                    log.debug(this.IMPORTERRORMEG_0);
                    throw new KDBizException(this.IMPORTERRORMEG_0);
                }
                throw new KDBizException(new ErrorCode("NEXT_SHEET", ResManager.loadKDString((String)"\u6a21\u677f\u6821\u9a8c\u901a\u8fc7\uff0c\u5df2\u89e3\u6790\u5230\u6570\u636e", (String)"ImportDataServiceImpl_3", (String)"bos-nocode-service", (Object[])new Object[0])), new Object[0]);
            }
        }
        if (condition[1] && row.getRowNum() == 3) {
            this.allFieldName = row.getData();
        }
    }

    private Set<String> getHeadField(Map<Integer, String> nameRow, Map<Integer, String> entityRow, boolean isNewTemplate) {
        Integer endIndex = Integer.MAX_VALUE;
        if (entityRow != null && entityRow.size() >= 2) {
            TreeMap<Integer, String> sortedMap = new TreeMap<Integer, String>(entityRow);
            endIndex = (Integer)new ArrayList(sortedMap.keySet()).get(1);
        }
        HashSet<String> fields = new HashSet<String>(10);
        String number = null;
        String[] nameSplit = null;
        for (Map.Entry<Integer, String> entry : nameRow.entrySet()) {
            number = entry.getValue();
            if (!isNewTemplate && (nameSplit = number.split(" # ")).length == 2) {
                number = nameSplit[1];
                this.allFieldName.put(entry.getKey(), nameSplit[0]);
            }
            if (entry.getKey() < endIndex) {
                fields.add(number);
            }
            this.allFieldNumber.put(entry.getKey(), number);
        }
        return fields;
    }

    private String startImport() {
        Object logIdObj = this.createImportlog(this.billFormId, "");
        String logId = logIdObj.toString();
        return this.dispatchTask(logId);
    }

    private Object createImportlog(String billFormId, String name) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_importlog");
        DynamicObject dyn = (DynamicObject)objType.createInstance();
        dyn.set("name", (Object)name);
        dyn.set("billstatus", (Object)"C");
        dyn.set("importstatus", (Object)"0");
        dyn.set("createtime", (Object)new TimeService().now());
        dyn.set("importtype", (Object)"1");
        if (StringUtils.isNotBlank((CharSequence)billFormId)) {
            dyn.set("sourceObj_id", (Object)billFormId);
        }
        dyn = (DynamicObject)BusinessDataWriter.save((IDataEntityType)objType, (Object[])new Object[]{dyn})[0];
        return dyn.getPkValue();
    }

    private String dispatchTask(String logId) {
        JobFormInfo jobFormInfo = this.buildJobFormInfo(logId);
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        cache.put("noCodeLogId:" + logId, (Object)taskId);
        cache.put(CACHEKEY_JOBFORMINFO + taskId, (Object)SerializationUtils.toJsonString((Object)jobFormInfo));
        return taskId;
    }

    private JobFormInfo buildJobFormInfo(Object logId) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setName(ResManager.loadKDString((String)"\u5bfc\u5165 - %s", (String)"ImportDataServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[]{this.billFormName}));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByLang(Lang.get());
        String routeAppId = this.billFormId;
        if (StringUtils.isNotBlank((CharSequence)routeAppId)) {
            String subRouteAppId = routeAppId + ".import";
            if (subRouteAppId.equals(ServiceLookup.getServiceAppId((String)subRouteAppId))) {
                routeAppId = subRouteAppId;
            } else if ("imp-exp".equals(ServiceLookup.getServiceAppId((String)"imp-exp"))) {
                routeAppId = "imp-exp";
            }
        }
        jobInfo.setAppId(routeAppId);
        jobInfo.setTaskClassname("kd.bos.nocode.restapi.service.impt.NoCodeImportService");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("requestcontext", RequestContext.get());
        params.put("logId", logId);
        params.put("BillFormId", this.billFormId);
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.getParams().put("logId", logId);
        return jobFormInfo;
    }

    private RestApiServiceData queryProgress(RestApiSaveParam param) {
        long start = System.currentTimeMillis();
        Map importParam = (Map)param.getDataList().get(0);
        String taskId = importParam.get("taskId").toString();
        RestApiResponse response = new RestApiResponse();
        RestApiImportProgress importProgressResult = new RestApiImportProgress();
        String cachedLogStr = (String)cache.get(IMPORTCACHEKEY + taskId);
        if (cachedLogStr == null) {
            importProgressResult.setProgress(0);
            importProgressResult.setStatus("0");
            response.setData((Object)importProgressResult);
        } else {
            JSONObject map = JSON.parseObject((String)cachedLogStr);
            int total = Integer.parseInt(map.get((Object)"total").toString());
            int failed = Integer.parseInt(map.get((Object)"failed").toString());
            int succeed = total - failed;
            int progress = Integer.parseInt(map.get((Object)PROGRESS).toString());
            String status = "";
            status = progress == 100 ? "1" : "0";
            if (progress == 100 && failed == total) {
                status = "-1";
            }
            String message = "";
            if (progress == 100) {
                if (failed == 0) {
                    message = ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\uff0c\u5171\u65b0\u589e", (String)"ImportDataServiceImpl_5", (String)"bos-nocode-service", (Object[])new Object[0]) + total + ResManager.loadKDString((String)"\u6761\u8bb0\u5f55", (String)"ImportDataServiceImpl_6", (String)"bos-nocode-service", (Object[])new Object[0]);
                } else if (failed > 0 && failed < total) {
                    message = ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\uff0c\u5171\u65b0\u589e", (String)"ImportDataServiceImpl_5", (String)"bos-nocode-service", (Object[])new Object[0]) + succeed + ResManager.loadKDString((String)"\u6761\u8bb0\u5f55\uff0c\u6709", (String)"ImportDataServiceImpl_7", (String)"bos-nocode-service", (Object[])new Object[0]) + failed + ResManager.loadKDString((String)"\u6761\u9519\u8bef\u8bb0\u5f55", (String)"ImportDataServiceImpl_8", (String)"bos-nocode-service", (Object[])new Object[0]);
                } else if (failed == total) {
                    message = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5171\u6709", (String)"ImportDataServiceImpl_9", (String)"bos-nocode-service", (Object[])new Object[0]) + failed + ResManager.loadKDString((String)"\u6761\u9519\u8bef\u8bb0\u5f55", (String)"ImportDataServiceImpl_8", (String)"bos-nocode-service", (Object[])new Object[0]);
                }
                cache.remove(IMPORTCACHEKEY + taskId);
            }
            importProgressResult.setProgress(progress);
            importProgressResult.setStatus(status);
            importProgressResult.setMessage(message);
            response.setData((Object)importProgressResult);
        }
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)System.currentTimeMillis());
    }

    private RestApiServiceData cancel(RestApiSaveParam param) {
        long start = System.currentTimeMillis();
        Map importParam = (Map)param.getDataList().get(0);
        String taskId = importParam.get("taskId").toString();
        RestApiResponse response = new RestApiResponse();
        RestApiImportCancelResult cancelResult = new RestApiImportCancelResult();
        cache.put(CANCEL_IMPORT + taskId, (Object)"cancel");
        String jobFormInfoStr = (String)cache.get(CACHEKEY_JOBFORMINFO + taskId);
        try {
            JobFormInfo jobFormInfo = (JobFormInfo)SerializationUtils.fromJsonString((String)jobFormInfoStr, JobFormInfo.class);
            TaskClientProxy.suspend((JobFormInfo)jobFormInfo, (String)taskId);
            cancelResult.setStatus("1");
        }
        catch (Exception e) {
            cancelResult.setStatus("-1");
        }
        response.setData((Object)cancelResult);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)System.currentTimeMillis());
    }

    private RestApiServiceData downloadTemplate(RestApiSaveParam param) {
        long start = System.currentTimeMillis();
        Map importParam = (Map)param.getDataList().get(0);
        String billFormId = importParam.get("formId").toString();
        NoCodePermHelper.verifyFuncPerm((FuncPermItemEnum)FuncPermItemEnum._import, (String)billFormId);
        RestApiResponse response = new RestApiResponse();
        RestApiLoadTemplateResult loadTemplateResult = new RestApiLoadTemplateResult();
        String templateUrl = this.buildTemplateUrl(billFormId);
        loadTemplateResult.setTemplateUrl(templateUrl);
        response.setData((Object)loadTemplateResult);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)System.currentTimeMillis());
    }

    private String buildTemplateUrl(String billFormId) {
        ImportTemplateHelper importTemplateHelper = new ImportTemplateHelper();
        return importTemplateHelper.buildTemplate(billFormId);
    }
}

