/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.impt;

import com.alibaba.fastjson.JSONArray;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.NameVersionEntryProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.expt.IExportService;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.web.actions.export.ExportSheetStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class ImportTemplateHelper {
    private static Log log = LogFactory.getLog(ImportTemplateHelper.class);
    private static final String INPUT_TYPE_KEY = "InputType";
    private static final String INPUT_FORMAT = "InputFormat";
    private static final String INPUT_PROPKEY = "ImportProp";
    private static final String INPUT_PROPNAME = "ImportPropName";
    private static final String INPUT_VALUES = "InputValues";
    private static final String INPUT_DESC_KEY = "InputDesc";
    private static final String INPUT_DATA_KEY = "DataKey";
    private static final String INPUT_DECIMAL_FORMAT = "DecimalFormat";
    private static final String COLWIDTH_KEY = "ColWidth";
    private String kdName = ResManager.loadKDString((String)"\u540d\u79f0", (String)"ImportTemplateHelper_0", (String)"bos-nocode-service", (Object[])new Object[0]);
    private String kdCode = ResManager.loadKDString((String)"\u7f16\u7801", (String)"ImportTemplateHelper_1", (String)"bos-nocode-service", (Object[])new Object[0]);
    private String kdId = ResManager.loadKDString((String)"\u5185\u7801", (String)"ImportTemplateHelper_2", (String)"bos-nocode-service", (Object[])new Object[0]);
    private static final int MAX_FILE_NAME_LENGTH = 50;

    public ExportWriterFormat init(String formId) {
        MainEntityType billEntity = EntityMetadataCache.getDataEntityType((String)formId);
        ExportWriterFormat writer = new ExportWriterFormat(billEntity.getName(), billEntity.getDisplayName().toString(), 0);
        List<EnabledLang> enableLangs = this.getEnabledLangs(formId);
        this.parse((DynamicObjectType)billEntity, writer, enableLangs);
        return writer;
    }

    protected String buildTemplate(String formId) {
        ExportWriterFormat writer = this.init(formId);
        MainEntityType billEntity = EntityMetadataCache.getDataEntityType((String)formId);
        SXSSFWorkbook wb = new SXSSFWorkbook(5000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        this.writeHeader(wb, sheet, styles, writer);
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
        String formName = formConfig.getCaption().getLocaleValue();
        return this.flush(wb, billEntity, formName + ResManager.loadKDString((String)"_\u5bfc\u5165\u6a21\u677f", (String)"ImportTemplateHelper_3", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    private int parse(DynamicObjectType entityType, ExportWriterFormat writer, List<EnabledLang> enableLangs) {
        int col = writer.col;
        String ID2 = "id";
        String PID = "pid";
        DataEntityPropertyCollection properties = entityType.getProperties();
        String entityTypeName = entityType.getName();
        for (IDataEntityProperty prop : properties) {
            boolean isID = ID2.equalsIgnoreCase(prop.getName());
            boolean isPID = PID.equalsIgnoreCase(prop.getName());
            if (prop instanceof LongProp || prop instanceof AttachmentProp || prop instanceof DynamicLocaleProperty || prop instanceof IFieldHandle && !((IFieldHandle)prop).isImportable() || prop instanceof FlexProp && !((IFieldHandle)prop).isImportable() || prop instanceof ItemClassProp && !((IFieldHandle)prop).isImportable()) continue;
            String propName = prop.getName();
            if ((isID || isPID) && !(entityType instanceof MainEntityType)) {
                propName = prop.getParent().getName() + "." + propName;
            }
            if (prop instanceof LinkEntryProp || prop instanceof NameVersionEntryProp || !(prop instanceof IFieldHandle) || !isID && !isPID && !((IFieldHandle)prop).isImportable() && !((IFieldHandle)prop).isExportable()) continue;
            String currLang = RequestContext.getOrCreate().getLang().name();
            ArrayList props = new ArrayList();
            ArrayList dataKeyProps = new ArrayList();
            ArrayList propDisplayNames = new ArrayList();
            boolean isBasedata = prop instanceof IBasedataField;
            boolean isMultiLang = prop instanceof MuliLangTextProp;
            boolean isLargeText = prop instanceof LargeTextProp;
            HashMap<String, Object> property = new HashMap<String, Object>(16);
            property.put("propName", propName);
            LocaleString displayName = null;
            if (isID) {
                displayName = new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)"ImportTemplateHelper_2", (String)"bos-nocode-service", (Object[])new Object[0]));
            } else if (isPID) {
                displayName = new LocaleString(ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"ImportTemplateHelper_4", (String)"bos-nocode-service", (Object[])new Object[0]));
            } else if (prop instanceof FieldProp) {
                displayName = ((FieldProp)prop).getDisplayName();
            } else if (prop instanceof BasedataProp) {
                displayName = ((BasedataProp)prop).getDisplayName();
            } else if (prop instanceof RefBillProp) {
                displayName = ((RefBillProp)prop).getDisplayName();
            } else if (prop instanceof MulBasedataProp) {
                displayName = ((MulBasedataProp)prop).getDisplayName();
            }
            property.put("DisplayName", displayName == null ? "" : displayName.toString());
            if (isID) {
                property.put(INPUT_TYPE_KEY, ID2);
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u5185\u7801\u662f\u5339\u914d\u5355\u636e\u4f53\u6216\u5b50\u5355\u636e\u4f53\u7684\u552f\u4e00\u6807\u8bc6\uff0c\u7528\u4e8e\u786e\u5b9a\u6570\u636e\u7684\u552f\u4e00\u6027", (String)"ImportTemplateHelper_5", (String)"bos-nocode-service", (Object[])new Object[0]));
            } else if (isPID) {
                property.put(INPUT_TYPE_KEY, PID);
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801\u662f\u6811\u5f62\u5355\u636e\u4f53\u4e0a\u7ea7\u884c\u7684\u552f\u4e00\u6807\u8bc6\uff0c\u7528\u4e8e\u786e\u5b9a\u6570\u636e\u7684\u4e0a\u4e0b\u7ea7\u5173\u7cfb", (String)"ImportTemplateHelper_6", (String)"bos-nocode-service", (Object[])new Object[0]));
            } else if (isLargeText) {
                property.put(INPUT_TYPE_KEY, "largetext");
            } else if (isMultiLang) {
                property.put(INPUT_TYPE_KEY, "multilang");
            } else if (prop instanceof TextProp || prop instanceof VarcharProp) {
                property.put(INPUT_TYPE_KEY, "varchar");
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u6587\u672c", (String)"ImportTemplateHelper_7", (String)"bos-nocode-service", (Object[])new Object[0]));
            } else if (prop instanceof DecimalProp) {
                property.put(INPUT_TYPE_KEY, "decimal");
                HashMap<String, Integer> decimalformat = new HashMap<String, Integer>();
                decimalformat.put("precision", ((DecimalProp)prop).getScale());
                property.put(INPUT_DECIMAL_FORMAT, decimalformat);
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u6570\u5b57", (String)"ImportTemplateHelper_8", (String)"bos-nocode-service", (Object[])new Object[0]));
            } else if (isBasedata) {
                property.put(INPUT_TYPE_KEY, "basedata");
                property.put(INPUT_PROPKEY, props);
                property.put(INPUT_PROPNAME, propDisplayNames);
            } else if (prop instanceof TimeProp) {
                property.put(INPUT_TYPE_KEY, "time");
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u65f6\u95f4\uff0c\u793a\u4f8b\uff1a12:00:00", (String)"ImportTemplateHelper_9", (String)"bos-nocode-service", (Object[])new Object[0]));
            } else if (prop instanceof DateProp) {
                property.put(INPUT_TYPE_KEY, "date");
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u65e5\u671f\uff0c\u793a\u4f8b\uff1a2018-05-01", (String)"ImportTemplateHelper_10", (String)"bos-nocode-service", (Object[])new Object[0]));
            } else if (prop instanceof DateTimeProp) {
                property.put(INPUT_TYPE_KEY, "datetime");
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u65e5\u671f\u65f6\u95f4\uff0c\u793a\u4f8b\uff1a2018-05-01 12:00:00", (String)"ImportTemplateHelper_11", (String)"bos-nocode-service", (Object[])new Object[0]));
            } else if (prop instanceof ComboProp) {
                try {
                    ArrayList itemList = new ArrayList(((ComboProp)prop).getComboItems());
                    Iterator iterator = itemList.iterator();
                    while (iterator.hasNext()) {
                        ValueMapItem next = (ValueMapItem)iterator.next();
                        if (next.isItemVisible()) continue;
                        iterator.remove();
                    }
                    String[] items = new String[itemList.size()];
                    CharSequence[] itemDesc = new String[itemList.size()];
                    for (int index = 0; index < itemList.size(); ++index) {
                        items[index] = ((ValueMapItem)itemList.get(index)).getName() + " # " + ((ValueMapItem)itemList.get(index)).getValue();
                        itemDesc[index] = ((ValueMapItem)itemList.get(index)).getName().toString();
                    }
                    property.put(INPUT_TYPE_KEY, items);
                    if (prop instanceof MulComboProp) {
                        property.put("PropType", "MulComboProp");
                        property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u53ef\u9009\u9879\uff1a", (String)"ImportTemplateHelper_12", (String)"bos-nocode-service", (Object[])new Object[0]) + String.join((CharSequence)"\u3001", itemDesc) + ResManager.loadKDString((String)"\uff0c\u591a\u4e2a\u9009\u9879\u4ee5\u2018,\u2019\u5206\u9694", (String)"ImportTemplateHelper_13", (String)"bos-nocode-service", (Object[])new Object[0]));
                    }
                }
                catch (Exception e) {
                    log.warn((Throwable)e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0b\u62c9\u5217\u8868%1$s\u7684\u9009\u9879\u5931\u8d25\uff1akey=%2$s", (String)"ImportTemplateHelper_14", (String)"bos-nocode-service", (Object[])new Object[]{prop.getDisplayName(), prop.getName()}));
                }
            }
            if (isMultiLang) {
                property.put(INPUT_DATA_KEY, currLang);
            } else if (isLargeText) {
                property.put(INPUT_DATA_KEY, "largetext");
            } else if (prop instanceof IBasedataField) {
                ArrayList<String> mulDataKey = null;
                if (prop instanceof MulBasedataProp) {
                    mulDataKey = new ArrayList<String>(props.size());
                    for (String p : props) {
                        mulDataKey.add("fbasedataid." + p);
                    }
                }
                property.put(INPUT_DATA_KEY, mulDataKey == null ? dataKeyProps : mulDataKey);
            }
            if (prop instanceof FieldProp) {
                property.put("MustInput", ((FieldProp)prop).isMustInput());
            } else if (prop instanceof BasedataProp) {
                property.put("MustInput", ((BasedataProp)prop).isMustInput());
            } else if (prop instanceof MulBasedataProp) {
                property.put("MustInput", ((MulBasedataProp)prop).isMustInput());
            }
            if (isBasedata || isMultiLang || isLargeText) {
                ArrayList<String> items = new ArrayList<String>();
                ArrayList<String> display = new ArrayList<String>();
                ArrayList<String> desc = new ArrayList<String>();
                if (prop instanceof BasedataProp || prop instanceof MulBasedataProp) {
                    boolean isMulBasedata = prop instanceof MulBasedataProp;
                    String basedataColumnKey = propName;
                    String basedataColumnName = prop.getDisplayName().getLocaleValue();
                    if (props.isEmpty()) {
                        if (!(prop instanceof ItemClassProp)) {
                            this.setDefaultBasedataProps(propName, prop, items, display, desc);
                        }
                    } else {
                        for (String p : props) {
                            items.add(basedataColumnKey + "." + p);
                            if (!desc.isEmpty()) continue;
                            desc.add(String.format(ResManager.loadKDString((String)"%1$s\uff0c\u652f\u6301\u5f55\u5165%2$s", (String)"ImportTemplateHelper_53", (String)"bos-nocode-service", (Object[])new Object[]{isMulBasedata ? ResManager.loadKDString((String)"\u591a\u4e2a\u57fa\u7840\u8d44\u6599\u7528\u9017\u53f7\u5206\u9694", (String)"ImportTemplateHelper_16", (String)"bos-nocode-service", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"ImportTemplateHelper_17", (String)"bos-nocode-service", (Object[])new Object[0]), "name".equals(p) ? this.kdName : this.kdCode}), new Object[0]));
                        }
                        for (int i = 0; i < propDisplayNames.size(); ++i) {
                            display.add(basedataColumnName + "." + (String)propDisplayNames.get(i));
                        }
                    }
                } else if (isMultiLang) {
                    String comment = ResManager.loadKDString((String)"\u6587\u672c", (String)"ImportTemplateHelper_7", (String)"bos-nocode-service", (Object[])new Object[0]);
                    for (EnabledLang lang : enableLangs) {
                        if (lang.number.equals(currLang)) {
                            items.add(0, propName + "." + lang.number);
                            display.add(0, this.getDisplayName(prop) + "." + lang.name);
                            desc.add(0, comment);
                            continue;
                        }
                        items.add(propName + "." + lang.number);
                        display.add(this.getDisplayName(prop) + "." + lang.name);
                        desc.add(comment);
                    }
                } else if (isLargeText) {
                    for (String p : props) {
                        items.add(p);
                    }
                    for (int i = 0; i < propDisplayNames.size(); ++i) {
                        display.add((String)propDisplayNames.get(i));
                    }
                }
                writer.flexColumn.put(propName, items);
                writer.flexColumnDisplay.put(propName, display);
                writer.flexColumnDesc.put(propName, desc);
                col += items.size();
            } else {
                ++col;
            }
            writer.fields.add(propName);
            writer.properties.put(propName, property);
        }
        return col;
    }

    private String getDisplayName(IDataEntityProperty prop) {
        if (prop == null) {
            return "";
        }
        if ("id".equals(prop.getName())) {
            return this.kdId;
        }
        LocaleString displayName = prop.getDisplayName();
        if (StringUtils.isBlank((Object)displayName)) {
            return prop.getName();
        }
        return displayName.toString();
    }

    private List<EnabledLang> getEnabledLangs(String formId) {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List multiLangEnabledLang = service.getMultiLangEnabledLang();
        IExportService exportService = (IExportService)ServiceFactory.getService(IExportService.class);
        Map settingOfMultilang = exportService.getSettingOfMultilang(formId);
        if (CollectionUtils.isEmpty((Map)settingOfMultilang)) {
            return multiLangEnabledLang;
        }
        ArrayList<EnabledLang> result = new ArrayList<EnabledLang>(multiLangEnabledLang.size());
        for (EnabledLang enabledLang : multiLangEnabledLang) {
            if (enabledLang.getIsDefault().booleanValue()) {
                result.add(enabledLang);
                continue;
            }
            String key = enabledLang.getNumber().toLowerCase();
            if (!settingOfMultilang.getOrDefault(key, Boolean.TRUE).booleanValue()) continue;
            result.add(enabledLang);
        }
        return result;
    }

    private void setDefaultBasedataProps(String propName, IDataEntityProperty prop, List<String> items, List<String> display, List<String> desc) {
        boolean isMulBasedata = prop instanceof MulBasedataProp;
        String basedataColumnName = prop.getDisplayName().getLocaleValue();
        String bdNumProp = this.getBasedataNumberProp((IBasedataField)prop);
        String bdNameProp = this.getBasedataNameProp((IBasedataField)prop);
        String disPlayNumber = basedataColumnName + this.appendName((IBasedataField)prop, bdNumProp);
        String disPlayName = basedataColumnName + this.appendName((IBasedataField)prop, bdNameProp);
        items.add(propName + "." + bdNumProp);
        display.add(disPlayNumber);
        desc.add(ResManager.loadKDString((String)"%s\uff0c\u652f\u6301\u5f55\u5165\u7f16\u7801", (String)"ImportTemplateHelper_18", (String)"bos-nocode-service", (Object[])new Object[]{isMulBasedata ? ResManager.loadKDString((String)"\u591a\u4e2a\u5173\u8054\u8868\u5355\u7528\u9017\u53f7\u5206\u9694", (String)"ImportTemplateHelper_19", (String)"bos-nocode-service", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5173\u8054\u8868\u5355", (String)"ImportTemplateHelper_20", (String)"bos-nocode-service", (Object[])new Object[0])}));
        items.add(propName + "." + bdNameProp);
        display.add(disPlayName);
        desc.add(ResManager.loadKDString((String)"%s\uff0c\u652f\u6301\u5f55\u5165\u540d\u79f0", (String)"ImportTemplateHelper_21", (String)"bos-nocode-service", (Object[])new Object[]{isMulBasedata ? ResManager.loadKDString((String)"\u591a\u4e2a\u5173\u8054\u8868\u5355\u7528\u9017\u53f7\u5206\u9694", (String)"ImportTemplateHelper_19", (String)"bos-nocode-service", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5173\u8054\u8868\u5355", (String)"ImportTemplateHelper_20", (String)"bos-nocode-service", (Object[])new Object[0])}));
    }

    private String getBasedataNumberProp(IBasedataField prop) {
        BasedataEntityType entityType = (BasedataEntityType)prop.getComplexType();
        return entityType.getNumberProperty();
    }

    private String getBasedataNameProp(IBasedataField prop) {
        BasedataEntityType entityType = (BasedataEntityType)prop.getComplexType();
        return entityType.getNameProperty();
    }

    private String appendName(IBasedataField prop, String propName) {
        BasedataEntityType entityType = (BasedataEntityType)prop.getComplexType();
        DynamicProperty bdProp = entityType.getProperty(propName);
        if (entityType.getProperty(propName) != null) {
            return "." + bdProp.getDisplayName();
        }
        return "." + propName;
    }

    private void writeHeader(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, ExportWriterFormat format) {
        SXSSFSheet formatSpecificationSheet = wb.createSheet(ResManager.loadKDString((String)"\u683c\u5f0f\u8bf4\u660e", (String)"ImportTemplateHelper_22", (String)"bos-nocode-service", (Object[])new Object[0]));
        formatSpecificationSheet.setRandomAccessWindowSize(-1);
        int offset = 0;
        ImportTemplateHelper.writeHeader(wb, sheet, null, styles, format, offset);
        this.buildSheet2(formatSpecificationSheet, wb);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int writeHeader(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFSheet dropdownSheet, ExportSheetStyle styles, ExportWriterFormat format, int preOffset) {
        SXSSFRow titleRow = ImportTemplateHelper.getRow(sheet, 0);
        int offset = preOffset;
        String caption = "";
        int i = 0;
        while (true) {
            block16: {
                List splitColDesc;
                List splitColDisplayNames;
                List splitCols;
                boolean mustInput;
                Map property;
                block17: {
                    block8: {
                        String propName;
                        block10: {
                            block15: {
                                Object inputType;
                                String fieldName;
                                block14: {
                                    block13: {
                                        block12: {
                                            block11: {
                                                block9: {
                                                    if (i >= format.fields.size()) {
                                                        return offset;
                                                    }
                                                    fieldName = (String)format.fields.get(i);
                                                    property = (Map)format.properties.get(fieldName);
                                                    mustInput = false;
                                                    inputType = null;
                                                    if (property == null) break block8;
                                                    mustInput = Boolean.TRUE.equals(property.get("MustInput"));
                                                    inputType = property.get(INPUT_TYPE_KEY);
                                                    if (!"id".equals(inputType)) break block9;
                                                    sheet.setDefaultColumnStyle(format.col + offset, styles.getTextStyle());
                                                    break block10;
                                                }
                                                if (!(inputType instanceof JSONArray)) break block11;
                                                ArrayList items = new ArrayList();
                                                ((JSONArray)inputType).forEach(obj -> items.add(obj.toString().split(" # ", -1)[0]));
                                                if (!items.isEmpty() && "MulComboProp".equals(property.get("PropType"))) {
                                                    // empty if block
                                                }
                                                break block10;
                                            }
                                            if (!"date".equals(inputType)) break block12;
                                            sheet.setDefaultColumnStyle(format.col + offset, styles.getDateStyle());
                                            break block10;
                                        }
                                        if (!"datetime".equals(inputType)) break block13;
                                        sheet.setDefaultColumnStyle(format.col + offset, styles.getDatetimeStyle());
                                        break block10;
                                    }
                                    if (!"decimal".equals(inputType)) break block14;
                                    sheet.setDefaultColumnStyle(format.col + offset, styles.getDecimalStyle(wb, (Map)property.get(INPUT_DECIMAL_FORMAT)));
                                    break block10;
                                }
                                if (!ImportTemplateHelper.multipleColumnsField(inputType).booleanValue()) break block15;
                                splitCols = (List)format.flexColumn.get(fieldName);
                                splitColDisplayNames = (List)format.flexColumnDisplay.get(fieldName);
                                splitColDesc = (List)format.flexColumnDesc.get(fieldName);
                                if (splitCols == null) break block16;
                                break block17;
                            }
                            sheet.setDefaultColumnStyle(format.col + offset, styles.getTextStyle());
                        }
                        String displayName = (String)property.get("DisplayName");
                        String string = propName = property.get("propName") instanceof String ? (String)property.get("propName") : "";
                        if (format.getExchangeNameAndMark().booleanValue() && StringUtils.isNotBlank(property.get("EntityDescription"))) {
                            String descValue = (String)property.get("EntityDescription");
                            displayName = ImportTemplateHelper.getRealDescByInputType(descValue, property, null, propName);
                        }
                        caption = (mustInput ? "*" : "") + displayName;
                    }
                    SXSSFCell cell = ImportTemplateHelper.createCell(wb, titleRow, format.col + offset, mustInput ? styles.getTitleMustInputStyle() : styles.getTitleStyle());
                    cell.setCellValue(caption);
                    if (property != null && format.col + offset != 0) {
                        Object colWidth = property.get(COLWIDTH_KEY);
                        int designatedColWidth = colWidth instanceof Integer ? (Integer)colWidth : 0;
                        sheet.setColumnWidth(format.col + offset, ImportTemplateHelper.calcColumnWidth(caption, designatedColWidth));
                    }
                    if (property != null && property.containsKey(INPUT_DESC_KEY)) {
                        String tip = property.getOrDefault(INPUT_DESC_KEY, "");
                        ImportTemplateHelper.bindCellTip(sheet, cell, format.col + offset, 0, tip);
                    }
                    ++offset;
                    break block16;
                }
                for (int j = 0; j < splitCols.size(); ++offset, ++j) {
                    boolean isImportPropValid;
                    Object colWidth;
                    String displayName = ImportTemplateHelper.dealDisplayName(j, format.getExchangeNameAndMark(), property, splitCols, splitColDisplayNames);
                    caption = (j == 0 && mustInput ? "*" : "") + displayName;
                    sheet.setDefaultColumnStyle(format.col + offset, styles.getTextStyle());
                    SXSSFCell cell = ImportTemplateHelper.createCell(wb, titleRow, format.col + offset, j == 0 && mustInput ? styles.getTitleMustInputStyle() : styles.getTitleStyle());
                    cell.setCellValue(caption);
                    if (j < splitColDesc.size()) {
                        ImportTemplateHelper.bindCellTip(sheet, cell, format.col + offset, 0, (String)splitColDesc.get(j));
                    }
                    int designatedColWidth = (colWidth = property.get(COLWIDTH_KEY)) instanceof Integer ? (Integer)colWidth : 0;
                    sheet.setColumnWidth(format.col + offset, ImportTemplateHelper.calcColumnWidth(caption, designatedColWidth));
                    Object ImportProp = property.get(INPUT_PROPKEY);
                    boolean bl = isImportPropValid = ImportProp instanceof List && !((List)ImportProp).isEmpty();
                    if (!isImportPropValid) continue;
                    List importPropList = (List)ImportProp;
                    if (!((String)splitCols.get(j)).contains((CharSequence)importPropList.get(0))) continue;
                }
            }
            ++i;
        }
    }

    private void buildSheet2(SXSSFSheet formatSpecificationSheet, SXSSFWorkbook wb) {
        HashMap<String, String> cellDataMap = new HashMap<String, String>(50);
        cellDataMap.put("r0_c0", ResManager.loadKDString((String)"\u5b57\u6bb5\u7c7b\u578b", (String)"ImportTemplateHelper_23", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r0_c1", ResManager.loadKDString((String)"\u89c4\u8303\u683c\u5f0f\u793a\u4f8b", (String)"ImportTemplateHelper_24", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r0_c2", ResManager.loadKDString((String)"\u8bf4\u660e", (String)"ImportTemplateHelper_25", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r1_c0", ResManager.loadKDString((String)"\u521b\u5efa\u65e5\u671f", (String)"ImportTemplateHelper_26", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r1_c1", ResManager.loadKDString((String)"\u76ee\u524d\u652f\u6301\u4ee5\u4e0b\u683c\u5f0f", (String)"ImportTemplateHelper_27", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n2022-09-16  10:30:15 \n2022-09-16\n2022/09/16  10:30:15\n2022/09/16\n" + ResManager.loadKDString((String)"2022\u5e749\u670816\u65e5", (String)"ImportTemplateHelper_28", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n");
        cellDataMap.put("r1_c2", ResManager.loadKDString((String)"\u76ee\u524d\u652f\u6301\u4ee5\u4e0b\u683c\u5f0f", (String)"ImportTemplateHelper_27", (String)"bos-nocode-service", (Object[])new Object[0]) + "\nyyyy-MM-dd  HH:mm:ss\nyyyy-MM-dd\nyyyy/MM/dd  HH:mm:ss\nyyyy/MM/dd\n" + ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"ImportTemplateHelper_29", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n");
        cellDataMap.put("r2_c0", ResManager.loadKDString((String)"\u521b\u5efa\u4eba", (String)"ImportTemplateHelper_30", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r2_c1", ResManager.loadKDString((String)"\u5c0f\u5218", (String)"ImportTemplateHelper_31", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r2_c2", "");
        cellDataMap.put("r3_c0", ResManager.loadKDString((String)"\u4fee\u6539\u65e5\u671f", (String)"ImportTemplateHelper_32", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r3_c1", ResManager.loadKDString((String)"\u76ee\u524d\u652f\u6301\u4ee5\u4e0b\u683c\u5f0f", (String)"ImportTemplateHelper_27", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n2022-09-16  10:30:15 \n2022-09-16\n2022/09/16  10:30:15\n2022/09/16\n" + ResManager.loadKDString((String)"2022\u5e749\u670816\u65e5", (String)"ImportTemplateHelper_28", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n");
        cellDataMap.put("r3_c2", ResManager.loadKDString((String)"\u76ee\u524d\u652f\u6301\u4ee5\u4e0b\u683c\u5f0f", (String)"ImportTemplateHelper_27", (String)"bos-nocode-service", (Object[])new Object[0]) + "\nyyyy-MM-dd  HH:mm:ss\nyyyy-MM-dd\nyyyy/MM/dd  HH:mm:ss\nyyyy/MM/dd\n" + ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"ImportTemplateHelper_29", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n");
        cellDataMap.put("r4_c0", ResManager.loadKDString((String)"\u4fee\u6539\u4eba", (String)"ImportTemplateHelper_33", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r4_c1", ResManager.loadKDString((String)"\u5c0f\u5218", (String)"ImportTemplateHelper_31", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r4_c2", "");
        cellDataMap.put("r5_c0", ResManager.loadKDString((String)"\u8868\u5355\u7f16\u53f7", (String)"ImportTemplateHelper_34", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r5_c1", ResManager.loadKDString((String)"\u65e0\u89c4\u8303\u683c\u5f0f\u8981\u6c42", (String)"ImportTemplateHelper_35", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r5_c2", "");
        cellDataMap.put("r6_c0", ResManager.loadKDString((String)"\u8868\u5355\u72b6\u6001", (String)"ImportTemplateHelper_36", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r6_c1", ResManager.loadKDString((String)"\u8868\u5355\u72b6\u6001\u793a\u4f8b", (String)"ImportTemplateHelper_37", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r6_c2", "");
        cellDataMap.put("r7_c0", ResManager.loadKDString((String)"\u5355\u884c\u6587\u672c", (String)"ImportTemplateHelper_38", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r7_c1", ResManager.loadKDString((String)"\u5355\u884c\u793a\u4f8b\u6587\u672c", (String)"ImportTemplateHelper_39", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r7_c2", "");
        cellDataMap.put("r8_c0", ResManager.loadKDString((String)"\u591a\u884c\u6587\u672c", (String)"ImportTemplateHelper_40", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r8_c1", ResManager.loadKDString((String)"\u591a\u884c\u793a\u4f8b\u6587\u672c", (String)"ImportTemplateHelper_41", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"\u591a\u884c\u793a\u4f8b\u6587\u672c", (String)"ImportTemplateHelper_41", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n");
        cellDataMap.put("r8_c2", "");
        cellDataMap.put("r9_c0", ResManager.loadKDString((String)"\u9009\u9879\uff08\u5355\u9009\uff09", (String)"ImportTemplateHelper_42", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r9_c1", ResManager.loadKDString((String)"\u793a\u4f8b\u9009\u9879A", (String)"ImportTemplateHelper_43", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r9_c2", "");
        cellDataMap.put("r10_c0", ResManager.loadKDString((String)"\u9009\u9879\uff08\u591a\u9009\uff09", (String)"ImportTemplateHelper_44", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r10_c1", ResManager.loadKDString((String)"\u793a\u4f8b\u9009\u9879A, \u793a\u4f8b\u9009\u9879B", (String)"ImportTemplateHelper_45", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r10_c2", ResManager.loadKDString((String)"\u4e0d\u540c\u9009\u9879\u4e4b\u95f4\u4f7f\u7528\u82f1\u6587\u5b57\u7b26%s\u9694\u5f00", (String)"ImportTemplateHelper_46", (String)"bos-nocode-service", (Object[])new Object[]{"\\\\n"}));
        cellDataMap.put("r11_c0", ResManager.loadKDString((String)"\u6570\u5b57", (String)"ImportTemplateHelper_8", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r11_c1", "12345.12");
        cellDataMap.put("r11_c2", "");
        cellDataMap.put("r12_c0", ResManager.loadKDString((String)"\u65e5\u671f", (String)"ImportTemplateHelper_47", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r12_c1", ResManager.loadKDString((String)"\u76ee\u524d\u652f\u6301\u4ee5\u4e0b\u683c\u5f0f", (String)"ImportTemplateHelper_27", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n2022-09-16  10:30:15 \n2022-09-16\n2022/09/16  10:30:15\n2022/09/16\n" + ResManager.loadKDString((String)"2022\u5e749\u670816\u65e5", (String)"ImportTemplateHelper_28", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n");
        cellDataMap.put("r12_c2", ResManager.loadKDString((String)"\u76ee\u524d\u652f\u6301\u4ee5\u4e0b\u683c\u5f0f", (String)"ImportTemplateHelper_27", (String)"bos-nocode-service", (Object[])new Object[0]) + "\nyyyy-MM-dd  HH:mm:ss\nyyyy-MM-dd\nyyyy/MM/dd  HH:mm:ss\nyyyy/MM/dd\n" + ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"ImportTemplateHelper_29", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n");
        cellDataMap.put("r13_c0", ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\uff08\u5f00\u59cb\uff09", (String)"ImportTemplateHelper_48", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r13_c1", ResManager.loadKDString((String)"\u76ee\u524d\u652f\u6301\u4ee5\u4e0b\u683c\u5f0f", (String)"ImportTemplateHelper_27", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n2022-09-16  10:30:15 \n2022-09-16\n2022/09/16  10:30:15\n2022/09/16\n" + ResManager.loadKDString((String)"2022\u5e749\u670816\u65e5", (String)"ImportTemplateHelper_28", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n");
        cellDataMap.put("r13_c2", ResManager.loadKDString((String)"\u76ee\u524d\u652f\u6301\u4ee5\u4e0b\u683c\u5f0f", (String)"ImportTemplateHelper_27", (String)"bos-nocode-service", (Object[])new Object[0]) + "\nyyyy-MM-dd  HH:mm:ss\nyyyy-MM-dd\nyyyy/MM/dd  HH:mm:ss\nyyyy/MM/dd\n" + ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"ImportTemplateHelper_29", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n");
        cellDataMap.put("r14_c0", ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\uff08\u7ed3\u675f\uff09", (String)"ImportTemplateHelper_49", (String)"bos-nocode-service", (Object[])new Object[0]));
        cellDataMap.put("r14_c1", ResManager.loadKDString((String)"\u76ee\u524d\u652f\u6301\u4ee5\u4e0b\u683c\u5f0f", (String)"ImportTemplateHelper_27", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n2022-09-16  10:30:15 \n2022-09-16\n2022/09/16  10:30:15\n2022/09/16\n" + ResManager.loadKDString((String)"2022\u5e749\u670816\u65e5", (String)"ImportTemplateHelper_28", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n");
        cellDataMap.put("r14_c2", ResManager.loadKDString((String)"\u76ee\u524d\u652f\u6301\u4ee5\u4e0b\u683c\u5f0f", (String)"ImportTemplateHelper_27", (String)"bos-nocode-service", (Object[])new Object[0]) + "\nyyyy-MM-dd  HH:mm:ss\nyyyy-MM-dd\nyyyy/MM/dd  HH:mm:ss\nyyyy/MM/dd\n" + ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"ImportTemplateHelper_29", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n");
        for (int i = 0; i < 15; ++i) {
            SXSSFRow curRow = formatSpecificationSheet.createRow(i);
            for (int j = 0; j < 3; ++j) {
                String cellValue = (String)cellDataMap.get("r" + i + "_c" + j);
                SXSSFCell curRowCell = curRow.createCell(j);
                curRowCell.setCellValue(cellValue);
                CellStyle cellStyle = wb.createCellStyle();
                cellStyle.setWrapText(true);
                curRowCell.setCellStyle(cellStyle);
            }
        }
        formatSpecificationSheet.setColumnWidth(0, 5632);
        formatSpecificationSheet.setColumnWidth(1, 7680);
        formatSpecificationSheet.setColumnWidth(2, 10240);
    }

    public static SXSSFRow getRow(SXSSFSheet sheet, int r) {
        SXSSFRow row = sheet.getRow(r);
        if (row == null) {
            row = sheet.createRow(r);
        }
        return row;
    }

    private static SXSSFCell createCell(SXSSFWorkbook wb, SXSSFRow row, int column, CellStyle style) {
        SXSSFCell cell = row.createCell(column);
        cell.setCellStyle(style);
        return cell;
    }

    private static Boolean multipleColumnsField(Object inputType) {
        return "basedata".equals(inputType) || "flex".equals(inputType) || "multilang".equals(inputType) || "largetext".equals(inputType);
    }

    private static List<String> getPropList(List<String> splitCols) {
        ArrayList<String> propList = new ArrayList<String>(splitCols.size());
        for (String splitCol : splitCols) {
            if (splitCol.contains(".")) {
                splitCol = splitCol.substring(splitCol.indexOf(".") + 1);
            }
            propList.add(splitCol);
        }
        return propList;
    }

    public static String dealDisplayName(int j, Boolean exchangeNameAndMark, Map<String, Object> property, List<String> splitCols, List<String> splitColDisplayNames) {
        boolean isFlexOrLargetext;
        boolean containSpecilKey;
        String inputType = (String)property.get(INPUT_TYPE_KEY);
        String displayName = splitColDisplayNames.get(j);
        String description = (String)property.get("EntityDescription");
        String columnNumber = splitCols.get(j);
        List<String> propList = ImportTemplateHelper.getPropList(splitCols);
        String curLangKey = Lang.get().toString();
        Map<String, Map<String, String>> langPropDesMapping = ImportTemplateHelper.getLangPropDesMapping(description, propList);
        Map<String, String> propDesMapping = langPropDesMapping.get(curLangKey);
        if (propDesMapping == null) {
            return displayName;
        }
        boolean bl = containSpecilKey = propDesMapping.size() > 0;
        if (columnNumber.contains(".")) {
            columnNumber = columnNumber.substring(columnNumber.indexOf(".") + 1);
        }
        String curLangDes = propDesMapping.get(columnNumber);
        boolean bl2 = isFlexOrLargetext = "flex".equals(inputType) || "largetext".equals(inputType);
        if (isFlexOrLargetext) {
            Optional<String> firstValue = propDesMapping.values().stream().findFirst();
            curLangDes = firstValue.orElse(curLangDes);
        }
        if (exchangeNameAndMark.booleanValue() && StringUtils.isNotBlank((CharSequence)curLangDes)) {
            property.put("splitColumnName", displayName);
            String suffix = !containSpecilKey && displayName.contains(".") ? displayName.substring(displayName.indexOf(".")) : "";
            displayName = curLangDes + suffix;
        }
        return displayName;
    }

    public static Map<String, Map<String, String>> getLangPropDesMapping(String des, List<String> keyList) {
        Map<String, Map<String, String>> langPropDesMapping = null;
        boolean newFormatJsonString = false;
        try {
            langPropDesMapping = (Map<String, Map<String, String>>)SerializationUtils.fromJsonString((String)des, Map.class);
            newFormatJsonString = true;
        }
        catch (Exception formatException) {
            log.debug("format des to langPropDesMapping fail , source des is " + des);
        }
        if (newFormatJsonString) {
            return langPropDesMapping;
        }
        langPropDesMapping = ImportTemplateHelper.getLangPropDesMappingFormOldFormat(des, keyList);
        return langPropDesMapping;
    }

    private static Map<String, Map<String, String>> getLangPropDesMappingFormOldFormat(String des, List<String> keyList) {
        List<String> enabledLangList = ImportTemplateHelper.getEnabledLangList();
        LinkedHashMap<String, Map<String, String>> langPropDesMapping = new LinkedHashMap<String, Map<String, String>>(enabledLangList.size());
        for (String langNumber : enabledLangList) {
            Map<String, String> propDesMapping = ImportTemplateHelper.getKeyDesMapping(des, keyList);
            langPropDesMapping.put(langNumber, propDesMapping);
        }
        return langPropDesMapping;
    }

    private static List<String> getEnabledLangList() {
        List enabledLang = InteServiceHelper.getMultiLangEnabledLang();
        ArrayList<String> langList = new ArrayList<String>(enabledLang.size());
        for (EnabledLang lang : enabledLang) {
            langList.add(lang.getNumber());
        }
        return langList;
    }

    private static Map<String, String> getKeyDesMapping(String des, List<String> keyList) {
        if (des == null) {
            des = "";
        }
        LinkedHashMap<String, String> keyDesMapping = new LinkedHashMap<String, String>(keyList.size());
        HashMap<String, Integer> keyIndexMapping = new HashMap<String, Integer>(keyList.size());
        for (String key : keyList) {
            String langKey = "#" + key;
            if (!des.contains(langKey)) continue;
            keyIndexMapping.put(langKey, des.indexOf(langKey));
        }
        if (keyIndexMapping.size() == 0 || des.equals("")) {
            for (String key : keyList) {
                keyDesMapping.put(key, des);
            }
            return keyDesMapping;
        }
        List<Map.Entry<String, Integer>> langKeyIndexMappingList = ImportTemplateHelper.sortMap(keyIndexMapping);
        for (int i = 0; i < langKeyIndexMappingList.size(); ++i) {
            Map.Entry<String, Integer> curEntry = langKeyIndexMappingList.get(i);
            String curLangNumberKey = curEntry.getKey();
            if (i == langKeyIndexMappingList.size() - 1) {
                String curLangDes = des.substring(curEntry.getValue() + curLangNumberKey.length());
                keyDesMapping.put(curEntry.getKey().substring(1), curLangDes);
                break;
            }
            Map.Entry<String, Integer> nextEntry = langKeyIndexMappingList.get(i + 1);
            String curLangDes = des.substring(curEntry.getValue() + curLangNumberKey.length(), nextEntry.getValue());
            keyDesMapping.put(curEntry.getKey().substring(1), curLangDes);
        }
        return keyDesMapping;
    }

    private static List<Map.Entry<String, Integer>> sortMap(Map<String, Integer> langKeyIndexMapping) {
        ArrayList<Map.Entry<String, Integer>> entryList = new ArrayList<Map.Entry<String, Integer>>(langKeyIndexMapping.entrySet());
        Collections.sort(entryList, Comparator.comparingInt(Map.Entry::getValue));
        return entryList;
    }

    private static void bindCellTip(SXSSFSheet sheet, SXSSFCell cell, int colSeq, int rowSeq, String tip) {
        if (StringUtils.isBlank((CharSequence)tip)) {
            return;
        }
        SXSSFDrawing p = sheet.createDrawingPatriarch();
        Comment comment = p.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)colSeq), rowSeq, (short)colSeq + 2, rowSeq + 3));
        comment.setString((RichTextString)new XSSFRichTextString(tip));
        cell.setCellComment(comment);
    }

    private static int calcColumnWidth(String caption, int designatedColWidth) {
        if (designatedColWidth > 0) {
            return designatedColWidth * 32;
        }
        int colWidth = 0;
        try {
            colWidth = 256 * (caption.getBytes("GBK").length + 8);
        }
        catch (UnsupportedEncodingException e) {
            colWidth = 256 * (caption.getBytes(StandardCharsets.UTF_8).length + 8);
        }
        return Math.min(colWidth, 51200);
    }

    private static void writeComment(SXSSFWorkbook wb, SXSSFRow commentRow, ExportWriterFormat format, ExportSheetStyle styles, Map<String, Object> property, String columnNumber, List<String> propList, int offset) {
        String entityDesc = (String)property.get("EntityDescription");
        entityDesc = ImportTemplateHelper.getRealDescByInputType(entityDesc, property, propList, columnNumber);
        if (format.getExchangeNameAndMark().booleanValue() && StringUtils.isNotBlank((CharSequence)entityDesc)) {
            String string = entityDesc = StringUtils.isNotBlank((Object)property.get("splitColumnName")) ? (String)property.get("splitColumnName") : (String)property.get("DisplayName");
        }
        if (format.col + offset == 0) {
            StringBuilder tips = ImportTemplateHelper.buildTips(format, commentRow, entityDesc, property);
            CellStyle textHighLightStyle = styles.getTextHighLightStyle();
            textHighLightStyle.setVerticalAlignment(VerticalAlignment.TOP);
            textHighLightStyle.setWrapText(true);
            ImportTemplateHelper.createCell(wb, commentRow, 0, textHighLightStyle).setCellValue(tips.toString());
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)entityDesc)) {
            ImportTemplateHelper.createCell(wb, commentRow, format.col + offset, styles.getTextStyle()).setCellValue(entityDesc);
        }
    }

    public static String getRealDescByInputType(String entityDesc, Map<String, Object> property, List<String> propList, String columnNumber) {
        boolean isFlexOrLargetext;
        Map<String, Map<String, String>> langPropDesMapping;
        Map<String, String> propDesMapping;
        if (columnNumber.contains(".")) {
            columnNumber = columnNumber.substring(columnNumber.indexOf(".") + 1);
        }
        Object inputType = property.get(INPUT_TYPE_KEY);
        String curLangKey = Lang.get().toString();
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(propList)) {
            propList = new ArrayList<String>(1);
            propList.add(columnNumber);
        }
        if ((propDesMapping = (langPropDesMapping = ImportTemplateHelper.getLangPropDesMapping(entityDesc, propList)).get(curLangKey)) == null) {
            return "";
        }
        entityDesc = propDesMapping.get(columnNumber);
        boolean bl = isFlexOrLargetext = "flex".equals(inputType) || "largetext".equals(inputType);
        if (isFlexOrLargetext) {
            Optional<String> firstValue = propDesMapping.values().stream().findFirst();
            entityDesc = firstValue.orElse(entityDesc);
        }
        return entityDesc;
    }

    private static StringBuilder buildTips(ExportWriterFormat format, SXSSFRow commentRow, String entityDesc, Map<String, Object> property) {
        StringBuilder strb = new StringBuilder();
        ArrayList<String> tips = new ArrayList<String>(8);
        tips.add(ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"ImportTemplateHelper_50", (String)"bos-nocode-service", (Object[])new Object[0]));
        tips.add(ResManager.loadKDString((String)"2\u3001\u7ea2\u8272\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5", (String)"ImportTemplateHelper_51", (String)"bos-nocode-service", (Object[])new Object[0]));
        if (format.getEnableSetNull().booleanValue()) {
            tips.add(ResManager.loadKDString((String)"#SetNULL\uff08\u542f\u7528\u5355\u5143\u683c\u8f93\u5165NULL\u6e05\u7a7a\u5b57\u6bb5\uff09", (String)"ImportTemplateHelper_52", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        if (format.getSplitSubEntries().booleanValue()) {
            tips.add("#SplitSubEntries");
        }
        if (format.getForUpdateMultiLangFields().booleanValue()) {
            tips.add("#ForUpdateMultiLangFields");
        }
        if (StringUtils.isNotBlank((CharSequence)entityDesc)) {
            tips.add("-----------");
            tips.add(entityDesc);
        }
        int radit = ImportTemplateHelper.addTips(strb, tips);
        Optional maxLengthStr = tips.stream().max((o1, o2) -> {
            if (o1.length() > o2.length()) {
                return 1;
            }
            return -1;
        });
        commentRow.setHeightInPoints((float)radit * commentRow.getSheet().getDefaultRowHeightInPoints());
        Object colWidth = property.get(COLWIDTH_KEY);
        int designatedColWidth = colWidth instanceof Integer ? (Integer)colWidth : 0;
        commentRow.getSheet().setColumnWidth(0, ImportTemplateHelper.calcColumnWidth(maxLengthStr.orElse(""), designatedColWidth));
        return strb;
    }

    private static int addTips(StringBuilder strb, List<String> tips) {
        for (String tip : tips) {
            strb.append(tip).append("\r\n");
        }
        strb.delete(strb.length() - "\r\n".length(), strb.length());
        return tips.size();
    }

    public String flush(SXSSFWorkbook wb, MainEntityType listEntityType, String fileName) {
        String string;
        File temp;
        FileInputStream fis;
        block9: {
            FileOutputStream fos = null;
            fis = null;
            temp = null;
            try {
                String url;
                temp = File.createTempFile(UUID.randomUUID().toString(), ".xlsx");
                fos = new FileOutputStream(temp);
                wb.write((OutputStream)fos);
                wb.dispose();
                fis = new FileInputStream(temp);
                string = url = this.upload(listEntityType, fileName + ".xlsx", fis);
                if (fos == null) break block9;
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    if (fos != null) {
                        FileSecurityUtil.safeClose(fos);
                    }
                    if (fis != null) {
                        FileSecurityUtil.safeClose(fis);
                    }
                    if (temp != null) {
                        FileSecurityUtil.safeDeleteFile((File)temp);
                    }
                    throw throwable;
                }
            }
            FileSecurityUtil.safeClose((Closeable)fos);
        }
        if (fis != null) {
            FileSecurityUtil.safeClose((Closeable)fis);
        }
        if (temp != null) {
            FileSecurityUtil.safeDeleteFile((File)temp);
        }
        return string;
    }

    public String upload(MainEntityType listEntityType, String fileName, InputStream in) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        RequestContext ctx = RequestContext.getOrCreate();
        if (fileName.length() > 50) {
            int trimLength = fileName.length() - 50;
            int suffixIndex = fileName.lastIndexOf(46);
            String suffix = fileName.substring(suffixIndex);
            fileName = fileName.substring(0, fileName.length() - trimLength - suffix.length()) + suffix;
        }
        String path = this.getExportFileName(ctx.getAccountId(), listEntityType.getAppId(), listEntityType.getName() + Uuid8.generateShortUuid(), fileName);
        String url = service.upload(new FileItem(fileName, path, in));
        return UrlService.getAttachmentFullUrl((String)url);
    }

    private String getExportFileName(String accountId, String appId, String tag, String filename) {
        String dateStr = new SimpleDateFormat("yyyyMMdd").format(new Date());
        return String.format("/%s/%s/%s/%s/%s", accountId, dateStr, appId, tag, filename);
    }
}

