/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.impt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;

public class NoCodeImportContext {
    private static final String IMPORTCACHEKEY = "Cached_Import_Logger_ByTaskId:";
    private Object logId;
    private String appId;
    private String listName;
    private String billFormId;
    private String url;
    private String opSaveKey;
    private int succeed = 0;
    public static final int DEFAULT_BATCH_IMPORT_SIZE = 1000;
    private Set<String> completeUrls = new HashSet<String>(1);
    private Map<String, LinkedBlockingQueue<ImportBillData>> dataQueues = new HashMap<String, LinkedBlockingQueue<ImportBillData>>(1);
    private Map<String, ImportLogger> importLoggers = new LinkedHashMap<String, ImportLogger>(1);
    private CountDownLatch countDownLatch;
    public static final String PROGRESS = "progress";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("NOCODE_IMPORT", new DistributeCacheHAPolicy(true, true));

    public NoCodeImportContext(Object logId, String appid, String listName, String billFormId, String url, CountDownLatch countDownLatch) {
        this.logId = logId;
        this.appId = appid;
        this.listName = listName;
        this.billFormId = billFormId;
        this.url = url;
        this.countDownLatch = countDownLatch;
        this.importLoggers.put(url, new ImportLogger(url));
        this.dataQueues.put(url, new LinkedBlockingQueue(3000));
    }

    public Object getLogId() {
        return this.logId;
    }

    public void setLogId(Object logId) {
        this.logId = logId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appid) {
        this.appId = appid;
    }

    public String getListName() {
        return this.listName;
    }

    public void setListName(String listName) {
        this.listName = listName;
    }

    public String getBillFormId() {
        return this.billFormId;
    }

    public void setBillFormId(String billFormId) {
        this.billFormId = billFormId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getOpSaveKey() {
        return this.opSaveKey;
    }

    public void setOpSaveKey(String opSaveKey) {
        this.opSaveKey = opSaveKey;
    }

    public int getSucceed() {
        return this.succeed;
    }

    public void setSucceed(int succeed) {
        this.succeed = succeed;
    }

    public boolean isResolveComplete(String key) {
        return this.completeUrls.contains(key);
    }

    public void setResolveComplete(String url) {
        this.completeUrls.add(url);
    }

    public void addBillData(String url, ImportBillData importBillData) {
        this.getDataQueue(url).add(importBillData);
    }

    public LinkedBlockingQueue<ImportBillData> getDataQueue(String url) {
        return this.dataQueues.get(url);
    }

    public ImportLogger getLogger(String url) {
        return this.importLoggers.get(url);
    }

    public Object getUrlLoggers() {
        return this.importLoggers;
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }

    public void setCountDownLatch(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    public void feedbackProgress(int progress, ImportLogger logger, String errMsg) {
        JSONObject map;
        String taskId = (String)cache.get("noCodeLogId:" + this.logId);
        String cachedLogStr = (String)cache.get(IMPORTCACHEKEY + taskId);
        JSONObject jSONObject = map = StringUtils.isNotBlank((CharSequence)cachedLogStr) ? JSON.parseObject((String)cachedLogStr) : new JSONObject();
        if (progress > map.getIntValue(PROGRESS)) {
            map.put(PROGRESS, (Object)progress);
        }
        if (logger != null) {
            int headRowCount = 4;
            map.put("curRowNum", (Object)(logger.getRowIndex() + 1 - headRowCount));
            map.put("totalRowNum", (Object)(logger.getLastRowIndex() - headRowCount));
            map.put("total", (Object)logger.getTotal());
            map.put("succeed", (Object)logger.getDelRows().size());
            map.put("failed", (Object)logger.getFailed());
            map.put("totalRow", (Object)logger.getTotalRow());
        }
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            map.put("err", (Object)errMsg);
        }
        cachedLogStr = JSON.toJSONString((Object)map);
        cache.put(IMPORTCACHEKEY + taskId, (Object)cachedLogStr);
    }
}

