/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.impt;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.service.impt.ReferenceInteger;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class NoCodeImportHelper {
    private static Log log = LogFactory.getLog(NoCodeImportHelper.class);
    private static Set<String> TRUE = new HashSet<String>(Arrays.asList(ResManager.loadKDString((String)"\u662f", (String)"NoCodeImportHelper_0", (String)"bos-nocode-service", (Object[])new Object[0]), ResManager.loadKDString((String)"\u771f", (String)"NoCodeImportHelper_1", (String)"bos-nocode-service", (Object[])new Object[0]), ResManager.loadKDString((String)"\u52fe\u9009", (String)"NoCodeImportHelper_2", (String)"bos-nocode-service", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9", (String)"NoCodeImportHelper_3", (String)"bos-nocode-service", (Object[])new Object[0])));

    public static void invalidBill(List<ImportBillData> billdatas, ImportLogger logger) {
        HashMap<Integer, List<String>> needInput = new HashMap<Integer, List<String>>(billdatas.size());
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            ImportBillData bill = it.next();
            if (bill.isEmpty()) continue;
            try {
                if (!NoCodeImportHelper.mustInputValid(logger, needInput, it, bill)) continue;
            }
            catch (Throwable throwable) {
                log.warn(throwable);
                if (SystemParamServiceHelper.isShowStackTrace()) {
                    logger.log(Integer.valueOf(billdatas.get(0).getStartIndex()), throwable);
                } else {
                    logger.log(Integer.valueOf(billdatas.get(0).getStartIndex()), ResManager.loadKDString((String)"\u6570\u636e\u5305\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38,\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790", (String)"NoCodeImportHelper_4", (String)"bos-nocode-service", (Object[])new Object[0]));
                }
                it.remove();
                logger.fail();
                logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
            }
        }
    }

    private static boolean mustInputValid(ImportLogger logger, Map<Integer, List<String>> needInput, Iterator<ImportBillData> it, ImportBillData bill) {
        if (!NoCodeImportHelper.checkValues(bill.getEntityMapping(), bill.getData(), needInput, logger, new ReferenceInteger(bill.getStartIndex()))) {
            if (!needInput.isEmpty()) {
                for (Map.Entry<Integer, List<String>> required : needInput.entrySet()) {
                    logger.log(required.getKey(), String.format(ResManager.loadKDString((String)"\u6570\u636e\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a%s", (String)"NoCodeImportHelper_5", (String)"bos-nocode-service", (Object[])new Object[]{String.join((CharSequence)",", (Iterable<? extends CharSequence>)required.getValue())}), new Object[0]));
                }
                needInput.clear();
            }
            it.remove();
            logger.fail();
            logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
            return true;
        }
        return false;
    }

    private static boolean checkValues(ImportEntityMapping mapping, JSONObject data, Map<Integer, List<String>> needInput, ImportLogger logger, ReferenceInteger index) {
        boolean isValid = true;
        if (data == null) {
            return true;
        }
        Object val = null;
        for (Map.Entry col : mapping.getCols().entrySet()) {
            String fieldKey = (String)col.getKey();
            ImportEntityMapping.ColInfo colInfo = (ImportEntityMapping.ColInfo)col.getValue();
            String displayName = colInfo.getDisplayName();
            IDataEntityProperty prop = colInfo.getProperty();
            val = data.get((Object)fieldKey);
            if (data.containsKey((Object)fieldKey) && val == null) continue;
            if (StringUtils.isBlank((Object)val) || val instanceof Map && ((Map)val).isEmpty()) {
                if (!colInfo.isMustInput()) continue;
                List<String> needInputFields = needInput.get(index.getValue());
                if (needInputFields == null) {
                    needInputFields = new ArrayList<String>(32);
                    needInput.put(index.getValue(), needInputFields);
                }
                needInputFields.add(colInfo.getDisplayName());
                isValid = false;
                continue;
            }
            if (prop instanceof ComboProp) {
                List items = ((ComboProp)prop).getComboItems();
                if (items == null || items.isEmpty()) continue;
                List<String> cellValueSplit = Arrays.asList(((String)val).split(","));
                ArrayList<String> values = new ArrayList<String>();
                boolean isMulCombo = prop instanceof MulComboProp;
                for (ValueMapItem item : items) {
                    if (!(isMulCombo ? cellValueSplit.contains(item.getName().toString()) : item.getName().toString().equals(val))) continue;
                    values.add(item.getValue());
                    if (isMulCombo) continue;
                    break;
                }
                if (StringUtils.isNotBlank((Object)val) && values.isEmpty()) {
                    logger.log(index.getValue(), prop.getDisplayName() + ResManager.loadKDString((String)"\u5339\u914d\u4e0d\u5230\u4e0b\u62c9\u9009\u9879\uff1a", (String)"NoCodeImportHelper_6", (String)"bos-nocode-service", (Object[])new Object[0]) + val);
                    isValid = false;
                }
                data.put(fieldKey, (Object)String.join((CharSequence)",", values));
                continue;
            }
            if (prop instanceof BooleanProp) {
                data.put(fieldKey, (Object)TRUE.contains(((String)val).toLowerCase()));
                continue;
            }
            if (!(prop instanceof FlexProp) || !(val instanceof Map)) continue;
            Map flexItem = (Map)val;
            for (Map.Entry entry : flexItem.entrySet()) {
                Object flexValueObj = entry.getValue();
                if (!(flexValueObj instanceof Map) || !((Map)flexValueObj).isEmpty()) continue;
                String msg = colInfo.getDisplayName() + ":\"" + (String)entry.getKey() + "\"";
                msg = String.format(ResManager.loadKDString((String)"%s\u7684\u7f16\u7801\u6216\u540d\u79f0\u81f3\u5c11\u586b\u4e00\u9879", (String)"NoCodeImportHelper_7", (String)"bos-nocode-service", (Object[])new Object[]{msg}), new Object[0]);
                logger.log(index.getValue(), msg);
                isValid = false;
            }
        }
        return isValid;
    }
}

