/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.impt;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.nocode.restapi.service.impt.NoCodeImportContext;
import kd.bos.nocode.restapi.service.impt.ReloveAndImportData;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class NoCodeImportService
extends AbstractTask {
    private static Log log = LogFactory.getLog(NoCodeImportService.class);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("NOCODE_IMPORT", new DistributeCacheHAPolicy(true, true));
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    public static final String LOG_ID = "logId";
    protected static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"NoCodeImportThreadPool", (int)2, (int)6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            String logId = String.valueOf(map.get(LOG_ID));
            this.startImport(logId);
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            log.debug("\u5bfc\u5165\u8c03\u5ea6\u4efb\u52a1\u7ebf\u7a0b\u5f02\u5e38" + e, (Object)e);
        }
    }

    public void startImport(String logId) {
        SessionManager sm = SessionManager.getCurrent();
        sm.setRequestThread(true);
        String taskId = (String)cache.get("noCodeLogId:" + logId);
        String taskParamJson = (String)cache.get("Import_TaskParam_ByTaskId:" + taskId);
        Map taskParam = (Map)SerializationUtils.fromJsonString((String)taskParamJson, Map.class);
        String appid = (String)taskParam.get("appId");
        String billFormId = (String)taskParam.get("billFormId");
        String billFormName = (String)taskParam.get("billFormName");
        String url = (String)taskParam.get("url");
        RequestContext rc = RequestContext.get();
        NoCodeImportContext ctx = new NoCodeImportContext(logId, appid, billFormName, billFormId, url, this.countDownLatch);
        ReloveAndImportData reloveAndImportData = new ReloveAndImportData().setContext(rc, ctx, Arrays.asList("resolveExcel", "importData"));
        threadPool.submit((Callable)reloveAndImportData);
        threadPool.submit((Callable)reloveAndImportData);
    }
}

